/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.editor.samplemanager.ontology;

import com.hp.hpl.jena.ontology.Individual;
import com.hp.hpl.jena.ontology.OntClass;
import com.hp.hpl.jena.ontology.OntResource;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.rdf.model.impl.StatementImpl;
import com.hp.hpl.jena.shared.AlreadyExistsException;
import com.hp.hpl.jena.shared.NotFoundException;
import com.hp.hpl.jena.util.iterator.Filter;
import com.hp.hpl.jena.vocabulary.RDF;
import com.hp.hpl.jena.vocabulary.RDFS;
import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;
import org.grits.toolbox.editor.samplemanager.ontology.EditMode;
import org.grits.toolbox.editor.samplemanager.ontology.ISampleOntologyEditApi;
import org.grits.toolbox.entry.sample.model.MeasurementUnit;
import org.grits.toolbox.entry.sample.ontologymanager.SampleOntologyApi;

public class SampleOntologyEditApi
extends SampleOntologyApi
implements ISampleOntologyEditApi {
    private Logger logger = Logger.getLogger(SampleOntologyEditApi.class);
    protected EditMode editMode = null;

    public SampleOntologyEditApi(EditMode editMode) throws Exception {
        this.logger.info((Object)("initializing sample manager in mode : " + (Object)((Object)editMode)));
        editMode = editMode == null ? EditMode.USER_MODE : editMode;
        try {
            switch (editMode) {
                case USER_MODE: {
                    this.logger.info((Object)"loading local sample ontology in USER mode");
                    break;
                }
                case ADMIN_MODE: {
                    this.logger.info((Object)"setting standard ontology as local ontology in ADMIN mode");
                    this.localOntologyFile = this.standardOntologyFile;
                    this.localOntModel = this.getStandardOntModel();
                    break;
                }
                default: {
                    this.logger.error((Object)("This edit mode is not supported : " + (Object)((Object)editMode)));
                    throw new Exception("This edit mode is not supported : " + (Object)((Object)editMode));
                }
            }
        }
        catch (IOException ex) {
            this.logger.error((Object)("error loading ontologies\n" + ex.getMessage()), (Throwable)ex);
            throw ex;
        }
        catch (Exception ex) {
            this.logger.fatal((Object)("something unexpected went wrong while loading ontologies\n" + ex.getMessage()), (Throwable)ex);
            throw ex;
        }
        this.logger.info((Object)"sample ontologies loaded");
    }

    @Override
    public String createNewIndividual(String classUri, String label) throws AlreadyExistsException {
        this.logger.info((Object)("creating new individual for class " + classUri + " with label " + label));
        if (classUri == null || label == null) {
            return null;
        }
        OntClass classResource = this.localOntModel.getOntClass(classUri);
        if (classResource == null) {
            this.logger.info((Object)("no class found for this uri : " + classUri));
            return null;
        }
        String classLabel = classResource.getLabel(null);
        if (classLabel == null) {
            this.logger.error((Object)("no label found for found class " + classUri));
            return null;
        }
        String modifiedLabel = String.valueOf(classLabel) + " " + label;
        String indivUri = this.getUriForLabel(modifiedLabel);
        if (this.localOntModel.getOntResource(indivUri) != null) {
            this.logger.error((Object)("some individual with this class_individual combination already exists in this ontology : " + modifiedLabel + "\nuri : " + indivUri));
            throw new AlreadyExistsException(indivUri);
        }
        Individual indiv = this.localOntModel.createIndividual(indivUri, (Resource)classResource);
        indiv.setLabel(label, null);
        this.logger.info((Object)("individual created : " + indivUri));
        return indivUri;
    }

    private String getUriForLabel(String givenLabel) {
        return "http://www.grits-toolbox.org/ontology/sample#" + givenLabel.toLowerCase().trim().replaceAll(" ", "_").replaceAll("/", "_").replaceAll("%", "_");
    }

    @Override
    public Set<String> getLocalIndividualURIs(String classUri) {
        this.logger.debug((Object)("getting local uris for class : " + classUri));
        if (classUri == null || this.localOntModel.getOntClass(classUri) == null) {
            return null;
        }
        HashSet<String> localUris = new HashSet<String>();
        final OntClass ontClass = this.localOntModel.getOntClass(classUri);
        for (OntResource instance : this.localOntModel.listIndividuals((Resource)this.localOntModel.getOntClass(classUri)).filterKeep((Filter)new Filter<Individual>(){

            public boolean accept(Individual indiv) {
                SampleOntologyEditApi.this.logger.debug((Object)indiv.getURI().toUpperCase());
                boolean accept = SampleOntologyEditApi.this.localOntModel.isInBaseModel((Statement)new StatementImpl((Resource)indiv, RDF.type, (RDFNode)ontClass));
                SampleOntologyEditApi.this.logger.debug((Object)("added : " + accept));
                return accept;
            }
        }).toSet()) {
            localUris.add(instance.getURI());
        }
        return localUris;
    }

    @Override
    public boolean updateLabel(String uri, String label) throws NotFoundException {
        this.logger.info((Object)("updating label for : " + uri + " with new label : " + label));
        if (uri == null || label == null) {
            return false;
        }
        Individual localIndiv = this.getDefinedIndivFromLocalOntology(uri);
        localIndiv.setLabel(label, null);
        this.logger.info((Object)("label updated for " + localIndiv.getURI() + " with new label " + localIndiv.getLabel(null)));
        return true;
    }

    private Individual getDefinedIndivFromLocalOntology(String uri) throws NotFoundException {
        if (uri == null) {
            return null;
        }
        Individual localIndiv = this.localOntModel.getIndividual(uri);
        if (localIndiv == null) {
            this.logger.error((Object)"individual to be updated not found in current ontology");
            throw new NotFoundException("individual to be updated not found in current ontology");
        }
        OntClass indivClass = localIndiv.getOntClass(true);
        if (localIndiv.getLabel(null) == null || indivClass == null || indivClass.getURI() == null) {
            this.logger.error((Object)"indiv to be updated not defined in current ontology");
            throw new NotFoundException("indiv to be updated not defined in current ontology");
        }
        this.logger.debug((Object)("exists with name : " + localIndiv.getLabel(null) + " in class : " + indivClass.getURI()));
        return localIndiv;
    }

    @Override
    public boolean updateDescription(String uri, String description) throws NotFoundException {
        this.logger.info((Object)("updating description for : " + uri + " with new description : " + description));
        if (uri == null) {
            return false;
        }
        Individual localIndiv = this.getDefinedIndivFromLocalOntology(uri);
        localIndiv.removeAll(RDFS.comment);
        localIndiv.addComment(description, null);
        this.logger.info((Object)("description updated for " + localIndiv.getURI() + " with new description " + localIndiv.getComment(null)));
        return true;
    }

    @Override
    public boolean updateCategorySelection(String categoryUri, String descriptorOrGroupUri, boolean selected) {
        return false;
    }

    @Override
    public boolean addUnitToDescriptor(String descriptorUri, MeasurementUnit measurementUnit) {
        return false;
    }

    @Override
    public boolean setDefaultUnitForDescriptor(String descriptorUri, String unitUri) {
        return false;
    }

    @Override
    public boolean addNamespaceToDescriptor(String descriptorUri, String namespaceUri) {
        return false;
    }

    @Override
    public boolean addDescriptorToGroup(String groupUri, String descriptorUri, Integer maxOcurrence, boolean mandatory) {
        return false;
    }

    @Override
    public boolean addDescriptorOrGroupToCategoryTemplate(String templateUri, String categoryUri, String descriptorUri, Integer maxOcurrence, boolean mandatory) {
        return false;
    }

    @Override
    public boolean setMaxOccurrence(String descriptorOrGroupUri, Integer maxOccurrence) {
        return false;
    }

    @Override
    public boolean setMaxOccurrenceInGroup(String groupUri, String descriptorUri, Integer maxOccurrence) {
        return false;
    }

    @Override
    public boolean setMaxOccurrenceInTemplate(String templateUri, String categoryUri, String descriptorOrGroupUri, Integer maxOccurrence) {
        return false;
    }

    @Override
    public boolean setMandatoryDescriptorInGroup(String groupUri, String descriptorUri, boolean mandatory) {
        return false;
    }

    @Override
    public boolean setMandatoryDescriptorInCategoryTemplate(String templateUri, String categoryUri, String descriptorUri, boolean mandatory) {
        return false;
    }

    @Override
    public boolean removeDescriptorFromGroup(String groupUri, String descriptorUri) {
        return false;
    }

    @Override
    public boolean removeDescriptorOrGroupFromTemplate(String templateUri, String categoryUri, String descriptorUri) {
        return false;
    }

    @Override
    public boolean removeIndividual(String indivUri) {
        return false;
    }

    @Override
    public boolean removeTriple(String subjectUri, String propertyUri, String objectUri) {
        return false;
    }

    @Override
    public List<MeasurementUnit> getAllMeasurementUnits() {
        return null;
    }

    @Override
    public boolean saveModel() {
        try {
            super.saveLocalOntology();
            return true;
        }
        catch (Exception ex) {
            this.logger.fatal((Object)ex.getMessage(), (Throwable)ex);
            return false;
        }
    }
}

