/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.editor.samplemanager.ontology;

import com.hp.hpl.jena.ontology.DatatypeProperty;
import com.hp.hpl.jena.ontology.Individual;
import com.hp.hpl.jena.ontology.ObjectProperty;
import com.hp.hpl.jena.ontology.OntClass;
import com.hp.hpl.jena.ontology.OntModel;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.ResourceFactory;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import com.hp.hpl.jena.vocabulary.RDF;
import com.hp.hpl.jena.vocabulary.RDFS;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.Set;
import org.apache.log4j.Logger;
import org.grits.toolbox.editor.samplemanager.ontology.OntologyManager;
import org.grits.toolbox.entry.sample.model.Category;
import org.grits.toolbox.entry.sample.model.Descriptor;
import org.grits.toolbox.entry.sample.model.DescriptorGroup;
import org.grits.toolbox.entry.sample.model.MeasurementUnit;
import org.grits.toolbox.entry.sample.model.Namespace;
import org.grits.toolbox.entry.sample.model.Template;

public class GritsOntologyManagerApi {
    private static final Logger logger = Logger.getLogger(GritsOntologyManagerApi.class);
    private static final String NAMESPACE_CLASS_URI = "http://www.grits-toolbox.org/ontology/sample#namespace";
    private static final String MEASUREMENT_UNIT_CLASS_URI = "http://www.grits-toolbox.org/ontology/sample#unit";
    private OntologyManager ontologyManager = null;
    private OntModel defaultOntologyModel = null;
    private OntModel readOnlyOntologyModel = null;
    private boolean managerMode = false;

    public GritsOntologyManagerApi(OntModel localOntologyModel) {
        this.ontologyManager = new OntologyManager(localOntologyModel);
        this.defaultOntologyModel = localOntologyModel;
        this.managerMode = true;
    }

    public GritsOntologyManagerApi(OntModel standardOntologyModel, OntModel localOntologyModel) {
        this.ontologyManager = new OntologyManager(standardOntologyModel, localOntologyModel);
        this.readOnlyOntologyModel = standardOntologyModel;
        this.defaultOntologyModel = localOntologyModel;
    }

    public List<Descriptor> getAllDescriptors(OntModel model) {
        logger.debug((Object)"- START : Retrieving all Descriptors from the ontology model.");
        ArrayList<Descriptor> descriptors = new ArrayList<Descriptor>();
        try {
            String uri = null;
            OntClass descriptorClass = model.getOntClass("http://www.grits-toolbox.org/ontology/sample#descriptor");
            ExtendedIterator indivs = model.listIndividuals((Resource)descriptorClass);
            while (indivs.hasNext()) {
                Individual indiv = (Individual)indivs.next();
                uri = indiv.getURI();
                descriptors.add(this.ontologyManager.getDescriptorByUri(model, uri));
            }
        }
        catch (Exception ex) {
            logger.error((Object)ex);
        }
        logger.debug((Object)"- END   : Retrieving all Descriptors from the ontology model.");
        return descriptors;
    }

    public List<DescriptorGroup> getAllDescriptorGroups(OntModel model) {
        logger.debug((Object)"- START : Retrieving all DescriptorGroups from the ontology model.");
        ArrayList<DescriptorGroup> descriptorGroups = new ArrayList<DescriptorGroup>();
        try {
            List<Individual> indivs = this.ontologyManager.getAllDescriptorGroup(model);
            for (Individual indiv : indivs) {
                descriptorGroups.add(this.ontologyManager.getDescriptorGroupByUri(model, indiv.getURI()));
            }
        }
        catch (Exception ex) {
            logger.error((Object)ex);
        }
        logger.debug((Object)"- END   : Retrieving all DescriptorGroups from the ontology model.");
        return descriptorGroups;
    }

    public void updateLabel(String uri, String label) {
        logger.debug((Object)("- START : Updating label for " + uri + " as " + label + " in the ontology model."));
        try {
            Resource resource = this.defaultOntologyModel.getResource(uri);
            if (resource != null) {
                resource.removeAll(RDFS.label);
                this.defaultOntologyModel.add(resource, RDFS.label, label);
            }
        }
        catch (Exception ex) {
            logger.error((Object)ex);
        }
        logger.debug((Object)("- END   : Updating label for " + uri + " as " + label + " in the ontology model."));
    }

    public void updateDescription(String uri, String label) {
        logger.debug((Object)("- START : Updating description for " + uri + " as " + label + " in the ontology model."));
        try {
            Resource resource = this.defaultOntologyModel.getResource(uri);
            if (resource != null) {
                resource.removeAll(RDFS.comment);
                this.defaultOntologyModel.add(resource, RDFS.comment, label);
            }
        }
        catch (Exception ex) {
            logger.error((Object)ex);
        }
        logger.debug((Object)("- END   : Updating description for " + uri + " as " + label + " in the ontology model."));
    }

    public void updateMaxOccurrence(String uri, Integer maxOccurrence) {
        logger.debug((Object)("- START : Updating Max Occurrence for " + uri + " as " + maxOccurrence + " in the ontology model."));
        try {
            Resource resource = this.defaultOntologyModel.getResource(uri);
            if (resource != null) {
                DatatypeProperty property = this.defaultOntologyModel.getDatatypeProperty("http://www.grits-toolbox.org/ontology/sample#has_abbundance");
                resource.removeAll((Property)property);
                if (maxOccurrence != null) {
                    this.defaultOntologyModel.addLiteral(resource, (Property)property, maxOccurrence.intValue());
                }
            }
        }
        catch (Exception ex) {
            logger.error((Object)ex);
        }
        logger.debug((Object)("- END   : Updating Max Occurrence for " + uri + " as " + maxOccurrence + " in the ontology model."));
    }

    public void updatePosition(String uri, Integer position) {
        logger.debug((Object)("- START : Updating Position for " + uri + " as " + position + " in the ontology model."));
        try {
            Resource resource = this.defaultOntologyModel.getResource(uri);
            if (resource != null) {
                DatatypeProperty property = this.defaultOntologyModel.getDatatypeProperty("http://www.grits-toolbox.org/ontology/sample#has_position");
                resource.removeAll((Property)property);
                if (position != null) {
                    this.defaultOntologyModel.addLiteral(resource, (Property)property, position.intValue());
                }
            }
        }
        catch (Exception ex) {
            logger.error((Object)ex);
        }
        logger.debug((Object)("- END   : Updating Position for " + uri + " as " + position + " in the ontology model."));
    }

    public void updateStandardGuideline(String uri, String mirageURI) {
        logger.debug((Object)("- START : Updating StandardGuideline for " + uri + " as " + mirageURI + " in the ontology model."));
        try {
            ObjectProperty property;
            Resource resource = this.defaultOntologyModel.getResource(uri);
            String guidelineUri = "http://www.grits-toolbox.org/ontology/sample#StandardGuideline_" + mirageURI.toLowerCase().replaceAll(" ", "_");
            Individual guideline = this.defaultOntologyModel.getIndividual(guidelineUri);
            if (guideline == null) {
                guideline = this.defaultOntologyModel.createIndividual(guidelineUri, (Resource)this.defaultOntologyModel.getOntClass("http://www.grits-toolbox.org/ontology/sample#StandardGuideline"));
                guideline.setLabel(mirageURI, null);
            }
            if (resource != null && guideline != null && !this.defaultOntologyModel.contains(resource, (Property)(property = this.defaultOntologyModel.getObjectProperty("http://www.grits-toolbox.org/ontology/sample#guideline_info")), (RDFNode)guideline)) {
                resource.addProperty((Property)property, (RDFNode)guideline);
            }
        }
        catch (Exception ex) {
            logger.error((Object)"Error adding guideline_info", (Throwable)ex);
        }
        logger.debug((Object)("- END   : Updating Mirage for " + uri + " as " + mirageURI + " in the ontology model."));
    }

    public HashMap<String, String> getAllCategoriesURILabelMap(OntModel model) {
        try {
            logger.debug((Object)"- START : Retrieving all Categories Label from the ontology model.");
            HashMap<String, String> categoryURIs = new HashMap<String, String>();
            List<Individual> indivs = this.ontologyManager.getAllIndiviudalsOfClass(model, "http://www.grits-toolbox.org/ontology/sample#category");
            for (Individual indiv : indivs) {
                categoryURIs.put(indiv.getURI(), indiv.getLabel(null));
            }
            logger.debug((Object)"- END   : Retrieving all Categories Label from the ontology model.");
            return categoryURIs;
        }
        catch (Exception ex) {
            logger.error((Object)ex);
            throw ex;
        }
    }

    public List<Category> getAllCategories() throws Exception {
        try {
            logger.debug((Object)"- START : Retrieving all Categories from the ontology model.");
            ArrayList<Category> categories = new ArrayList<Category>();
            List<Object> indivs = new ArrayList();
            indivs = !this.managerMode ? this.ontologyManager.getAllIndiviudalsOfClass(this.readOnlyOntologyModel, "http://www.grits-toolbox.org/ontology/sample#category") : this.ontologyManager.getAllIndiviudalsOfClass(this.defaultOntologyModel, "http://www.grits-toolbox.org/ontology/sample#category");
            Category category = null;
            Property categoryProperty = this.defaultOntologyModel.getProperty("http://www.grits-toolbox.org/ontology/sample#has_category");
            Set subjectsWithCategory = new HashSet();
            Individual subjectIndiv = null;
            OntClass subjectClass = null;
            String subjectClassURI = null;
            String subjectURI = null;
            Descriptor descriptor = null;
            DescriptorGroup descriptorGroup = null;
            String indivURI = null;
            try {
                for (Individual individual : indivs) {
                    indivURI = individual.getURI();
                    category = new Category(individual.getURI());
                    subjectsWithCategory = this.defaultOntologyModel.listSubjectsWithProperty(categoryProperty, (RDFNode)this.defaultOntologyModel.getResource(indivURI)).toSet();
                    if (!this.managerMode) {
                        subjectsWithCategory.addAll(this.readOnlyOntologyModel.listSubjectsWithProperty(categoryProperty, (RDFNode)this.readOnlyOntologyModel.getResource(indivURI)).toSet());
                    }
                    for (Resource subject : subjectsWithCategory) {
                        subjectURI = subject.getURI();
                        subjectIndiv = this.getIndividual(subjectURI);
                        if (subjectIndiv == null) continue;
                        subjectClass = subjectIndiv.getOntClass();
                        switch (subjectClassURI = subjectClass.getURI()) {
                            case "http://www.grits-toolbox.org/ontology/sample#descriptor": {
                                descriptor = null;
                                if (!this.managerMode) {
                                    descriptor = this.ontologyManager.getDescriptorByUri(this.readOnlyOntologyModel, subjectURI);
                                }
                                if (descriptor == null) {
                                    descriptor = this.ontologyManager.getDescriptorByUri(this.defaultOntologyModel, subjectURI);
                                }
                                if (descriptor == null) break;
                                category.addDescriptor(descriptor);
                                break;
                            }
                            case "http://www.grits-toolbox.org/ontology/sample#descriptor_group": {
                                descriptorGroup = null;
                                if (!this.managerMode) {
                                    descriptorGroup = this.ontologyManager.getDescriptorGroupByUri(this.readOnlyOntologyModel, subjectURI);
                                }
                                if (descriptorGroup == null) {
                                    descriptorGroup = this.ontologyManager.getDescriptorGroupByUri(this.defaultOntologyModel, subjectURI);
                                }
                                if (descriptorGroup == null) break;
                                category.addDescriptorGroup(descriptorGroup);
                            }
                        }
                    }
                    categories.add(category);
                }
            }
            catch (Exception exception) {
                logger.error((Object)exception);
                throw exception;
            }
            logger.debug((Object)"- END   : Retrieving all Categories from the ontology model.");
            return categories;
        }
        catch (Exception ex) {
            logger.error((Object)ex);
            throw ex;
        }
    }

    public void updateCategorySelection(String categoryUri, String descriptorTypeUri, boolean selected) {
        logger.debug((Object)("- START : Updating Category " + categoryUri + " for " + descriptorTypeUri + " as selection " + selected + " in the ontology model."));
        try {
            Resource descriptorType = this.defaultOntologyModel.getResource(descriptorTypeUri);
            Individual category = this.defaultOntologyModel.getIndividual(categoryUri);
            if (descriptorType != null && category != null) {
                ObjectProperty property = this.defaultOntologyModel.getObjectProperty("http://www.grits-toolbox.org/ontology/sample#has_category");
                if (selected) {
                    if (!this.defaultOntologyModel.contains(descriptorType, (Property)property, (RDFNode)category)) {
                        descriptorType.addProperty((Property)property, (RDFNode)category);
                    }
                } else {
                    this.defaultOntologyModel.remove(descriptorType, (Property)property, (RDFNode)category);
                }
            }
        }
        catch (Exception ex) {
            logger.error((Object)ex);
        }
        logger.debug((Object)("- END   : Updating Category " + categoryUri + " for " + descriptorTypeUri + " as selection " + selected + " in the ontology model."));
    }

    public List<MeasurementUnit> getAllMeasurementUnits(OntModel model) {
        logger.debug((Object)"- START : Retrieving all Measurement Units from the ontology model.");
        ArrayList<MeasurementUnit> allUnits = new ArrayList<MeasurementUnit>();
        try {
            List<Individual> unitIndivs = this.ontologyManager.getAllIndiviudalsOfClass(model, MEASUREMENT_UNIT_CLASS_URI);
            for (Individual indiv : unitIndivs) {
                allUnits.add(new MeasurementUnit(indiv.getURI(), indiv.getLabel(null)));
            }
        }
        catch (Exception ex) {
            logger.error((Object)ex);
        }
        logger.debug((Object)"- END   : Retrieving all Measurement Units from the ontology model.");
        return allUnits;
    }

    public void addUnitToDescriptor(String descriptorURI, MeasurementUnit measurementUnit) {
        logger.debug((Object)("- START : Adding a Measurement Unit " + measurementUnit + " to Descriptor " + descriptorURI + " in the ontology model."));
        try {
            Individual unitIndiv = this.defaultOntologyModel.getIndividual(measurementUnit.getUri());
            if (unitIndiv == null && !this.managerMode) {
                unitIndiv = this.readOnlyOntologyModel.getIndividual(measurementUnit.getUri());
                this.defaultOntologyModel.createIndividual((Resource)unitIndiv);
            }
            if (unitIndiv == null) {
                Resource mUnit = this.defaultOntologyModel.createResource(measurementUnit.getUri(), (Resource)this.defaultOntologyModel.getOntClass(MEASUREMENT_UNIT_CLASS_URI));
                this.defaultOntologyModel.add(mUnit, RDFS.label, measurementUnit.getLabel());
            }
            this.addObjectPropertyStatement(descriptorURI, "has_unit_of_measurement", measurementUnit.getUri());
        }
        catch (Exception ex) {
            logger.error((Object)ex);
        }
        logger.debug((Object)("- END   : Adding a Measurement Unit " + measurementUnit + " to Descriptor " + descriptorURI + " in the ontology model."));
    }

    public void setDefaultUnitForDescriptor(String descriptorURI, String unitUri) {
        logger.debug((Object)("- START : Setting default measurement unit " + unitUri + " for Descriptor " + descriptorURI + " in the ontology model."));
        try {
            Individual descriptorIndiv = null;
            Property defaultUnitProperty = null;
            if (this.managerMode) {
                descriptorIndiv = this.defaultOntologyModel.getIndividual(descriptorURI);
                defaultUnitProperty = this.defaultOntologyModel.getProperty("http://www.grits-toolbox.org/ontology/sample#has_default_unit_of_measurement");
                descriptorIndiv.removeAll(defaultUnitProperty);
            } else {
                descriptorIndiv = this.readOnlyOntologyModel.getIndividual(descriptorURI);
                if (descriptorIndiv == null) {
                    descriptorIndiv = this.defaultOntologyModel.getIndividual(descriptorURI);
                    defaultUnitProperty = this.defaultOntologyModel.getProperty("http://www.grits-toolbox.org/ontology/sample#has_default_unit_of_measurement");
                    descriptorIndiv.removeAll(defaultUnitProperty);
                } else {
                    defaultUnitProperty = this.readOnlyOntologyModel.getProperty("http://www.grits-toolbox.org/ontology/sample#has_default_unit_of_measurement");
                    descriptorIndiv.removeAll(defaultUnitProperty);
                }
            }
            Individual unitIndiv = this.getIndividual(unitUri);
            if (descriptorIndiv != null && unitIndiv != null) {
                this.addObjectPropertyStatement(descriptorURI, "has_default_unit_of_measurement", unitUri);
            }
        }
        catch (Exception ex) {
            logger.error((Object)ex);
        }
        logger.debug((Object)("- END   : Setting default measurement unit " + unitUri + " for Descriptor " + descriptorURI + " in the ontology model."));
    }

    private void addObjectPropertyStatement(String subject, String property, String object) {
        Resource subjectResource = this.defaultOntologyModel.getResource(subject);
        Individual objectIndiv = this.defaultOntologyModel.getIndividual(object);
        if (subjectResource != null && objectIndiv != null) {
            ObjectProperty objectProperty = this.defaultOntologyModel.getObjectProperty("http://www.grits-toolbox.org/ontology/sample#" + property);
            subjectResource.addProperty((Property)objectProperty, (RDFNode)objectIndiv);
        }
    }

    public void removeTriple(String subjectURI, String propertyURI, String objectURI) {
        Resource subjectResource = this.defaultOntologyModel.getResource(subjectURI);
        Individual objectIndiv = this.defaultOntologyModel.getIndividual(objectURI);
        if (subjectResource != null && objectIndiv != null) {
            ObjectProperty objectProperty = this.defaultOntologyModel.getObjectProperty("http://www.grits-toolbox.org/ontology/sample#" + propertyURI);
            this.defaultOntologyModel.remove(subjectResource, (Property)objectProperty, (RDFNode)objectIndiv);
        }
    }

    public List<Template> getAllTemplates(OntModel model) {
        logger.debug((Object)"- START : Retrieving all Templates from the ontology model.");
        ArrayList<Template> templates = new ArrayList<Template>();
        try {
            List<Individual> templateIndivs = this.ontologyManager.getAllTemplates(model);
            for (Individual tempIndiv : templateIndivs) {
                templates.add(this.ontologyManager.getTemplate(model, tempIndiv.getURI()));
            }
        }
        catch (Exception ex) {
            logger.error((Object)ex);
        }
        logger.debug((Object)"- END   : Retrieving all Templates from the ontology model.");
        return templates;
    }

    public void removeDescriptorFromGroup(String groupURI, String descriptorURI) {
        logger.debug((Object)("- START : Removing Descriptor " + descriptorURI + " from Descriptor Group " + groupURI + " in the ontology model."));
        try {
            Individual groupIndiv = this.defaultOntologyModel.getIndividual(groupURI);
            Property property = this.getProperty("has_descriptor_group_context");
            Set dgContexts = this.defaultOntologyModel.listObjectsOfProperty((Resource)groupIndiv, property).toSet();
            Individual descriptorIndiv = this.getIndividual(descriptorURI);
            property = this.getProperty("has_descriptor");
            Resource dgContextToBeRemoved = null;
            for (RDFNode dgContext : dgContexts) {
                if (!dgContext.asResource().getPropertyResourceValue(property).getURI().equals(descriptorIndiv.getURI())) continue;
                dgContextToBeRemoved = dgContext.asResource();
                break;
            }
            this.defaultOntologyModel.removeAll(null, null, dgContextToBeRemoved);
            this.defaultOntologyModel.removeAll(dgContextToBeRemoved, null, null);
        }
        catch (Exception ex) {
            logger.error((Object)ex);
        }
        logger.debug((Object)("- END   : Removing Descriptor " + descriptorURI + " from Descriptor Group " + groupURI + " in the ontology model."));
    }

    private Resource getResource(String givenURI) {
        Individual resource = null;
        if (this.managerMode) {
            resource = this.defaultOntologyModel.getIndividual(givenURI);
        } else {
            resource = this.readOnlyOntologyModel.getIndividual(givenURI);
            if (resource == null) {
                resource = this.defaultOntologyModel.getIndividual(givenURI);
            }
        }
        return resource;
    }

    private Individual getIndividual(String givenURI) {
        Individual indiv = null;
        if (this.managerMode) {
            indiv = this.defaultOntologyModel.getIndividual(givenURI);
        } else {
            indiv = this.readOnlyOntologyModel.getIndividual(givenURI);
            if (indiv == null) {
                indiv = this.defaultOntologyModel.getIndividual(givenURI);
            }
        }
        return indiv;
    }

    private Property getProperty(String givenSuffixURI) {
        Property property = null;
        if (this.managerMode) {
            property = this.defaultOntologyModel.getProperty("http://www.grits-toolbox.org/ontology/sample#" + givenSuffixURI);
        } else {
            property = this.readOnlyOntologyModel.getProperty("http://www.grits-toolbox.org/ontology/sample#" + givenSuffixURI);
            if (property == null) {
                property = this.defaultOntologyModel.getProperty("http://www.grits-toolbox.org/ontology/sample#" + givenSuffixURI);
            }
        }
        return property;
    }

    private String createNewIndividualURI(String className) {
        try {
            logger.debug((Object)("- START : Creating a new Individual URI for class " + className + " in the ontology model."));
            String newURI = "http://www.grits-toolbox.org/ontology/sample#" + className.toLowerCase().replaceAll(" ", "_");
            Random random = new Random();
            int randomLength = 8;
            boolean notUnique = true;
            String randomSuffix = null;
            Resource searchResource = null;
            while (notUnique) {
                randomSuffix = "";
                int i = 0;
                while (i < randomLength) {
                    char randamCharacter = (char)(97 + random.nextInt(26));
                    randomSuffix = String.valueOf(randomSuffix) + randamCharacter;
                    ++i;
                }
                searchResource = ResourceFactory.createResource((String)(String.valueOf(newURI) + "_" + randomSuffix));
                notUnique = this.defaultOntologyModel.containsResource((RDFNode)searchResource);
                if (this.readOnlyOntologyModel == null) continue;
                boolean bl = notUnique = notUnique || this.readOnlyOntologyModel.containsResource((RDFNode)searchResource);
            }
            newURI = searchResource.getURI();
            logger.debug((Object)("- END   : Creating a new Individual URI for class " + className + " in the ontology model."));
            return newURI;
        }
        catch (Exception ex) {
            logger.error((Object)ex);
            throw ex;
        }
    }

    public void addDescriptorToGroup(String groupURI, String descriptorURI, Integer maxOcurrence, boolean mandatory) {
        logger.debug((Object)("- START : Adding Descriptor " + descriptorURI + " to Descriptor Group " + groupURI + " in the ontology model."));
        try {
            String dgContextURI = this.createNewIndividualURI("Descriptor Group Context");
            Individual dgContextIndiv = this.defaultOntologyModel.createIndividual(dgContextURI, (Resource)this.defaultOntologyModel.getOntClass("http://www.grits-toolbox.org/ontology/sample#descriptor_group_context"));
            dgContextIndiv.setLabel(dgContextURI.substring("http://www.grits-toolbox.org/ontology/sample#".length()), null);
            Property property = this.getProperty("is_mandatory");
            dgContextIndiv.addLiteral(property, mandatory);
            if (maxOcurrence != null) {
                property = this.getProperty("has_abbundance");
                dgContextIndiv.addLiteral(property, (Object)maxOcurrence);
            }
            Individual descriptorIndiv = this.getIndividual(descriptorURI);
            property = this.getProperty("has_descriptor");
            this.defaultOntologyModel.add((Resource)dgContextIndiv, property, (RDFNode)descriptorIndiv);
            Resource groupResource = this.getResource(groupURI);
            property = this.getProperty("has_descriptor_group_context");
            this.defaultOntologyModel.add(groupResource, property, (RDFNode)dgContextIndiv);
        }
        catch (Exception ex) {
            logger.error((Object)ex);
        }
        logger.debug((Object)("- END   : Adding Descriptor " + descriptorURI + " to Descriptor Group " + groupURI + " in the ontology model."));
    }

    public void setMandatoryStateDescriptorInGroup(String groupURI, String descriptorURI, boolean mandatory) {
        logger.debug((Object)("- START : Setting Descriptor " + descriptorURI + " as mandatory value " + mandatory + " for Descriptor Group " + groupURI + " in the ontology model."));
        try {
            Individual groupIndiv = this.defaultOntologyModel.getIndividual(groupURI);
            Property property = this.getProperty("has_descriptor_group_context");
            Set dgContexts = this.defaultOntologyModel.listObjectsOfProperty((Resource)groupIndiv, property).toSet();
            Individual descriptorIndiv = this.getIndividual(descriptorURI);
            property = this.getProperty("has_descriptor");
            Resource dgContextToBeUpdated = null;
            for (RDFNode dgContext : dgContexts) {
                if (!dgContext.asResource().getPropertyResourceValue(property).getURI().equals(descriptorIndiv.getURI())) continue;
                dgContextToBeUpdated = dgContext.asResource();
                break;
            }
            property = this.getProperty("is_mandatory");
            this.defaultOntologyModel.removeAll(dgContextToBeUpdated, property, null);
            dgContextToBeUpdated.addLiteral(property, mandatory);
        }
        catch (Exception ex) {
            logger.error((Object)ex);
        }
        logger.debug((Object)("- END   : Setting Descriptor " + descriptorURI + " as mandatory value " + mandatory + " for Descriptor Group " + groupURI + " in the ontology model."));
    }

    public void setMandatoryStateDescriptorInCategoryTemplate(String templateURI, String categoryURI, String descriptorURI, boolean mandatory) {
        block4: {
            logger.debug((Object)("- START : Setting Descriptor / Descriptor Group " + descriptorURI + " as mandatory value " + mandatory + " in category " + categoryURI + " for Template " + templateURI + " in the ontology model."));
            try {
                Individual templateIndiv = this.defaultOntologyModel.getIndividual(templateURI);
                Property property = this.getProperty("has_template_context");
                Set templateContexts = this.defaultOntologyModel.listObjectsOfProperty((Resource)templateIndiv, property).toSet();
                Individual descriptorIndiv = this.getIndividual(descriptorURI);
                property = this.getProperty("has_template_descriptor");
                Property categoryProperty = this.getProperty("has_category");
                Resource templateContextToBeUpdated = null;
                for (RDFNode tempContext : templateContexts) {
                    if (!tempContext.asResource().getPropertyResourceValue(property).getURI().equals(descriptorIndiv.getURI())) continue;
                    Individual templateContextIndiv = this.defaultOntologyModel.getIndividual(tempContext.asResource().getURI());
                    Set categoryResources = this.defaultOntologyModel.listObjectsOfProperty((Resource)templateContextIndiv, categoryProperty).toSet();
                    for (RDFNode categoryResource : categoryResources) {
                        if (!categoryResource.asResource().getURI().equals(categoryURI)) continue;
                        templateContextToBeUpdated = tempContext.asResource();
                        property = this.getProperty("is_mandatory");
                        this.defaultOntologyModel.removeAll(templateContextToBeUpdated, property, null);
                        templateContextToBeUpdated.addLiteral(property, mandatory);
                        break block4;
                    }
                    break;
                }
            }
            catch (Exception ex) {
                logger.error((Object)ex);
            }
        }
        logger.debug((Object)("- END   : Setting Descriptor / Descriptor Group " + descriptorURI + " as mandatory value " + mandatory + " in category " + categoryURI + " for Template " + templateURI + " in the ontology model."));
    }

    public void addDescriptorOrGroupToCategoryTemplate(String templateURI, String categoryURI, String descriptorURI, Integer maxOcurrence, boolean mandatory) {
        logger.debug((Object)("- START : Adding Descriptor / Descriptor Group " + descriptorURI + " for Template " + templateURI + " in category " + categoryURI + " in the ontology model."));
        try {
            Individual templateIndiv = this.defaultOntologyModel.getIndividual(templateURI);
            Property property = this.getProperty("has_template_context");
            property = this.getProperty("has_template_descriptor");
            String templateContextToBeUpdatedURI = null;
            Individual templateContextIndiv = null;
            templateContextToBeUpdatedURI = this.createNewIndividualURI("Template Context");
            templateContextIndiv = this.defaultOntologyModel.createIndividual(templateContextToBeUpdatedURI, (Resource)this.defaultOntologyModel.getOntClass("http://www.grits-toolbox.org/ontology/sample#template_context"));
            templateContextIndiv.setLabel(templateContextToBeUpdatedURI.substring("http://www.grits-toolbox.org/ontology/sample#".length()), null);
            property = this.getProperty("has_template_context");
            templateIndiv.addProperty(property, (RDFNode)templateContextIndiv);
            property = this.getProperty("has_template_descriptor");
            templateContextIndiv.addProperty(property, (RDFNode)this.getResource(descriptorURI));
            property = this.getProperty("has_category");
            templateContextIndiv.addProperty(property, (RDFNode)this.getResource(categoryURI));
            property = this.getProperty("is_mandatory");
            this.defaultOntologyModel.removeAll((Resource)templateContextIndiv, property, null);
            this.defaultOntologyModel.addLiteral((Resource)templateContextIndiv, property, mandatory);
            if (maxOcurrence != null) {
                property = this.getProperty("has_abbundance");
                this.defaultOntologyModel.removeAll((Resource)templateContextIndiv, property, null);
                this.defaultOntologyModel.addLiteral((Resource)templateContextIndiv, property, (Object)maxOcurrence);
            }
        }
        catch (Exception ex) {
            logger.error((Object)ex);
        }
        logger.debug((Object)("- END   : Adding Descriptor / Descriptor Group " + descriptorURI + " for Template " + templateURI + " in category " + categoryURI + " in the ontology model."));
    }

    public void removeDescriptorOrGroupFromTemplate(String templateURI, String categoryURI, String descriptorURI) {
        logger.debug((Object)("- START : Removing Descriptor / Descriptor Group " + descriptorURI + " for Template " + templateURI + " in category " + categoryURI + " in the ontology model."));
        try {
            Individual templateIndiv = this.defaultOntologyModel.getIndividual(templateURI);
            Property property = this.getProperty("has_template_context");
            Set templateContexts = this.defaultOntologyModel.listObjectsOfProperty((Resource)templateIndiv, property).toSet();
            property = this.getProperty("has_template_descriptor");
            Property categoryProperty = this.getProperty("has_category");
            Resource templateContextToBeUpdated = null;
            Individual templateContextIndiv = null;
            block2: for (RDFNode tempContext : templateContexts) {
                if (!tempContext.asResource().getPropertyResourceValue(property).getURI().equals(descriptorURI)) continue;
                templateContextIndiv = this.defaultOntologyModel.getIndividual(tempContext.asResource().getURI());
                Set categoryResources = this.defaultOntologyModel.listObjectsOfProperty((Resource)templateContextIndiv, categoryProperty).toSet();
                for (RDFNode categoryResource : categoryResources) {
                    if (!categoryResource.asResource().getURI().equals(categoryURI)) continue;
                    templateContextToBeUpdated = tempContext.asResource();
                    this.defaultOntologyModel.removeAll(templateContextToBeUpdated, categoryProperty, (RDFNode)this.getResource(categoryURI));
                    break block2;
                }
            }
            Set categoryResources = this.defaultOntologyModel.listObjectsOfProperty(templateContextIndiv, categoryProperty).toSet();
            if (categoryResources.isEmpty()) {
                this.defaultOntologyModel.removeAll(null, null, templateContextToBeUpdated);
                this.defaultOntologyModel.removeAll(templateContextToBeUpdated, null, null);
            }
        }
        catch (Exception ex) {
            logger.error((Object)ex);
        }
        logger.debug((Object)("- END   : Removing Descriptor / Descriptor Group " + descriptorURI + " for Template " + templateURI + " in category " + categoryURI + " in the ontology model."));
    }

    public String createNewIndividual(String classUri, String label) {
        try {
            logger.debug((Object)("- START : Creating a new Individual for class " + classUri + " with label " + label + " in the ontology model."));
            String indivURI = this.createNewIndividualURI(classUri.substring("http://www.grits-toolbox.org/ontology/sample#".length()));
            Individual indiv = this.defaultOntologyModel.createIndividual(indivURI, (Resource)this.defaultOntologyModel.getOntClass(classUri));
            indiv.setLabel(label, null);
            logger.debug((Object)("- END   : Creating a new Individual for class " + classUri + " with label " + label + " in the ontology model."));
            return indiv.getURI();
        }
        catch (Exception ex) {
            logger.error((Object)ex);
            throw ex;
        }
    }

    public void removeIndividual(String indivURI) {
        try {
            logger.debug((Object)("- START : Removing the individual " + indivURI + " from the ontology model."));
            Individual indivToBeRemoved = this.defaultOntologyModel.getIndividual(indivURI);
            switch (indivToBeRemoved.getOntClass().getURI()) {
                case "http://www.grits-toolbox.org/ontology/sample#descriptor": {
                    this.removeIndividualsAsSubjects("has_descriptor", indivURI);
                }
                case "http://www.grits-toolbox.org/ontology/sample#descriptor_group": {
                    this.removeIndividualsAsSubjects("has_template_descriptor", indivURI);
                    break;
                }
                case "http://www.grits-toolbox.org/ontology/sample#template": {
                    this.removeIndividualsAsObjects(indivURI, "has_template_context");
                }
            }
            indivToBeRemoved.remove();
            logger.debug((Object)("- END   : Removing the individual " + indivURI + " from the ontology model."));
        }
        catch (Exception ex) {
            logger.error((Object)ex);
            throw ex;
        }
    }

    private void removeIndividualsAsSubjects(String propertyName, String objectURI) {
        Resource objectResource = this.defaultOntologyModel.getResource(objectURI);
        Property property = this.defaultOntologyModel.getProperty("http://www.grits-toolbox.org/ontology/sample#" + propertyName);
        List resources = this.defaultOntologyModel.listSubjectsWithProperty(property, (RDFNode)objectResource).toList();
        Individual indivToBeRemoved = null;
        for (Resource resource : resources) {
            indivToBeRemoved = this.defaultOntologyModel.getIndividual(resource.getURI());
            indivToBeRemoved.remove();
        }
    }

    private void removeIndividualsAsObjects(String subjectURI, String propertyName) {
        Resource subjectResource = this.defaultOntologyModel.getResource(subjectURI);
        Property property = this.defaultOntologyModel.getProperty("http://www.grits-toolbox.org/ontology/sample#" + propertyName);
        List rdfNodes = this.defaultOntologyModel.listObjectsOfProperty(subjectResource, property).toList();
        Individual indivToBeRemoved = null;
        for (RDFNode rdfNode : rdfNodes) {
            indivToBeRemoved = this.defaultOntologyModel.getIndividual(rdfNode.asResource().getURI());
            indivToBeRemoved.remove();
        }
    }

    public List<Namespace> getAllNamespaces() {
        ArrayList<Namespace> namespaces = new ArrayList<Namespace>();
        logger.debug((Object)"- START : Retrieving all Namespaces from the ontology model.");
        try {
            Set instances = null;
            DatatypeProperty hasNamespaceFileProperty = null;
            DatatypeProperty hasNamespaceIdFileProperty = null;
            OntModel model = null;
            if (this.managerMode) {
                instances = this.defaultOntologyModel.listSubjectsWithProperty(RDF.type, (RDFNode)this.defaultOntologyModel.getResource(NAMESPACE_CLASS_URI)).toSet();
                hasNamespaceFileProperty = this.defaultOntologyModel.getDatatypeProperty("http://www.grits-toolbox.org/ontology/sample#has_namespace_file");
                hasNamespaceIdFileProperty = this.defaultOntologyModel.getDatatypeProperty("http://www.grits-toolbox.org/ontology/sample#has_namespace_id_file");
                model = this.defaultOntologyModel;
            } else {
                instances = this.readOnlyOntologyModel.listSubjectsWithProperty(RDF.type, (RDFNode)this.readOnlyOntologyModel.getResource(NAMESPACE_CLASS_URI)).toSet();
                hasNamespaceFileProperty = this.readOnlyOntologyModel.getDatatypeProperty("http://www.grits-toolbox.org/ontology/sample#has_namespace_file");
                hasNamespaceIdFileProperty = this.readOnlyOntologyModel.getDatatypeProperty("http://www.grits-toolbox.org/ontology/sample#has_namespace_id_file");
                model = this.readOnlyOntologyModel;
            }
            Individual indiv = null;
            for (Resource instance : instances) {
                indiv = this.getIndividual(instance.getURI());
                if (indiv != null) {
                    String namespaceFile = null;
                    String namespaceIdFile = null;
                    List nodes = model.listObjectsOfProperty((Resource)indiv, (Property)hasNamespaceFileProperty).toList();
                    if (!nodes.isEmpty()) {
                        namespaceFile = ((RDFNode)nodes.get(0)).asLiteral().toString();
                        nodes = model.listObjectsOfProperty((Resource)indiv, (Property)hasNamespaceIdFileProperty).toList();
                        namespaceIdFile = ((RDFNode)nodes.get(0)).asLiteral().toString();
                    }
                    namespaces.add(new Namespace(indiv.getURI(), indiv.getLabel(null), namespaceFile, namespaceIdFile));
                    continue;
                }
                String label = instance.getLocalName();
                namespaces.add(new Namespace(instance.getURI(), label, null, null));
            }
        }
        catch (Exception ex) {
            logger.error((Object)ex);
        }
        logger.debug((Object)"- END   : Retrieving all Namespaces from the ontology model.");
        return namespaces;
    }

    public void addNamespaceToDescriptor(String descriptorURI, String namespaceURI) {
        Set instances = this.defaultOntologyModel.listSubjectsWithProperty(RDF.type, (RDFNode)this.defaultOntologyModel.getResource(NAMESPACE_CLASS_URI)).toSet();
        Resource subjectResource = this.defaultOntologyModel.getResource(descriptorURI);
        ObjectProperty objectProperty = this.defaultOntologyModel.getObjectProperty("http://www.grits-toolbox.org/ontology/sample#has_namespace");
        Individual indiv = null;
        for (Resource instance : instances) {
            if (!instance.getURI().equals(namespaceURI)) continue;
            indiv = this.getIndividual(instance.getURI());
            if (indiv != null) {
                if (subjectResource == null) break;
                subjectResource.addProperty((Property)objectProperty, (RDFNode)indiv);
                break;
            }
            if (!instance.getURI().startsWith("http://www.w3.org/2001/XMLSchema")) continue;
            subjectResource.addProperty((Property)objectProperty, (RDFNode)instance);
        }
    }

    public void setMaxOccurrenceInGroup(String groupURI, String descriptorURI, Integer maxOccurrence) {
        logger.debug((Object)("- START : Updating Max Occurrence for Descriptor " + descriptorURI + " in Group " + groupURI + " as maxOccurrence " + maxOccurrence + " in the ontology model."));
        try {
            Individual groupIndiv = this.defaultOntologyModel.getIndividual(groupURI);
            Property property = this.getProperty("has_descriptor_group_context");
            Set dgContexts = this.defaultOntologyModel.listObjectsOfProperty((Resource)groupIndiv, property).toSet();
            Individual descriptorIndiv = this.getIndividual(descriptorURI);
            property = this.getProperty("has_descriptor");
            Resource dgContextToBeUpdated = null;
            for (RDFNode dgContext : dgContexts) {
                if (!dgContext.asResource().getPropertyResourceValue(property).getURI().equals(descriptorIndiv.getURI())) continue;
                dgContextToBeUpdated = dgContext.asResource();
                property = this.getProperty("has_abbundance");
                this.defaultOntologyModel.removeAll(dgContextToBeUpdated, property, null);
                if (maxOccurrence != null) {
                    dgContextToBeUpdated.addLiteral(property, (Object)maxOccurrence);
                }
                break;
            }
        }
        catch (Exception ex) {
            logger.error((Object)ex);
        }
        logger.debug((Object)("- END   : Updating Max Occurrence for Descriptor " + descriptorURI + " in Group " + groupURI + " as maxOccurrence maxOccurrence " + maxOccurrence + " in the ontology model."));
    }

    public void setMaxOccurrenceInTemplate(String templateURI, String categoryURI, String descriptorOrGroupURI, Integer maxOccurrence) {
        logger.debug((Object)("- START : Updating Max Occurrence for Descriptor / Descriptor Group " + descriptorOrGroupURI + " for Template " + descriptorOrGroupURI + " in Category " + categoryURI + " as " + maxOccurrence + " in the ontology model."));
        try {
            Individual tempIndiv = this.defaultOntologyModel.getIndividual(templateURI);
            Property property = this.getProperty("has_template_context");
            Set tempContexts = this.defaultOntologyModel.listObjectsOfProperty((Resource)tempIndiv, property).toSet();
            Individual descriptorIndiv = this.getIndividual(descriptorOrGroupURI);
            Individual categoryIndividual = this.getIndividual(categoryURI);
            property = this.getProperty("has_template_descriptor");
            Property categoryProperty = this.getProperty("has_category");
            Resource tempContextToBeUpdated = null;
            for (RDFNode tempContext : tempContexts) {
                if (!tempContext.asResource().getPropertyResourceValue(property).getURI().equals(descriptorIndiv.getURI()) || !tempContext.asResource().getPropertyResourceValue(categoryProperty).getURI().equals(categoryIndividual.getURI())) continue;
                tempContextToBeUpdated = tempContext.asResource();
                property = this.getProperty("has_abbundance");
                this.defaultOntologyModel.removeAll(tempContextToBeUpdated, property, null);
                if (maxOccurrence != null) {
                    tempContextToBeUpdated.addLiteral(property, (Object)maxOccurrence);
                }
                break;
            }
        }
        catch (Exception ex) {
            logger.error((Object)ex);
        }
        logger.debug((Object)("- END   : Updating Max Occurrence for Descriptor / Descriptor Group " + descriptorOrGroupURI + " for Template " + descriptorOrGroupURI + " in Category " + categoryURI + " as maxOccurrence " + maxOccurrence + " in the ontology model."));
    }
}

