/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.editor.samplemanager.actions.pages.rightside.category;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.jface.viewers.TableViewer;
import org.grits.toolbox.editor.samplemanager.actions.pages.rightside.AbstractAddAction;
import org.grits.toolbox.editor.samplemanager.dialogs.DescriptorSelectionDialog;
import org.grits.toolbox.editor.samplemanager.input.DescriptorWithFeatures;
import org.grits.toolbox.editor.samplemanager.pages.AbstractManagementPage;
import org.grits.toolbox.editor.samplemanager.pages.DesciptorManagementPage;
import org.grits.toolbox.entry.sample.model.Category;
import org.grits.toolbox.entry.sample.model.Descriptor;
import org.grits.toolbox.entry.sample.utilities.UtilityDescriptorDescriptorGroup;

public class AddDescriptorToCategoryAction
extends AbstractAddAction {
    private ArrayList<Descriptor> descriptors = new ArrayList();
    private HashMap<String, String> descriptorLabelToObjectMap;
    private List<DescriptorWithFeatures> descriptorsWithFeatures;
    private DescriptorSelectionDialog descriptorSelectionDialog;

    public AddDescriptorToCategoryAction(AbstractManagementPage page, TableViewer tableViewer) {
        super(page, tableViewer);
        this.descriptorSelectionDialog = new DescriptorSelectionDialog(page.getRightSectionOfPage().getShell(), false);
        this.descriptorSelectionDialog.setInitialPattern("?");
    }

    @Override
    public void run() {
        Category selectedCategory = (Category)this.tableViewer.getInput();
        this.descriptorSelectionDialog.setTitle("Add to the " + this.editor.getAllCategoriesURILabelMap().get(selectedCategory.getUri()));
        List descriptorLabels = UtilityDescriptorDescriptorGroup.getDescriptorLabels((Category)selectedCategory);
        this.descriptorSelectionDialog.setNotAllowedLabels(descriptorLabels);
        this.fillDialogChoices();
        this.descriptorSelectionDialog.open();
        if (this.descriptorSelectionDialog.getReturnCode() == 0) {
            String selectedDescriptorLabel = (String)this.descriptorSelectionDialog.getFirstResult();
            String descriptorUri = this.descriptorLabelToObjectMap.get(selectedDescriptorLabel);
            Descriptor descriptor = null;
            for (DescriptorWithFeatures d : this.descriptorsWithFeatures) {
                if (!d.getUri().equals(descriptorUri)) continue;
                descriptor = d.getDescriptor();
                break;
            }
            if (this.descriptorSelectionDialog.maxOccurrence != null) {
                descriptor.setMaxOccurrence(this.descriptorSelectionDialog.maxOccurrence);
            }
            selectedCategory.addDescriptor(descriptor);
            this.ontologyManagerApi.updateCategorySelection(selectedCategory.getUri(), descriptor.getUri(), true);
            this.ontologyManagerApi.updateMaxOccurrence(descriptor.getUri(), this.descriptorSelectionDialog.maxOccurrence);
            this.refreshModifed();
        }
    }

    private void fillDialogChoices() {
        this.descriptorLabelToObjectMap = new HashMap();
        this.descriptorsWithFeatures = ((DesciptorManagementPage)this.editor.findPage("0")).getAllDescriptorWithFeatures();
        for (DescriptorWithFeatures descriptorWithFeatures : this.descriptorsWithFeatures) {
            this.descriptors.add(descriptorWithFeatures.getDescriptor());
            this.descriptorLabelToObjectMap.put(descriptorWithFeatures.getLabel(), descriptorWithFeatures.getDescriptor().getUri());
        }
        this.descriptorSelectionDialog.setAllDescriptors(this.descriptors);
    }
}

