/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.editor.samplemanager.actions.pages;

import java.util.List;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.widgets.Shell;
import org.grits.toolbox.editor.samplemanager.actions.pages.rightside.AbstractAddAction;
import org.grits.toolbox.editor.samplemanager.actions.pages.rightside.LabelValidator;
import org.grits.toolbox.editor.samplemanager.pages.AbstractManagementPage;

public class CreateNewObjectInOntology
extends AbstractAddAction {
    private String classUri;
    private InputDialog dialogWithLabel;
    private LabelValidator labelValidator;

    public CreateNewObjectInOntology(AbstractManagementPage page, TableViewer tableViewer, String classUri) {
        super(page, tableViewer);
        this.classUri = classUri;
        this.setToolTipText("Add new to the Ontology");
        Shell shell = this.page.getRightSectionOfPage().getShell();
        this.labelValidator = new LabelValidator(this.getExistingLabels());
        this.dialogWithLabel = new InputDialog(shell, "New ", "Please give a unique label to it", "", (IInputValidator)this.labelValidator);
    }

    private List<String> getExistingLabels() {
        List<String> existingLabels = this.editor.getAllIndividualLabels(this.classUri);
        return existingLabels;
    }

    @Override
    public void run() {
        this.labelValidator.setExistingLabels(this.getExistingLabels());
        this.dialogWithLabel.open();
        if (this.dialogWithLabel.getReturnCode() == 0) {
            String label = this.dialogWithLabel.getValue().trim();
            String objectURI = this.createNewIndividualWithLabel(label);
            this.page.addInput(label, objectURI);
            this.refreshModifed();
        }
    }

    private String createNewIndividualWithLabel(String label) {
        return this.ontologyManagerApi.createNewIndividual(this.classUri, label);
    }
}

