/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.editor.samplemanager;

import com.hp.hpl.jena.ontology.Individual;
import com.hp.hpl.jena.ontology.OntClass;
import com.hp.hpl.jena.ontology.OntModel;
import com.hp.hpl.jena.ontology.OntModelSpec;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.vocabulary.RDF;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.editor.IFormPage;
import org.grits.toolbox.editor.samplemanager.input.ManagementEditorInput;
import org.grits.toolbox.editor.samplemanager.ontology.GritsOntologyManagerApi;
import org.grits.toolbox.editor.samplemanager.pages.AbstractManagementPage;
import org.grits.toolbox.editor.samplemanager.pages.CategoryManagementPage;
import org.grits.toolbox.editor.samplemanager.pages.DesciptorManagementPage;
import org.grits.toolbox.editor.samplemanager.pages.DescriptorGroupManagementPage;
import org.grits.toolbox.editor.samplemanager.pages.TemplateManagementPage;
import org.grits.toolbox.editor.samplemanager.util.ModelValidator;

public class ManagementEditor
extends FormEditor {
    private static final Logger logger = Logger.getLogger(ManagementEditor.class);
    public static final String EDITOR_ID = "org.grits.toolbox.editor.samplemanager.managementEditor";
    private OntModel localOntologyModel = null;
    private OntModel standardOntologyModel = null;
    private GritsOntologyManagerApi ontologyManagerApi = null;
    public boolean managerMode = false;
    private boolean dirtyFlag = false;

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        logger.debug((Object)"- START : Initializing the Sample Meta Data Manager Editor.");
        try {
            super.init(site, input);
            String localOntologyFile = ((ManagementEditorInput)input).getLocalOntologyFileName();
            FileInputStream localInputOntology = new FileInputStream(localOntologyFile);
            this.createLocalOntModel(localInputOntology);
            String standardOntologyFile = ((ManagementEditorInput)input).getStandardOntologyFileName();
            localInputOntology.close();
            if (standardOntologyFile == null) {
                this.setPartName("Meta Data Manager - Admin");
                this.managerMode = true;
                this.ontologyManagerApi = new GritsOntologyManagerApi(this.localOntologyModel);
            } else {
                this.setPartName("Meta Data Manager - User");
                FileInputStream standardInputOntology = new FileInputStream(standardOntologyFile);
                this.createStandardOntModel(standardInputOntology);
                this.ontologyManagerApi = new GritsOntologyManagerApi(this.standardOntologyModel, this.localOntologyModel);
                standardInputOntology.close();
            }
        }
        catch (Exception ex) {
            logger.error((Object)"Error while reading ontology file", (Throwable)ex);
            throw new PartInitException(ex.getMessage());
        }
        logger.debug((Object)"- END   : Initializing the Sample Meta Data Manager Editor.");
    }

    private void createStandardOntModel(FileInputStream standardInputOntology) {
        logger.debug((Object)"- START : Creating Standard Ontology Model.");
        this.standardOntologyModel = ModelFactory.createOntologyModel((OntModelSpec)OntModelSpec.OWL_DL_MEM_RDFS_INF, null);
        this.standardOntologyModel.read((InputStream)standardInputOntology, "http://www.grits-toolbox.org/ontology/sample#");
        logger.debug((Object)"- END   : Creating Standard Ontology Model.");
    }

    private void createLocalOntModel(FileInputStream locaInputOntology) throws FileNotFoundException {
        logger.debug((Object)"- START : Creating Local Ontology Model.");
        this.localOntologyModel = ModelFactory.createOntologyModel((OntModelSpec)OntModelSpec.OWL_DL_MEM_RDFS_INF, null);
        this.localOntologyModel.read((InputStream)locaInputOntology, "http://www.grits-toolbox.org/ontology/sample#");
        logger.debug((Object)"- END   : Creating Local Ontology Model.");
    }

    public GritsOntologyManagerApi getOntologyManagerApi() {
        return this.ontologyManagerApi;
    }

    public OntModel getStandardOntologyModel() {
        return this.standardOntologyModel;
    }

    public OntModel getLocalOntologyModel() {
        return this.localOntologyModel;
    }

    public void synchronizingFileWithModel() throws Exception {
        block8: {
            logger.debug((Object)"- START : Synchronizing ontology file with model.");
            try {
                String currentFileName = ((ManagementEditorInput)this.getEditorInput()).getLocalOntologyFileName();
                File currentFile = new File(currentFileName);
                Path currentFilePath = currentFile.toPath();
                String parentFolderLocation = currentFile.getParentFile().getAbsolutePath();
                File parentFolder = new File(parentFolderLocation);
                boolean exists = parentFolder.exists();
                if (!exists) {
                    MessageDialog.openWarning((Shell)this.getContainer().getShell(), (String)"Missing Folder", (String)"The parent folder for the ontology could not be found. A new folder will be created.");
                    exists = parentFolder.mkdirs();
                }
                boolean bl = exists = currentFile.exists() ? true : currentFile.createNewFile();
                if (exists) {
                    File backUpFile = new File(String.valueOf(parentFolderLocation) + File.separator + "Backup_Ontology.owl");
                    FileOutputStream backupOutputStream = new FileOutputStream(backUpFile);
                    Files.copy(currentFilePath, backupOutputStream);
                    ((OutputStream)backupOutputStream).close();
                    try {
                        FileWriter fileWriter = new FileWriter(currentFileName);
                        this.localOntologyModel.write((Writer)fileWriter, "RDF/XML-ABBREV");
                        fileWriter.close();
                        backUpFile.delete();
                        break block8;
                    }
                    catch (Exception ex) {
                        logger.error((Object)"Error copying current model to ontology file");
                        try {
                            FileOutputStream os = new FileOutputStream(currentFile);
                            Files.copy(backUpFile.toPath(), os);
                            os.close();
                            backUpFile.delete();
                            break block8;
                        }
                        catch (IOException iOException) {
                            logger.error((Object)"Error while reloading backup ontology file.", (Throwable)ex);
                            throw ex;
                        }
                    }
                }
                logger.fatal((Object)("Ontology File " + currentFileName + " could not be found or created"));
                MessageDialog.openError((Shell)this.getActivePageInstance().getManagedForm().getForm().getShell(), (String)"Error Saving Ontology", (String)"The ontology file could not be saved.");
            }
            catch (Exception ex) {
                logger.error((Object)"Error synchronizing model with ontology file.", (Throwable)ex);
                throw ex;
            }
        }
        logger.debug((Object)"- END   : Synchronizing ontology file with model.");
    }

    protected void addPages() {
        logger.debug((Object)"- START : Retrieving lists and Creating pages for the Manager Editor.");
        try {
            try {
                this.addPage(0, (IFormPage)new DesciptorManagementPage(this));
                this.addPage(1, (IFormPage)new DescriptorGroupManagementPage(this));
                this.addPage(2, (IFormPage)new TemplateManagementPage(this));
                this.addPage(3, (IFormPage)new CategoryManagementPage(this));
            }
            catch (PartInitException e) {
                logger.error((Object)"Error adding pages", (Throwable)e);
            }
        }
        catch (Exception ex) {
            logger.error((Object)"Error creating pages.", (Throwable)ex);
            throw ex;
        }
        logger.debug((Object)"- END   : Retrieving lists and Creating pages for the Manager Editor.");
    }

    protected void pageChange(int newPageIndex) {
        logger.debug((Object)("- START : Reloading while changing to page " + newPageIndex));
        try {
            super.pageChange(newPageIndex);
            ((AbstractManagementPage)this.getActivePageInstance()).refreshPage();
        }
        catch (Exception ex) {
            logger.error((Object)ex);
        }
        logger.debug((Object)("- END   : Reloading while changing to page " + newPageIndex));
    }

    public void doSave(IProgressMonitor monitor) {
        logger.debug((Object)"- START : Saving model.");
        try {
            String warnMessage = ModelValidator.validateModel(this.ontologyManagerApi, this.localOntologyModel);
            if (warnMessage != null) {
                MessageDialog.openWarning((Shell)this.getActivePageInstance().getManagedForm().getForm().getShell(), (String)"Model Warning", (String)("Warning : The changes are being saved with following potential problem(s) : \n\n" + warnMessage));
            }
            this.synchronizingFileWithModel();
            this.resetDirtyFlag();
        }
        catch (Exception ex) {
            logger.error((Object)"Error saving Model.", (Throwable)ex);
            MessageDialog.openError((Shell)this.getActivePageInstance().getManagedForm().getForm().getShell(), (String)"Error In Saving", (String)"The changes could not be saved to the file.");
        }
        logger.debug((Object)"- END   : Saving model.");
    }

    private void resetDirtyFlag() {
        this.dirtyFlag = false;
        this.firePropertyChange(257);
    }

    public void doSaveAs() {
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public boolean isDirty() {
        return this.dirtyFlag;
    }

    public void markDirty() {
        this.dirtyFlag = true;
        super.firePropertyChange(257);
    }

    public HashMap<String, String> getAllCategoriesURILabelMap() {
        if (this.managerMode) {
            return this.ontologyManagerApi.getAllCategoriesURILabelMap(this.localOntologyModel);
        }
        return this.ontologyManagerApi.getAllCategoriesURILabelMap(this.standardOntologyModel);
    }

    public List<String> getAllIndividualLabels(String classUri) {
        try {
            Individual indiv;
            logger.debug((Object)("- START : Retrieving all labels for the class " + classUri));
            ArrayList<String> allIndiviualLabels = new ArrayList<String>();
            OntClass classResource = this.localOntologyModel.getOntClass(classUri);
            Set results = this.localOntologyModel.listSubjectsWithProperty(RDF.type, (RDFNode)classResource).toSet();
            for (Resource result : results) {
                indiv = this.localOntologyModel.getIndividual(result.getURI());
                allIndiviualLabels.add(indiv.getLabel(null));
            }
            if (!this.managerMode) {
                results = this.standardOntologyModel.listSubjectsWithProperty(RDF.type, (RDFNode)classResource).toSet();
                for (Resource result : results) {
                    indiv = this.standardOntologyModel.getIndividual(result.getURI());
                    allIndiviualLabels.add(indiv.getLabel(null));
                }
            }
            logger.debug((Object)("- END   : Retrieving all labels for the class " + classUri));
            return allIndiviualLabels;
        }
        catch (Exception ex) {
            logger.error((Object)ex);
            throw ex;
        }
    }
}

