/*
 * Decompiled with CFR 0.152.
 */
package org.eurocarbdb.resourcesdb.io;

import java.util.ArrayList;
import java.util.List;
import org.eurocarbdb.resourcesdb.Config;
import org.eurocarbdb.resourcesdb.GlycanNamescheme;
import org.eurocarbdb.resourcesdb.ResourcesDbException;
import org.eurocarbdb.resourcesdb.atom.Atom;
import org.eurocarbdb.resourcesdb.atom.AtomConnection;
import org.eurocarbdb.resourcesdb.atom.Isotope;
import org.eurocarbdb.resourcesdb.atom.Periodic;
import org.eurocarbdb.resourcesdb.monosaccharide.Anomer;
import org.eurocarbdb.resourcesdb.monosaccharide.Basetype;
import org.eurocarbdb.resourcesdb.monosaccharide.CoreModification;
import org.eurocarbdb.resourcesdb.monosaccharide.Monosaccharide;
import org.eurocarbdb.resourcesdb.monosaccharide.MonosaccharideDataBuilder;
import org.eurocarbdb.resourcesdb.monosaccharide.MonosaccharideException;
import org.eurocarbdb.resourcesdb.monosaccharide.MonosaccharideLinkingPosition;
import org.eurocarbdb.resourcesdb.monosaccharide.MonosaccharideSynonym;
import org.eurocarbdb.resourcesdb.monosaccharide.Stereocode;
import org.eurocarbdb.resourcesdb.monosaccharide.SubstituentAlias;
import org.eurocarbdb.resourcesdb.monosaccharide.Substitution;
import org.eurocarbdb.resourcesdb.nonmonosaccharide.AglyconAlias;
import org.eurocarbdb.resourcesdb.nonmonosaccharide.AglyconTemplate;
import org.eurocarbdb.resourcesdb.nonmonosaccharide.NonBasetypeLinkingPosition;
import org.eurocarbdb.resourcesdb.representation.ResidueRepresentation;
import org.eurocarbdb.resourcesdb.template.AglyconTemplateContainer;
import org.eurocarbdb.resourcesdb.template.BasetypeTemplateContainer;
import org.eurocarbdb.resourcesdb.template.SubstituentTemplate;
import org.eurocarbdb.resourcesdb.template.SubstituentTemplateContainer;
import org.eurocarbdb.resourcesdb.template.TemplateContainer;
import org.eurocarbdb.resourcesdb.util.HibernateUtil;
import org.hibernate.Criteria;
import org.hibernate.Query;
import org.hibernate.Transaction;
import org.hibernate.classic.Session;
import org.hibernate.criterion.Conjunction;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.DetachedCriteria;
import org.hibernate.criterion.Disjunction;
import org.hibernate.criterion.Restrictions;

public class HibernateAccess {
    public static boolean writeElementsToDB() throws ResourcesDbException {
        Session hbSession = HibernateUtil.getSessionFactory().getCurrentSession();
        Transaction tx = hbSession.beginTransaction();
        try {
            for (Periodic elem : Periodic.values()) {
                System.out.println("write element " + elem.getSymbol() + "...");
                hbSession.save((Object)elem);
                for (Isotope iso : elem.getIsotopes()) {
                    System.out.println("   write isotope " + iso.getNeutrons() + "...");
                    hbSession.save((Object)iso);
                }
            }
            hbSession.getTransaction().commit();
        }
        catch (Exception e) {
            System.err.println(e);
            tx.rollback();
            return false;
        }
        return true;
    }

    public static ArrayList<Periodic> getElementListFromDB() {
        ArrayList resultList = null;
        Session hbSession = HibernateUtil.getSessionFactory().getCurrentSession();
        Transaction tx = hbSession.beginTransaction();
        try {
            resultList = (ArrayList)hbSession.createQuery("from Element").list();
        }
        catch (Exception e) {
            tx.rollback();
        }
        return resultList;
    }

    public static boolean writeBasetypeToDB(Basetype bt, BasetypeTemplateContainer container) {
        return HibernateAccess.writeBasetypeToDB(bt, container, true);
    }

    public static boolean writeBasetypeToDB(Basetype bt, BasetypeTemplateContainer container, boolean commit) {
        Session session = HibernateUtil.getSessionFactory().getCurrentSession();
        Transaction tx = session.beginTransaction();
        try {
            if (bt.getName() == null) {
                bt.buildName();
            }
            if (bt.getSuperclass() == null) {
                bt.setSuperclass(container.getSuperclassTemplateBySize(bt.getSize()).getBaseName());
            }
            if (bt.getIsSuperclassFlag() == null) {
                bt.checkIsSuperclass();
            }
            if (bt.getComposition() == null) {
                bt.buildComposition();
            }
            session.save((Object)bt);
            for (CoreModification mod : bt.getCoreModifications()) {
                session.save((Object)mod);
            }
            if (bt.getAtoms() == null) {
                bt.buildAtoms();
            }
            for (Atom a : bt.getAtoms()) {
                session.save("BasetypeAtom", (Object)a);
            }
            for (Atom a : bt.getAtoms()) {
                for (AtomConnection ac : a.getConnections()) {
                    session.save("BasetypeAtomConnection", (Object)ac);
                }
            }
            if (commit) {
                tx.commit();
            }
        }
        catch (Exception e) {
            tx.rollback();
            System.err.println("Exception in HibernateAccess.writeBasetypeToDB(bt): " + e);
            return false;
        }
        return true;
    }

    public static Basetype getBasetypeFromDB(String name) {
        Basetype bt = null;
        Session session = HibernateUtil.getSessionFactory().getCurrentSession();
        Transaction tx = session.beginTransaction();
        try {
            bt = (Basetype)session.createQuery("from Basetype where name='" + name + "'").uniqueResult();
        }
        catch (Exception e) {
            tx.rollback();
        }
        return bt;
    }

    public static Basetype getBasetypeFromDB(int id) {
        Basetype bt = null;
        Session session = HibernateUtil.getSessionFactory().getCurrentSession();
        Transaction tx = session.beginTransaction();
        try {
            bt = (Basetype)session.createQuery("from Basetype where id=" + id).uniqueResult();
        }
        catch (Exception e) {
            tx.rollback();
        }
        return bt;
    }

    public static Basetype storeOrUpdateBasetype(Basetype bt, BasetypeTemplateContainer container) throws ResourcesDbException {
        return HibernateAccess.storeOrUpdateBasetype(bt, container, true);
    }

    public static Basetype storeOrUpdateBasetype(Basetype bt, BasetypeTemplateContainer container, boolean commit) throws ResourcesDbException {
        Basetype dbBasetype;
        if (bt.getName() == null) {
            bt.buildName();
        }
        if ((dbBasetype = HibernateAccess.getBasetypeFromDB(bt.getName())) == null) {
            HibernateAccess.writeBasetypeToDB(bt, container, commit);
            return bt;
        }
        return dbBasetype;
    }

    public static Monosaccharide getMonosaccharideFromDB(String name) {
        Monosaccharide ms = null;
        Session session = HibernateUtil.getSessionFactory().getCurrentSession();
        Transaction tx = session.beginTransaction();
        try {
            ms = (Monosaccharide)session.createQuery("from Monosaccharide where name='" + name + "'").uniqueResult();
        }
        catch (Exception e) {
            tx.rollback();
        }
        return ms;
    }

    public static Monosaccharide getMonosaccharideFromDB(int id) {
        Monosaccharide ms = null;
        Session session = HibernateUtil.getSessionFactory().getCurrentSession();
        Transaction tx = session.beginTransaction();
        try {
            ms = (Monosaccharide)session.createQuery("from Monosaccharide where id=" + id).uniqueResult();
        }
        catch (Exception e) {
            tx.rollback();
        }
        return ms;
    }

    public static ArrayList<Monosaccharide> getMonosaccharideListByFuzzyMonosaccharide(Monosaccharide mono) {
        return HibernateAccess.getMonosaccharideListByFuzzyMonosaccharide(mono, true, true);
    }

    public static ArrayList<Monosaccharide> getMonosaccharideListByFuzzyMonosaccharide(Monosaccharide mono, boolean matchCoremodCount, boolean matchSubstCount) {
        Session session = HibernateUtil.getSessionFactory().getCurrentSession();
        session.beginTransaction();
        Criteria query = session.createCriteria(Monosaccharide.class);
        query.createAlias("basetype", "bt");
        if (mono.countCoreModifications() > 0) {
            query.createAlias("bt.coreModifications", "mod");
        }
        if (mono.countSubstitutions() > 0) {
            query.createAlias("substitutions", "subst", 1);
        }
        Conjunction monoJunc = Restrictions.conjunction();
        query.add((Criterion)monoJunc);
        if (mono.getSize() > 0) {
            monoJunc.add((Criterion)Restrictions.eq((String)"bt.size", (Object)mono.getSize()));
        }
        if (mono.getStereoStr() != null && mono.getStereoStr().length() > 0) {
            String stereo1 = null;
            String stereo2 = null;
            if (mono.getStereocode().hasRelativePosition()) {
                try {
                    stereo1 = Stereocode.relativeToAbsolute(mono.getStereoStr());
                    stereo2 = Stereocode.relativeToAbsolute(Stereocode.changeRelativeDLinStereoString(mono.getStereoStr()));
                    stereo2 = stereo2.replaceAll("x", "_");
                }
                catch (ResourcesDbException me) {
                    if (Config.getGlobalConfig().isPrintErrorMsgs()) {
                        System.err.println(me);
                        me.printStackTrace();
                    }
                }
            } else {
                stereo1 = mono.getStereoStr();
            }
            if (stereo1 != null) {
                stereo1 = stereo1.replaceAll("x", "_");
                if (stereo2 != null) {
                    monoJunc.add((Criterion)Restrictions.disjunction().add((Criterion)Restrictions.like((String)"bt.stereoStr", (Object)stereo1)).add((Criterion)Restrictions.like((String)"bt.stereoStr", (Object)stereo2)));
                } else {
                    monoJunc.add((Criterion)Restrictions.like((String)"bt.stereoStr", (Object)stereo1));
                }
            }
        }
        if (mono.getAnomer() != null && !mono.getAnomer().equals((Object)Anomer.UNKNOWN)) {
            monoJunc.add((Criterion)Restrictions.eq((String)"bt.anomerSymbol", (Object)mono.getAnomer().getSymbol()));
        }
        if (mono.getRingStart() != 0) {
            monoJunc.add((Criterion)Restrictions.eq((String)"bt.ringStart", (Object)mono.getRingStart()));
        }
        if (mono.getRingEnd() != 0) {
            monoJunc.add((Criterion)Restrictions.eq((String)"bt.ringEnd", (Object)mono.getRingEnd()));
        }
        if (mono.countCoreModifications() > 0) {
            Conjunction modListConjunct = Restrictions.conjunction();
            for (CoreModification mod : mono.getCoreModifications()) {
                Conjunction modConjunct = Restrictions.conjunction();
                modConjunct.add((Criterion)Restrictions.eq((String)"mod.name", (Object)mod.getName()));
                if (mod.getPosition1().size() > 1) {
                    Disjunction modPos1Disjunct = Restrictions.disjunction();
                    for (Integer pos1 : mod.getPosition1()) {
                        if (pos1 == 0) continue;
                        modPos1Disjunct.add((Criterion)Restrictions.eq((String)"mod.intValuePosition1", (Object)pos1));
                    }
                    modConjunct.add((Criterion)modPos1Disjunct);
                } else if (mod.getIntValuePosition1() > 0) {
                    modConjunct.add((Criterion)Restrictions.eq((String)"mod.intValuePosition1", (Object)mod.getIntValuePosition1()));
                }
                if (mod.hasPosition2()) {
                    if (mod.getPosition2().size() > 1) {
                        Disjunction modPos2Disjunct = Restrictions.disjunction();
                        for (Integer pos2 : mod.getPosition2()) {
                            if (pos2 == 0) continue;
                            modPos2Disjunct.add((Criterion)Restrictions.eq((String)"mod.intValuePosition2", (Object)pos2));
                        }
                        modConjunct.add((Criterion)modPos2Disjunct);
                    } else if (mod.getIntValuePosition2() > 0) {
                        modConjunct.add((Criterion)Restrictions.eq((String)"mod.intValuePosition2", (Object)mod.getIntValuePosition2()));
                    }
                }
                modListConjunct.add((Criterion)modConjunct);
            }
            monoJunc.add((Criterion)modListConjunct);
        }
        if (mono.countSubstitutions() > 0) {
            Conjunction substListConjunct = Restrictions.conjunction();
            for (Substitution subst : mono.getSubstitutions()) {
                Conjunction substConjunct = Restrictions.conjunction();
                substConjunct.add((Criterion)Restrictions.eq((String)"subst.name", (Object)subst.getName()));
                if (subst.getPosition1().size() > 1) {
                    Disjunction substPos1Disjunct = Restrictions.disjunction();
                    for (Integer pos1 : subst.getPosition1()) {
                        if (pos1 == 0) continue;
                        substPos1Disjunct.add((Criterion)Restrictions.eq((String)"subst.intValuePosition1", (Object)pos1));
                    }
                    substConjunct.add((Criterion)substPos1Disjunct);
                } else if (subst.getIntValuePosition1() > 0) {
                    substConjunct.add((Criterion)Restrictions.eq((String)"subst.intValuePosition1", (Object)subst.getIntValuePosition1()));
                }
                if (subst.getLinkagetype1() != null) {
                    substConjunct.add((Criterion)Restrictions.eq((String)"subst.linkagetypeStr1", (Object)subst.getLinkagetypeStr1()));
                }
                if (subst.hasPosition2()) {
                    if (subst.getPosition2().size() > 1) {
                        Disjunction substPos2Disjunct = Restrictions.disjunction();
                        for (Integer pos2 : subst.getPosition2()) {
                            if (pos2 == 0) continue;
                            substPos2Disjunct.add((Criterion)Restrictions.eq((String)"subst.intValuePosition2", (Object)pos2));
                        }
                        substConjunct.add((Criterion)substPos2Disjunct);
                    } else if (subst.getIntValuePosition2() > 0) {
                        substConjunct.add((Criterion)Restrictions.eq((String)"subst.intValuePosition2", (Object)subst.getIntValuePosition2()));
                    }
                    if (subst.getLinkagetype2() != null) {
                        substConjunct.add((Criterion)Restrictions.eq((String)"subst.linkagetypeStr2", (Object)subst.getLinkagetypeStr2()));
                    }
                }
                substListConjunct.add((Criterion)substConjunct);
            }
            monoJunc.add((Criterion)substListConjunct);
        }
        query.setResultTransformer(Criteria.DISTINCT_ROOT_ENTITY);
        List queryList = query.list();
        ArrayList<Monosaccharide> resultList = new ArrayList<Monosaccharide>();
        for (Monosaccharide resultMs : queryList) {
            if (resultMs == null || matchCoremodCount && resultMs.countCoreModifications() != mono.countCoreModifications() || matchSubstCount && resultMs.countSubstitutions() != mono.countSubstitutions()) continue;
            resultList.add(resultMs);
        }
        return resultList;
    }

    public static List<Monosaccharide> getMonosaccharideListByAliasName(String aliasname, GlycanNamescheme scheme) {
        List msList = null;
        Session session = HibernateUtil.getSessionFactory().getCurrentSession();
        Transaction tx = session.beginTransaction();
        try {
            Criteria query = session.createCriteria(Monosaccharide.class);
            query.createAlias("synonyms", "alias");
            Conjunction monoJunc = Restrictions.conjunction();
            query.add((Criterion)monoJunc);
            if (scheme == null || scheme.isCaseSensitive()) {
                monoJunc.add((Criterion)Restrictions.like((String)"alias.name", (Object)aliasname));
            } else {
                monoJunc.add(Restrictions.ilike((String)"alias.name", (Object)aliasname));
            }
            if (scheme != null && !scheme.equals((Object)GlycanNamescheme.AUTO)) {
                monoJunc.add((Criterion)Restrictions.eq((String)"alias.nameschemeStr", (Object)scheme.name()));
            }
            query.setResultTransformer(Criteria.DISTINCT_ROOT_ENTITY);
            msList = query.list();
        }
        catch (Exception e) {
            tx.rollback();
        }
        return msList;
    }

    public static boolean writeMonosaccharideToDB(Monosaccharide ms, TemplateContainer container) {
        Session session = HibernateUtil.getSessionFactory().getCurrentSession();
        Transaction tx = session.beginTransaction();
        try {
            Basetype bt;
            if (ms.getName() == null) {
                ms.buildName();
            }
            if ((bt = ms.getBasetype()).getName() == null) {
                bt.buildName();
            }
            if (ms.getSynonyms() == null || ms.getSynonyms().size() == 0) {
                MonosaccharideDataBuilder.buildSynonyms(ms, container);
            }
            if (ms.getComposition() == null) {
                MonosaccharideDataBuilder.buildComposition(ms);
            }
            if (ms.getAtoms() == null || ms.getAtoms().size() == 0) {
                MonosaccharideDataBuilder.buildAtoms(ms, Config.getGlobalConfig());
            }
            if (ms.getAtoms() == null || ms.getAtoms().size() == 0) {
                System.err.println("no atoms set in ms " + ms.toString());
                return false;
            }
            if (ms.getRepresentations() == null || ms.getRepresentations().size() == 0) {
                ms.buildRepresentations();
            }
            ms.setBasetype(HibernateAccess.storeOrUpdateBasetype(bt, container.getBasetypeTemplateContainer(), false));
            System.out.println("store monosaccharide " + ms.getName());
            session.save((Object)ms);
            for (Substitution subst : ms.getSubstitutions()) {
                session.save("Substitution", (Object)subst);
            }
            for (Atom a : ms.getAtoms()) {
                session.save("MonosaccharideAtom", (Object)a);
            }
            for (Atom a : ms.getAtoms()) {
                for (AtomConnection ac : a.getConnections()) {
                    session.save("MonosaccharideAtomConnection", (Object)ac);
                }
            }
            for (MonosaccharideSynonym alias : ms.getSynonyms()) {
                if (alias.getName() == null) continue;
                session.save((Object)alias);
                for (Substitution extSubst : alias.getExternalSubstList()) {
                    session.save("MonosaccharideSynonymExternalSubstituent", (Object)extSubst);
                }
            }
            for (ResidueRepresentation monoRep : ms.getRepresentations()) {
                session.save("MonosaccharideRepresentation", (Object)monoRep);
            }
            for (MonosaccharideLinkingPosition linkPos : ms.getPossibleLinkingPositions()) {
                session.save((Object)linkPos);
            }
            tx.commit();
            Monosaccharide dbMs = HibernateAccess.getMonosaccharideFromDB(ms.getDbId());
            System.out.println("stored ms with id " + dbMs.getDbId());
        }
        catch (Exception e) {
            if (Config.getGlobalConfig().isPrintErrorMsgs()) {
                System.err.println("Exception in WriteMonosaccharideToDB(): " + e);
                e.printStackTrace();
            }
            tx.rollback();
            return false;
        }
        return true;
    }

    public static boolean updateMonosaccharide(Monosaccharide dbMs) {
        Session session = HibernateUtil.getSessionFactory().getCurrentSession();
        Transaction tx = session.beginTransaction();
        try {
            session.update((Object)dbMs);
        }
        catch (Exception e) {
            if (Config.getGlobalConfig().isPrintErrorMsgs()) {
                System.err.println("Exception in HibernateAccess.updateMonosaccharide(): " + e);
                e.printStackTrace();
            }
            tx.rollback();
            return false;
        }
        return true;
    }

    public static Monosaccharide storeOrUpdateMonosaccharide(Monosaccharide ms, TemplateContainer container) throws ResourcesDbException {
        Monosaccharide dbMs;
        if (ms.getName() == null || ms.getName().equals("")) {
            ms.buildName();
        }
        if ((dbMs = HibernateAccess.getMonosaccharideFromDB(ms.getName())) == null) {
            HibernateAccess.writeMonosaccharideToDB(ms, container);
            return ms;
        }
        for (ResidueRepresentation msRep : ms.getRepresentations()) {
            if (dbMs.hasRepresentation(msRep.getType(), msRep.getFormat())) continue;
            dbMs.addRepresentation(msRep);
            System.out.println("store representation " + msRep.toString());
            HibernateAccess.storeOrUpdateMonosaccharideRepresentation(msRep);
        }
        return dbMs;
    }

    public static MonosaccharideSynonym storeOrUpdateMonosaccharideSynonym(MonosaccharideSynonym msAlias) throws ResourcesDbException {
        Session session = HibernateUtil.getSessionFactory().getCurrentSession();
        Transaction tx = session.beginTransaction();
        try {
            session.saveOrUpdate((Object)msAlias);
            for (Substitution extSubst : msAlias.getExternalSubstList()) {
                session.saveOrUpdate("MonosaccharideSynonymExternalSubstituent", (Object)extSubst);
            }
            tx.commit();
        }
        catch (Exception e) {
            tx.rollback();
            throw new ResourcesDbException("Error in storing or updating monosaccharide alias", e);
        }
        return msAlias;
    }

    public static ResidueRepresentation storeOrUpdateMonosaccharideRepresentation(ResidueRepresentation monoRep) throws ResourcesDbException {
        Session session = HibernateUtil.getSessionFactory().getCurrentSession();
        Transaction tx = session.beginTransaction();
        try {
            session.saveOrUpdate("MonosaccharideRepresentation", (Object)monoRep);
            tx.commit();
        }
        catch (Exception e) {
            tx.rollback();
            MonosaccharideException me = new MonosaccharideException("Error in storing or updating monosaccharide representation");
            me.initCause(e);
            throw me;
        }
        return monoRep;
    }

    private static void writeOrUpdateSingleSubstituentTemplateToDB(SubstituentTemplate substTmpl, org.hibernate.Session openSession) {
        SubstituentTemplate dbTmpl = (SubstituentTemplate)openSession.createQuery("from SubstituentTemplate where name='" + substTmpl.getName() + "'").uniqueResult();
        if (dbTmpl == null) {
            openSession.save((Object)substTmpl);
            for (SubstituentAlias alias : substTmpl.getAliasList()) {
                openSession.save((Object)alias);
            }
            for (Atom a : substTmpl.getAtoms()) {
                openSession.save("SubstituentAtom", (Object)a);
            }
            for (Atom a : substTmpl.getAtoms()) {
                for (AtomConnection ac : a.getConnections()) {
                    openSession.save("SubstituentAtomConnection", (Object)ac);
                }
            }
            try {
                for (NonBasetypeLinkingPosition nlp : substTmpl.getValidLinkingPositions()) {
                    openSession.save("ValidSubstituentLinkage", (Object)nlp);
                }
            }
            catch (ResourcesDbException resourcesDbException) {}
        } else {
            System.out.println("subst already present: " + dbTmpl.toString());
        }
    }

    public static void writeSubstituentTemplatesToDB(SubstituentTemplateContainer container) throws ResourcesDbException {
        ArrayList<String> substTmplList = container.getResidueIncludedNameList(GlycanNamescheme.MONOSACCHARIDEDB);
        if (substTmplList == null) {
            System.err.println("subst template list is null");
            return;
        }
        Session session = HibernateUtil.getSessionFactory().getCurrentSession();
        session.beginTransaction();
        for (String tmplName : container.getResidueIncludedNameList(GlycanNamescheme.MONOSACCHARIDEDB)) {
            SubstituentTemplate substTmpl = container.forName(GlycanNamescheme.MONOSACCHARIDEDB, tmplName);
            System.out.println("write substituent template " + substTmpl.getName());
            HibernateAccess.writeOrUpdateSingleSubstituentTemplateToDB(substTmpl, (org.hibernate.Session)session);
        }
        session.getTransaction().commit();
    }

    public static SubstituentTemplate getSubstituentTemplateFromDB(String name) {
        SubstituentTemplate dbTmpl = null;
        Session session = HibernateUtil.getSessionFactory().getCurrentSession();
        Transaction tx = session.beginTransaction();
        try {
            dbTmpl = (SubstituentTemplate)session.createQuery("from SubstituentTemplate where name='" + name + "'").uniqueResult();
        }
        catch (Exception e) {
            tx.rollback();
        }
        return dbTmpl;
    }

    private static void writeOrUpdateSingleAglyconTemplateToDB(AglyconTemplate aglTmpl, org.hibernate.Session openSession) {
        AglyconTemplate dbTmpl = (AglyconTemplate)openSession.createQuery("from AglyconTemplate where name='" + aglTmpl.getName() + "'").uniqueResult();
        if (dbTmpl == null) {
            openSession.save((Object)aglTmpl);
            for (AglyconAlias alias : aglTmpl.getAliasList()) {
                openSession.save((Object)alias);
            }
            for (Atom a : aglTmpl.getAtoms()) {
                openSession.save("AglyconAtom", (Object)a);
            }
            for (Atom a : aglTmpl.getAtoms()) {
                for (AtomConnection ac : a.getConnections()) {
                    openSession.save("AglyconAtomConnection", (Object)ac);
                }
            }
            try {
                for (NonBasetypeLinkingPosition nlp : aglTmpl.getValidLinkingPositions()) {
                    openSession.save("ValidAglyconLinkage", (Object)nlp);
                }
            }
            catch (ResourcesDbException resourcesDbException) {}
        } else {
            System.out.println("aglycon already present: " + dbTmpl.toString());
        }
    }

    public static void writeAglyconTemplatesToDB() throws ResourcesDbException {
        AglyconTemplateContainer container = new AglyconTemplateContainer();
        Session session = HibernateUtil.getSessionFactory().getCurrentSession();
        session.beginTransaction();
        for (String tmplName : container.getTemplateNameList(GlycanNamescheme.GLYCOCT)) {
            AglyconTemplate aglTmpl = container.getAglyconTemplateByName(GlycanNamescheme.GLYCOCT, tmplName);
            System.out.println("write aglycon template " + aglTmpl.getName());
            HibernateAccess.writeOrUpdateSingleAglyconTemplateToDB(aglTmpl, (org.hibernate.Session)session);
        }
        session.getTransaction().commit();
    }

    public static ResidueRepresentation getMonosaccharideRepresentation(int repId) {
        Session session = HibernateUtil.getSessionFactory().getCurrentSession();
        Transaction tx = session.beginTransaction();
        ResidueRepresentation dbRep = null;
        try {
            dbRep = (ResidueRepresentation)session.createQuery("from MonosaccharideRepresentation where id=" + repId).uniqueResult();
        }
        catch (Exception e) {
            tx.rollback();
        }
        return dbRep;
    }

    public static ResidueRepresentation getMonosaccharideRepresentation(int monoId, String formatStr, String typeStr) {
        Session session = HibernateUtil.getSessionFactory().getCurrentSession();
        Transaction tx = session.beginTransaction();
        ResidueRepresentation dbRep = null;
        try {
            dbRep = (ResidueRepresentation)session.createQuery("from MonosaccharideRepresentation where monosaccharide_id=" + monoId + " and representation_format='" + formatStr + "' and representation_type='" + typeStr + "'").uniqueResult();
        }
        catch (Exception e) {
            tx.rollback();
        }
        return dbRep;
    }

    public static void updateMonosaccharideRepresentations(Monosaccharide ms) {
        Session session = HibernateUtil.getSessionFactory().getCurrentSession();
        Transaction tx = session.beginTransaction();
        try {
            if (ms != null) {
                System.out.println("check monosaccharide " + ms.toString() + "\n");
                ms.updateRepresentations();
                System.out.println("  updated representations...");
                if (ms.getRepresentations() != null) {
                    System.out.println("   representations: " + ms.getRepresentations().size());
                    for (ResidueRepresentation monoRep : ms.getRepresentations()) {
                        System.out.println("  save or update rep. " + monoRep.toString());
                        session.saveOrUpdate("MonosaccharideRepresentation", (Object)monoRep);
                    }
                } else {
                    System.out.println("  getRepresentations() is null");
                }
            }
        }
        catch (Exception e) {
            System.err.println("Exception: " + e);
            tx.rollback();
        }
        tx.commit();
    }

    public static void updateMonosaccharideRepresentations(int msId) {
        Session session = HibernateUtil.getSessionFactory().getCurrentSession();
        Transaction tx = session.beginTransaction();
        try {
            Monosaccharide ms = HibernateAccess.getMonosaccharideFromDB(msId);
            if (ms != null) {
                HibernateAccess.updateMonosaccharideRepresentations(ms);
            }
        }
        catch (Exception e) {
            System.err.println("Exception: " + e);
            tx.rollback();
        }
    }

    public static void updateMonosaccharideRepresentations(int firstId, int lastId) {
        for (int i = firstId; i <= lastId; ++i) {
            HibernateAccess.updateMonosaccharideRepresentations(i);
        }
    }

    public static void updateMonosaccharideLinkingPositions(Monosaccharide ms) {
        Session session = HibernateUtil.getSessionFactory().getCurrentSession();
        Transaction tx = session.beginTransaction();
        try {
            if (ms != null) {
                System.out.println("check monosaccharide " + ms.toString() + "\n");
                if (ms.getPossibleLinkingPositions().size() == 0) {
                    ms.setPossibleLinkingPositions(MonosaccharideDataBuilder.buildPossibleLinkagePositions(ms));
                }
                for (MonosaccharideLinkingPosition linkpos : ms.getPossibleLinkingPositions()) {
                    System.out.println("  save or update linkpos. " + linkpos.toString());
                    session.saveOrUpdate((Object)linkpos);
                }
            }
        }
        catch (Exception e) {
            System.err.println("Exception: " + e);
            tx.rollback();
        }
        tx.commit();
    }

    public static void updateMonosaccharideLinkingPositions(int msId) {
        Session session = HibernateUtil.getSessionFactory().getCurrentSession();
        Transaction tx = session.beginTransaction();
        try {
            Monosaccharide ms = HibernateAccess.getMonosaccharideFromDB(msId);
            if (ms != null) {
                HibernateAccess.updateMonosaccharideLinkingPositions(ms);
            }
        }
        catch (Exception e) {
            System.err.println("Exception: " + e);
            tx.rollback();
        }
    }

    public static void updateMonosaccharideLinkingPositions(int firstId, int lastId) {
        for (int i = firstId; i <= lastId; ++i) {
            HibernateAccess.updateMonosaccharideLinkingPositions(i);
        }
    }

    public static List<?> getObjectList(String hqlStr) {
        Session session = HibernateUtil.getSessionFactory().getCurrentSession();
        session.beginTransaction();
        Query q = session.createQuery(hqlStr);
        List resultList = null;
        if (q != null) {
            resultList = q.list();
        }
        return resultList;
    }

    public static List<?> getObjectList(DetachedCriteria queryCriteria) {
        Session session = HibernateUtil.getSessionFactory().getCurrentSession();
        session.beginTransaction();
        List resultList = queryCriteria.getExecutableCriteria((org.hibernate.Session)session).list();
        return resultList;
    }

    public static void writeTemplateDataToDB(TemplateContainer container) throws ResourcesDbException {
        HibernateAccess.writeElementsToDB();
        HibernateAccess.writeSubstituentTemplatesToDB(container.getSubstituentTemplateContainer());
        HibernateAccess.writeAglyconTemplatesToDB();
    }
}

