/*
 * Decompiled with CFR 0.152.
 */
package org.eurocarbdb.resourcesdb.template;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.eurocarbdb.resourcesdb.Config;
import org.eurocarbdb.resourcesdb.GlycanNamescheme;
import org.eurocarbdb.resourcesdb.ResourcesDbException;
import org.eurocarbdb.resourcesdb.glycoconjugate_derived.LinkageType;
import org.eurocarbdb.resourcesdb.monosaccharide.CoreModification;
import org.eurocarbdb.resourcesdb.monosaccharide.CoreModificationTemplate;
import org.eurocarbdb.resourcesdb.monosaccharide.Monosaccharide;
import org.eurocarbdb.resourcesdb.monosaccharide.MonosaccharideException;
import org.eurocarbdb.resourcesdb.monosaccharide.StereoConfiguration;
import org.eurocarbdb.resourcesdb.monosaccharide.Stereocode;
import org.eurocarbdb.resourcesdb.monosaccharide.SubstituentSubpartTreeNode;
import org.eurocarbdb.resourcesdb.monosaccharide.Substitution;
import org.eurocarbdb.resourcesdb.template.SubstituentTemplate;
import org.eurocarbdb.resourcesdb.template.SubstituentTemplateContainer;
import org.eurocarbdb.resourcesdb.template.TrivialnameTemplate;
import org.eurocarbdb.resourcesdb.util.NumberUtils;
import org.eurocarbdb.resourcesdb.util.Utils;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TrivialnameTemplateContainer {
    private Config config = null;
    private SubstituentTemplateContainer substContainer;
    private ArrayList<TrivialnameTemplate> trivialnameTemplateList;
    private HashMap<GlycanNamescheme, ArrayList<String>> trivialnameTemplateNamelistsMap;

    public TrivialnameTemplateContainer() {
        this.setConfig(new Config());
    }

    public TrivialnameTemplateContainer(Config conf) {
        this.setConfig(conf);
    }

    public TrivialnameTemplateContainer(Config conf, SubstituentTemplateContainer substTmplContainer) {
        this.setConfig(conf);
        this.setSubstContainer(substTmplContainer);
    }

    private void setConfig(Config theConf) {
        this.config = theConf;
    }

    public Config getConfig() {
        return this.config;
    }

    public void setSubstContainer(SubstituentTemplateContainer container) {
        this.substContainer = container;
    }

    public SubstituentTemplateContainer getSubstContainer() {
        if (this.substContainer == null) {
            this.substContainer = new SubstituentTemplateContainer(this.getConfig());
        }
        return this.substContainer;
    }

    public ArrayList<TrivialnameTemplate> getTemplateList() throws ResourcesDbException {
        if (this.trivialnameTemplateList == null) {
            this.trivialnameTemplateList = this.readTemplateList(this.getConfig());
        }
        return this.trivialnameTemplateList;
    }

    public TrivialnameTemplate forBasetypeName(GlycanNamescheme scheme, String basename) throws ResourcesDbException {
        for (TrivialnameTemplate template : this.getTemplateList()) {
            if (!template.isTrivialName(scheme, basename)) continue;
            return template;
        }
        return null;
    }

    public ArrayList<String> getTrivialnameBasetypeList(GlycanNamescheme scheme) throws ResourcesDbException {
        ArrayList<String> basetypeList;
        if (this.trivialnameTemplateNamelistsMap == null) {
            this.trivialnameTemplateNamelistsMap = new HashMap();
        }
        if ((basetypeList = this.trivialnameTemplateNamelistsMap.get((Object)scheme)) == null) {
            ArrayList<TrivialnameTemplate> templates = this.getTemplateList();
            basetypeList = new ArrayList();
            for (TrivialnameTemplate template : templates) {
                if (!template.getNameschemes().contains((Object)scheme) || template.getSchemesMap().get((Object)scheme) == null) continue;
                basetypeList.addAll((Collection<String>)template.getSchemesMap().get((Object)scheme));
            }
            this.trivialnameTemplateNamelistsMap.put(scheme, basetypeList);
        }
        return basetypeList;
    }

    public boolean isTrivialname(GlycanNamescheme scheme, String basename) throws ResourcesDbException {
        return this.forBasetypeName(scheme, basename) != null;
    }

    private ArrayList<TrivialnameTemplate> readTemplateList(Config conf) throws ResourcesDbException {
        return this.getTemplateListFromXml(conf.getTrivialnameTemplatesXmlUrl());
    }

    private ArrayList<TrivialnameTemplate> getTemplateListFromXml(URL xmlUrl) throws ResourcesDbException {
        ArrayList<TrivialnameTemplate> tmplList = new ArrayList<TrivialnameTemplate>();
        SAXBuilder parser = new SAXBuilder();
        try {
            Document doc = parser.build(xmlUrl);
            Element root = doc.getRootElement();
            List templateTagsList = root.getChildren();
            for (Element xmlTemplate : templateTagsList) {
                TrivialnameTemplate template = this.getTemplateFromXmlTree(xmlTemplate);
                if (template == null) continue;
                tmplList.add(template);
            }
        }
        catch (JDOMException je) {
            throw new ResourcesDbException("Exception in reading TrivialnameTemplate XML file.", je);
        }
        catch (IOException ie) {
            throw new ResourcesDbException("Exception in reading TrivialnameTemplate XML file.", ie);
        }
        return tmplList;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Lifted jumps to return sites
     */
    private TrivialnameTemplate getTemplateFromXmlTree(Element xmlTemplate) {
        TrivialnameTemplate template = null;
        if (!xmlTemplate.getName().equalsIgnoreCase("template")) return template;
        template = new TrivialnameTemplate();
        List propList = xmlTemplate.getChildren();
        Iterator propIter = propList.iterator();
        GlycanNamescheme scheme = null;
        try {
            block4: while (propIter.hasNext()) {
                Element property = (Element)propIter.next();
                String propName = property.getName().toLowerCase();
                if (propName.equals("notation_set")) {
                    String name = property.getAttributeValue("name");
                    List schemeList = property.getChildren();
                    Iterator schemeIter = schemeList.iterator();
                    while (true) {
                        if (!schemeIter.hasNext()) continue block4;
                        Element schemeTag = (Element)schemeIter.next();
                        if (!schemeTag.getName().toLowerCase().equals("namescheme")) continue;
                        scheme = GlycanNamescheme.forName(schemeTag.getValue());
                        String primaryStr = schemeTag.getAttributeValue("primary");
                        boolean isPrimary = Utils.parseTrueFalseString(primaryStr, false);
                        template.addName(name, scheme, isPrimary);
                    }
                }
                if (propName.equals("longname")) {
                    template.setLongName(property.getValue());
                    continue;
                }
                if (propName.equals("stereocode")) {
                    template.setStereocode(property.getValue());
                    continue;
                }
                if (propName.equals("size")) {
                    template.setSize(Integer.parseInt(property.getValue()));
                    continue;
                }
                if (propName.equals("carbonyl_position")) {
                    template.setCarbonylPosition(NumberUtils.parseIntStr(property.getValue(), 0));
                    continue;
                }
                if (propName.equals("default_configuration")) {
                    try {
                        template.setDefaultConfiguration(StereoConfiguration.forNameOrSymbol(property.getValue()));
                        String compulsory = property.getAttributeValue("compulsory");
                        boolean isCompulsory = false;
                        if (compulsory != null && compulsory.length() > 0) {
                            isCompulsory = Utils.parseTrueFalseString(compulsory, isCompulsory);
                        }
                        template.setDefaultConfigIsCompulsory(isCompulsory);
                        continue;
                    }
                    catch (MonosaccharideException me) {
                        continue;
                    }
                }
                if (propName.equals("default_ringtype")) {
                    if (property.getValue().equals("p")) {
                        template.setDefaultRingend(template.getCarbonylPosition() + 4);
                        continue;
                    }
                    if (!property.getValue().equals("f")) continue;
                    template.setDefaultRingend(template.getCarbonylPosition() + 3);
                    continue;
                }
                if (propName.equals("coremodification_list")) {
                    template.setCoreModifications(this.getCoreModificationListFromXmlTree(property));
                    continue;
                }
                if (propName.equals("substitution_list")) {
                    template.setSubstitutions(this.getSubstitutionListFromXmlTree(GlycanNamescheme.GLYCOCT, property));
                    continue;
                }
                System.err.println("Warning: unknown tag in trivialname templates xml file: " + property.getName());
            }
            return template;
        }
        catch (ResourcesDbException me) {
            System.err.println("Warning: error in parsing trivial name templates xml file " + me);
            me.printStackTrace();
            return null;
        }
    }

    private ArrayList<CoreModification> getCoreModificationListFromXmlTree(Element xmlElement) throws MonosaccharideException {
        ArrayList<CoreModification> modList = new ArrayList<CoreModification>();
        List xmlModList = xmlElement.getChildren();
        Iterator modIter = xmlModList.iterator();
        while (modIter.hasNext()) {
            CoreModification mod = this.getCoreModificationFromXmlTree((Element)modIter.next());
            if (mod == null) {
                throw new MonosaccharideException("Error in parsing core modifications of trivialname templates xml file.");
            }
            modList.add(mod);
        }
        return modList;
    }

    private CoreModification getCoreModificationFromXmlTree(Element xmlElement) throws MonosaccharideException {
        CoreModification mod = null;
        if (xmlElement.getName().equalsIgnoreCase("modification")) {
            CoreModificationTemplate modTemplate = null;
            int modPosition1 = 0;
            int modPosition2 = 0;
            for (Element property : xmlElement.getChildren()) {
                if (property.getName().equalsIgnoreCase("type")) {
                    modTemplate = CoreModificationTemplate.forName(property.getValue());
                    continue;
                }
                if (property.getName().equalsIgnoreCase("position1")) {
                    modPosition1 = Integer.parseInt(property.getValue());
                    continue;
                }
                if (!property.getName().equalsIgnoreCase("position2") || property.getValue().length() <= 0) continue;
                modPosition2 = Integer.parseInt(property.getValue());
            }
            if (modTemplate != null && modPosition1 != 0) {
                mod = new CoreModification();
                if (modPosition2 == 0) {
                    mod.setModification(modTemplate, modPosition1);
                } else {
                    mod.setDivalentModification(modTemplate, modPosition1, modPosition2);
                }
            }
        }
        return mod;
    }

    private ArrayList<Substitution> getSubstitutionListFromXmlTree(GlycanNamescheme scheme, Element xmlElement) throws ResourcesDbException {
        ArrayList<Substitution> substList = new ArrayList<Substitution>();
        List xmlSubstList = xmlElement.getChildren();
        for (Element xmlElem : xmlSubstList) {
            Substitution subst = this.getSubstitutionFromXmlTree(scheme, xmlElem);
            if (subst == null) {
                throw new MonosaccharideException("Error in parsing substitutions of trivialname templates xml file.");
            }
            substList.add(subst);
        }
        return substList;
    }

    private Substitution getSubstitutionFromXmlTree(GlycanNamescheme scheme, Element xmlElement) throws ResourcesDbException {
        Substitution subst = null;
        if (xmlElement.getName().equalsIgnoreCase("substitution")) {
            SubstituentTemplate substTemplate = null;
            int position1 = 0;
            int position2 = 0;
            int substPosition1 = 0;
            int substPosition2 = 0;
            LinkageType linktype1 = null;
            LinkageType linktype2 = null;
            for (Element property : xmlElement.getChildren()) {
                if (property.getName().equalsIgnoreCase("type")) {
                    substTemplate = this.getSubstContainer().forName(scheme, property.getValue());
                    if (substTemplate == null) {
                        substTemplate = this.substContainer.forName(GlycanNamescheme.GLYCOCT, property.getValue());
                    }
                    if (substTemplate != null) continue;
                    System.err.println("cannot get substitution template for " + scheme.getNameStr() + "::" + property.getValue());
                    continue;
                }
                if (property.getName().equalsIgnoreCase("position1")) {
                    position1 = Integer.parseInt(property.getValue());
                    continue;
                }
                if (property.getName().equalsIgnoreCase("position2")) {
                    if (property.getValue().length() <= 0) continue;
                    position2 = Integer.parseInt(property.getValue());
                    continue;
                }
                if (property.getName().equalsIgnoreCase("substituent_position1")) {
                    if (property.getValue().length() <= 0) continue;
                    substPosition1 = Integer.parseInt(property.getValue());
                    continue;
                }
                if (property.getName().equalsIgnoreCase("substituent_position2")) {
                    if (property.getValue().length() <= 0) continue;
                    substPosition2 = Integer.parseInt(property.getValue());
                    continue;
                }
                if (property.getName().equalsIgnoreCase("linkagetype1")) {
                    if (property.getValue().length() <= 0) continue;
                    linktype1 = SubstituentTemplate.getLinkageTypeByLinkageName(property.getValue());
                    continue;
                }
                if (!property.getName().equalsIgnoreCase("linkagetype2") || property.getValue().length() <= 0) continue;
                linktype2 = SubstituentTemplate.getLinkageTypeByLinkageName(property.getValue());
            }
            if (substTemplate != null && position1 != 0) {
                subst = new Substitution();
                if (linktype1 == null) {
                    linktype1 = substTemplate.getDefaultLinkagetype1();
                }
                if (substPosition1 == 0) {
                    substPosition1 = substTemplate.getDefaultLinkingPosition1();
                }
                if (position2 == 0) {
                    subst.setSubstitution(substTemplate, position1, linktype1, substPosition1);
                } else {
                    if (linktype2 == null) {
                        linktype2 = substTemplate.getDefaultLinkagetype2();
                    }
                    if (substPosition2 == 0) {
                        substPosition2 = substTemplate.getDefaultLinkingPosition2();
                    }
                    subst.setDivalentSubstitution(substTemplate, position1, linktype1, substPosition1, position2, linktype2, substPosition2);
                }
            }
        }
        return subst;
    }

    public TrivialnameTemplate checkMsForTrivialname(GlycanNamescheme scheme, Monosaccharide ms) throws ResourcesDbException {
        String msStereo = ms.getStereoStr();
        if (ms.getRingStart() > 0) {
            msStereo = Stereocode.setPositionInStereoString(msStereo, StereoConfiguration.Nonchiral, ms.getRingStart());
        }
        msStereo = msStereo.substring(1, msStereo.length() - 1);
        try {
            if (Stereocode.stereoStringHasRelativePosition(msStereo)) {
                if (scheme.equals((Object)GlycanNamescheme.CFG)) {
                    return null;
                }
                msStereo = Stereocode.relativeToAbsolute(msStereo);
            }
        }
        catch (MonosaccharideException me) {
            return null;
        }
        String msStereoDL = Stereocode.changeDLinStereoString(msStereo);
        ArrayList<String> trivialnameList = this.getTrivialnameBasetypeList(scheme);
        TrivialnameTemplate returnTemplate = null;
        if (trivialnameList == null) {
            return null;
        }
        int returnTemplateSplitCount = 0;
        for (String trivTmplName : trivialnameList) {
            String tmplStereo;
            int currentTemplateSplitCount = 0;
            TrivialnameTemplate template = this.forBasetypeName(scheme, trivTmplName);
            if (template.getSize() != ms.getSize() || template.getCarbonylPosition() != ms.getRingStart() && ms.getRingStart() != -1 && ms.getRingStart() != 0 || !(tmplStereo = template.getStereocode()).equals(msStereo) && !tmplStereo.equals(msStereoDL) || template.isDefaultConfigIsCompulsory() && !Stereocode.getConfigurationFromStereoString(msStereo).equals((Object)template.getDefaultConfiguration()) || (scheme.equals((Object)GlycanNamescheme.BCSDB) ? ms.countCoreModifications() < template.getCoreModificationCount() || ms.countCoreModifications(CoreModificationTemplate.DEOXY) != template.countCoreModifications(CoreModificationTemplate.DEOXY) || ms.countCoreModifications(CoreModificationTemplate.KETO) != template.countCoreModifications(CoreModificationTemplate.KETO) || ms.countCoreModifications(CoreModificationTemplate.EN) != template.countCoreModifications(CoreModificationTemplate.EN) || ms.countCoreModifications(CoreModificationTemplate.ENX) != template.countCoreModifications(CoreModificationTemplate.ENX) || ms.countCoreModifications(CoreModificationTemplate.YN) != template.countCoreModifications(CoreModificationTemplate.YN) : ms.countCoreModifications() != template.getCoreModificationCount())) continue;
            ArrayList<CoreModification> trivialMods = template.getCoreModifications();
            boolean modificationMissing = false;
            for (int m = 0; m < trivialMods.size(); ++m) {
                CoreModification mod = trivialMods.get(m);
                if (ms.hasCoreModification(mod)) continue;
                modificationMissing = true;
                break;
            }
            if (modificationMissing) continue;
            ArrayList<Substitution> trivialSubstList = template.getSubstitutions();
            for (Substitution trivialSubst : trivialSubstList) {
                List<Substitution> msSubstList;
                if (ms.hasSubstitution(trivialSubst)) continue;
                modificationMissing = true;
                if (scheme.equals((Object)GlycanNamescheme.CFG)) {
                    msSubstList = ms.getSubstitutions();
                    for (Substitution msSubst : msSubstList) {
                        SubstituentSubpartTreeNode msChildNode;
                        SubstituentSubpartTreeNode msSubstNode;
                        if (!Utils.formatPositionsString(trivialSubst.getPosition1(), "/", "?").equals(Utils.formatPositionsString(msSubst.getPosition1(), "/", "?")) || msSubst.hasPosition2() && (!trivialSubst.hasPosition2() || !Utils.formatPositionsString(trivialSubst.getPosition2(), "/", "?").equals(Utils.formatPositionsString(msSubst.getPosition2(), "/", "?"))) || (msSubstNode = msSubst.getTemplate().getSubparts()) == null) continue;
                        SubstituentTemplate msSubstNodeTmpl = msSubstNode.getSubstTmpl(this.getSubstContainer());
                        if (!trivialSubst.getTemplate().getName().equals(msSubstNodeTmpl.getName()) || msSubstNode.getChildCount() != 1 || !(msChildNode = (SubstituentSubpartTreeNode)msSubstNode.getFirstChild()).isLeaf()) continue;
                        SubstituentTemplate msChildTmpl = msChildNode.getSubstTmpl(this.getSubstContainer());
                        if (msChildTmpl == null) {
                            throw new ResourcesDbException("Cannot get SubstituentTemplate for subst. subpart " + msChildNode.getName());
                        }
                        try {
                            msChildTmpl.getPrimaryAlias(GlycanNamescheme.CFG, LinkageType.H_AT_OH);
                        }
                        catch (ResourcesDbException rEx) {
                            continue;
                        }
                        modificationMissing = false;
                        ++currentTemplateSplitCount;
                        break;
                    }
                } else if (trivialSubst.getName().equalsIgnoreCase(SubstituentTemplate.AMINOTEMPLATENAME)) {
                    msSubstList = ms.getSubstitutions();
                    for (Substitution msSubst : msSubstList) {
                        if (msSubst.getPosition1().size() != 1 || msSubst.getIntValuePosition1() != trivialSubst.getIntValuePosition1() || !msSubst.getTemplate().isExtendedAmine(this.getSubstContainer())) continue;
                        modificationMissing = false;
                        break;
                    }
                }
                if (!modificationMissing) continue;
                break;
            }
            if (modificationMissing) continue;
            if (returnTemplate == null || template.getSubstitutionCount() > returnTemplate.getSubstitutionCount()) {
                returnTemplate = template;
                returnTemplateSplitCount = currentTemplateSplitCount;
                continue;
            }
            if (currentTemplateSplitCount >= returnTemplateSplitCount || template.getSubstitutionCount() != returnTemplate.getSubstitutionCount()) continue;
            returnTemplate = template;
            returnTemplateSplitCount = currentTemplateSplitCount;
        }
        return returnTemplate;
    }
}

