/*
 * Decompiled with CFR 0.152.
 */
package org.eurocarbdb.resourcesdb.atom;

import java.util.HashMap;
import java.util.List;
import org.eurocarbdb.resourcesdb.Config;
import org.eurocarbdb.resourcesdb.ResourcesDbException;
import org.eurocarbdb.resourcesdb.atom.Atom;
import org.eurocarbdb.resourcesdb.atom.Periodic;
import org.eurocarbdb.resourcesdb.monosaccharide.MonosaccharideException;
import org.eurocarbdb.resourcesdb.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Composition
implements Cloneable {
    private HashMap<String, Integer> compositionMap;

    public Composition() {
        this.setCompositionMap(new HashMap<String, Integer>());
    }

    public Composition(String formula) throws ResourcesDbException {
        this.parseFormula(formula);
    }

    public Composition(Composition compo) {
        this.addComposition(compo);
    }

    public HashMap<String, Integer> getCompositionMap() {
        return this.compositionMap;
    }

    private void setCompositionMap(HashMap<String, Integer> composMap) {
        this.compositionMap = composMap;
    }

    public int getElementCount(Periodic el) {
        if (el == null) {
            return 0;
        }
        return this.getElementCount(el.getSymbol());
    }

    public int getElementCount(String elSymbol) {
        if (this.getCompositionMap().get(elSymbol) == null) {
            return 0;
        }
        return this.getCompositionMap().get(elSymbol);
    }

    public void setElementCount(Periodic el, int value) {
        this.getCompositionMap().put(el.getSymbol(), new Integer(value));
    }

    public void setElementCount(String elSymbol, int value) {
        this.getCompositionMap().put(elSymbol, new Integer(value));
    }

    public void increaseCount(Periodic el, int step) {
        Integer countObj = this.getCompositionMap().get(el.getSymbol());
        countObj = countObj == null ? new Integer(step) : Integer.valueOf(countObj + step);
        this.getCompositionMap().put(el.getSymbol(), countObj);
    }

    public void increaseCount(Periodic el) {
        this.increaseCount(el, 1);
    }

    public void increaseCount(String elSymbol, int step) {
        Integer countObj = this.getCompositionMap().get(elSymbol);
        countObj = countObj == null ? new Integer(step) : Integer.valueOf(countObj + step);
        this.getCompositionMap().put(elSymbol, countObj);
    }

    public void decreaseCount(Periodic el, int step) {
        Integer countObj = this.getCompositionMap().get(el.getSymbol());
        countObj = countObj == null ? new Integer(-1 * step) : Integer.valueOf(countObj - step);
        this.getCompositionMap().put(el.getSymbol(), countObj);
    }

    public void decreaseCount(Periodic el) {
        this.decreaseCount(el, 1);
    }

    public void parseFormula(String formula) throws ResourcesDbException {
        if (this.getCompositionMap() != null) {
            this.getCompositionMap().clear();
        }
        this.addFormula(formula);
    }

    public void addFormula(String formula) throws ResourcesDbException {
        if (this.getCompositionMap() == null) {
            this.setCompositionMap(new HashMap<String, Integer>());
        }
        String subformula = formula != null ? formula : "";
        while (subformula.length() > 0) {
            int closeBracketPos;
            if (subformula.startsWith(" ")) {
                subformula = subformula.substring(1);
                continue;
            }
            if (subformula.startsWith("(") && (closeBracketPos = StringUtils.findClosingBracketPosition(subformula)) > 0) {
                int count;
                Composition subCompo = new Composition(subformula.substring(1, closeBracketPos));
                if ((subformula = subformula.substring(closeBracketPos + 1)).length() == 0 || subformula.matches("^[A-Z()].*")) {
                    count = 1;
                } else {
                    count = 0;
                    while (subformula.matches("^[0-9].*")) {
                        count = 10 * count + Integer.parseInt(subformula.substring(0, 1));
                        subformula = subformula.substring(1);
                    }
                }
                if (count != 1) {
                    for (String elSymbol : subCompo.getCompositionMap().keySet()) {
                        subCompo.getCompositionMap().put(elSymbol, subCompo.getElementCount(elSymbol) * count);
                    }
                }
                this.addComposition(subCompo);
                continue;
            }
            boolean foundElement = false;
            for (Periodic el : Periodic.values()) {
                int count;
                String symbol = el.getSymbol();
                if (!subformula.matches("^" + symbol + "[0-9A-Z()].*") && !subformula.equals(symbol)) continue;
                subformula = subformula.substring(symbol.length());
                foundElement = true;
                if (subformula.length() == 0 || subformula.matches("^[A-Z()].*")) {
                    count = 1;
                } else {
                    count = 0;
                    while (subformula.matches("^[0-9].*")) {
                        count = 10 * count + Integer.parseInt(subformula.substring(0, 1));
                        subformula = subformula.substring(1);
                    }
                }
                this.increaseCount(el, count);
                break;
            }
            if (foundElement) continue;
            throw new MonosaccharideException("Cannot parse formula " + formula);
        }
    }

    public void addComposition(Composition compo) {
        if (this.getCompositionMap() == null) {
            this.setCompositionMap(new HashMap<String, Integer>());
        }
        for (String elSymbol : compo.getCompositionMap().keySet()) {
            Integer elCount = compo.getElementCount(elSymbol);
            if (elCount == null || elCount == 0) continue;
            this.increaseCount(elSymbol, (int)elCount);
        }
    }

    public void addAtoms(List<Atom> atomList) {
        for (Atom a : atomList) {
            this.addAtom(a);
        }
    }

    public void addAtom(Atom a) {
        this.increaseCount(a.getElement());
    }

    public double getAvgMass() {
        double mass = 0.0;
        for (String elSymbol : this.getCompositionMap().keySet()) {
            try {
                Periodic el = Periodic.getElementBySymbol(elSymbol);
                Integer elCount = this.getElementCount(el);
                if (elCount == null) continue;
                mass += (double)elCount.intValue() * el.getAvgMass();
            }
            catch (ResourcesDbException me) {
                if (!Config.getGlobalConfig().isPrintErrorMsgs()) continue;
                System.err.println("Exception: " + me);
                me.printStackTrace();
            }
        }
        return mass;
    }

    public double getMonoMass() {
        double mass = 0.0;
        for (String elSymbol : this.getCompositionMap().keySet()) {
            try {
                Periodic el = Periodic.getElementBySymbol(elSymbol);
                int elCount = this.getElementCount(el);
                if (elCount == 0) continue;
                mass += (double)elCount * el.getMostAbundantIsotope().getMass();
            }
            catch (ResourcesDbException me) {
                if (!Config.getGlobalConfig().isPrintErrorMsgs()) continue;
                System.err.println("Exception: " + me);
                me.printStackTrace();
            }
        }
        return mass;
    }

    public String toFormula() {
        String outStr = "";
        for (String elemSymbol : this.getCompositionMap().keySet()) {
            Integer elCount = this.getElementCount(elemSymbol);
            if (elCount == null || elCount == 0) continue;
            outStr = outStr + elemSymbol + elCount;
        }
        return outStr;
    }

    public String toWebFormula() {
        String outStr = "";
        for (String elemSymbol : this.getCompositionMap().keySet()) {
            Integer elCount = this.getElementCount(elemSymbol);
            if (elCount == null || elCount == 0) continue;
            outStr = outStr + elemSymbol + "<sub>" + elCount + "</sub>";
        }
        return outStr;
    }

    public String toString() {
        String outStr = "Composition:";
        for (String elemSymbol : this.getCompositionMap().keySet()) {
            Integer elCount = this.getElementCount(elemSymbol);
            if (elCount == null || elCount == 0) continue;
            outStr = outStr + " " + elemSymbol + elCount;
        }
        return outStr;
    }

    public Composition clone() {
        Composition retComp = new Composition(this);
        return retComp;
    }
}

