/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.importer.ms.annotation.glycan.simiansearch.wizard;

import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.grits.toolbox.core.utilShare.TextFieldUtils;
import org.grits.toolbox.importer.ms.annotation.glycan.simiansearch.wizard.FragmentPerOptionForm;
import org.grits.toolbox.importer.ms.annotation.glycan.simiansearch.wizard.FragmentSettingsForm;
import org.grits.toolbox.ms.om.data.FragmentPerActivationMethod;

public class FragmentPerActivation
extends FragmentPerOptionForm {
    private Text txtActivationName;
    private Text txtMaxClvg;
    private Text txtMaxCR;
    private Combo cmbActivationMethod;

    public FragmentPerActivation(Shell parentShell, FragmentSettingsForm parentForm) {
        super(parentShell, parentForm);
    }

    @Override
    protected String getFormTitle() {
        return "Fragments Per Activation Method";
    }

    @Override
    protected void addPreFragmentControls(Composite container) {
        Label lblActivationMethod = new Label(container, 0);
        lblActivationMethod.setText("Activation Method");
        this.cmbActivationMethod = new Combo(container, 0);
        this.cmbActivationMethod.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (FragmentPerActivation.this.cmbActivationMethod.getItem(FragmentPerActivation.this.cmbActivationMethod.getSelectionIndex()).equals("Other")) {
                    FragmentPerActivation.this.txtActivationName.setEnabled(true);
                } else {
                    FragmentPerActivation.this.txtActivationName.setEnabled(false);
                }
                FragmentPerActivation.this.setDirty(true, true);
            }
        });
        this.cmbActivationMethod.setItems(new String[]{"CID", "HCD", "ETD", "ECD", "IRMPD", "Other"});
        this.cmbActivationMethod.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.cmbActivationMethod.select(0);
        Label lblName = new Label(container, 0);
        lblName.setText("Name");
        this.txtActivationName = new Text(container, 2048);
        this.txtActivationName.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                FragmentPerActivation.this.setDirty(true, FragmentPerActivation.this.validatInput());
            }
        });
        this.txtActivationName.setEnabled(false);
        this.txtActivationName.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        Label lblMaxClvg = new Label(container, 0);
        lblMaxClvg.setText("Max Num of Cleavages");
        this.txtMaxClvg = new Text(container, 2048);
        this.txtMaxClvg.setText("2");
        this.txtMaxClvg.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                FragmentPerActivation.this.setDirty(true, FragmentPerActivation.this.validatInput());
            }
        });
        this.txtMaxClvg.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        Label label_1 = new Label(container, 0);
        label_1.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        label_1.setText("Max Num of CrossRing Cleavages");
        this.txtMaxCR = new Text(container, 2048);
        this.txtMaxCR.setText("0");
        this.txtMaxCR.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                FragmentPerActivation.this.setDirty(true, FragmentPerActivation.this.validatInput());
            }
        });
        this.txtMaxCR.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
    }

    @Override
    protected void addButtonEventListeners() {
        this.btnB.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                System.out.println("Selection: " + FragmentPerActivation.this.btnB.getSelection());
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.btnAdd.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                String activationSelectedName = FragmentPerActivation.this.cmbActivationMethod.getItem(FragmentPerActivation.this.cmbActivationMethod.getSelectionIndex()).equals("Other") ? FragmentPerActivation.this.txtActivationName.getText().trim() : FragmentPerActivation.this.cmbActivationMethod.getItem(FragmentPerActivation.this.cmbActivationMethod.getSelectionIndex());
                FragmentPerActivationMethod method = new FragmentPerActivationMethod();
                method.setActivationMethod(activationSelectedName);
                method.setFragments(FragmentPerActivation.this.getFragments());
                method.setMaxNumOfCleavages(Integer.parseInt(FragmentPerActivation.this.txtMaxClvg.getText()));
                method.setMaxNumOfCrossRingCleavages(Integer.parseInt(FragmentPerActivation.this.txtMaxCR.getText()));
                FragmentPerActivation.this.parentForm.addToGrid(method);
                FragmentPerActivation.this.setMessage("Added Successfully");
                FragmentPerActivation.this.setDirty(false, true);
            }
        });
    }

    @Override
    public boolean validatInput() {
        boolean bVal = super.validatInput();
        if (!bVal) {
            return false;
        }
        if (!TextFieldUtils.isNonZero((Text)this.txtMaxClvg)) {
            this.setErrorMessage("Please enter a valid number");
            return false;
        }
        if (this.txtActivationName.getEnabled() && TextFieldUtils.isEmpty((Text)this.txtActivationName)) {
            this.setErrorMessage("Please enter a valid name");
            return false;
        }
        if (TextFieldUtils.isNonZero((Text)this.txtMaxCR) && !this.btnA.getSelection() && !this.btnX.getSelection()) {
            this.setErrorMessage("Please select at least one cross ring cleavage type ");
            return false;
        }
        if (!TextFieldUtils.isNonZero((Text)this.txtMaxCR) && (this.btnA.getSelection() || this.btnX.getSelection())) {
            this.setErrorMessage("Please enter Max cross ring value ");
            return false;
        }
        if (!TextFieldUtils.isNonZero((Text)this.txtMaxClvg) && (this.btnB.getSelection() || this.btnY.getSelection() || this.btnC.getSelection() || this.btnZ.getSelection())) {
            this.setErrorMessage("Please enter Max Cleavge value ");
            return false;
        }
        this.setErrorMessage(null);
        return true;
    }

    @Override
    protected void addPostFragmentControls(Composite container) {
    }
}

