/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.entry.ms.mycustom.property.datamodel;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import org.apache.log4j.Logger;
import org.grits.toolbox.core.dataShare.PropertyHandler;
import org.grits.toolbox.core.datamodel.Entry;
import org.grits.toolbox.core.datamodel.io.PropertyWriter;
import org.grits.toolbox.core.datamodel.property.Property;
import org.grits.toolbox.core.datamodel.property.PropertyDataFile;
import org.grits.toolbox.core.datamodel.util.DataModelSearch;
import org.grits.toolbox.core.utilShare.DeleteUtils;
import org.grits.toolbox.core.utilShare.XMLUtils;
import org.grits.toolbox.entry.ms.mycustom.property.datamodel.MyMSPropertyDataFile;
import org.grits.toolbox.entry.ms.mycustom.property.io.MyMassSpecPropertyWriter;
import org.grits.toolbox.entry.ms.property.MassSpecProperty;
import org.grits.toolbox.entry.ms.property.datamodel.MSPropertyDataFile;
import org.grits.toolbox.entry.ms.property.datamodel.MassSpecMetaData;

public class MyCustomMassSpecProperty
extends MassSpecProperty {
    public static final String CURRENT_VERSION = "1.0";
    private static final Logger logger = Logger.getLogger(MyCustomMassSpecProperty.class);
    public static final String TYPE = "org.grits.toolbox.property.ms.mycustom";
    protected static MyMassSpecPropertyWriter writer = new MyMassSpecPropertyWriter();

    @Inject
    public MyCustomMassSpecProperty() {
    }

    public MSPropertyDataFile getUpdatePropertyDataFile(MSPropertyDataFile msPDF) {
        MyMSPropertyDataFile clonePdf = null;
        if (!(msPDF instanceof MyMSPropertyDataFile)) {
            clonePdf = new MyMSPropertyDataFile();
            msPDF.clone((MSPropertyDataFile)clonePdf);
            if (msPDF.getChildren() != null) {
                clonePdf.getChildren().clear();
                for (MSPropertyDataFile child : msPDF.getChildren()) {
                    MyMSPropertyDataFile cloneChildPdf = new MyMSPropertyDataFile();
                    child.clone((MSPropertyDataFile)cloneChildPdf);
                    if (clonePdf.getChildren().contains((Object)cloneChildPdf)) continue;
                    clonePdf.getChildren().add(cloneChildPdf);
                }
            }
        }
        if (clonePdf != null) {
            return clonePdf;
        }
        return msPDF;
    }

    public void updateMSPropertyDataFiles(MassSpecMetaData metaData) {
        boolean bChanged = false;
        ArrayList<MSPropertyDataFile> fileList = new ArrayList<MSPropertyDataFile>();
        for (MSPropertyDataFile msPDF : metaData.getFileList()) {
            if (!(msPDF instanceof MyMSPropertyDataFile)) {
                MSPropertyDataFile clonePdf = this.getUpdatePropertyDataFile(msPDF);
                fileList.add(clonePdf);
                bChanged = true;
                continue;
            }
            fileList.add(msPDF);
        }
        if (bChanged) {
            metaData.setFileList(fileList);
        }
    }

    public List<PropertyDataFile> getDataFiles() {
        return super.getDataFiles();
    }

    public MassSpecMetaData unmarshallSettingsFile(String sFileName) {
        MassSpecMetaData metaData = null;
        try {
            metaData = (MassSpecMetaData)XMLUtils.unmarshalObjectXML((String)sFileName, (List)MassSpecProperty.msMetaDataClasses);
            if (metaData.getFileList() != null) {
                this.updateMSPropertyDataFiles(metaData);
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return metaData;
    }

    public void marshallSettingsFile(String sFileName, MassSpecMetaData metaData) {
        try {
            String xmlString = XMLUtils.marshalObjectXML((Object)metaData, (List)MassSpecProperty.msMetaDataClasses);
            FileWriter fileWriter = new FileWriter(sFileName);
            fileWriter.write(xmlString);
            fileWriter.close();
        }
        catch (IOException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    public String getType() {
        return TYPE;
    }

    public PropertyWriter getWriter() {
        return writer;
    }

    public static String getFullyQualifiedFolderName(Entry entry) {
        String workspaceLocation = PropertyHandler.getVariable((String)"workspace_location");
        String projectName = DataModelSearch.findParentByType((Entry)entry, (String)"org.grits.toolbox.property.project").getDisplayName();
        String folderName = String.valueOf(workspaceLocation) + projectName + File.separator + MyCustomMassSpecProperty.getFoldername();
        return folderName;
    }

    public String getFullyQualifiedMetaDataFileName(Entry entry) {
        String msSettings = this.getMSSettingsFile().getName();
        if (msSettings == null) {
            return null;
        }
        String workspaceLocation = PropertyHandler.getVariable((String)"workspace_location");
        String projectName = DataModelSearch.findParentByType((Entry)entry, (String)"org.grits.toolbox.property.project").getDisplayName();
        String mzXML = String.valueOf(workspaceLocation) + projectName + File.separator + MyCustomMassSpecProperty.getFoldername() + File.separator + msSettings;
        return mzXML;
    }

    public void delete(Entry entry) throws IOException {
        String workspaceLocation = PropertyHandler.getVariable((String)"workspace_location");
        String projectName = DataModelSearch.findParentByType((Entry)entry, (String)"org.grits.toolbox.property.project").getDisplayName();
        String msPath = String.valueOf(workspaceLocation) + projectName + File.separator + MyCustomMassSpecProperty.getFoldername();
        String sEntryPath = null;
        if (this.getMassSpecMetaData() != null) {
            sEntryPath = this.deleteSettings(entry, msPath);
        }
        for (PropertyDataFile file : this.getDataFiles()) {
            if (file.getName().trim().equals("")) continue;
            DeleteUtils.delete((File)new File(String.valueOf(msPath) + File.separator + file.getName()));
        }
        if (sEntryPath != null) {
            DeleteUtils.delete((File)new File(String.valueOf(msPath) + File.separator + sEntryPath));
        }
    }

    public static Entry getMSParentEntry(Entry entry) {
        if (entry.getProperty() instanceof MyCustomMassSpecProperty) {
            return entry;
        }
        if (entry.getParent() != null) {
            return MyCustomMassSpecProperty.getMSParentEntry(entry.getParent());
        }
        return null;
    }

    public boolean updateMSSettings(MassSpecMetaData metaData, String sSettingsFIle) {
        try {
            this.marshallSettingsFile(sSettingsFIle, metaData);
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage());
            return false;
        }
        return true;
    }

    public Object clone() {
        MyCustomMassSpecProperty newProp = new MyCustomMassSpecProperty();
        if (this.getMassSpecMetaData() != null) {
            MassSpecMetaData settings = (MassSpecMetaData)this.getMassSpecMetaData().clone();
            newProp.setDataFiles(this.getDataFiles());
            newProp.setMassSpecMetaData(settings);
        }
        return newProp;
    }

    public Property getParentProperty() {
        return null;
    }

    public MassSpecProperty getNewMSProperty() {
        MyCustomMassSpecProperty t_property = new MyCustomMassSpecProperty();
        t_property.setVersion(CURRENT_VERSION);
        return t_property;
    }
}

