/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.entry.ms.annotation.tablehelpers;

import java.util.List;
import org.eclipse.nebula.widgets.nattable.data.IRowDataProvider;
import org.eclipse.nebula.widgets.nattable.layer.LabelStack;
import org.grits.toolbox.datamodel.ms.annotation.tablemodel.dmtranslate.DMAnnotation;
import org.grits.toolbox.display.control.table.datamodel.GRITSListDataProvider;
import org.grits.toolbox.display.control.table.datamodel.GRITSListDataRow;
import org.grits.toolbox.display.control.table.process.TableDataProcessor;
import org.grits.toolbox.display.control.table.tablecore.DoubleFormat;
import org.grits.toolbox.entry.ms.tablehelpers.MassSpecCellOverrideLabelAccumulator;

public class MSAnnotationCellOverrideLabelAccumulator<T>
extends MassSpecCellOverrideLabelAccumulator<T> {
    protected Integer filterCol = null;
    protected Integer commentCol = null;
    protected Integer ratioCol = null;

    public MSAnnotationCellOverrideLabelAccumulator(IRowDataProvider<T> dataProvider) {
        super(dataProvider);
        this.iSelectedCol = null;
        this.filterCol = null;
        this.commentCol = null;
        this.ratioCol = null;
    }

    public MSAnnotationCellOverrideLabelAccumulator(IRowDataProvider<T> dataProvider, Integer iSelectedCol, Integer filterCol, Integer commentCol, Integer ratioCol, List<Integer> intensityCols) {
        super(dataProvider, iSelectedCol, intensityCols);
        this.filterCol = filterCol;
        this.commentCol = commentCol;
        this.ratioCol = ratioCol;
    }

    public void accumulateConfigLabels(LabelStack configLabels, int columnPosition, int rowPosition) {
        GRITSListDataRow rowObj = ((GRITSListDataProvider)this.dataProvider).getGRITSListDataRow(rowPosition);
        if (rowObj == null) {
            return;
        }
        if (this.filterCol != null) {
            Integer filterVal = (Integer)rowObj.getDataRow().get(this.filterCol);
            if (filterVal != null && filterVal > 1) {
                configLabels.addLabel("filteredAndSelected");
            } else if (filterVal != null && filterVal.equals(1)) {
                configLabels.addLabel("filteredNotSelected");
            }
        }
        if (this.commentCol != null && columnPosition == this.commentCol) {
            configLabels.addLabel("comment-config" + TableDataProcessor.commentColHeader.getKeyValue());
        }
        if (this.ratioCol != null && columnPosition == this.ratioCol) {
            configLabels.addLabel("comment-config" + DMAnnotation.annotation_ratio.name());
        }
        if (this.iSelectedCol != null && columnPosition == this.iSelectedCol) {
            configLabels.addLabel(TableDataProcessor.selColHeader.getLabel());
        }
        if (this.intensityCols != null && this.intensityCols.contains(columnPosition)) {
            configLabels.addLabel(DoubleFormat.SCIENTIFIC_NOTATION.name());
        }
        if (this.polarityCol != null && this.polarityCol == columnPosition) {
            configLabels.addLabel("PolarityValue");
        }
    }
}

