/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.ms.annotation.gelato.glycan;

import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;
import org.eurocarbdb.MolecularFramework.io.SugarImporterException;
import org.eurocarbdb.MolecularFramework.sugar.Sugar;
import org.eurocarbdb.MolecularFramework.util.visitor.GlycoVisitorException;
import org.eurocarbdb.application.glycanbuilder.BuilderWorkspace;
import org.eurocarbdb.application.glycanbuilder.Glycan;
import org.eurocarbdb.application.glycanbuilder.GlycanRenderer;
import org.eurocarbdb.application.glycanbuilder.GlycanRendererAWT;
import org.eurocarbdb.application.glycanbuilder.MassOptions;
import org.eurocarbdb.application.glycanbuilder.ResidueDictionary;
import org.eurocarbdb.application.glycanbuilder.ResidueType;
import org.grits.toolbox.ms.annotation.gelato.Analyte;
import org.grits.toolbox.ms.annotation.gelato.AnalyteMatcher;
import org.grits.toolbox.ms.annotation.gelato.AnalyteStructureAnnotation;
import org.grits.toolbox.ms.annotation.gelato.GelatoUtils;
import org.grits.toolbox.ms.annotation.gelato.glycan.GlycanAnalyte;
import org.grits.toolbox.ms.annotation.gelato.glycan.GlycanMatcher;
import org.grits.toolbox.ms.annotation.structure.AnalyteStructure;
import org.grits.toolbox.ms.annotation.structure.GelatoAnalyte;
import org.grits.toolbox.ms.annotation.structure.GelatoAnalyteCache;
import org.grits.toolbox.ms.annotation.structure.GlycanPreDefinedOptions;
import org.grits.toolbox.ms.annotation.structure.GlycanStructure;
import org.grits.toolbox.ms.annotation.structure.StructureHandlerException;
import org.grits.toolbox.ms.annotation.structure.StructureHandlerJarFile;
import org.grits.toolbox.ms.annotation.sugar.GlycanExtraInfo;
import org.grits.toolbox.ms.file.MSFile;
import org.grits.toolbox.ms.om.data.AnalyteSettings;
import org.grits.toolbox.ms.om.data.Annotation;
import org.grits.toolbox.ms.om.data.Data;
import org.grits.toolbox.ms.om.data.GlycanAnnotation;
import org.grits.toolbox.ms.om.data.GlycanFilter;
import org.grits.toolbox.ms.om.data.GlycanScansAnnotation;
import org.grits.toolbox.ms.om.data.GlycanSettings;
import org.grits.toolbox.ms.om.data.Method;
import org.grits.toolbox.ms.om.data.ReducingEnd;
import org.grits.toolbox.ms.om.data.ScansAnnotation;
import org.grits.toolbox.ms.om.io.xml.AnnotationReader;
import org.grits.toolbox.ms.om.io.xml.AnnotationWriter;
import org.grits.toolbox.util.structure.glycan.filter.GlycanFilterOperator;
import org.grits.toolbox.util.structure.glycan.filter.om.Filter;
import org.grits.toolbox.widgets.tools.INotifyingProcess;

public abstract class GlycanStructureAnnotation
extends AnalyteStructureAnnotation
implements INotifyingProcess {
    private static final Logger logger = Logger.getLogger(GlycanStructureAnnotation.class);
    private GlycanMatcher curGlycanMatcher = null;

    public GlycanStructureAnnotation() {
    }

    public GlycanStructureAnnotation(Data data, String path, String archiveName, MSFile msFile) {
        super(data, path, archiveName, msFile);
        BuilderWorkspace bw = new BuilderWorkspace((GlycanRenderer)new GlycanRendererAWT());
    }

    @Override
    protected List<AnalyteStructure> loadAnalyteSettingsFromDB(AnalyteSettings settings) {
        List<AnalyteStructure> settingStructures = GlycanStructureAnnotation.getGlycanStructures(settings.getGlycanSettings().getFilter());
        return settingStructures;
    }

    public static List<AnalyteStructure> getGlycanStructures(GlycanFilter gf) {
        List<AnalyteStructure> structures = null;
        try {
            StructureHandlerJarFile fj = new StructureHandlerJarFile();
            structures = fj.getStructures(gf);
        }
        catch (StructureHandlerException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return structures;
    }

    @Override
    protected boolean passesFilters(AnalyteStructure structure, AnalyteSettings analyteSettings) {
        try {
            Analyte analyte = GelatoUtils.getAnalyteFromGelatoCache(structure);
            if (analyteSettings.getGlycanSettings().getFilterSetting() != null) {
                return GlycanFilterOperator.evaluate((Sugar)((GlycanAnalyte)analyte).getGlycan().toSugar(), (Filter)analyteSettings.getGlycanSettings().getFilterSetting().getFilter());
            }
        }
        catch (Exception e) {
            logger.error((Object)"Exception evaluating filters.", (Throwable)e);
        }
        return true;
    }

    @Override
    protected Annotation getNewAnnotationObject() {
        return new GlycanAnnotation();
    }

    protected Annotation getNewGlycanAnnotation(String sAnnotId, String sSequence, String sSeqFormat, String sGWBSequence, String sPerDerivType, String glytoucanId, ReducingEnd sRedEnd) {
        GlycanAnnotation annotation = (GlycanAnnotation)super.getNewAnnotation(sAnnotId, sSequence, sSeqFormat);
        annotation.setSequenceGWB(sGWBSequence);
        annotation.setPerDerivatisationType(sPerDerivType);
        annotation.setReducingEnd(sRedEnd);
        annotation.setGlytoucanId(glytoucanId);
        return annotation;
    }

    @Override
    protected boolean processStructure(AnalyteSettings analyteSettings, GelatoAnalyte gelatoAnalyte) {
        Annotation annotation = null;
        GlycanScansAnnotation glycanScansAnnotation = null;
        try {
            Method method = this.getData().getDataHeader().getMethod();
            GlycanStructure glycanStructure = (GlycanStructure)gelatoAnalyte.getAnalyteStructure();
            annotation = this.getNewGlycanAnnotation(glycanStructure.getId(), glycanStructure.getSequence(), glycanStructure.getSequenceFormat(), glycanStructure.getGWBSequence().substring(0, glycanStructure.getGWBSequence().indexOf("$")), analyteSettings.getGlycanSettings().getPerDerivatisationType(), glycanStructure.getGlytoucanId(), analyteSettings.getGlycanSettings().getReducingEnd());
            glycanScansAnnotation = new GlycanScansAnnotation();
            glycanScansAnnotation.setAnnotationId(Integer.valueOf(iAnnotationIDCount));
            glycanScansAnnotation.setStringAnnotationId(glycanStructure.getId());
            ((GlycanAnnotation)annotation).setGlycanId(glycanStructure.getId());
            annotation.setId(Integer.valueOf(iAnnotationIDCount));
            ++iAnnotationIDCount;
            int currentFeatureIndex = this.data.getFeatureIndex();
            Glycan glycan = ((GlycanAnalyte)gelatoAnalyte.getAnalyte()).getGlycan();
            GlycanStructureAnnotation.populateExtraInfo((GlycanAnnotation)annotation, glycan);
            GlycanStructureAnnotation.setGlycanMassOptions(glycan, method.getMonoisotopic(), analyteSettings);
            boolean bRes = false;
            if (analyteSettings.getGlycanSettings().getFilter().getUseDatabaseStructureMetaInfo().booleanValue()) {
                AnalyteSettings customAnalyteSettings = new AnalyteSettings();
                customAnalyteSettings.setPeptideSettings(analyteSettings.getPeptideSettings());
                GlycanSettings gSettings = new GlycanSettings();
                gSettings.setAllowInnerFragments(analyteSettings.getGlycanSettings().getAllowInnerFragments());
                gSettings.setFilter(analyteSettings.getGlycanSettings().getFilter());
                gSettings.setGlycanFragments(analyteSettings.getGlycanSettings().getGlycanFragments());
                gSettings.setMaxNumOfCleavages(analyteSettings.getGlycanSettings().getMaxNumOfCleavages());
                gSettings.setMaxNumOfCrossRingCleavages(analyteSettings.getGlycanSettings().getMaxNumOfCrossRingCleavages());
                gSettings.setPerActivation(analyteSettings.getGlycanSettings().getPerActivation());
                gSettings.setPerMsLevel(analyteSettings.getGlycanSettings().getPerMsLevel());
                gSettings.setPerDerivatisationType(GlycanStructureAnnotation.getGelatoPerDerivatisationType(glycan.getMassOptions().getDerivatization()));
                gSettings.setReducingEnd(GlycanStructureAnnotation.getGelatoReducingEnd(glycan.getMassOptions().getReducingEndTypeString()));
                customAnalyteSettings.setGlycanSettings(gSettings);
                bRes = this.processAllStructureOptions(this.lPosModeSettingsToAnalyze, this.lPosModeSettingsToAnalyzeCounts, this.lNegModeSettingsToAnalyze, this.lNegModeSettingsToAnalyzeCounts, this.lExchangesoAnalyze, this.lExchangesToAnalyzeCounts, this.lNeutralLossesToAnalyze, this.lNeutralLossesToAnalyzeCounts, (ScansAnnotation)glycanScansAnnotation, customAnalyteSettings, gelatoAnalyte, annotation);
            } else {
                bRes = this.processAllStructureOptions(this.lPosModeSettingsToAnalyze, this.lPosModeSettingsToAnalyzeCounts, this.lNegModeSettingsToAnalyze, this.lNegModeSettingsToAnalyzeCounts, this.lExchangesoAnalyze, this.lExchangesToAnalyzeCounts, this.lNeutralLossesToAnalyze, this.lNeutralLossesToAnalyzeCounts, (ScansAnnotation)glycanScansAnnotation, analyteSettings, gelatoAnalyte, annotation);
            }
            if (bRes) {
                if (!glycanScansAnnotation.getScanAnnotations().keySet().isEmpty()) {
                    AnnotationWriter writer = new AnnotationWriter();
                    writer.writeAnnotationsPerAnalyte((ScansAnnotation)glycanScansAnnotation, this.m_tempFilePath);
                }
                return true;
            }
        }
        catch (Exception e) {
            logger.error((Object)"Error in processScans", (Throwable)e);
        }
        return false;
    }

    @Override
    protected AnalyteMatcher getNewAnalyteMatcher(int iCurScan) {
        return new GlycanMatcher(iCurScan, this);
    }

    @Override
    protected ScansAnnotation readScansAnnotation(AnnotationReader reader, String filePath, String annId) {
        ScansAnnotation scansAnnotation = reader.readAnnotation(filePath, annId, GlycanScansAnnotation.class);
        return scansAnnotation;
    }

    @Override
    protected String correctSequence(String _sStructureSequence) {
        Pattern p1 = Pattern.compile("(\\()(\\-1)(\\+)");
        Pattern p2 = Pattern.compile("(\\+)(\\-1)(\\))");
        Matcher m1 = p1.matcher(_sStructureSequence);
        if (m1.find()) {
            StringBuffer sb = new StringBuffer(_sStructureSequence.length());
            m1.reset();
            while (m1.find()) {
                String match1 = m1.group(1);
                String match2 = m1.group(2);
                String match3 = m1.group(3);
                match2 = match2.replace("-1", "1");
                String sNew = match1 + Matcher.quoteReplacement(match2) + match3;
                m1.appendReplacement(sb, sNew);
            }
            m1.appendTail(sb);
            return sb.toString().trim();
        }
        Matcher m2 = p2.matcher(_sStructureSequence);
        if (m2.find()) {
            StringBuffer sb = new StringBuffer(_sStructureSequence.length());
            m2.reset();
            while (m2.find()) {
                String match1 = m2.group(1);
                String match2 = m2.group(2);
                String match3 = m2.group(3);
                match2 = match2.replace("-1", "1");
                String sNew = match1 + Matcher.quoteReplacement(match2) + match3;
                m2.appendReplacement(sb, sNew);
            }
            m2.appendTail(sb);
            return sb.toString().trim();
        }
        return _sStructureSequence;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected GelatoAnalyte getNewGelatoAnalyteObject(AnalyteStructure structure) {
        Glycan glycan = null;
        GelatoAnalyte gelatoGlycan = null;
        Sugar t_sugar = null;
        if (GelatoAnalyteCache.hmGelatoAnalytesByStructureId.containsKey(structure.getId())) {
            return null;
        }
        gelatoGlycan = new GelatoAnalyte();
        try {
            GlycanStructure glycanStructure = (GlycanStructure)structure;
            if (glycanStructure.getGWBSequence() != null && !glycanStructure.getGWBSequence().equals("")) {
                glycan = Glycan.fromString((String)glycanStructure.getGWBSequence());
                if (structure.getSequenceFormat() == null || !structure.getSequenceFormat().equals(GlycanAnnotation.SEQ_FORMAT_GLYCOCT_CONDENSED)) {
                    structure.setSequence(glycan.toGlycoCTCondensed());
                }
            } else {
                if (structure.getSequence() == null || structure.getSequence().equals("")) throw new Exception("Sequence not specfied for structure: " + structure.getId());
                if (structure.getSequenceFormat() == null || structure.getSequenceFormat().equals(GlycanAnnotation.SEQ_FORMAT_GLYDEII)) {
                    t_sugar = GlycanExtraInfo.glydeToSugar(structure.getSequence());
                    String t_glycoCT = GlycanExtraInfo.sugarToGlycoCT(t_sugar);
                    glycan = Glycan.fromGlycoCTCondensed((String)t_glycoCT);
                    structure.setSequence(glycan.toGlycoCTCondensed());
                } else if (structure.getSequenceFormat().equals(GlycanAnnotation.SEQ_FORMAT_GLYCOCT_CONDENSED)) {
                    glycan = Glycan.fromGlycoCTCondensed((String)structure.getSequence());
                } else {
                    if (!structure.getSequenceFormat().equals(GlycanAnnotation.SEQ_FORMAT_GLYCOCT_XML)) throw new Exception("Unsupported sequence type (" + structure.getSequenceFormat() + ") for structure: " + structure.getId());
                    glycan = Glycan.fromGlycoCT((String)structure.getSequence());
                    structure.setSequence(glycan.toGlycoCTCondensed());
                }
            }
            String sCorrectedSeq = this.correctSequence(structure.getSequence());
            while (!sCorrectedSeq.equals(structure.getSequence())) {
                structure.setSequence(sCorrectedSeq);
                sCorrectedSeq = this.correctSequence(sCorrectedSeq);
            }
            structure.setSequenceFormat(GlycanAnnotation.SEQ_FORMAT_GLYCOCT_CONDENSED);
            if (glycan != null && glycanStructure.getGWBSequence() == null) {
                glycanStructure.setGWBSequence(glycan.toString());
                String string = glycan.toStringOrdered(false);
            }
            GlycanAnalyte glycanAnalyte = new GlycanAnalyte(glycanStructure.getGWBSequence(), glycan);
            gelatoGlycan.setAnalyte(glycanAnalyte);
            gelatoGlycan.setAnalyteStructure(structure);
            return gelatoGlycan;
        }
        catch (GlycoVisitorException e) {
            logger.error((Object)e.getMessage());
            return gelatoGlycan;
        }
        catch (SugarImporterException e) {
            logger.error((Object)e.getMessage());
            return gelatoGlycan;
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage());
        }
        return gelatoGlycan;
    }

    public static double calculateMass(Glycan glycan) {
        return glycan.computeMass();
    }

    public static GlycanAnalyte getGlycan(GlycanStructure structure) {
        try {
            if (!GelatoAnalyteCache.hmGelatoAnalytesByStructureId.containsKey(structure.getId())) {
                throw new Exception("Could not find Glycan object for structure: " + structure.getId());
            }
            GelatoAnalyte gelatoGlycan = GelatoAnalyteCache.hmGelatoAnalytesByStructureId.get(structure.getId());
            if (gelatoGlycan == null || gelatoGlycan.getAnalyte() == null) {
                throw new Exception("Could not find Glycan object for structure: " + structure.getId());
            }
            return (GlycanAnalyte)gelatoGlycan.getAnalyte();
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public static void setGlycanMassOptions(Glycan _glycan, boolean _bIsMono, AnalyteSettings _analyteSettings) {
        try {
            if (!_analyteSettings.getGlycanSettings().getFilter().getUseDatabaseStructureMetaInfo().booleanValue()) {
                _glycan.setMassOptions(GlycanStructureAnnotation.collectMassOptions(_bIsMono, _analyteSettings));
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    public static void populateExtraInfo(GlycanAnnotation annotation, Glycan glycan) {
        try {
            String sKey = glycan.toString();
            if (!GelatoAnalyteCache.hmCachedExtraSettings.containsKey(sKey)) {
                glycan.setReducingEndType(ResidueType.createFreeReducingEnd());
                GlycanExtraInfo.populateGlycanExtraInformation(annotation, glycan.toSugar());
                GelatoAnalyteCache.hmCachedExtraSettings.put(sKey, (Annotation)annotation);
            } else {
                logger.debug((Object)("Cloning extra info for: " + sKey));
                GlycanAnnotation sourceAnnotation = (GlycanAnnotation)GelatoAnalyteCache.hmCachedExtraSettings.get(sKey);
                GlycanExtraInfo.cloneGlycanExtraInformation(sourceAnnotation, annotation);
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    protected AnalyteSettings getGlycanSpecificAnalyteSettings(Glycan glycan) {
        return null;
    }

    public static ReducingEnd getGelatoReducingEnd(String _gwbReducingEnd) {
        ReducingEnd re = new ReducingEnd();
        re.setLabel(_gwbReducingEnd);
        if (_gwbReducingEnd.contains("=")) {
            String[] sToks = _gwbReducingEnd.split("=");
            re.setLabel(sToks[0]);
            sToks[1] = sToks[1].replace("u", "");
            re.setMass(Double.valueOf(Double.parseDouble(sToks[1])));
        } else {
            ResidueType type = ResidueDictionary.findResidueType((String)_gwbReducingEnd);
            re.setLabel(type.getName());
            re.setMass(Double.valueOf(type.getMass()));
        }
        re.setType(_gwbReducingEnd);
        return re;
    }

    public static String getGelatoPerDerivatisationType(String _gwbDerivatisationType) {
        if (_gwbDerivatisationType.equals("perMe")) {
            return GlycanPreDefinedOptions.DERIVITIZATION_PERMETHYLATED;
        }
        if (_gwbDerivatisationType.equals("perMe(C^13)")) {
            return GlycanPreDefinedOptions.DERIVITIZATION_HEAVYPERMETHYLATION;
        }
        if (_gwbDerivatisationType.equals("perDMe")) {
            return GlycanPreDefinedOptions.DERIVITIZATION_PERDMETHYLATED;
        }
        if (_gwbDerivatisationType.equals("perAc")) {
            return GlycanPreDefinedOptions.DERIVITIZATION_PERACETYLATED;
        }
        if (_gwbDerivatisationType.equals("perDAc")) {
            return GlycanPreDefinedOptions.DERIVITIZATION_PERDACETYLATED;
        }
        if (_gwbDerivatisationType.equals("Und")) {
            return GlycanPreDefinedOptions.DERIVITIZATION_NO_DERIVATIZATION;
        }
        return GlycanPreDefinedOptions.DERIVITIZATION_NO_DERIVATIZATION;
    }

    public static MassOptions collectMassOptions(boolean _isMono, AnalyteSettings _analyteSettings) {
        MassOptions t_massOptions = new MassOptions();
        if (_analyteSettings.getGlycanSettings().getPerDerivatisationType().equals(GlycanPreDefinedOptions.DERIVITIZATION_PERMETHYLATED)) {
            t_massOptions.setDerivatization("perMe");
        } else if (_analyteSettings.getGlycanSettings().getPerDerivatisationType().equals(GlycanPreDefinedOptions.DERIVITIZATION_HEAVYPERMETHYLATION)) {
            t_massOptions.setDerivatization("perMe(C^13)");
        } else if (_analyteSettings.getGlycanSettings().getPerDerivatisationType().equals(GlycanPreDefinedOptions.DERIVITIZATION_PERDMETHYLATED)) {
            t_massOptions.setDerivatization("perDMe");
        } else if (_analyteSettings.getGlycanSettings().getPerDerivatisationType().equals(GlycanPreDefinedOptions.DERIVITIZATION_PERACETYLATED)) {
            t_massOptions.setDerivatization("perAc");
        } else if (_analyteSettings.getGlycanSettings().getPerDerivatisationType().equals(GlycanPreDefinedOptions.DERIVITIZATION_PERDACETYLATED)) {
            t_massOptions.setDerivatization("perDAc");
        } else {
            t_massOptions.setDerivatization("Und");
        }
        if (_isMono) {
            t_massOptions.setIsotope("MONO");
        } else {
            t_massOptions.setIsotope("AVG");
        }
        ResidueType gwbRT = GlycanStructureAnnotation.getResidueTypeForReducingEnd(_analyteSettings.getGlycanSettings().getReducingEnd());
        t_massOptions.setReducingEndType(gwbRT);
        return t_massOptions;
    }

    public static ResidueType getResidueTypeForReducingEnd(ReducingEnd _reducingEnd) {
        ResidueType gwbRT = null;
        if (_reducingEnd.getType().equals(GlycanPreDefinedOptions.OTHER)) {
            gwbRT = ResidueType.createOtherReducingEnd((String)_reducingEnd.getLabel(), (double)_reducingEnd.getMass());
        } else {
            gwbRT = ResidueDictionary.findResidueType((String)_reducingEnd.getType());
            if (gwbRT == null) {
                logger.warn((Object)("Unable to look-up reducing end \"" + _reducingEnd.getLabel() + "\""));
                _reducingEnd.setType(GlycanPreDefinedOptions.OTHER);
                return GlycanStructureAnnotation.getResidueTypeForReducingEnd(_reducingEnd);
            }
        }
        return gwbRT;
    }

    public static double getOtherReducingEnd(AnalyteSettings settings) {
        try {
            double changeValue = 0.0;
            if (settings.getGlycanSettings().getReducingEnd().getType().equals(GlycanPreDefinedOptions.OTHER)) {
                return changeValue += settings.getGlycanSettings().getReducingEnd().getMass().doubleValue();
            }
        }
        catch (Exception ex) {
            logger.error((Object)ex.getMessage(), (Throwable)ex);
        }
        return 0.0;
    }

    @Override
    public void setCanceled(boolean bCancel) {
        this.bCancel = bCancel;
        if (bCancel && this.curGlycanMatcher != null) {
            this.curGlycanMatcher.setCanceled(true);
        }
    }

    @Override
    public boolean isCanceled() {
        return this.bCancel;
    }
}

