/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.appender.rolling;

import java.lang.reflect.Method;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.appender.rolling.RollingFileManager;
import org.apache.logging.log4j.core.appender.rolling.TriggeringPolicy;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginFactory;
import org.apache.logging.log4j.status.StatusLogger;

@Plugin(name="OnStartupTriggeringPolicy", category="Core", printObject=true)
public class OnStartupTriggeringPolicy
implements TriggeringPolicy {
    private static long JVM_START_TIME = OnStartupTriggeringPolicy.initStartTime();
    private boolean evaluated = false;
    private RollingFileManager manager;

    @Override
    public void initialize(RollingFileManager manager) {
        this.manager = manager;
        if (JVM_START_TIME == 0L) {
            this.evaluated = true;
        }
    }

    private static long initStartTime() {
        try {
            Class<?> factoryClass = Class.forName("java.lang.management.ManagementFactory");
            Method getRuntimeMXBean = factoryClass.getMethod("getRuntimeMXBean", new Class[0]);
            Object runtimeMXBean = getRuntimeMXBean.invoke(null, new Object[0]);
            Class<?> runtimeMXBeanClass = Class.forName("java.lang.management.RuntimeMXBean");
            Method getStartTime = runtimeMXBeanClass.getMethod("getStartTime", new Class[0]);
            Long result = (Long)getStartTime.invoke(runtimeMXBean, new Object[0]);
            return result;
        }
        catch (Throwable t) {
            StatusLogger.getLogger().error("Unable to call ManagementFactory.getRuntimeMXBean().getStartTime(), using system time for OnStartupTriggeringPolicy", t);
            return System.currentTimeMillis();
        }
    }

    @Override
    public boolean isTriggeringEvent(LogEvent event) {
        if (this.evaluated) {
            return false;
        }
        this.evaluated = true;
        return this.manager.getFileTime() < JVM_START_TIME;
    }

    public String toString() {
        return "OnStartupTriggeringPolicy";
    }

    @PluginFactory
    public static OnStartupTriggeringPolicy createPolicy() {
        return new OnStartupTriggeringPolicy();
    }
}

