/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.entry.ms.annotation.views.tabbed;

import org.apache.log4j.Logger;
import org.grits.toolbox.entry.ms.annotation.views.tabbed.MSAnnotationMultiPageViewer;
import org.grits.toolbox.entry.ms.property.MassSpecEntityProperty;
import org.grits.toolbox.entry.ms.views.tabbed.MassSpecMultiPageViewer;
import org.grits.toolbox.entry.ms.views.tabbed.MassSpecMultiPageViewerWorker;
import org.grits.toolbox.widgets.tools.GRITSProcessStatus;

public class MSAnnotationMultiPageViewerWorker
extends MassSpecMultiPageViewerWorker {
    private static final Logger logger = Logger.getLogger(MSAnnotationMultiPageViewerWorker.class);

    public MSAnnotationMultiPageViewerWorker(MassSpecMultiPageViewer parentEditor, MassSpecEntityProperty prop) {
        super(parentEditor, prop);
    }

    public int doWork() {
        int iSuccess;
        MSAnnotationMultiPageViewer msParentEditor = (MSAnnotationMultiPageViewer)this.getParentEditor();
        this.iMajorCount = 0;
        if ((iSuccess = this.addPropertyPage(this.iMajorCount++)) != GRITSProcessStatus.OK) {
            return iSuccess;
        }
        if (!msParentEditor.hasMSFile(this.prop)) {
            return GRITSProcessStatus.OK;
        }
        if (this.getParentEditor().getMinMSLevel() < 0 && (iSuccess = this.determineMinMSLevel(this.iMajorCount++)) != GRITSProcessStatus.OK) {
            return iSuccess;
        }
        iSuccess = this.addMSScansTab(this.prop, this.iMajorCount);
        this.iMajorCount += 2;
        if (iSuccess != GRITSProcessStatus.OK) {
            return iSuccess;
        }
        if ((iSuccess = this.addMSAnnotationPropertyPage(this.iMajorCount++)) != GRITSProcessStatus.OK) {
            return iSuccess;
        }
        if ((iSuccess = this.addMSFilterPage(this.iMajorCount++)) != GRITSProcessStatus.OK) {
            return iSuccess;
        }
        if ((iSuccess = this.addMSOtherSettingsPage(this.iMajorCount++)) != GRITSProcessStatus.OK) {
            return iSuccess;
        }
        if ((iSuccess = this.addMSQuantificationPage(this.iMajorCount++)) != GRITSProcessStatus.OK) {
            return iSuccess;
        }
        if (this.getParentEditor().needsPeaksView(this.prop)) {
            iSuccess = this.addPeakListPage(this.prop, this.iMajorCount++);
            if (!msParentEditor.needsDetailsView(this.prop)) {
                ++this.iMajorCount;
            }
            if (iSuccess != GRITSProcessStatus.OK) {
                return iSuccess;
            }
        }
        if (msParentEditor.needsDetailsView(this.prop)) {
            iSuccess = this.addDetailsPage(this.prop, this.iMajorCount++);
            this.iMajorCount += msParentEditor.getNumDetailSteps();
            if (iSuccess != GRITSProcessStatus.OK) {
                msParentEditor.setStatus(iSuccess);
                return iSuccess;
            }
        }
        if (this.getParentEditor().needsSpectraView(this.prop) && (iSuccess = this.addSpectraPage(this.prop, this.iMajorCount++)) != GRITSProcessStatus.OK) {
            return iSuccess;
        }
        if ((iSuccess = this.addScanHierarcyPage(this.prop, this.iMajorCount++)) != GRITSProcessStatus.OK) {
            return iSuccess;
        }
        this.updateListeners("Finished MS Annotation work!", this.iMajorCount);
        logger.debug((Object)"Finished MS Annotation work");
        return iSuccess;
    }

    public int addMSAnnotationPropertyPage(int iProcessCount) {
        try {
            this.updateListeners("Creating MS Annotation Property tab (loading)", iProcessCount);
            int iSuccess = ((MSAnnotationMultiPageViewer)this.getParentEditor()).addMSAnnotationPropertyView();
            this.updateListeners("Creating MS Annotation Property tab (done)", iProcessCount + 1);
            return iSuccess;
        }
        catch (Exception ex) {
            logger.error((Object)"Unable to open MS Annotation Property view", (Throwable)ex);
            return GRITSProcessStatus.ERROR;
        }
    }

    public int addMSFilterPage(int iProcessCount) {
        try {
            this.updateListeners("Creating MS Annotation Filters tab (loading)", iProcessCount);
            int iSuccess = ((MSAnnotationMultiPageViewer)this.getParentEditor()).addMsFilterPage();
            this.updateListeners("Creating MS Annotation Filters tab (done)", iProcessCount + 1);
            return iSuccess;
        }
        catch (Exception ex) {
            logger.error((Object)"Unable to open MS Annotation Filters view", (Throwable)ex);
            return GRITSProcessStatus.ERROR;
        }
    }

    public int addMSOtherSettingsPage(int iProcessCount) {
        try {
            this.updateListeners("Creating MS Custom Annotation Settings tab (loading)", iProcessCount);
            int iSuccess = ((MSAnnotationMultiPageViewer)this.getParentEditor()).addOtherSettingsPage();
            this.updateListeners("Creating MS Custom Annotation Settings tab (done)", iProcessCount + 1);
            return iSuccess;
        }
        catch (Exception ex) {
            logger.error((Object)"Unable to open MS Custom Annotation Settings view", (Throwable)ex);
            return GRITSProcessStatus.ERROR;
        }
    }

    public int addMSQuantificationPage(int iProcessCount) {
        try {
            this.updateListeners("Creating MS Annotation Quantification Settings tab (loading)", iProcessCount);
            int iSuccess = ((MSAnnotationMultiPageViewer)this.getParentEditor()).addQuantificationPage();
            this.updateListeners("Creating MS Annotation Quantification Settings tab (done)", iProcessCount + 1);
            return iSuccess;
        }
        catch (Exception ex) {
            logger.error((Object)"Unable to open MS Annotation Quantification Settings view", (Throwable)ex);
            return GRITSProcessStatus.ERROR;
        }
    }

    public int addPeakListPage(MassSpecEntityProperty prop, int iProcessCount) {
        try {
            this.updateListeners("Creating MS Peak tab (loading)", iProcessCount);
            int iSuccess = this.getParentEditor().addPeakListPage_Step1(prop);
            if (iSuccess != GRITSProcessStatus.OK) {
                return iSuccess;
            }
            if (!((MSAnnotationMultiPageViewer)this.getParentEditor()).needsDetailsView(prop)) {
                this.updateListeners("Creating MS Peak tab (populating)", iProcessCount + 1);
                iSuccess = ((MSAnnotationMultiPageViewer)this.getParentEditor()).addPeakListPage_Step2();
                this.updateListeners("Creating MS Peak tab (done)", iProcessCount + 2);
            } else {
                this.updateListeners("Creating MS Peak tab (done)", iProcessCount + 1);
            }
            return iSuccess;
        }
        catch (Exception e) {
            logger.error((Object)"Unable to open MS Peaks view", (Throwable)e);
            return GRITSProcessStatus.ERROR;
        }
    }

    public int addDetailsPage(MassSpecEntityProperty prop, int iProcessCount) {
        try {
            this.updateListeners("Creating Details tab (loading)", iProcessCount);
            int iSuccess = ((MSAnnotationMultiPageViewer)this.getParentEditor()).addDetailsTab_Step1(prop);
            if (iSuccess != GRITSProcessStatus.OK) {
                return iSuccess;
            }
            this.updateListeners("Creating Details tab (populating)", iProcessCount + 1);
            iSuccess = ((MSAnnotationMultiPageViewer)this.getParentEditor()).addDetailsTab_Step2();
            return iSuccess;
        }
        catch (Exception e) {
            logger.error((Object)"Unable to open Details view", (Throwable)e);
            return GRITSProcessStatus.ERROR;
        }
    }
}

