/*
 * Decompiled with CFR 0.152.
 */
package org.eurocarbdb.application.glycanbuilder;

import java.awt.Color;
import java.util.Vector;
import org.eurocarbdb.application.glycanbuilder.TextUtils;

public class ResidueStyle {
    private String name;
    private String shape;
    private Color shape_color;
    private String fill_style;
    private boolean fill_negative;
    private Color fill_color;
    private String text;
    private Color text_color;

    public ResidueStyle() {
        this.name = "#empty";
        this.shape = null;
        this.shape_color = Color.black;
        this.fill_style = "empty";
        this.fill_negative = false;
        this.fill_color = Color.white;
        this.text = null;
        this.text_color = Color.black;
    }

    public ResidueStyle(String init) throws Exception {
        Vector<String> tokens = TextUtils.tokenize(init, "\t");
        if (tokens.size() != 8) {
            throw new Exception("Invalid string format: " + init);
        }
        this.name = tokens.elementAt(0);
        this.shape = tokens.elementAt(6).equals("none") || tokens.elementAt(1).equals("-") ? null : tokens.elementAt(1);
        this.shape_color = ResidueStyle.parseColor(tokens.elementAt(2));
        this.fill_style = tokens.elementAt(3);
        this.fill_negative = tokens.elementAt(4).equals("yes") || tokens.elementAt(4).equals("true");
        this.fill_color = ResidueStyle.parseColor(tokens.elementAt(5));
        this.text = tokens.elementAt(6).equals("none") || tokens.elementAt(6).equals("-") ? null : tokens.elementAt(6);
        this.text_color = ResidueStyle.parseColor(tokens.elementAt(7));
    }

    private static Color parseColor(String init) {
        Vector<String> tokens = TextUtils.tokenize(init, ",");
        if (tokens.size() != 3) {
            return Color.black;
        }
        int r = Integer.parseInt(tokens.elementAt(0));
        int g = Integer.parseInt(tokens.elementAt(1));
        int b = Integer.parseInt(tokens.elementAt(2));
        return new Color(r, g, b);
    }

    public String getName() {
        return this.name;
    }

    public String getShape() {
        return this.shape;
    }

    public boolean hasShape() {
        return this.shape != null;
    }

    public Color getShapeColor() {
        return this.shape_color;
    }

    public String getFillStyle() {
        return this.fill_style;
    }

    public boolean isFillNegative() {
        return this.fill_negative;
    }

    public Color getFillColor() {
        return this.fill_color;
    }

    public boolean isTextOnly() {
        return this.shape == null && this.text != null;
    }

    public String getText() {
        return this.text;
    }

    public Color getTextColor() {
        return this.text_color;
    }

    public static ResidueStyle createText(String text) {
        ResidueStyle ret = new ResidueStyle();
        ret.text = text;
        return ret;
    }

    public static ResidueStyle createStartRepetition() {
        ResidueStyle ret = new ResidueStyle();
        ret.shape = "startrep";
        ret.fill_style = "full";
        ret.fill_color = Color.black;
        return ret;
    }

    public static ResidueStyle createEndRepetition() {
        ResidueStyle ret = new ResidueStyle();
        ret.shape = "endrep";
        ret.fill_style = "full";
        ret.fill_color = Color.black;
        return ret;
    }

    public static ResidueStyle createAttachPoint() {
        ResidueStyle ret = new ResidueStyle();
        ret.shape = "point";
        return ret;
    }

    public static ResidueStyle createReducingEnd() {
        ResidueStyle ret = new ResidueStyle();
        ret.shape = "end";
        return ret;
    }

    public static ResidueStyle createBracket() {
        ResidueStyle ret = new ResidueStyle();
        ret.shape = "bracket";
        return ret;
    }

    public static ResidueStyle createACleavage(int start, int end) {
        ResidueStyle ret = new ResidueStyle();
        ret.shape = "hexagon";
        ret.fill_style = "arc_" + start + "_" + end;
        ret.fill_color = Color.gray;
        return ret;
    }

    public static ResidueStyle createBCleavage() {
        ResidueStyle ret = new ResidueStyle();
        ret.shape = "bcleavage";
        return ret;
    }

    public static ResidueStyle createCCleavage() {
        ResidueStyle ret = new ResidueStyle();
        ret.shape = "ccleavage";
        return ret;
    }

    public static ResidueStyle createXCleavage(int start, int end) {
        ResidueStyle ret = new ResidueStyle();
        ret.shape = "hexagon";
        ret.fill_style = "arc_" + start + "_" + end;
        ret.fill_color = Color.gray;
        return ret;
    }

    public static ResidueStyle createYCleavage() {
        ResidueStyle ret = new ResidueStyle();
        ret.shape = "ycleavage";
        return ret;
    }

    public static ResidueStyle createZCleavage() {
        ResidueStyle ret = new ResidueStyle();
        ret.shape = "zcleavage";
        return ret;
    }
}

