/*
 * Decompiled with CFR 0.152.
 */
package org.eurocarbdb.application.glycanbuilder;

import java.awt.Component;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Collection;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JSeparator;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerListModel;
import org.eurocarbdb.application.glycanbuilder.CustomFocusTraversalPolicy;
import org.eurocarbdb.application.glycanbuilder.EscapeDialog;
import org.eurocarbdb.application.glycanbuilder.Glycan;
import org.eurocarbdb.application.glycanbuilder.MassOptions;
import org.eurocarbdb.application.glycanbuilder.MassUtils;
import org.eurocarbdb.application.glycanbuilder.ResidueDictionary;
import org.eurocarbdb.application.glycanbuilder.ResidueType;
import org.eurocarbdb.application.glycanbuilder.Union;
import org.jdesktop.layout.GroupLayout;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MassOptionsStructureDialog
extends EscapeDialog
implements ActionListener {
    private MassOptions common_options = new MassOptions();
    private Collection<Glycan> structures = null;
    private JButton button_cancel;
    private JButton button_ok;
    private JComboBox field_derivatization;
    private JSpinner field_ex_k_ions;
    private JSpinner field_ex_li_ions;
    private JSpinner field_ex_na_ions;
    private JSpinner field_ex_cl_ions;
    private JSpinner field_ex_h2po4_ions;
    private JComboBox field_isotope;
    private JCheckBox field_negative_mode;
    private JSpinner field_no_h_ions;
    private JSpinner field_no_k_ions;
    private JSpinner field_no_li_ions;
    private JSpinner field_no_na_ions;
    private JSpinner field_no_cl_ions;
    private JSpinner field_no_h2po4_ions;
    private JTextField field_other_mass;
    private JTextField field_other_name;
    private JComboBox field_reducingend;
    private JLabel jLabel1;
    private JLabel jLabel10;
    private JLabel jLabel11;
    private JLabel jLabel12;
    private JLabel jLabel13;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JLabel jLabel8;
    private JLabel jLabel9;
    private JLabel jLabelCLNo;
    private JLabel jLabelCLExtNo;
    private JLabel jLabelH2PO4No;
    private JLabel jLabelH2PO4ExtNo;
    private JSeparator jSeparator1;
    private JSeparator jSeparator3;
    private JSeparator jSeparator4;

    public MassOptionsStructureDialog(Frame parent, Collection<Glycan> _structures, MassOptions _default) {
        super(parent, true);
        this.structures = _structures;
        this.setCommonOptions(_structures, _default);
        this.initComponents();
        this.initData();
        this.setTraversal();
        this.setActions();
        this.enableItems();
        this.setLocationRelativeTo(parent);
    }

    public MassOptions getMassOptions() {
        return this.common_options;
    }

    private Object[] generateValues(int min, int max, boolean include_und) {
        if (include_und) {
            Object[] values = new Object[1 + (max - min + 1)];
            values[0] = "---";
            for (int i = min; i <= max; ++i) {
                values[i - min + 1] = i;
            }
            return values;
        }
        Object[] values = new Object[max - min + 1];
        for (int i = min; i <= max; ++i) {
            values[i - min] = i;
        }
        return values;
    }

    private void setValue(JSpinner field, int value) {
        if (value == 999) {
            field.setValue("---");
        } else {
            field.setValue(value);
        }
    }

    private int getValue(JSpinner field) {
        if (field.getValue().equals("---")) {
            return 999;
        }
        return (Integer)field.getValue();
    }

    private int limitValue(int v, int l) {
        if (v == 999) {
            return 999;
        }
        return Math.min(v, l);
    }

    private void setCommonOptions(Collection<Glycan> structures, MassOptions _default) {
        if (structures == null || structures.size() == 0) {
            this.common_options = _default;
            return;
        }
        this.common_options = new MassOptions(true);
        boolean first = true;
        for (Glycan structure : structures) {
            MassOptions structure_options = structure.getMassOptions();
            if (first) {
                this.common_options = structure_options.clone();
                first = false;
                continue;
            }
            this.common_options.merge(structure_options);
        }
    }

    private void initData() {
        this.field_isotope.setModel(new DefaultComboBoxModel<String>(new String[]{"---", "MONO", "AVG"}));
        this.field_derivatization.setModel(new DefaultComboBoxModel<String>(new String[]{"---", "Und", "perMe", "perDMe", "perMe(C^13)", "perAc", "perDAc"}));
        this.field_reducingend.setModel(new DefaultComboBoxModel<String>(new Union<String>().and("---").and(ResidueDictionary.getReducingEndsString()).and("Other...").toArray((String[])new String[0])));
        this.field_no_h_ions.setModel(new SpinnerListModel(this.generateValues(0, 10, true)));
        this.field_no_na_ions.setModel(new SpinnerListModel(this.generateValues(0, 10, true)));
        this.field_no_li_ions.setModel(new SpinnerListModel(this.generateValues(0, 10, true)));
        this.field_no_k_ions.setModel(new SpinnerListModel(this.generateValues(0, 10, true)));
        this.field_no_cl_ions.setModel(new SpinnerListModel(this.generateValues(0, 10, true)));
        this.field_no_h2po4_ions.setModel(new SpinnerListModel(this.generateValues(0, 10, true)));
        this.field_ex_na_ions.setModel(new SpinnerListModel(this.generateValues(0, 50, true)));
        this.field_ex_li_ions.setModel(new SpinnerListModel(this.generateValues(0, 50, true)));
        this.field_ex_k_ions.setModel(new SpinnerListModel(this.generateValues(0, 50, true)));
        this.field_ex_cl_ions.setModel(new SpinnerListModel(this.generateValues(0, 50, true)));
        this.field_ex_h2po4_ions.setModel(new SpinnerListModel(this.generateValues(0, 50, true)));
        this.field_isotope.setSelectedItem(this.common_options.ISOTOPE);
        this.field_derivatization.setSelectedItem(this.common_options.DERIVATIZATION);
        if (this.common_options.REDUCING_END_TYPE == null) {
            this.field_reducingend.setSelectedItem("---");
            this.field_other_name.setText("");
            this.field_other_mass.setText("0");
        } else if (this.common_options.REDUCING_END_TYPE.isCustomType()) {
            this.field_reducingend.setSelectedItem("Other...");
            this.field_other_name.setText(this.common_options.REDUCING_END_TYPE.getResidueName());
            this.field_other_mass.setText("" + (this.common_options.REDUCING_END_TYPE.getResidueMassMain() - MassUtils.water.getMainMass()));
        } else {
            this.field_reducingend.setSelectedItem(this.common_options.REDUCING_END_TYPE.getName());
            this.field_other_name.setText("");
            this.field_other_mass.setText("0");
        }
        this.field_negative_mode.setSelected(this.common_options.ION_CLOUD.isNegative());
        this.setValue(this.field_no_h_ions, Math.abs(this.common_options.ION_CLOUD.get("H")));
        this.setValue(this.field_no_na_ions, Math.abs(this.common_options.ION_CLOUD.get("Na")));
        this.setValue(this.field_no_li_ions, Math.abs(this.common_options.ION_CLOUD.get("Li")));
        this.setValue(this.field_no_k_ions, Math.abs(this.common_options.ION_CLOUD.get("K")));
        this.setValue(this.field_no_cl_ions, Math.abs(this.common_options.ION_CLOUD.get("Cl")));
        this.setValue(this.field_no_h2po4_ions, Math.abs(this.common_options.ION_CLOUD.get("H2PO4")));
        this.setValue(this.field_ex_na_ions, this.common_options.NEUTRAL_EXCHANGES.get("Na"));
        this.setValue(this.field_ex_li_ions, this.common_options.NEUTRAL_EXCHANGES.get("Li"));
        this.setValue(this.field_ex_k_ions, this.common_options.NEUTRAL_EXCHANGES.get("K"));
        this.setValue(this.field_ex_cl_ions, this.common_options.NEUTRAL_EXCHANGES.get("Cl"));
        this.setValue(this.field_ex_h2po4_ions, this.common_options.NEUTRAL_EXCHANGES.get("H2PO4"));
    }

    private void setTraversal() {
        CustomFocusTraversalPolicy tp = new CustomFocusTraversalPolicy();
        tp.addComponent(this.field_isotope);
        tp.addComponent(this.field_derivatization);
        tp.addComponent(this.field_reducingend);
        tp.addComponent(this.field_other_name);
        tp.addComponent(this.field_other_mass);
        tp.addComponent(this.field_negative_mode);
        tp.addComponent(this.field_no_h_ions);
        tp.addComponent(this.field_no_na_ions);
        tp.addComponent(this.field_no_li_ions);
        tp.addComponent(this.field_no_k_ions);
        tp.addComponent(this.field_no_cl_ions);
        tp.addComponent(this.field_no_h2po4_ions);
        tp.addComponent(this.field_ex_na_ions);
        tp.addComponent(this.field_ex_li_ions);
        tp.addComponent(this.field_ex_k_ions);
        tp.addComponent(this.field_ex_cl_ions);
        tp.addComponent(this.field_ex_h2po4_ions);
        tp.addComponent(this.button_ok);
        tp.addComponent(this.button_cancel);
        this.setFocusTraversalPolicy(tp);
        this.getRootPane().setDefaultButton(this.button_ok);
    }

    private void setActions() {
        this.button_ok.addActionListener(this);
        this.button_cancel.addActionListener(this);
        this.field_reducingend.addActionListener(this);
    }

    private void enableItems() {
        this.field_isotope.setEnabled(false);
        this.field_other_name.setEnabled(this.field_reducingend.getSelectedItem().equals("Other..."));
        this.field_other_mass.setEnabled(this.field_reducingend.getSelectedItem().equals("Other..."));
    }

    private boolean retrieveData() {
        if (this.field_reducingend.getSelectedItem().equals("Other...")) {
            ResidueType red_end_type = ResidueType.createOtherReducingEnd(this.field_other_name.getText(), Double.valueOf(this.field_other_mass.getText()));
            if (ResidueDictionary.findResidueType(red_end_type.getResidueName()) != null) {
                JOptionPane.showMessageDialog(this, "The name specified for the reducing end is already existing.", "Duplicate name", 0);
                return false;
            }
            this.common_options.REDUCING_END_TYPE = red_end_type;
        } else {
            this.common_options.REDUCING_END_TYPE = ResidueDictionary.findResidueType((String)this.field_reducingend.getSelectedItem());
        }
        this.common_options.ISOTOPE = (String)this.field_isotope.getSelectedItem();
        this.common_options.DERIVATIZATION = (String)this.field_derivatization.getSelectedItem();
        int multiplier = this.field_negative_mode.isSelected() ? -1 : 1;
        this.common_options.ION_CLOUD.set("H", multiplier * this.getValue(this.field_no_h_ions));
        this.common_options.ION_CLOUD.set("Na", multiplier * this.getValue(this.field_no_na_ions));
        this.common_options.ION_CLOUD.set("Li", multiplier * this.getValue(this.field_no_li_ions));
        this.common_options.ION_CLOUD.set("K", multiplier * this.getValue(this.field_no_k_ions));
        this.common_options.ION_CLOUD.set("Cl", 1 * this.getValue(this.field_no_cl_ions));
        this.common_options.ION_CLOUD.set("H2PO4", 1 * this.getValue(this.field_no_h2po4_ions));
        this.common_options.NEUTRAL_EXCHANGES.set("H", -this.getValue(this.field_ex_na_ions) - this.getValue(this.field_ex_li_ions) - this.getValue(this.field_ex_k_ions) - this.getValue(this.field_ex_cl_ions) - this.getValue(this.field_ex_h2po4_ions));
        this.common_options.NEUTRAL_EXCHANGES.set("Na", this.getValue(this.field_ex_na_ions));
        this.common_options.NEUTRAL_EXCHANGES.set("Li", this.getValue(this.field_ex_li_ions));
        this.common_options.NEUTRAL_EXCHANGES.set("K", this.getValue(this.field_ex_k_ions));
        this.common_options.NEUTRAL_EXCHANGES.set("Cl", this.getValue(this.field_ex_cl_ions));
        this.common_options.NEUTRAL_EXCHANGES.set("H2PO4", this.getValue(this.field_ex_h2po4_ions));
        return true;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String action = e.getActionCommand();
        if (action == "OK") {
            this.return_status = action;
            if (this.retrieveData()) {
                this.closeDialog();
            }
        } else if (action == "Cancel") {
            this.return_status = action;
            this.closeDialog();
        } else {
            this.enableItems();
        }
    }

    private void initComponents() {
        this.jLabel2 = new JLabel();
        this.field_isotope = new JComboBox();
        this.field_derivatization = new JComboBox();
        this.jLabel3 = new JLabel();
        this.jLabel4 = new JLabel();
        this.button_ok = new JButton();
        this.button_cancel = new JButton();
        this.jSeparator3 = new JSeparator();
        this.jLabel5 = new JLabel();
        this.jLabel7 = new JLabel();
        this.jLabel8 = new JLabel();
        this.jLabelCLNo = new JLabel();
        this.jLabelH2PO4No = new JLabel();
        this.field_no_h_ions = new JSpinner();
        this.field_no_na_ions = new JSpinner();
        this.field_no_li_ions = new JSpinner();
        this.field_no_k_ions = new JSpinner();
        this.field_no_cl_ions = new JSpinner();
        this.field_no_h2po4_ions = new JSpinner();
        this.jLabel6 = new JLabel();
        this.jLabel9 = new JLabel();
        this.jLabel10 = new JLabel();
        this.jLabelCLExtNo = new JLabel();
        this.jLabelH2PO4ExtNo = new JLabel();
        this.field_ex_na_ions = new JSpinner();
        this.field_ex_li_ions = new JSpinner();
        this.field_ex_k_ions = new JSpinner();
        this.jSeparator4 = new JSeparator();
        this.field_ex_cl_ions = new JSpinner();
        this.field_ex_h2po4_ions = new JSpinner();
        this.jLabel11 = new JLabel();
        this.field_negative_mode = new JCheckBox();
        this.jLabel12 = new JLabel();
        this.field_reducingend = new JComboBox();
        this.jSeparator1 = new JSeparator();
        this.jLabel1 = new JLabel();
        this.field_other_name = new JTextField();
        this.jLabel13 = new JLabel();
        this.field_other_mass = new JTextField();
        this.setResizable(false);
        this.setTitle("Mass options");
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                MassOptionsStructureDialog.this.closeDialog();
            }
        });
        this.jLabel2.setText("Isotope");
        this.field_isotope.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.field_derivatization.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.jLabel3.setText("Derivatization");
        this.jLabel4.setText("# H ions");
        this.button_ok.setText("OK");
        this.button_cancel.setText("Cancel");
        this.jLabel5.setText("# Na ions");
        this.jLabel7.setText("# Li ions");
        this.jLabel8.setText("# K ions");
        this.jLabelCLNo.setText("# Cl ions");
        this.jLabelH2PO4No.setText("# H2PO4 ions");
        this.jLabel6.setText("ex. Na ions");
        this.jLabel9.setText("ex. Li ions");
        this.jLabel10.setText("ex. K ions");
        this.jLabelCLExtNo.setText("ex. Cl ions");
        this.jLabelH2PO4ExtNo.setText("ex. H2PO4 ions");
        this.jLabel11.setText("Negative mode");
        this.field_negative_mode.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.field_negative_mode.setMargin(new Insets(0, 0, 0, 0));
        this.jLabel12.setText("Reducing end");
        this.field_reducingend.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.jLabel1.setText("name");
        this.field_other_name.setText("jTextField1");
        this.jLabel13.setText("mass");
        this.field_other_mass.setText("jTextField1");
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(1).add(2, (GroupLayout.Group)layout.createSequentialGroup().add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.jLabel3).add((Component)this.jLabel2).add((Component)this.jLabel12)).add(21, 21, 21).add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((GroupLayout.Group)layout.createParallelGroup(1, false).add((Component)this.jLabel1, -1, -1, Short.MAX_VALUE).add((Component)this.field_reducingend, 0, 80, Short.MAX_VALUE).add((Component)this.jLabel13, -1, -1, Short.MAX_VALUE)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(2).add((Component)this.field_other_mass, -1, 160, Short.MAX_VALUE).add(1, (Component)this.field_other_name, -1, 160, Short.MAX_VALUE))).add((GroupLayout.Group)layout.createSequentialGroup().add((GroupLayout.Group)layout.createParallelGroup(2, false).add(1, (Component)this.field_isotope, 0, -1, Short.MAX_VALUE).add(1, (Component)this.field_derivatization, 0, 80, Short.MAX_VALUE)).addPreferredGap(0, 172, Short.MAX_VALUE)))).add(2, (Component)this.jSeparator1, -1, 361, Short.MAX_VALUE).add(2, (Component)this.jSeparator4, -1, 361, Short.MAX_VALUE).add((GroupLayout.Group)layout.createSequentialGroup().add(107, 107, 107).add((Component)this.button_ok).addPreferredGap(0).add((Component)this.button_cancel)).add((GroupLayout.Group)layout.createSequentialGroup().add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.jLabel11).add((Component)this.jLabel8).add((Component)this.jLabelCLNo).add((Component)this.jLabelH2PO4No).add((Component)this.jLabel7).add((Component)this.jLabel5).add((Component)this.jLabel4)).add(16, 16, 16).add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.field_no_na_ions, -1, 80, Short.MAX_VALUE).add((Component)this.field_no_h_ions, -1, 80, Short.MAX_VALUE).add((Component)this.field_no_li_ions, -1, 80, Short.MAX_VALUE).add((Component)this.field_no_k_ions, -1, 80, Short.MAX_VALUE).add((Component)this.field_no_cl_ions, -1, 80, Short.MAX_VALUE).add((Component)this.field_no_h2po4_ions, -1, 80, Short.MAX_VALUE)).add(12, 12, 12)).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.field_negative_mode).add(79, 79, 79))).add((GroupLayout.Group)layout.createParallelGroup(1).add(2, (GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jLabel10).addPreferredGap(0, 19, Short.MAX_VALUE).add((Component)this.field_ex_k_ions, -2, 80, -2)).add(2, (GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jLabelCLExtNo).addPreferredGap(0, 19, Short.MAX_VALUE).add((Component)this.field_ex_cl_ions, -2, 80, -2)).add(2, (GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jLabelH2PO4ExtNo).addPreferredGap(0, 19, Short.MAX_VALUE).add((Component)this.field_ex_h2po4_ions, -2, 80, -2)).add(2, (GroupLayout.Group)layout.createSequentialGroup().add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.jLabel6).add((Component)this.jLabel9)).addPreferredGap(0, -1, Short.MAX_VALUE).add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.field_ex_na_ions, -1, 80, Short.MAX_VALUE).add(2, (Component)this.field_ex_li_ions, -2, 80, -2))))).add(2, (Component)this.jSeparator3, -1, 361, Short.MAX_VALUE)).addContainerGap()));
        layout.linkSize(new Component[]{this.button_cancel, this.button_ok}, 1);
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.field_isotope, -2, -1, -2).add((Component)this.jLabel2)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.field_derivatization, -2, -1, -2).add((Component)this.jLabel3)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jLabel12).add((Component)this.field_reducingend, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jLabel1).add((Component)this.field_other_name, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jLabel13).add((Component)this.field_other_mass, -2, -1, -2)).addPreferredGap(0).add((Component)this.jSeparator1, -2, 10, -2).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jLabel11).add((Component)this.field_negative_mode)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jLabel4).add((Component)this.field_no_h_ions, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add(30, 30, 30).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jLabel7).add((Component)this.field_ex_li_ions, -2, -1, -2).add((Component)this.field_no_li_ions, -2, -1, -2).add((Component)this.jLabel9))).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jLabel5).add((Component)this.field_ex_na_ions, -2, -1, -2).add((Component)this.field_no_na_ions, -2, -1, -2).add((Component)this.jLabel6))).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jLabel8).add((Component)this.field_ex_k_ions, -2, -1, -2)).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.field_no_k_ions, -2, -1, -2).add((Component)this.jLabel10))).addPreferredGap(0).add((Component)this.jSeparator4, -2, 10, -2).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jLabelCLExtNo).add((Component)this.field_ex_cl_ions, -2, -1, -2)).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.field_no_cl_ions, -2, -1, -2).add((Component)this.jLabelCLNo))).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jLabelH2PO4ExtNo).add((Component)this.field_ex_h2po4_ions, -2, -1, -2)).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.field_no_h2po4_ions, -2, -1, -2).add((Component)this.jLabelH2PO4No))).addPreferredGap(0).add((Component)this.jSeparator3, -2, 10, -2).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.button_ok).add((Component)this.button_cancel)).addContainerGap()));
        this.pack();
    }

    private void closeDialog() {
        this.setVisible(false);
        this.dispose();
    }
}

