/*
 * Decompiled with CFR 0.152.
 */
package org.eurocarbdb.application.glycanbuilder;

import java.awt.Rectangle;
import java.util.Collections;
import java.util.Iterator;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eurocarbdb.application.glycanbuilder.BBoxManager;
import org.eurocarbdb.application.glycanbuilder.Bond;
import org.eurocarbdb.application.glycanbuilder.CrossRingFragmentDictionary;
import org.eurocarbdb.application.glycanbuilder.Glycan;
import org.eurocarbdb.application.glycanbuilder.GlycanParser;
import org.eurocarbdb.application.glycanbuilder.Linkage;
import org.eurocarbdb.application.glycanbuilder.MassOptions;
import org.eurocarbdb.application.glycanbuilder.ResAngle;
import org.eurocarbdb.application.glycanbuilder.Residue;
import org.eurocarbdb.application.glycanbuilder.ResidueDictionary;
import org.eurocarbdb.application.glycanbuilder.ResidueHolder;
import org.eurocarbdb.application.glycanbuilder.ResiduePlacement;
import org.eurocarbdb.application.glycanbuilder.TextUtils;

public class GWSParser
implements GlycanParser {
    private static Pattern residue_pattern;
    private static Pattern link_pattern;

    public void setTolerateUnknown(boolean f) {
    }

    public String writeGlycan(Glycan structure) {
        return GWSParser.toString(structure, false, true);
    }

    public String writeGlycan(Glycan structure, BBoxManager bboxManager) {
        return GWSParser.toString(structure, false, true, bboxManager);
    }

    public String writeGlycanOrdered(Glycan structure) {
        return GWSParser.toString(structure, true, true);
    }

    public Glycan readGlycan(String str, MassOptions default_mass_options) throws Exception {
        return GWSParser.fromString(str, default_mass_options);
    }

    public static String toString(Glycan structure) {
        return GWSParser.toString(structure, null);
    }

    public static String toString(Glycan structure, BBoxManager bboxManager) {
        return GWSParser.toString(structure, false, true, bboxManager);
    }

    public static String toString(Glycan structure, boolean ordered) {
        return GWSParser.toString(structure, ordered, null);
    }

    public static String toString(Glycan structure, boolean ordered, BBoxManager bboxManager) {
        return GWSParser.toString(structure, ordered, true, bboxManager);
    }

    public static String toString(Glycan structure, boolean ordered, boolean add_massopt) {
        return GWSParser.toString(structure, ordered, add_massopt, null);
    }

    public static String toString(Glycan structure, boolean ordered, boolean add_massopt, BBoxManager bboxManager) {
        if (structure == null) {
            return "";
        }
        StringBuilder ss = new StringBuilder();
        if (structure.getRoot() != null) {
            ss.append(GWSParser.writeSubtree(structure.getRoot(), ordered, bboxManager));
            if (structure.getBracket() != null) {
                ss.append(GWSParser.writeSubtree(structure.getBracket(), ordered, bboxManager));
            }
            if (add_massopt) {
                ss.append("$");
                ss.append(structure.getMassOptions().toString());
            }
        }
        return ss.toString();
    }

    public static Glycan fromString(String str, MassOptions default_mass_options) throws Exception {
        str = TextUtils.trim(str);
        MassOptions mass_opt = default_mass_options.clone();
        int ind1 = str.indexOf(36);
        if (ind1 != -1) {
            mass_opt = MassOptions.fromString(str.substring(ind1 + 1));
            str = str.substring(0, ind1);
        }
        Glycan ret = null;
        int ind2 = str.indexOf(125);
        ret = ind2 == -1 ? new Glycan(GWSParser.readSubtree(str, true), false, mass_opt) : new Glycan(GWSParser.readSubtree(str.substring(0, ind2), true), GWSParser.readSubtree(str.substring(ind2), true), false, mass_opt);
        return ret;
    }

    public static String writeResidueType(Residue r) {
        String str = "";
        if (r.isBracket()) {
            str = str + '}';
        } else if (r.isStartRepetition()) {
            str = str + '[';
        } else if (r.isEndRepetition()) {
            str = str + ']';
            if (r.getType().getMinRepetitions() >= 0) {
                str = str + "_" + r.getType().getMinRepetitions();
            }
            if (r.getType().getMaxRepetitions() >= 0) {
                str = str + "^" + r.getType().getMaxRepetitions();
            }
        } else if (r.isCleavage()) {
            Residue cleaved_residue = r.getCleavedResidue();
            str = str + GWSParser.writeResidueType(cleaved_residue) + "/" + r.getTypeName();
        } else {
            if (r.hasAnomericState() || r.hasAnomericCarbon()) {
                str = str + r.getAnomericState() + "" + r.getAnomericCarbon();
            }
            if (r.hasChirality()) {
                str = str + r.getChirality() + "-";
            }
            str = str + r.getTypeName();
            if (r.hasRingSize()) {
                str = str + "," + r.getRingSize();
            }
        }
        return str;
    }

    public static String writeSubtree(Residue r, boolean ordered) {
        return GWSParser.writeSubtree(r, ordered, null);
    }

    public static String writeSubtree(Residue r, boolean ordered, BBoxManager bboxManager) {
        String str = GWSParser.writeResidueType(r);
        if (r.getCleavedResidue() != null) {
            Residue cleaved_residue = r.getCleavedResidue();
            if (cleaved_residue.hasPreferredPlacement()) {
                str = str + "@" + GWSParser.placementToString(cleaved_residue.getPreferredPlacement());
            }
        } else if (r.hasPreferredPlacement()) {
            str = str + "@" + GWSParser.placementToString(r.getPreferredPlacement());
        }
        if (bboxManager != null && bboxManager.border_bboxes.containsKey(r)) {
            Rectangle rec = bboxManager.border_bboxes.get(r);
            str = str + "<bounding_box>" + rec.x + "," + rec.y + "," + rec.width + "," + rec.height + "</bounding_box>";
        }
        Vector<String> str_children = new Vector<String>();
        for (Linkage l : r.getChildrenLinkages()) {
            str_children.add(GWSParser.writeSubtree(l, ordered, bboxManager));
        }
        if (ordered) {
            Collections.sort(str_children);
        }
        for (int i = 0; i < r.getChildrenLinkages().size() - 1; ++i) {
            str = str + "(";
        }
        Iterator i = str_children.iterator();
        while (i.hasNext()) {
            str = str + (String)i.next();
            if (!i.hasNext()) continue;
            str = str + ")";
        }
        return str;
    }

    public static String writeSubtree(Linkage l, boolean ordered) {
        return GWSParser.writeSubtree(l, ordered, null);
    }

    public static String writeSubtree(Linkage l, boolean ordered, BBoxManager bboxManager) {
        return "--" + GWSParser.toStringLinkage(l) + GWSParser.writeSubtree(l.getChildResidue(), ordered, bboxManager);
    }

    public static String toStringLinkage(Linkage link) {
        StringBuilder sb = new StringBuilder();
        Iterator<Bond> i = link.getBonds().iterator();
        while (i.hasNext()) {
            Bond b = i.next();
            if (sb.length() > 0) {
                sb.append(',');
            }
            char[] p_poss = b.getParentPositions();
            for (int l = 0; l < p_poss.length; ++l) {
                if (l > 0) {
                    sb.append('/');
                }
                sb.append(p_poss[l]);
            }
            if (!i.hasNext()) continue;
            sb.append('=');
            sb.append(b.getChildPosition());
        }
        return sb.toString();
    }

    public static Residue readSubtree(String str, boolean accept_empty) throws Exception {
        return GWSParser.readSubtree(str, accept_empty, new ResidueHolder());
    }

    public static Residue readSubtree(String str, boolean accept_empty, ResidueHolder startRep) throws Exception {
        int nopars;
        if (str.length() == 0) {
            if (accept_empty) {
                return null;
            }
            throw new Exception("Empty node");
        }
        Residue ret = null;
        if (str.charAt(0) == '}') {
            ret = ResidueDictionary.createBracket();
            str = str.substring(1);
        } else {
            Matcher m = residue_pattern.matcher(str);
            if (!m.lookingAt()) {
                throw new Exception("Invalid format for string: " + str);
            }
            if (str.charAt(0) == '[') {
                startRep.res = ret = ResidueDictionary.createStartRepetition();
            } else if (str.charAt(0) == ']') {
                ret = ResidueDictionary.createEndRepetition(m.group(1), m.group(2));
                startRep.res.setEndRepitionResidue(ret);
                startRep.res = null;
            } else {
                char ret_anom_state = '?';
                char ret_anom_carbon = '?';
                char ret_chirality = '?';
                if (m.group(3) != null) {
                    ret_anom_state = m.group(3).charAt(0);
                    ret_anom_carbon = m.group(3).charAt(1);
                }
                if (m.group(4) != null) {
                    ret_chirality = m.group(4).charAt(0);
                }
                String typename = m.group(5);
                char ret_ring_size = '?';
                if (m.group(6) != null) {
                    ret_ring_size = m.group(6).charAt(0);
                }
                ret = ResidueDictionary.newResidue(typename);
                ret.setAnomericState(ret_anom_state);
                ret.setAnomericCarbon(ret_anom_carbon);
                ret.setChirality(ret_chirality);
                ret.setRingSize(ret_ring_size);
                String cleavage_typename = m.group(7);
                if (cleavage_typename != null) {
                    Residue cleavage = null;
                    cleavage = cleavage_typename.indexOf(95) != -1 ? CrossRingFragmentDictionary.newFragment(cleavage_typename, ret) : ResidueDictionary.newResidue(cleavage_typename);
                    cleavage.setCleavedResidue(ret);
                    ret = cleavage;
                }
            }
            if (m.group(8) != null) {
                ResiduePlacement pref_place = GWSParser.placementFromString(m.group(8));
                if (ret.getCleavedResidue() != null) {
                    ret.getCleavedResidue().setPreferredPlacement(pref_place);
                } else {
                    ret.setPreferredPlacement(pref_place);
                }
            }
            if (m.group(9) != null && m.group(10) != null && m.group(11) != null && m.group(12) != null) {
                ret.setCenterPosition(new Rectangle(Integer.parseInt(m.group(9)), Integer.parseInt(m.group(10)), Integer.parseInt(m.group(11)), Integer.parseInt(m.group(12))));
            }
            str = str.substring(m.end());
        }
        for (nopars = 0; nopars < str.length() && str.charAt(nopars) == '('; ++nopars) {
        }
        str = str.substring(nopars);
        while (str.length() > 0) {
            Linkage child_link = null;
            if (nopars > 0) {
                int ind = TextUtils.findClosedParenthesis(str);
                if (ind == -1) {
                    throw new Exception("Invalid string format: " + str);
                }
                child_link = GWSParser.readSubtreeLinkage(str.substring(0, ind), startRep);
                str = str.substring(ind + 1);
                --nopars;
            } else {
                child_link = GWSParser.readSubtreeLinkage(str, startRep);
                str = "";
            }
            child_link.setParentResidue(ret);
            ret.getChildrenLinkages().add(child_link);
        }
        return ret;
    }

    public static Linkage readSubtreeLinkage(String str, ResidueHolder startRep) throws Exception {
        Matcher m = link_pattern.matcher(str);
        if (!m.lookingAt()) {
            throw new Exception("invalid format for linkage: " + str);
        }
        if (m.group(1) != null) {
            Residue child = GWSParser.readSubtree(str.substring(m.end()), false, startRep);
            return new Linkage(null, child, m.group(1).charAt(0));
        }
        Vector<Bond> ret_bonds = new Vector<Bond>();
        for (int i = 2; i <= m.groupCount(); ++i) {
            String str_bond = m.group(i);
            if (i < m.groupCount()) {
                if (str_bond == null || str_bond.length() <= 0) continue;
                String[] fields = str_bond.split("=");
                char[] p_poss = GWSParser.parsePositions(fields[0]);
                char c_pos = fields[1].charAt(0);
                ret_bonds.add(new Bond(p_poss, c_pos));
                continue;
            }
            char[] p_poss = GWSParser.parsePositions(str_bond);
            ret_bonds.add(new Bond(p_poss, '?'));
        }
        Residue child = GWSParser.readSubtree(str.substring(m.end()), false, startRep);
        Linkage ret = new Linkage(null, child);
        ret.setBonds(ret_bonds);
        ret.getChildResidue().setParentLinkage(ret);
        return ret;
    }

    private static char[] parsePositions(String str) throws Exception {
        int c = 0;
        char[] ret = new char[(str.length() + 1) / 2];
        for (int i = 0; i < str.length(); i += 2) {
            if (i > 0 && str.charAt(i - 1) != '/') {
                throw new Exception("Invalid positions string: " + str);
            }
            ret[c++] = str.charAt(i);
        }
        return ret;
    }

    private static String placementToString(ResiduePlacement rp) {
        if (rp == null) {
            return "";
        }
        String str = "" + (rp.getPositions()[0].getIntAngle() + 360);
        if (rp.isSticky()) {
            str = str + 's';
        }
        return str;
    }

    private static ResiduePlacement placementFromString(String str) throws Exception {
        if (str.length() == 0) {
            return null;
        }
        boolean _sticky = false;
        if (str.charAt(str.length() - 1) == 's') {
            _sticky = true;
            str = str.substring(0, str.length() - 1);
        }
        return new ResiduePlacement(new ResAngle(Integer.parseInt(str)), false, _sticky);
    }

    static {
        String link_old_pattern_str = "-([1-9N\\?])";
        String link_pattern_str = "--(?:((?:[1-9N\\?]/)*[1-9N\\?]=[1-9N\\?]),)*((?:[1-9N\\?]/)*[1-9N\\?])";
        link_pattern = Pattern.compile("(?:" + link_old_pattern_str + ")|(?:" + link_pattern_str + ")");
        String start_repeat_str = "\\[";
        String end_repeat_str = "\\](?:\\_([0-9]+))?+(?:\\^([0-9]+))?+";
        String residue_str = "([abo\\?][1-9N\\?])?+([DL]-)?+([a-zA-z0-9_#=\\.]+)(?:,([\\?opf]))?+";
        String cleaved_str = "/([a-zA-z0-9_#]+)";
        String place_str = "@(-?[0-9]+s?)";
        String cord_str = "<bounding_box>([0-9]+),([0-9]+),([0-9]+),([0-9]+)</bounding_box>";
        residue_pattern = Pattern.compile("(?:" + start_repeat_str + ")|(?:" + end_repeat_str + ")|" + "(?:" + residue_str + "(?:" + cleaved_str + ")?+)" + "(?:" + place_str + ")?+" + "(?:" + cord_str + ")?");
    }
}

