/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.visualization.xygraph.linearscale;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.FigureUtilities;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.nebula.visualization.xygraph.linearscale.AbstractScale;
import org.eclipse.nebula.visualization.xygraph.linearscale.LinearScale;
import org.eclipse.nebula.visualization.xygraph.util.XYGraphMediaFactory;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.RGB;

public class LinearScaledMarker
extends Figure {
    private Map<String, MarkerProperties> markersMap = new LinkedHashMap<String, MarkerProperties>();
    private static final RGB DEFAULT_MARKER_COLOR = XYGraphMediaFactory.COLOR_RED;
    private String[] labels;
    private double[] markerValues;
    private Dimension[] markerLabelDimensions;
    private List<Color> markerColorsList = new ArrayList<Color>();
    private LinearScale scale;
    private AbstractScale.LabelSide markerLabelsPosition = AbstractScale.LabelSide.Secondary;
    private boolean markerLineVisible = false;
    private boolean markerLabelVisible = true;
    private int tickLabelMaxLength;
    private boolean dirty = true;
    private int[] markerPositions;
    private static final int TICK_LENGTH = 10;
    private static final int TICK_LINE_WIDTH = 2;
    private static final int GAP_BTW_MARK_LABEL = 3;

    public LinearScaledMarker(LinearScale scale) {
        this.scale = scale;
        this.setFont(XYGraphMediaFactory.getInstance().getFont(XYGraphMediaFactory.FONT_TAHOMA));
    }

    public void setDirty(boolean dirty) {
        this.dirty = dirty;
    }

    public void setMarkerElementValue(String label, double value) {
        if (this.markersMap.containsKey(label)) {
            this.markersMap.get(label).value = value;
            this.dirty = true;
        }
    }

    public void setMarkerElementColor(String label, RGB color) {
        if (this.markersMap.containsKey(label)) {
            this.markersMap.get(label).color = color;
            this.dirty = true;
        }
    }

    public void addMarkerElement(String label, double value, RGB color) {
        if (this.markersMap.containsKey(label)) {
            this.markersMap.get(label).value = value;
            this.markersMap.get(label).color = color;
        } else {
            this.markersMap.put(label, new MarkerProperties(value, color));
        }
        this.dirty = true;
    }

    public void addMarkerElement(String label, double value) {
        if (this.markersMap.containsKey(label)) {
            this.markersMap.get(label).value = value;
        } else {
            this.markersMap.put(label, new MarkerProperties(value, DEFAULT_MARKER_COLOR));
        }
        this.dirty = true;
    }

    public void removeMarkerElement(String label) {
        this.markersMap.remove(label);
        this.dirty = true;
    }

    protected void paintClientArea(Graphics graphics) {
        graphics.translate(this.bounds.x, this.bounds.y);
        this.updateTick();
        this.drawMarkerTick(graphics);
        super.paintClientArea(graphics);
    }

    private void drawMarkerTick(Graphics graphics) {
        graphics.setLineWidth(2);
        if (this.scale.isHorizontal()) {
            if (this.markerLabelsPosition == AbstractScale.LabelSide.Primary) {
                int i = 0;
                int[] nArray = this.markerPositions;
                int n = this.markerPositions.length;
                int n2 = 0;
                while (n2 < n) {
                    int markerPos = nArray[n2];
                    graphics.setForegroundColor(this.markerColorsList.get(i));
                    graphics.drawLine(markerPos, 0, markerPos, 10);
                    if (this.isMarkerLabelVisible()) {
                        graphics.drawText(this.labels[i], markerPos - this.markerLabelDimensions[i].width / 2, 13);
                    }
                    ++i;
                    ++n2;
                }
            } else {
                int i = 0;
                int[] nArray = this.markerPositions;
                int n = this.markerPositions.length;
                int n3 = 0;
                while (n3 < n) {
                    int markerPos = nArray[n3];
                    graphics.setForegroundColor(this.markerColorsList.get(i));
                    graphics.drawLine(markerPos, this.bounds.height, markerPos, this.bounds.height - 10);
                    if (this.isMarkerLabelVisible()) {
                        graphics.drawText(this.labels[i], markerPos - this.markerLabelDimensions[i].width / 2, this.bounds.height - 10 - 3 - this.markerLabelDimensions[i].height);
                    }
                    ++i;
                    ++n3;
                }
            }
        } else if (this.markerLabelsPosition == AbstractScale.LabelSide.Primary) {
            int i = 0;
            while (i < this.markerPositions.length) {
                graphics.setForegroundColor(this.markerColorsList.get(i));
                graphics.drawLine(this.bounds.width, this.markerPositions[i], this.bounds.width - 10, this.markerPositions[i]);
                if (this.isMarkerLabelVisible()) {
                    graphics.drawText(this.labels[i], this.bounds.width - 10 - 3 - this.markerLabelDimensions[i].width, this.markerPositions[i] - this.markerLabelDimensions[i].height / 2);
                }
                ++i;
            }
        } else {
            int i = 0;
            int[] nArray = this.markerPositions;
            int n = this.markerPositions.length;
            int n4 = 0;
            while (n4 < n) {
                int markerPos = nArray[n4];
                graphics.setForegroundColor(this.markerColorsList.get(i));
                graphics.drawLine(0, markerPos, 10, markerPos);
                if (this.isMarkerLabelVisible()) {
                    graphics.drawText(this.labels[i], 13, markerPos - this.markerLabelDimensions[i].height / 2);
                }
                ++i;
                ++n4;
            }
        }
    }

    public void setBounds(Rectangle rect) {
        if (!this.bounds.equals((Object)rect)) {
            this.dirty = true;
        }
        super.setBounds(rect);
    }

    public void updateTick() {
        if (this.dirty) {
            this.updateMarkerElements();
            this.updateTickLabelMaxLength();
        }
        this.dirty = false;
    }

    private void updateTickLabelMaxLength() {
        int maxLength = 0;
        int i = 0;
        while (i < this.labels.length) {
            Dimension p = FigureUtilities.getTextExtents((String)this.labels[i], (Font)this.scale.getFont());
            if (p.width > maxLength) {
                maxLength = p.width;
            }
            ++i;
        }
        this.tickLabelMaxLength = maxLength;
    }

    public String[] getLabels() {
        String[] labels = new String[this.markersMap.size()];
        int i = 0;
        Iterator<String> iterator = this.markersMap.keySet().iterator();
        while (iterator.hasNext()) {
            String label;
            labels[i] = label = iterator.next();
            ++i;
        }
        return labels;
    }

    @Deprecated
    public void updateMarkerElments() {
        this.updateMarkerElements();
    }

    public void updateMarkerElements() {
        this.labels = new String[this.markersMap.size()];
        this.markerColorsList.clear();
        this.markerValues = new double[this.markersMap.size()];
        this.markerLabelDimensions = new Dimension[this.markersMap.size()];
        this.markerPositions = new int[this.markerValues.length];
        int i = 0;
        Iterator<String> iterator = this.markersMap.keySet().iterator();
        while (iterator.hasNext()) {
            String label;
            this.labels[i] = label = iterator.next();
            this.markerValues[i] = this.markersMap.get(label).value;
            this.markerPositions[i] = this.scale.getValuePosition(this.markerValues[i], true);
            this.markerLabelDimensions[i] = FigureUtilities.getTextExtents((String)label, (Font)this.getFont());
            this.markerColorsList.add(XYGraphMediaFactory.getInstance().getColor(this.markersMap.get(label).color));
            ++i;
        }
    }

    public void setScale(LinearScale scale) {
        this.scale = scale;
        this.dirty = true;
    }

    public LinearScale getScale() {
        return this.scale;
    }

    public void setLabelSide(AbstractScale.LabelSide labelSide) {
        this.markerLabelsPosition = labelSide;
        this.dirty = true;
    }

    public AbstractScale.LabelSide getMakerLabelsPosition() {
        return this.markerLabelsPosition;
    }

    @Deprecated
    public AbstractScale.LabelSide getMakerLablesPosition() {
        return this.getMakerLabelsPosition();
    }

    public void setMarkerLineVisible(boolean markerLineVisible) {
        this.markerLineVisible = markerLineVisible;
        this.dirty = true;
    }

    public boolean isMarkerLineVisible() {
        return this.markerLineVisible;
    }

    public void setMarkerLabelVisible(boolean markerLabelVisible) {
        this.markerLabelVisible = markerLabelVisible;
        this.dirty = true;
    }

    @Deprecated
    public void setMarkerLableVisible(boolean markerLabelVisible) {
        this.setMarkerLabelVisible(markerLabelVisible);
    }

    public boolean isMarkerLabelVisible() {
        return this.markerLabelVisible;
    }

    @Deprecated
    public boolean isMarkerLableVisible() {
        return this.isMarkerLabelVisible();
    }

    public Dimension getPreferredSize(int wHint, int hHint) {
        this.updateTick();
        Dimension size = new Dimension(wHint, hHint);
        if (this.scale.isHorizontal()) {
            size.width = this.scale.getSize().width;
            size.height = FigureUtilities.getTextExtents((String)"dummy", (Font)this.getFont()).height + 3 + 10;
        } else {
            this.updateTickLabelMaxLength();
            size.width = this.tickLabelMaxLength + 3 + 10;
            size.height = this.scale.getSize().height;
        }
        return size;
    }

    private static class MarkerProperties {
        private double value;
        private RGB color;

        public MarkerProperties(double value, RGB color) {
            this.value = value;
            this.color = color;
        }
    }
}

