/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.entry.sample.utilities;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.grits.toolbox.entry.sample.model.Category;
import org.grits.toolbox.entry.sample.model.CategoryTemplate;
import org.grits.toolbox.entry.sample.model.Component;
import org.grits.toolbox.entry.sample.model.Descriptor;
import org.grits.toolbox.entry.sample.model.DescriptorGroup;
import org.grits.toolbox.entry.sample.model.Template;
import org.grits.toolbox.entry.sample.utilities.AnalyteFactory;
import org.grits.toolbox.entry.sample.utilities.UtilityMatcher;

public class UtilityTemplate {
    public static Template createTemplateFromComponent(Component component) {
        Template template = new Template();
        template.setLabel("Untitled");
        CategoryTemplate sampleInformationTemplate = new CategoryTemplate("http://www.grits-toolbox.org/ontology/sample#category_sample");
        sampleInformationTemplate.setMandatoryDescriptors(UtilityTemplate.getDescriptorsFromCategory(component.getSampleInformation()));
        sampleInformationTemplate.setMandatoryDescriptorGroups(UtilityTemplate.getDescriptorGroupsFromCategory(component.getSampleInformation()));
        template.setSampleInformationTemplate(sampleInformationTemplate);
        CategoryTemplate trackingTemplate = new CategoryTemplate("http://www.grits-toolbox.org/ontology/sample#category_sample_tracking");
        trackingTemplate.setMandatoryDescriptors(UtilityTemplate.getDescriptorsFromCategory(component.getTracking()));
        trackingTemplate.setMandatoryDescriptorGroups(UtilityTemplate.getDescriptorGroupsFromCategory(component.getTracking()));
        template.setTrackingTemplate(trackingTemplate);
        CategoryTemplate amountTemplate = new CategoryTemplate("http://www.grits-toolbox.org/ontology/sample#category_amount");
        amountTemplate.setMandatoryDescriptors(UtilityTemplate.getDescriptorsFromCategory(component.getAmount()));
        amountTemplate.setMandatoryDescriptorGroups(UtilityTemplate.getDescriptorGroupsFromCategory(component.getAmount()));
        template.setAmountTemplate(amountTemplate);
        CategoryTemplate purityQCTemplate = new CategoryTemplate("http://www.grits-toolbox.org/ontology/sample#category_qc");
        purityQCTemplate.setMandatoryDescriptors(UtilityTemplate.getDescriptorsFromCategory(component.getPurityQC()));
        purityQCTemplate.setMandatoryDescriptorGroups(UtilityTemplate.getDescriptorGroupsFromCategory(component.getPurityQC()));
        template.setPurityQCTemplate(purityQCTemplate);
        return template;
    }

    public static Set<String> getMatchingTemplateUris(Component component, List<Template> allTemplates) {
        HashSet<String> matchingTemplateURIs = new HashSet<String>();
        for (Template template : allTemplates) {
            if (!UtilityTemplate.isMatching(component, template)) continue;
            matchingTemplateURIs.add(template.getUri());
        }
        return matchingTemplateURIs;
    }

    public static boolean isMatching(Component component, Template template) {
        return UtilityMatcher.match(component.getSampleInformation(), template.getSampleInformationTemplate()) == null && UtilityMatcher.match(component.getTracking(), template.getTrackingTemplate()) == null && UtilityMatcher.match(component.getAmount(), template.getAmountTemplate()) == null && UtilityMatcher.match(component.getPurityQC(), template.getPurityQCTemplate()) == null;
    }

    public static Component createComponentFromTemplate(Template template) {
        return AnalyteFactory.createComponentFromTemplate(template);
    }

    private static List<Descriptor> getDescriptorsFromCategory(Category category) {
        ArrayList<Descriptor> descriptors = new ArrayList<Descriptor>();
        for (Descriptor descriptor : category.getDescriptors()) {
            descriptors.add(descriptor.getACopy());
        }
        return descriptors;
    }

    private static List<DescriptorGroup> getDescriptorGroupsFromCategory(Category category) {
        ArrayList<DescriptorGroup> descriptorGroups = new ArrayList<DescriptorGroup>();
        for (DescriptorGroup descriptor : category.getDescriptorGroups()) {
            descriptorGroups.add(descriptor.getACopy());
        }
        return descriptorGroups;
    }

    public static CategoryTemplate getCategoryTemplate(Template template, String categoryUri) {
        CategoryTemplate categoryTemplate = null;
        switch (categoryUri) {
            case "http://www.grits-toolbox.org/ontology/sample#category_sample": {
                categoryTemplate = template.getSampleInformationTemplate();
                break;
            }
            case "http://www.grits-toolbox.org/ontology/sample#category_sample_tracking": {
                categoryTemplate = template.getTrackingTemplate();
                break;
            }
            case "http://www.grits-toolbox.org/ontology/sample#category_amount": {
                categoryTemplate = template.getAmountTemplate();
                break;
            }
            case "http://www.grits-toolbox.org/ontology/sample#category_qc": {
                categoryTemplate = template.getPurityQCTemplate();
                break;
            }
        }
        return categoryTemplate;
    }
}

