/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.entry.sample.utilities;

import com.hp.hpl.jena.ontology.OntModel;
import com.hp.hpl.jena.ontology.OntModelSpec;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.Files;
import java.util.Arrays;
import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.FileLocator;
import org.grits.toolbox.core.dataShare.PropertyHandler;
import org.grits.toolbox.entry.sample.config.Config;

public class UtilityOntologyLocation {
    private static Logger logger = Logger.getLogger(UtilityOntologyLocation.class);
    static final String BASE_URI_WITHOUT_HASH = "http://www.grits-toolbox.org/ontology/sample#".substring(0, "http://www.grits-toolbox.org/ontology/sample#".length() - 1);

    public static String getStandardOntologyLocation() throws Exception {
        try {
            String configFolderLocation = PropertyHandler.getVariable((String)"configuration_location");
            File configFolder = new File(configFolderLocation);
            if (configFolder.isDirectory()) {
                List<String> childFiles = Arrays.asList(configFolder.list());
                String sampleSubFolderName = String.valueOf(configFolderLocation) + File.separator + "org.grits.toolbox.entry.sample";
                File sampleSubFolder = new File(sampleSubFolderName);
                boolean subFolderExists = sampleSubFolder.exists();
                if (!subFolderExists && !childFiles.contains(sampleSubFolderName)) {
                    subFolderExists = sampleSubFolder.mkdir();
                }
                if (subFolderExists) {
                    String configOntologyLocation = String.valueOf(sampleSubFolder.getAbsolutePath()) + File.separator + "Standard_Sample_Ontology.owl";
                    childFiles = Arrays.asList(sampleSubFolder.list());
                    URL resourceFileUrl = FileLocator.toFileURL((URL)Config.ONTOLOGY_RESOURCE_URL);
                    String originalJarFilePath = String.valueOf(resourceFileUrl.getPath()) + "Standard_Sample_Ontology.owl";
                    File originalJarFile = new File(originalJarFilePath);
                    boolean toBeCopied = false;
                    if (childFiles.contains("Standard_Sample_Ontology.owl")) {
                        FileInputStream existingInputOntology = new FileInputStream(configOntologyLocation);
                        OntModel existingOntologyModel = ModelFactory.createOntologyModel((OntModelSpec)OntModelSpec.OWL_DL_MEM_RDFS_INF, null);
                        existingOntologyModel.read((InputStream)existingInputOntology, "http://www.grits-toolbox.org/ontology/sample#");
                        String existingVersionInfo = existingOntologyModel.getOntology(BASE_URI_WITHOUT_HASH).getVersionInfo();
                        FileInputStream originalJarInputOntology = new FileInputStream(originalJarFile);
                        OntModel originalJarOntologyModel = ModelFactory.createOntologyModel((OntModelSpec)OntModelSpec.OWL_DL_MEM_RDFS_INF, null);
                        originalJarOntologyModel.read((InputStream)originalJarInputOntology, "http://www.grits-toolbox.org/ontology/sample#");
                        String newVersionInfo = originalJarOntologyModel.getOntology(BASE_URI_WITHOUT_HASH).getVersionInfo();
                        toBeCopied = !existingVersionInfo.equals(newVersionInfo);
                    } else {
                        toBeCopied = true;
                    }
                    if (toBeCopied) {
                        FileOutputStream configFile = new FileOutputStream(configOntologyLocation);
                        Files.copy(originalJarFile.toPath(), configFile);
                        configFile.close();
                    }
                    return configOntologyLocation;
                }
                throw new Exception("Error locating subfolder for the ontology. Please check at this location : " + sampleSubFolderName);
            }
        }
        catch (Exception ex) {
            logger.error((Object)ex);
            throw ex;
        }
        return null;
    }

    public static String getLocalOntologyLocation() throws Exception {
        String configFolderLocation = PropertyHandler.getVariable((String)"configuration_location");
        File configFolder = new File(configFolderLocation);
        if (configFolder.isDirectory()) {
            List<String> childFiles = Arrays.asList(configFolder.list());
            String sampleSubFolderName = String.valueOf(configFolderLocation) + File.separator + "org.grits.toolbox.entry.sample";
            File sampleSubFolder = new File(sampleSubFolderName);
            boolean subFolderExists = sampleSubFolder.exists();
            if (!subFolderExists && !childFiles.contains(sampleSubFolderName)) {
                subFolderExists = sampleSubFolder.mkdir();
            }
            if (subFolderExists) {
                String configOntologyLocation = String.valueOf(sampleSubFolder.getAbsolutePath()) + File.separator + "Local_Sample_Ontology.owl";
                childFiles = Arrays.asList(sampleSubFolder.list());
                if (!childFiles.contains("Local_Sample_Ontology.owl")) {
                    URL resourceFileUrl = FileLocator.toFileURL((URL)Config.ONTOLOGY_RESOURCE_URL);
                    String originalJarFilePath = String.valueOf(resourceFileUrl.getPath()) + "Local_Sample_Ontology.owl";
                    File originalJarFile = new File(originalJarFilePath);
                    FileOutputStream configFile = new FileOutputStream(configOntologyLocation);
                    Files.copy(originalJarFile.toPath(), configFile);
                    configFile.close();
                }
                return configOntologyLocation;
            }
            throw new Exception("Error locating subfolder for the ontology. Please check at this location : " + sampleSubFolderName);
        }
        return null;
    }
}

