/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.entry.sample.part.action;

import javax.inject.Inject;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.grits.toolbox.entry.sample.config.ImageRegistry;
import org.grits.toolbox.entry.sample.dialog.AddDescriptorDialog;
import org.grits.toolbox.entry.sample.dialog.AddDescriptorGroupDialog;
import org.grits.toolbox.entry.sample.model.Descriptor;
import org.grits.toolbox.entry.sample.model.DescriptorGroup;
import org.grits.toolbox.entry.sample.part.action.AbstractTreeTableAction;

public class EditDescriptorDescriptorGroupAction
extends AbstractTreeTableAction {
    @Inject
    private IEclipseContext eclipseContext;

    @Override
    protected void setUp() {
        this.setToolTipText("Edit");
        this.setImageDescriptor(ImageRegistry.getImageDescriptor(ImageRegistry.SampleImage.EDIT_DESCRIPTOR_ICON));
    }

    public void run() {
        if (this.treeViewer != null) {
            if (!this.treeViewer.getSelection().isEmpty()) {
                Object firstSelectedItem = ((StructuredSelection)this.treeViewer.getSelection()).getFirstElement();
                if (firstSelectedItem instanceof Descriptor) {
                    AddDescriptorDialog descriptorDialog = new AddDescriptorDialog(Display.getCurrent().getActiveShell(), (Descriptor)firstSelectedItem);
                    if (descriptorDialog.open() == 0) {
                        this.treeViewer.refresh();
                        this.dirtyable.setDirty(true);
                    }
                } else if (firstSelectedItem instanceof DescriptorGroup) {
                    AddDescriptorGroupDialog descriptorGroupDialog = (AddDescriptorGroupDialog)((Object)ContextInjectionFactory.make(AddDescriptorGroupDialog.class, (IEclipseContext)this.eclipseContext));
                    descriptorGroupDialog.init((DescriptorGroup)firstSelectedItem);
                    if (descriptorGroupDialog.open() == 0) {
                        this.treeViewer.refresh();
                        this.dirtyable.setDirty(true);
                    }
                }
            } else {
                MessageDialog.openInformation((Shell)Display.getCurrent().getActiveShell(), (String)"No Descriptor / Descriptor Group selected", (String)"Please select a descriptor or descriptor group to edit.");
            }
        } else if (this.tableViewer != null) {
            if (!this.tableViewer.getSelection().isEmpty()) {
                AddDescriptorDialog descriptorDialog;
                Object firstSelectedItem = ((StructuredSelection)this.tableViewer.getSelection()).getFirstElement();
                if (firstSelectedItem instanceof Descriptor && (descriptorDialog = new AddDescriptorDialog(Display.getCurrent().getActiveShell(), (Descriptor)firstSelectedItem)).open() == 0) {
                    this.tableViewer.refresh();
                }
            } else {
                MessageDialog.openInformation((Shell)Display.getCurrent().getActiveShell(), (String)"No Descriptor selected", (String)"Please select a descriptor to edit.");
            }
        }
    }
}

