/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.entry.sample.handler;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import javax.inject.Inject;
import javax.inject.Named;
import javax.xml.bind.JAXBException;
import org.apache.log4j.Logger;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Shell;
import org.grits.toolbox.core.dataShare.PropertyHandler;
import org.grits.toolbox.core.datamodel.Entry;
import org.grits.toolbox.core.datamodel.io.ProjectFileHandler;
import org.grits.toolbox.core.datamodel.property.Property;
import org.grits.toolbox.core.datamodel.property.PropertyDataFile;
import org.grits.toolbox.core.service.IGritsDataModelService;
import org.grits.toolbox.core.service.IGritsUIService;
import org.grits.toolbox.core.utilShare.ErrorUtils;
import org.grits.toolbox.entry.sample.model.Sample;
import org.grits.toolbox.entry.sample.property.SampleProperty;
import org.grits.toolbox.entry.sample.utilities.UtilityFile;
import org.grits.toolbox.entry.sample.wizard.analyte.NewAnalyteWizard;

public class NewAnalyteHandler {
    private static final Logger logger = Logger.getLogger(NewAnalyteHandler.class);
    @Inject
    private static IGritsDataModelService gritsDataModelService = null;
    @Inject
    static IGritsUIService gritsUIService = null;

    @Execute
    public void execute(@Named(value="org.eclipse.ui.selection") Object object, IEventBroker eventBroker, @Named(value="activeShell") Shell shell) {
        logger.info((Object)"- START COMMAND : Create a new Analyte. ");
        try {
            Entry newEntry;
            Entry selectedEntry = null;
            if (object instanceof Entry) {
                selectedEntry = (Entry)object;
            } else if (object instanceof StructuredSelection && ((StructuredSelection)object).getFirstElement() instanceof Entry) {
                selectedEntry = (Entry)((StructuredSelection)object).getFirstElement();
            }
            if (selectedEntry == null && gritsDataModelService.getLastSelection() != null && gritsDataModelService.getLastSelection().getFirstElement() instanceof Entry) {
                selectedEntry = (Entry)gritsDataModelService.getLastSelection().getFirstElement();
            }
            if (!(selectedEntry == null || selectedEntry.getProperty() != null && "org.grits.toolbox.property.project".equals(selectedEntry.getProperty().getType()))) {
                selectedEntry = null;
            }
            if ((newEntry = this.createNewAnalyte(shell, selectedEntry)) != null) {
                eventBroker.post("grits_entry_selected", (Object)newEntry);
                gritsUIService.openEntryInPart(newEntry);
            }
        }
        catch (Exception ex) {
            logger.fatal((Object)("Error creating a new Analyte : " + ex.getMessage()), (Throwable)ex);
            ErrorUtils.createErrorMessageBox((Shell)shell, (String)"Unable to create an Analyte. ");
        }
        logger.info((Object)"- END   COMMAND : Create a new Analyte. ");
    }

    private Entry createNewAnalyte(Shell shell, Entry projectEntry) {
        logger.info((Object)"Opening Analyte Creation Wizard");
        Entry analyteEntry = null;
        NewAnalyteWizard wizard = new NewAnalyteWizard();
        wizard.setWindowTitle("New Analyte Wizard");
        wizard.setProjectEntry(projectEntry);
        WizardDialog dialog = new WizardDialog(PropertyHandler.getModalDialog((Shell)shell), (IWizard)wizard);
        if (dialog.open() == 0) {
            logger.info((Object)"Creating Sample entry file");
            projectEntry = wizard.getProjectEntry();
            File sampleFolder = UtilityFile.getSampleGroupDirectory(projectEntry.getDisplayName());
            String newSampleFileName = UtilityFile.generateFileName(sampleFolder.list());
            Sample sample = wizard.getSample();
            try {
                UtilityFile.writeToFile(sample, String.valueOf(sampleFolder.getAbsolutePath()) + File.separator + newSampleFileName);
                logger.info((Object)("Create analyte entry \"" + sample.getName() + "\" and add it to the project entry \"" + projectEntry.getDisplayName() + "\""));
                analyteEntry = NewAnalyteHandler.createEntry(sample.getName(), newSampleFileName);
                gritsDataModelService.addEntry(projectEntry, analyteEntry);
                try {
                    ProjectFileHandler.saveProject((Entry)projectEntry);
                }
                catch (IOException e) {
                    logger.error((Object)("Something went wrong while saving project entry \n" + e.getMessage()), (Throwable)e);
                    logger.fatal((Object)("Closing project entry \"" + projectEntry.getDisplayName() + "\""));
                    gritsDataModelService.closeProject(projectEntry);
                    throw e;
                }
            }
            catch (IOException | JAXBException e) {
                logger.error((Object)e.getMessage(), e);
                MessageDialog.openError((Shell)shell, (String)"Error Creating Analyte", (String)("Something went wrong while creating analyte entry.\n" + e.getMessage()));
            }
        }
        return analyteEntry;
    }

    public static Entry createEntry(String newEntryName, String newSampleFileName) {
        logger.info((Object)"Creating new sample entry");
        Entry newEntry = new Entry();
        newEntry.setDisplayName(newEntryName);
        SampleProperty property = new SampleProperty();
        ArrayList<PropertyDataFile> dataFiles = new ArrayList<PropertyDataFile>();
        PropertyDataFile samplePropertyFile = new PropertyDataFile(newSampleFileName, "1.0", "default");
        dataFiles.add(samplePropertyFile);
        property.setDataFiles(dataFiles);
        newEntry.setProperty((Property)property);
        logger.info((Object)"New sample entry created");
        return newEntry;
    }
}

