/*
 * Decompiled with CFR 0.152.
 */
package org.eurocarbdb.application.glycoworkbench.plugin.reporting;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.Ellipse2D;
import java.awt.image.BufferedImage;
import javax.swing.ImageIcon;
import javax.swing.table.DefaultTableCellRenderer;
import org.eurocarbdb.application.glycanbuilder.GraphicUtils;

class HeatMapCellRenderer
extends DefaultTableCellRenderer {
    private static final long serialVersionUID = 0L;
    private boolean fill_cell;
    private int spot_radius;

    public HeatMapCellRenderer() {
        this.fill_cell = true;
        this.spot_radius = 0;
    }

    public HeatMapCellRenderer(int sr) {
        this.fill_cell = false;
        this.spot_radius = sr;
    }

    @Override
    public void setValue(Object value) {
        Color color = HeatMapCellRenderer.getColor((Double)value);
        if (this.fill_cell) {
            this.setBackground(color);
        } else {
            this.setIcon(this.createSpot(color, HeatMapCellRenderer.getRadius((Double)value, this.spot_radius)));
        }
    }

    public ImageIcon createSpot(Color color, int radius) {
        BufferedImage img = GraphicUtils.createCompatibleImage((int)(2 * this.spot_radius), (int)(2 * this.spot_radius), (boolean)false);
        Graphics2D g2d = img.createGraphics();
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2d.setBackground(new Color(255, 255, 255, 0));
        g2d.setColor(color);
        g2d.fill(new Ellipse2D.Double(this.spot_radius - radius, this.spot_radius - radius, 2 * radius, 2 * radius));
        return new ImageIcon(img);
    }

    private static Color getColor(double value) {
        if (value <= -1.0) {
            return Color.red;
        }
        if (value >= 1.0) {
            return Color.green;
        }
        if (value < 0.0) {
            return new Color(-((float)value), 0.0f, 0.0f);
        }
        if (value > 0.0) {
            return new Color(0.0f, (float)value, 0.0f);
        }
        return Color.black;
    }

    private static int getRadius(double value, int spot_radius) {
        if (value >= 1.0) {
            return spot_radius;
        }
        if (value <= -1.0) {
            return spot_radius;
        }
        if (value > 0.0) {
            return (int)(value * (double)spot_radius);
        }
        if (value < 0.0) {
            return (int)(-value * (double)spot_radius);
        }
        return 0;
    }
}

