/*
 * Decompiled with CFR 0.152.
 */
package org.eurocarbdb.application.glycoworkbench.plugin.reporting;

import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringReader;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.filechooser.FileFilter;
import javax.xml.transform.sax.TransformerHandler;
import org.eurocarbdb.application.glycanbuilder.BaseDocument;
import org.eurocarbdb.application.glycanbuilder.BuilderWorkspace;
import org.eurocarbdb.application.glycanbuilder.Configuration;
import org.eurocarbdb.application.glycanbuilder.ExtensionFileFilter;
import org.eurocarbdb.application.glycanbuilder.FileUtils;
import org.eurocarbdb.application.glycanbuilder.Glycan;
import org.eurocarbdb.application.glycanbuilder.GlycanRenderer;
import org.eurocarbdb.application.glycanbuilder.GlycanRendererAWT;
import org.eurocarbdb.application.glycanbuilder.GraphicOptions;
import org.eurocarbdb.application.glycanbuilder.LogUtils;
import org.eurocarbdb.application.glycanbuilder.Pair;
import org.eurocarbdb.application.glycanbuilder.SAXUtils;
import org.eurocarbdb.application.glycanbuilder.XMLUtils;
import org.eurocarbdb.application.glycoworkbench.MMFCreator;
import org.eurocarbdb.application.glycoworkbench.Peak;
import org.eurocarbdb.application.glycoworkbench.PeakAnnotation;
import org.eurocarbdb.application.glycoworkbench.PeakAnnotationCollection;
import org.eurocarbdb.application.glycoworkbench.PeakData;
import org.eurocarbdb.application.glycoworkbench.PeakList;
import org.eurocarbdb.application.glycoworkbench.plugin.reporting.AnnotationObject;
import org.eurocarbdb.application.glycoworkbench.plugin.reporting.AnnotationReportCanvas;
import org.eurocarbdb.application.glycoworkbench.plugin.reporting.AnnotationReportOptions;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;
import org.xml.sax.helpers.DefaultHandler;

public class AnnotationReportDocument
extends BaseDocument
implements SAXUtils.SAXWriter {
    private static final int ANNOTATION = 1;
    private static final int ANCHOR = 2;
    private static final int SCALE = 3;
    private static final int CP = 4;
    private MMFCreator mmfc = null;
    private BuilderWorkspace theWorkspace;
    private AnnotationReportOptions theOptions = null;
    private GraphicOptions theGraphicOptions = null;
    private PeakList thePeakList = null;
    private boolean show_rel_int = false;
    private boolean show_empty_annotations = false;
    private double start_mz = 0.0;
    private double end_mz = 0.0;
    private PeakData thePeakData = null;
    private Glycan theParentStructure = null;
    private PeakAnnotationCollection thePeakAnnotationCollection = new PeakAnnotationCollection();
    private Vector<AnnotationObject> annotations = new Vector();
    private HashMap<AnnotationObject, Point2D> anchors = new HashMap();
    private HashMap<AnnotationObject, Point2D> control_points = new HashMap();
    private HashMap<AnnotationObject, Double> scales = new HashMap();

    public AnnotationReportDocument() {
        this.theWorkspace = new BuilderWorkspace(null, false, (GlycanRenderer)new GlycanRendererAWT());
        this.theOptions = new AnnotationReportOptions();
        this.theGraphicOptions = this.theWorkspace.getGraphicOptions();
        this.theWorkspace.setDisplay("compact");
        this.theGraphicOptions.SHOW_INFO = false;
        this.theGraphicOptions.SHOW_MASSES = false;
        this.theGraphicOptions.SHOW_REDEND = false;
    }

    public AnnotationReportDocument(double smz, double emz, PeakData pd, Glycan parent, PeakAnnotationCollection pac, AnnotationReportOptions opt, GraphicOptions gopt) {
        this();
        assert (pac != null);
        this.theOptions = opt;
        this.show_rel_int = opt.SHOW_RELATIVE_INTENSITIES;
        this.show_empty_annotations = opt.SHOW_EMPTY_ANNOTATIONS;
        this.start_mz = smz;
        this.end_mz = emz;
        this.thePeakData = opt.SHOW_RAW_SPECTRUM || opt.SHOW_COMPLETE_PEAK_LIST ? pd : null;
        this.theParentStructure = parent;
        this.thePeakAnnotationCollection = pac;
        this.theWorkspace.setNotation(gopt.NOTATION);
        this.theGraphicOptions.ORIENTATION = this.thePeakAnnotationCollection.isProfile() ? 1 : 0;
        this.initData();
    }

    private MMFCreator getMMFCreator() {
        try {
            if (this.mmfc == null) {
                this.mmfc = new MMFCreator();
            }
            return this.mmfc;
        }
        catch (Exception e) {
            LogUtils.report((Exception)e);
            return null;
        }
    }

    public BuilderWorkspace getWorkspace() {
        return this.theWorkspace;
    }

    public AnnotationReportOptions getAnnotationReportOptions() {
        return this.theOptions;
    }

    public GraphicOptions getGraphicOptions() {
        return this.theGraphicOptions;
    }

    public int size() {
        return this.annotations.size();
    }

    public String getName() {
        return "Annotation report";
    }

    public ImageIcon getIcon() {
        return FileUtils.defaultThemeManager.getImageIcon("annrepdoc");
    }

    public Collection<FileFilter> getFileFormats() {
        Vector<FileFilter> filters = new Vector<FileFilter>();
        filters.add((FileFilter)new ExtensionFileFilter("gwr", "Annotation report file"));
        return filters;
    }

    public FileFilter getAllFileFormats() {
        return new ExtensionFileFilter("gwr", "Annotation report file");
    }

    public boolean isShowRelativeIntensities() {
        return this.show_rel_int;
    }

    public boolean isShowEmptyAnnotations() {
        return this.show_empty_annotations;
    }

    public double getStartMZ() {
        return this.start_mz;
    }

    public double getEndMZ() {
        return this.end_mz;
    }

    public PeakData getPeakData() {
        return this.thePeakData;
    }

    public Glycan getParentStructure() {
        return this.theParentStructure;
    }

    public PeakAnnotationCollection getPeakAnnotationCollection() {
        return this.thePeakAnnotationCollection;
    }

    public Vector<AnnotationObject> getAnnotations() {
        return this.annotations;
    }

    public Vector<PeakAnnotation> getPeakAnnotations() {
        Vector<PeakAnnotation> ret = new Vector<PeakAnnotation>();
        for (AnnotationObject a : this.annotations) {
            ret.addAll(a.getPeakAnnotations());
        }
        return ret;
    }

    public Point2D getAnchor(AnnotationObject a) {
        return this.anchors.get(a);
    }

    public HashMap<AnnotationObject, Point2D> getAnchors() {
        return this.anchors;
    }

    public Point2D getControlPoint(AnnotationObject a) {
        return this.control_points.get(a);
    }

    public HashMap<AnnotationObject, Point2D> getControlPoints() {
        return this.control_points;
    }

    public Double getScale(AnnotationObject a) {
        return this.scales.get(a);
    }

    public HashMap<AnnotationObject, Double> getScales() {
        return this.scales;
    }

    public boolean isDisplayed(AnnotationObject a) {
        return this.annotations.contains(a);
    }

    public double[][] getData(Rectangle2D data_area) {
        return this.getData(data_area, this.show_rel_int);
    }

    public double[][] getData(Rectangle2D data_area, boolean rel_int) {
        if (this.thePeakData != null) {
            if (this.start_mz != this.end_mz) {
                double mz_toll = (this.end_mz - this.start_mz) / data_area.getWidth() / 2.0;
                return this.thePeakData.getData(this.start_mz, this.end_mz, mz_toll, rel_int);
            }
            double mz_toll = this.thePeakData.getMZRange().getLength() / data_area.getWidth() / 2.0;
            return this.thePeakData.getData(mz_toll, rel_int);
        }
        if (this.start_mz != this.end_mz) {
            return this.thePeakAnnotationCollection.getPeakData(this.start_mz, this.end_mz, 1.0, rel_int);
        }
        return this.thePeakAnnotationCollection.getPeakData(1.0, rel_int);
    }

    private Peak findNearestPeak(TreeMap<Double, Double> theData, double mz, double mz_toll) {
        Object[] after;
        double max_mz = mz;
        double max_int = 0.0;
        Object[] before = theData.subMap(mz - mz_toll, mz).entrySet().toArray();
        if (before != null) {
            Map.Entry e;
            for (int i = before.length - 1; i >= 0 && !((Double)(e = (Map.Entry)before[i]).getValue() < max_int); --i) {
                max_mz = (Double)e.getKey();
                max_int = (Double)e.getValue();
            }
        }
        if ((after = theData.subMap(mz, mz + mz_toll).entrySet().toArray()) != null) {
            Map.Entry e;
            for (int i = 0; i < after.length && !((Double)(e = (Map.Entry)after[i]).getValue() < max_int); ++i) {
                max_mz = (Double)e.getKey();
                max_int = (Double)e.getValue();
            }
        }
        return new Peak(max_mz, max_int);
    }

    public void initData() {
        if (this.annotations == null) {
            return;
        }
        this.annotations.clear();
        this.anchors.clear();
        this.control_points.clear();
        this.scales.clear();
        double max_int = 0.0;
        TreeMap<Double, Double> visibleData = new TreeMap<Double, Double>();
        if (this.thePeakData != null) {
            double[][] data = this.start_mz != this.end_mz ? this.thePeakData.getData(this.start_mz, this.end_mz, 0.1) : this.thePeakData.getData(0.1, this.show_rel_int);
            for (int i = 0; i < data[0].length; ++i) {
                visibleData.put(data[0][i], data[1][i]);
                max_int = Math.max(max_int, data[1][i]);
            }
        } else {
            max_int = this.start_mz != this.end_mz ? this.thePeakAnnotationCollection.getMaxIntensity(this.start_mz, this.end_mz) : this.thePeakAnnotationCollection.getMaxIntensity();
        }
        AnnotationObject last = null;
        for (PeakAnnotation pa : this.thePeakAnnotationCollection.getPeakAnnotations()) {
            if (!this.show_empty_annotations && !pa.isAnnotated()) continue;
            Peak p = pa.getPeak();
            if (this.start_mz != this.end_mz && (!(p.getMZ() >= this.start_mz) || !(p.getMZ() <= this.end_mz))) continue;
            if (this.thePeakData != null) {
                p = this.findNearestPeak(visibleData, p.getMZ(), 1.0);
            }
            double x = p.getMZ();
            double y = this.show_rel_int ? 100.0 * p.getIntensity() / max_int : p.getIntensity();
            AnnotationObject a = new AnnotationObject(x, y, pa);
            if (last != null && last.canGroup(a)) {
                last.group(a);
                continue;
            }
            this.annotations.add(a);
            this.anchors.put(a, new Point2D.Double(x, y));
            this.control_points.put(a, new Point2D.Double(x, y));
            this.scales.put(a, 1.0);
            last = a;
        }
        this.fireDocumentInit();
    }

    public boolean updateData(Glycan parent, PeakAnnotationCollection pac, Collection<AnnotationObject> added, boolean fire, boolean merge) {
        boolean changed;
        int i;
        this.theParentStructure = parent;
        this.thePeakAnnotationCollection = pac;
        double max_int = 0.0;
        TreeMap<Double, Double> visibleData = new TreeMap<Double, Double>();
        if (this.thePeakData != null) {
            double[][] data = this.start_mz != this.end_mz ? this.thePeakData.getData(this.start_mz, this.end_mz, 0.1) : this.thePeakData.getData(0.1, this.show_rel_int);
            for (i = 0; i < data[0].length; ++i) {
                visibleData.put(data[0][i], data[1][i]);
                max_int = Math.max(max_int, data[1][i]);
            }
        } else {
            max_int = this.start_mz != this.end_mz ? this.thePeakAnnotationCollection.getMaxIntensity(this.start_mz, this.end_mz) : this.thePeakAnnotationCollection.getMaxIntensity();
        }
        boolean removed = false;
        if (!merge) {
            for (i = 0; i < this.annotations.size(); ++i) {
                AnnotationObject a = this.annotations.get(i);
                for (int l = 0; l < a.getPeakAnnotations().size(); ++l) {
                    PeakAnnotation pa = a.getPeakAnnotations().get(l);
                    if (this.thePeakAnnotationCollection.getPeakAnnotations().contains(pa)) continue;
                    removed = true;
                    a.remove(pa);
                    --l;
                }
                if (a.size() != 0) continue;
                removed = true;
                this.annotations.removeElementAt(i);
                this.anchors.remove(a);
                this.control_points.remove(a);
                this.scales.remove(a);
                --i;
            }
        }
        AnnotationObject last = null;
        for (PeakAnnotation pa : this.thePeakAnnotationCollection.getPeakAnnotations()) {
            if (this.getAnnotation(pa) != null || !this.show_empty_annotations && !pa.isAnnotated()) continue;
            Peak p = pa.getPeak();
            if (this.start_mz != this.end_mz && (!(p.getMZ() >= this.start_mz) || !(p.getMZ() <= this.end_mz))) continue;
            if (this.thePeakData != null) {
                p = this.findNearestPeak(visibleData, p.getMZ(), 1.0);
            }
            double x = p.getMZ();
            double y = this.show_rel_int ? 100.0 * p.getIntensity() / max_int : p.getIntensity();
            AnnotationObject a = new AnnotationObject(x, y, pa);
            if (last != null && last.canGroup(a)) {
                last.group(a);
                continue;
            }
            added.add(a);
            this.annotations.add(a);
            this.anchors.put(a, new Point2D.Double(x, y));
            this.control_points.put(a, new Point2D.Double(x, y));
            this.scales.put(a, 1.0);
            last = a;
        }
        boolean bl = changed = removed || added.size() > 0;
        if (changed && fire) {
            this.fireDocumentChanged();
        }
        return changed;
    }

    public AnnotationObject getAnnotation(PeakAnnotation pa) {
        for (AnnotationObject a : this.annotations) {
            if (!a.getPeakAnnotations().contains(pa)) continue;
            return a;
        }
        return null;
    }

    public void remove(AnnotationObject a) {
        if (a.size() == 0 || !this.show_empty_annotations) {
            this.annotations.remove(a);
            this.anchors.remove(a);
            this.control_points.remove(a);
            this.scales.remove(a);
        } else {
            a.clear();
        }
        this.fireDocumentChanged();
    }

    public void remove(Collection<AnnotationObject> toremove) {
        for (AnnotationObject a : toremove) {
            if (a.size() == 0 || !this.show_empty_annotations) {
                this.annotations.remove(a);
                this.anchors.remove(a);
                this.control_points.remove(a);
                this.scales.remove(a);
                continue;
            }
            a.clear();
        }
        this.fireDocumentChanged();
    }

    public Point2D computeControlPoint(Point2D anchor, double mz, double intensity) {
        return this.computeControlPoint(anchor, new Point2D.Double(mz, intensity));
    }

    public Point2D computeControlPoint(Point2D anchor, Point2D peak) {
        if (anchor.getY() <= peak.getY()) {
            return new Point2D.Double((anchor.getX() + peak.getX()) / 2.0, (anchor.getY() + peak.getY()) / 2.0);
        }
        return new Point2D.Double(peak.getX(), (anchor.getY() + peak.getY()) / 2.0);
    }

    public void move(Collection<AnnotationObject> tomove, double ddx, double ddy) {
        for (AnnotationObject a : tomove) {
            Point2D anchor = this.anchors.get(a);
            if (anchor == null) continue;
            anchor.setLocation(anchor.getX() + ddx, anchor.getY() - ddy);
            this.control_points.put(a, this.computeControlPoint(anchor, a.getPeakPoint()));
        }
        this.fireDocumentChanged();
    }

    public void move(AnnotationObject tomove, double ddx, double ddy) {
        Point2D anchor = this.anchors.get(tomove);
        if (anchor != null) {
            anchor.setLocation(anchor.getX() + ddx, anchor.getY() - ddy);
            this.control_points.put(tomove, this.computeControlPoint(anchor, tomove.getPeakPoint()));
            this.fireDocumentChanged();
        }
    }

    public void moveTo(AnnotationObject tomove, double x, double y) {
        Point2D anchor = this.anchors.get(tomove);
        if (anchor != null) {
            anchor.setLocation(x, y);
            this.control_points.put(tomove, this.computeControlPoint(anchor, tomove.getPeakPoint()));
            this.fireDocumentChanged();
        }
    }

    public void moveControlPointTo(AnnotationObject tomove, double x, double y) {
        Point2D cp = this.control_points.get(tomove);
        if (cp != null) {
            cp.setLocation(x, y);
            this.fireDocumentChanged();
        }
    }

    public void rescale(Collection<AnnotationObject> toscale, double factor) {
        for (AnnotationObject a : toscale) {
            this.scales.put(a, this.scales.get(a) * factor);
        }
        this.fireDocumentChanged();
    }

    public void resetScale(Collection<AnnotationObject> toscale) {
        for (AnnotationObject a : toscale) {
            this.scales.put(a, 1.0);
        }
        this.fireDocumentChanged();
    }

    public void setHighlighted(Collection<AnnotationObject> toset, boolean highlight) {
        for (AnnotationObject a : toset) {
            a.setHighlighted(highlight);
        }
        this.fireDocumentChanged();
    }

    public boolean canGroup(Collection<AnnotationObject> togroup) {
        if (togroup == null || togroup.size() < 2) {
            return false;
        }
        AnnotationObject first = togroup.iterator().next();
        for (AnnotationObject a : togroup) {
            if (a == first || first.canGroup(a)) continue;
            return false;
        }
        return true;
    }

    public void group(Collection<AnnotationObject> togroup) {
        if (this.canGroup(togroup)) {
            AnnotationObject grouped = togroup.iterator().next();
            for (AnnotationObject a : togroup) {
                if (a == grouped) continue;
                this.annotations.remove(a);
                this.anchors.remove(a);
                this.control_points.remove(a);
                this.scales.remove(a);
                grouped.group(a);
            }
            this.fireDocumentChanged();
        }
    }

    public void ungroup(Collection<AnnotationObject> toungroup, AnnotationReportCanvas theCanvas) {
        boolean changed = false;
        for (AnnotationObject grouped : toungroup) {
            if (grouped.size() <= 1) continue;
            int ind = this.annotations.indexOf(grouped);
            Point2D anchor = this.anchors.get(grouped);
            Double scale = this.scales.get(grouped);
            for (AnnotationObject a : grouped.ungroup()) {
                this.annotations.insertElementAt(a, ind++);
                this.anchors.put(a, anchor);
                this.control_points.put(a, this.computeControlPoint(anchor, a.getPeakPoint()));
                this.scales.put(a, scale);
                anchor = new Point2D.Double(anchor.getX(), anchor.getY() + theCanvas.computeSizeData(a).getHeight());
            }
            this.annotations.remove(grouped);
            this.anchors.remove(grouped);
            this.control_points.remove(grouped);
            this.scales.remove(grouped);
            changed = true;
        }
        if (changed) {
            this.fireDocumentChanged();
        }
    }

    public String toString() {
        StringBuilder ret = new StringBuilder();
        if (this.annotations != null) {
            for (AnnotationObject annotationObject : this.annotations) {
                ret.append(1);
                ret.append(' ');
                ret.append(annotationObject.isHighlighted());
                ret.append(' ');
                ret.append(annotationObject.getPeakPoint().getX());
                ret.append(' ');
                ret.append(annotationObject.getPeakPoint().getY());
                ret.append(' ');
                ret.append(annotationObject.getPeakAnnotations().size());
                for (PeakAnnotation pa : annotationObject.getPeakAnnotations()) {
                    ret.append(' ');
                    ret.append(this.thePeakAnnotationCollection.indexOf(pa));
                }
                ret.append('\n');
            }
        }
        if (this.anchors != null) {
            for (Map.Entry entry : this.anchors.entrySet()) {
                ret.append(2);
                ret.append(' ');
                ret.append(this.annotations.indexOf(entry.getKey()));
                ret.append(' ');
                ret.append(((Point2D)entry.getValue()).getX());
                ret.append(' ');
                ret.append(((Point2D)entry.getValue()).getY());
                ret.append('\n');
            }
        }
        if (this.control_points != null) {
            for (Map.Entry entry : this.control_points.entrySet()) {
                ret.append(4);
                ret.append(' ');
                ret.append(this.annotations.indexOf(entry.getKey()));
                ret.append(' ');
                ret.append(((Point2D)entry.getValue()).getX());
                ret.append(' ');
                ret.append(((Point2D)entry.getValue()).getY());
                ret.append('\n');
            }
        }
        if (this.scales != null) {
            for (Map.Entry entry : this.scales.entrySet()) {
                ret.append(3);
                ret.append(' ');
                ret.append(this.annotations.indexOf(entry.getKey()));
                ret.append(' ');
                ret.append(entry.getValue());
                ret.append('\n');
            }
        }
        return ret.toString();
    }

    public void fromString(String str, boolean merge) throws Exception {
        String line;
        if (!merge) {
            this.annotations.clear();
            this.anchors.clear();
            this.control_points.clear();
            this.scales.clear();
        }
        BufferedReader br = new BufferedReader(new StringReader(str));
        while ((line = br.readLine()) != null) {
            double y;
            int ind;
            String[] tokens = line.split("\\s");
            int type = Integer.valueOf(tokens[0]);
            if (type == 1) {
                if (tokens.length < 4) {
                    throw new Exception("Invalid format for ANNOTATION line: " + line);
                }
                int off = 0;
                boolean highlighted = false;
                if (tokens[1].equals("true") || tokens[1].equals("false")) {
                    highlighted = Boolean.valueOf(tokens[1]);
                    off = 1;
                }
                double x = Double.valueOf(tokens[1 + off]);
                double y2 = Double.valueOf(tokens[2 + off]);
                int size = Integer.valueOf(tokens[3 + off]);
                if (tokens.length != size + 4 + off) {
                    throw new Exception("Invalid format for ANNOTATION line: " + line);
                }
                AnnotationObject read = new AnnotationObject(x, y2);
                read.setHighlighted(highlighted);
                for (int i = 0; i < size; ++i) {
                    int ind2 = Integer.valueOf(tokens[i + 4 + off]);
                    read.add(this.thePeakAnnotationCollection.getPeakAnnotation(ind2));
                }
                this.annotations.add(read);
                continue;
            }
            if (type == 2) {
                if (tokens.length != 4) {
                    throw new Exception("Invalid format for ANCHOR line: " + line);
                }
                ind = Integer.valueOf(tokens[1]);
                double x = Double.valueOf(tokens[2]);
                y = Double.valueOf(tokens[3]);
                this.anchors.put(this.annotations.elementAt(ind), new Point2D.Double(x, y));
                continue;
            }
            if (type == 4) {
                if (tokens.length != 4) {
                    throw new Exception("Invalid format for CP line: " + line);
                }
                ind = Integer.valueOf(tokens[1]);
                double x = Double.valueOf(tokens[2]);
                y = Double.valueOf(tokens[3]);
                this.control_points.put(this.annotations.elementAt(ind), new Point2D.Double(x, y));
                continue;
            }
            if (type == 3) {
                if (tokens.length != 3) {
                    throw new Exception("Invalid format for SCALE line: " + line);
                }
                ind = Integer.valueOf(tokens[1]);
                double s = Double.valueOf(tokens[2]);
                this.scales.put(this.annotations.elementAt(ind), s);
                continue;
            }
            throw new Exception("Invalid type: " + type);
        }
    }

    public void fromXMLString(String src) throws Exception {
        ByteArrayInputStream bis = new ByteArrayInputStream(src.getBytes());
        this.read(bis, false);
        this.setFilename("");
        this.fireDocumentInit();
    }

    public void fromXMLString(byte[] src) throws Exception {
        ByteArrayInputStream bis = new ByteArrayInputStream(src);
        this.read(bis, false);
        this.setFilename("");
        this.fireDocumentInit();
    }

    public String toXMLString() {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            this.write(baos);
            return baos.toString();
        }
        catch (Exception e) {
            LogUtils.report((Exception)e);
            return "";
        }
    }

    public void read(InputStream is, boolean merge) throws Exception {
        SAXUtils.read((InputStream)is, (DefaultHandler)((Object)new SAXHandler(this)));
    }

    public void write(OutputStream os) throws Exception {
        SAXUtils.write((OutputStream)os, (SAXUtils.SAXWriter)this);
    }

    public void fromXML(Node ard_node) throws Exception {
        double y;
        double x;
        Node pd_node;
        if (ard_node == null) {
            throw new Exception("empty node");
        }
        this.show_rel_int = Boolean.valueOf(XMLUtils.getAttribute((Node)ard_node, (String)"show_relative_intensities"));
        this.show_empty_annotations = Boolean.valueOf(XMLUtils.getAttribute((Node)ard_node, (String)"show_empty_annotations"));
        this.start_mz = Double.valueOf(XMLUtils.getAttribute((Node)ard_node, (String)"start_mz"));
        this.end_mz = Double.valueOf(XMLUtils.getAttribute((Node)ard_node, (String)"end_mz"));
        Node c_node = XMLUtils.findChild((Node)ard_node, (String)"Configuration");
        if (c_node != null) {
            Configuration config = new Configuration();
            config.fromXML(c_node);
            this.theOptions.retrieve(config);
            this.theGraphicOptions.retrieve(config);
        }
        this.thePeakData = (pd_node = XMLUtils.findChild((Node)ard_node, (String)"PeakData")) != null ? PeakData.fromXML(pd_node, this.getMMFCreator()) : null;
        this.thePeakAnnotationCollection = PeakAnnotationCollection.fromXML(XMLUtils.assertChild((Node)ard_node, (String)"PeakAnnotationCollection"));
        this.annotations = new Vector();
        for (Node node : XMLUtils.findAllChildren((Node)ard_node, (String)"Annotation")) {
            double x2 = Double.valueOf(XMLUtils.getAttribute((Node)node, (String)"x"));
            double y2 = Double.valueOf(XMLUtils.getAttribute((Node)node, (String)"y"));
            int size = Integer.valueOf(XMLUtils.getAttribute((Node)node, (String)"size"));
            AnnotationObject read = new AnnotationObject(x2, y2);
            for (int i = 0; i < size; ++i) {
                int ind = Integer.valueOf(XMLUtils.getAttribute((Node)node, (String)("pa" + i)));
                read.add(this.thePeakAnnotationCollection.getPeakAnnotation(ind));
            }
            this.annotations.add(read);
        }
        this.anchors = new HashMap();
        for (Node node : XMLUtils.findAllChildren((Node)ard_node, (String)"Anchor")) {
            int ind = Integer.valueOf(XMLUtils.getAttribute((Node)node, (String)"ind"));
            x = Double.valueOf(XMLUtils.getAttribute((Node)node, (String)"x"));
            y = Double.valueOf(XMLUtils.getAttribute((Node)node, (String)"y"));
            this.anchors.put(this.annotations.elementAt(ind), new Point2D.Double(x, y));
        }
        this.control_points = new HashMap();
        for (Node node : XMLUtils.findAllChildren((Node)ard_node, (String)"ControlPoint")) {
            int ind = Integer.valueOf(XMLUtils.getAttribute((Node)node, (String)"ind"));
            x = Double.valueOf(XMLUtils.getAttribute((Node)node, (String)"x"));
            y = Double.valueOf(XMLUtils.getAttribute((Node)node, (String)"y"));
            this.control_points.put(this.annotations.elementAt(ind), new Point2D.Double(x, y));
        }
        this.scales = new HashMap();
        for (Node node : XMLUtils.findAllChildren((Node)ard_node, (String)"Scale")) {
            int ind = Integer.valueOf(XMLUtils.getAttribute((Node)node, (String)"ind"));
            double s = Double.valueOf(XMLUtils.getAttribute((Node)node, (String)"s"));
            this.scales.put(this.annotations.elementAt(ind), s);
        }
    }

    public Element toXML(Document document) {
        if (document == null) {
            return null;
        }
        Element ard_node = document.createElement("AnnotationReportDocument");
        Configuration config = new Configuration();
        this.theOptions.store(config);
        this.theGraphicOptions.store(config);
        ard_node.appendChild(config.toXML(document));
        ard_node.setAttribute("show_relative_intensities", "" + this.show_rel_int);
        ard_node.setAttribute("show_empty_annotations", "" + this.show_empty_annotations);
        ard_node.setAttribute("start_mz", "" + this.start_mz);
        ard_node.setAttribute("end_mz", "" + this.end_mz);
        if (this.thePeakData != null) {
            ard_node.appendChild(this.thePeakData.toXML(document));
        }
        ard_node.appendChild(this.thePeakAnnotationCollection.toXML(document));
        if (this.annotations != null) {
            for (AnnotationObject annotationObject : this.annotations) {
                int i = 0;
                Element node = document.createElement("Annotation");
                node.setAttribute("x", "" + annotationObject.getPeakPoint().getX());
                node.setAttribute("y", "" + annotationObject.getPeakPoint().getY());
                node.setAttribute("size", "" + annotationObject.getPeakAnnotations().size());
                for (PeakAnnotation pa : annotationObject.getPeakAnnotations()) {
                    node.setAttribute("pa" + i++, "" + this.thePeakAnnotationCollection.indexOf(pa));
                }
                ard_node.appendChild(node);
            }
        }
        if (this.anchors != null) {
            for (Map.Entry entry : this.anchors.entrySet()) {
                Element node = document.createElement("Anchor");
                node.setAttribute("ind", "" + this.annotations.indexOf(entry.getKey()));
                node.setAttribute("x", "" + ((Point2D)entry.getValue()).getX());
                node.setAttribute("y", "" + ((Point2D)entry.getValue()).getY());
                ard_node.appendChild(node);
            }
        }
        if (this.control_points != null) {
            for (Map.Entry entry : this.control_points.entrySet()) {
                Element node = document.createElement("ControlPoint");
                node.setAttribute("ind", "" + this.annotations.indexOf(entry.getKey()));
                node.setAttribute("x", "" + ((Point2D)entry.getValue()).getX());
                node.setAttribute("y", "" + ((Point2D)entry.getValue()).getY());
                ard_node.appendChild(node);
            }
        }
        if (this.scales != null) {
            for (Map.Entry entry : this.scales.entrySet()) {
                Element node = document.createElement("Scale");
                node.setAttribute("ind", "" + this.annotations.indexOf(entry.getKey()));
                node.setAttribute("s", "" + entry.getValue());
                ard_node.appendChild(node);
            }
        }
        return ard_node;
    }

    public void write(TransformerHandler th) throws SAXException {
        AttributesImpl atts = new AttributesImpl();
        atts.addAttribute("", "", "show_relative_intensities", "CDATA", "" + this.show_rel_int);
        atts.addAttribute("", "", "show_empty_annotations", "CDATA", "" + this.show_empty_annotations);
        atts.addAttribute("", "", "start_mz", "CDATA", "" + this.start_mz);
        atts.addAttribute("", "", "end_mz", "CDATA", "" + this.end_mz);
        th.startElement("", "", "AnnotationReportDocument", atts);
        Configuration config = new Configuration();
        this.theOptions.store(config);
        this.theGraphicOptions.store(config);
        config.write(th);
        if (this.thePeakData != null) {
            this.thePeakData.write(th);
        }
        if (this.theParentStructure != null) {
            this.theParentStructure.write(th);
        }
        this.thePeakAnnotationCollection.write(th);
        if (this.annotations != null) {
            for (AnnotationObject annotationObject : this.annotations) {
                int i = 0;
                AttributesImpl aatts = new AttributesImpl();
                aatts.addAttribute("", "", "x", "CDATA", "" + annotationObject.getPeakPoint().getX());
                aatts.addAttribute("", "", "y", "CDATA", "" + annotationObject.getPeakPoint().getY());
                aatts.addAttribute("", "", "highlighted", "CDATA", "" + annotationObject.isHighlighted());
                aatts.addAttribute("", "", "size", "CDATA", "" + annotationObject.getPeakAnnotations().size());
                for (PeakAnnotation pa : annotationObject.getPeakAnnotations()) {
                    aatts.addAttribute("", "", "pa" + i++, "CDATA", "" + this.thePeakAnnotationCollection.indexOf(pa));
                }
                th.startElement("", "", "Annotation", aatts);
                th.endElement("", "", "Annotation");
            }
        }
        if (this.anchors != null) {
            for (Map.Entry entry : this.anchors.entrySet()) {
                AttributesImpl aatts = new AttributesImpl();
                aatts.addAttribute("", "", "ind", "CDATA", "" + this.annotations.indexOf(entry.getKey()));
                aatts.addAttribute("", "", "x", "CDATA", "" + ((Point2D)entry.getValue()).getX());
                aatts.addAttribute("", "", "y", "CDATA", "" + ((Point2D)entry.getValue()).getY());
                th.startElement("", "", "Anchor", aatts);
                th.endElement("", "", "Anchor");
            }
        }
        if (this.control_points != null) {
            for (Map.Entry entry : this.control_points.entrySet()) {
                AttributesImpl cpatts = new AttributesImpl();
                cpatts.addAttribute("", "", "ind", "CDATA", "" + this.annotations.indexOf(entry.getKey()));
                cpatts.addAttribute("", "", "x", "CDATA", "" + ((Point2D)entry.getValue()).getX());
                cpatts.addAttribute("", "", "y", "CDATA", "" + ((Point2D)entry.getValue()).getY());
                th.startElement("", "", "ControlPoint", cpatts);
                th.endElement("", "", "ControlPoint");
            }
        }
        if (this.scales != null) {
            for (Map.Entry entry : this.scales.entrySet()) {
                AttributesImpl satts = new AttributesImpl();
                satts.addAttribute("", "", "ind", "CDATA", "" + this.annotations.indexOf(entry.getKey()));
                satts.addAttribute("", "", "s", "CDATA", "" + entry.getValue());
                th.startElement("", "", "Scale", satts);
                th.endElement("", "", "Scale");
            }
        }
        th.endElement("", "", "AnnotationReportDocument");
    }

    public static class ScaleSAXHandler
    extends SAXUtils.ObjectTreeHandler {
        public boolean isElement(String namespaceURI, String localName, String qName) {
            return qName.equals(ScaleSAXHandler.getNodeElementName());
        }

        public static String getNodeElementName() {
            return "Scale";
        }

        protected void initContent(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
            super.initContent(namespaceURI, localName, qName, atts);
            int ind = this.integerAttribute(atts, "ind", -1);
            double s = this.doubleAttribute(atts, "s", 0.0);
            this.object = new Pair((Object)ind, (Object)s);
        }
    }

    public static class ControlPointSAXHandler
    extends SAXUtils.ObjectTreeHandler {
        public boolean isElement(String namespaceURI, String localName, String qName) {
            return qName.equals(ControlPointSAXHandler.getNodeElementName());
        }

        public static String getNodeElementName() {
            return "ControlPoint";
        }

        protected void initContent(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
            super.initContent(namespaceURI, localName, qName, atts);
            int ind = this.integerAttribute(atts, "ind", -1);
            double x = this.doubleAttribute(atts, "x", 0.0);
            double y = this.doubleAttribute(atts, "y", 0.0);
            this.object = new Pair((Object)ind, (Object)new Point2D.Double(x, y));
        }
    }

    public static class AnchorSAXHandler
    extends SAXUtils.ObjectTreeHandler {
        public boolean isElement(String namespaceURI, String localName, String qName) {
            return qName.equals(AnchorSAXHandler.getNodeElementName());
        }

        public static String getNodeElementName() {
            return "Anchor";
        }

        protected void initContent(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
            super.initContent(namespaceURI, localName, qName, atts);
            int ind = this.integerAttribute(atts, "ind", -1);
            double x = this.doubleAttribute(atts, "x", 0.0);
            double y = this.doubleAttribute(atts, "y", 0.0);
            this.object = new Pair((Object)ind, (Object)new Point2D.Double(x, y));
        }
    }

    public static class AnnotationSAXHandler
    extends SAXUtils.ObjectTreeHandler {
        private PeakAnnotationCollection thePeakAnnotationCollection;

        public AnnotationSAXHandler(PeakAnnotationCollection pac) {
            this.thePeakAnnotationCollection = pac;
        }

        public boolean isElement(String namespaceURI, String localName, String qName) {
            return qName.equals(AnnotationSAXHandler.getNodeElementName());
        }

        public static String getNodeElementName() {
            return "Annotation";
        }

        protected void initContent(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
            super.initContent(namespaceURI, localName, qName, atts);
            double x = this.doubleAttribute(atts, "x", 0.0);
            double y = this.doubleAttribute(atts, "y", 0.0);
            boolean h = this.booleanAttribute(atts, "highlighted", false);
            AnnotationObject read = new AnnotationObject(x, y);
            read.setHighlighted(h);
            int[] inds = new int[this.integerAttribute(atts, "size", 0).intValue()];
            for (int i = 0; i < inds.length; ++i) {
                inds[i] = this.integerAttribute(atts, "pa" + i, -1);
            }
            this.object = new Pair((Object)read, (Object)inds);
        }
    }

    public static class SAXHandler
    extends SAXUtils.ObjectTreeHandler {
        private AnnotationReportDocument theDocument;

        public SAXHandler(AnnotationReportDocument _doc) {
            this.theDocument = _doc;
        }

        public boolean isElement(String namespaceURI, String localName, String qName) {
            return qName.equals(SAXHandler.getNodeElementName());
        }

        public static String getNodeElementName() {
            return "AnnotationReportDocument";
        }

        protected SAXUtils.ObjectTreeHandler getHandler(String namespaceURI, String localName, String qName) {
            if (qName.equals(Configuration.SAXHandler.getNodeElementName())) {
                return new Configuration.SAXHandler(new Configuration());
            }
            if (qName.equals(Glycan.SAXHandler.getNodeElementName())) {
                return new Glycan.SAXHandler(this.theDocument.theWorkspace.getDefaultMassOptions());
            }
            if (qName.equals(PeakAnnotationCollection.SAXHandler.getNodeElementName())) {
                return new PeakAnnotationCollection.SAXHandler();
            }
            if (qName.equals(PeakData.SAXHandler.getNodeElementName())) {
                return new PeakData.SAXHandler(this.theDocument.getMMFCreator());
            }
            if (qName.equals(AnnotationSAXHandler.getNodeElementName())) {
                return new AnnotationSAXHandler(this.theDocument.thePeakAnnotationCollection);
            }
            if (qName.equals(AnchorSAXHandler.getNodeElementName())) {
                return new AnchorSAXHandler();
            }
            if (qName.equals(ControlPointSAXHandler.getNodeElementName())) {
                return new ControlPointSAXHandler();
            }
            if (qName.equals(ScaleSAXHandler.getNodeElementName())) {
                return new ScaleSAXHandler();
            }
            return null;
        }

        protected void initContent(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
            super.initContent(namespaceURI, localName, qName, atts);
            this.theDocument.show_rel_int = this.booleanAttribute(atts, "show_relative_intensities", false);
            this.theDocument.show_empty_annotations = this.booleanAttribute(atts, "show_empty_annotations", false);
            this.theDocument.start_mz = this.doubleAttribute(atts, "start_mz", 0.0);
            this.theDocument.end_mz = this.doubleAttribute(atts, "end_mz", 0.0);
        }

        protected Object finalizeContent(String namespaceURI, String localName, String qName) throws SAXException {
            Configuration config = (Configuration)this.getSubObject(Configuration.SAXHandler.getNodeElementName(), false);
            if (config != null) {
                this.theDocument.theOptions.retrieve(config);
                this.theDocument.theGraphicOptions.retrieve(config);
            }
            this.theDocument.thePeakData = (PeakData)this.getSubObject(PeakData.SAXHandler.getNodeElementName(), false);
            this.theDocument.theParentStructure = (Glycan)this.getSubObject(Glycan.SAXHandler.getNodeElementName(), false);
            this.theDocument.thePeakAnnotationCollection = (PeakAnnotationCollection)this.getSubObject(PeakAnnotationCollection.SAXHandler.getNodeElementName(), true);
            this.theDocument.annotations = new Vector();
            for (Object o : this.getSubObjects(AnnotationSAXHandler.getNodeElementName())) {
                Pair annotation = (Pair)o;
                for (int ind : (int[])annotation.getSecond()) {
                    ((AnnotationObject)annotation.getFirst()).add(this.theDocument.thePeakAnnotationCollection.getPeakAnnotation(ind));
                }
                this.theDocument.annotations.add(annotation.getFirst());
            }
            this.theDocument.anchors = new HashMap();
            for (Object o : this.getSubObjects(AnchorSAXHandler.getNodeElementName())) {
                Pair anchor = (Pair)o;
                this.theDocument.anchors.put(this.theDocument.annotations.elementAt((Integer)anchor.getFirst()), anchor.getSecond());
            }
            this.theDocument.control_points = new HashMap();
            for (Object o : this.getSubObjects(ControlPointSAXHandler.getNodeElementName())) {
                Pair control_point = (Pair)o;
                this.theDocument.control_points.put(this.theDocument.annotations.elementAt((Integer)control_point.getFirst()), control_point.getSecond());
            }
            this.theDocument.scales = new HashMap();
            for (Object o : this.getSubObjects(ScaleSAXHandler.getNodeElementName())) {
                Pair scale = (Pair)o;
                this.theDocument.scales.put(this.theDocument.annotations.elementAt((Integer)scale.getFirst()), scale.getSecond());
            }
            this.object = this.theDocument;
            return this.object;
        }
    }
}

