/*
 * Decompiled with CFR 0.152.
 */
package org.eurocarbdb.application.glycoworkbench.plugin.reporting;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.datatransfer.Transferable;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.text.DecimalFormat;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.RepaintManager;
import org.eurocarbdb.application.glycanbuilder.BBoxManager;
import org.eurocarbdb.application.glycanbuilder.BaseDocument;
import org.eurocarbdb.application.glycanbuilder.BuilderWorkspace;
import org.eurocarbdb.application.glycanbuilder.ClipUtils;
import org.eurocarbdb.application.glycanbuilder.DefaultPaintable;
import org.eurocarbdb.application.glycanbuilder.Geometry;
import org.eurocarbdb.application.glycanbuilder.Glycan;
import org.eurocarbdb.application.glycanbuilder.GlycanRenderer;
import org.eurocarbdb.application.glycanbuilder.GlycanRendererAWT;
import org.eurocarbdb.application.glycanbuilder.GlycanSelection;
import org.eurocarbdb.application.glycanbuilder.GraphicOptions;
import org.eurocarbdb.application.glycanbuilder.GraphicUtils;
import org.eurocarbdb.application.glycanbuilder.MouseUtils;
import org.eurocarbdb.application.glycanbuilder.Paintable;
import org.eurocarbdb.application.glycanbuilder.PositionManager;
import org.eurocarbdb.application.glycanbuilder.SVGUtils;
import org.eurocarbdb.application.glycoworkbench.PeakAnnotationCollection;
import org.eurocarbdb.application.glycoworkbench.plugin.reporting.AnnotationObject;
import org.eurocarbdb.application.glycoworkbench.plugin.reporting.AnnotationReportDocument;
import org.eurocarbdb.application.glycoworkbench.plugin.reporting.AnnotationReportOptions;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartRenderingInfo;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.NumberTickUnit;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.StandardXYItemRenderer;
import org.jfree.chart.renderer.xy.XYBarRenderer;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.data.xy.DefaultXYDataset;
import org.jfree.data.xy.XYBarDataset;
import org.jfree.data.xy.XYDataset;

public class AnnotationReportCanvas
extends JComponent
implements SVGUtils.Renderable,
BaseDocument.DocumentChangeListener,
MouseListener,
MouseMotionListener,
Printable {
    private AnnotationReportDocument theDocument;
    private GlycanRendererAWT theGlycanRenderer;
    private JScrollPane theScrollPane = null;
    private DefaultXYDataset theDataset;
    private DefaultXYDataset maxIntensityDataset;
    private XYPlot thePlot;
    private JFreeChart theChart;
    private boolean first_time;
    private boolean first_time_init_pos;
    private HashSet<AnnotationObject> selections;
    private HashMap<AnnotationObject, Rectangle> rectangles;
    private HashMap<AnnotationObject, Rectangle> rectangles_text;
    private HashMap<AnnotationObject, Rectangle> rectangles_complete;
    private HashMap<AnnotationObject, Polygon> connections;
    private HashMap<AnnotationObject, Point2D> connections_cp;
    private boolean is_printing;
    private Point mouse_start_point = null;
    private Point mouse_end_point = null;
    private AnnotationObject start_position = null;
    private boolean is_dragndrop = false;
    private boolean is_resizing = false;
    private boolean is_movingcp = false;
    private boolean was_dragged = false;
    private Rectangle draw_area;
    private Rectangle chart_area;
    private Rectangle2D data_area;
    private AnnotationReportOptions theOptions;
    private GraphicOptions theGraphicOptions;
    private Vector<SelectionChangeListener> listeners;

    public AnnotationReportCanvas(AnnotationReportDocument doc, boolean init_pos) {
        this.theDocument = doc;
        this.theDocument.addDocumentChangeListener(this);
        this.theOptions = this.theDocument.getAnnotationReportOptions();
        this.theGraphicOptions = this.theDocument.getGraphicOptions();
        this.theGlycanRenderer = (GlycanRendererAWT)this.theDocument.getWorkspace().getGlycanRenderer();
        this.updateChart();
        this.listeners = new Vector();
        this.is_printing = false;
        this.setScale(1.0);
        this.resetSelection();
        this.addMouseMotionListener(this);
        this.addMouseListener(this);
        this.first_time = true;
        this.first_time_init_pos = init_pos;
    }

    public void setScrollPane(JScrollPane sp) {
        this.theScrollPane = sp;
    }

    public AnnotationReportDocument getDocument() {
        return this.theDocument;
    }

    public BuilderWorkspace getWorkspace() {
        return this.theDocument.getWorkspace();
    }

    public AnnotationReportOptions getAnnotationReportOptions() {
        return this.theDocument.getAnnotationReportOptions();
    }

    public GraphicOptions getGraphicOptions() {
        return this.theDocument.getGraphicOptions();
    }

    public void beforeRendering() {
        this.is_printing = true;
        this.updateDrawArea(true);
        this.updateData();
    }

    public void afterRendering() {
        this.is_printing = false;
    }

    public Dimension getRenderableSize() {
        return this.getPreferredSize();
    }

    public void paintRenderable(Graphics2D g2d) {
        this.paintComponent(g2d);
    }

    @Override
    protected void paintComponent(Graphics g) {
        Graphics2D g2d = (Graphics2D)g.create();
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        if (this.is_printing) {
            g2d.translate(-this.draw_area.x, -this.draw_area.y);
            g2d.setClip(this.draw_area);
        }
        if (!this.is_printing) {
            g2d.setColor(this.getBackground());
            g2d.fillRect(0, 0, this.getWidth(), this.getHeight());
        }
        g2d.setColor(Color.white);
        g2d.fillRect(this.draw_area.x, this.draw_area.y, this.draw_area.width, this.draw_area.height);
        if (!this.is_printing) {
            g2d.setColor(Color.black);
            g2d.draw(this.draw_area);
        }
        this.paintChart(g2d);
        this.paintAnnotations(g2d);
        g2d.dispose();
        if (!this.is_printing) {
            if (this.first_time) {
                if (this.first_time_init_pos) {
                    this.placeStructures(true);
                } else {
                    this.theDocument.fireDocumentInit();
                }
                this.first_time = false;
            } else {
                this.revalidate();
            }
        }
    }

    protected void paintChart(Graphics2D g2d) {
        ChartRenderingInfo cri = new ChartRenderingInfo();
        this.theChart.draw(g2d, (Rectangle2D)this.chart_area, cri);
        this.data_area = cri.getPlotInfo().getDataArea();
    }

    protected Rectangle computeRectangles() {
        return this.computeRectangles(new PositionManager(), new BBoxManager());
    }

    protected Rectangle computeRectangles(PositionManager pman, BBoxManager bbman) {
        DecimalFormat mz_df = new DecimalFormat("0.0");
        Rectangle all_bbox = null;
        this.rectangles = new HashMap();
        this.rectangles_text = new HashMap();
        this.rectangles_complete = new HashMap();
        for (AnnotationObject a : this.theDocument.getAnnotations()) {
            this.theGlycanRenderer.getGraphicOptions().setScale(this.theOptions.SCALE_GLYCANS * this.theDocument.getScale(a));
            Point2D anchor = this.dataToScreenCoords(this.theDocument.getAnchor(a));
            Rectangle bbox = this.theGlycanRenderer.computeBoundingBoxes(a.getStructures(), false, false, pman, bbman, false);
            int x = (int)anchor.getX() - bbox.width / 2;
            int y = (int)anchor.getY() - bbox.height - this.theOptions.ANNOTATION_MARGIN - this.theOptions.ANNOTATION_MZ_SIZE;
            bbman.translate(x - bbox.x, y - bbox.y, a.getStructures());
            bbox.translate(x - bbox.x, y - bbox.y);
            this.rectangles.put(a, bbox);
            String mz_text = mz_df.format(a.getPeakPoint().getX());
            Dimension mz_dim = Geometry.textBounds((String)mz_text, (String)this.theOptions.ANNOTATION_MZ_FONT, (int)this.theOptions.ANNOTATION_MZ_SIZE);
            Rectangle text_bbox = new Rectangle((int)anchor.getX() - mz_dim.width / 2, (int)anchor.getY() - 2 * this.theOptions.ANNOTATION_MARGIN / 3 - mz_dim.height, mz_dim.width, mz_dim.height);
            this.rectangles_text.put(a, text_bbox);
            this.rectangles_complete.put(a, Geometry.expand((Rectangle)Geometry.union((Rectangle)bbox, (Rectangle)text_bbox), (int)(this.theOptions.ANNOTATION_MARGIN / 2)));
            all_bbox = Geometry.union(all_bbox, (Rectangle)bbox);
            all_bbox = Geometry.union((Rectangle)all_bbox, (Rectangle)text_bbox);
        }
        if (all_bbox == null) {
            return new Rectangle(0, 0, 0, 0);
        }
        return all_bbox;
    }

    public Rectangle2D computeSizeData(AnnotationObject a) {
        this.theGlycanRenderer.getGraphicOptions().setScale(this.theOptions.SCALE_GLYCANS * this.theDocument.getScale(a));
        Rectangle bbox = this.theGlycanRenderer.computeBoundingBoxes(a.getStructures(), false, false, new PositionManager(), new BBoxManager(), false);
        DecimalFormat mz_df = new DecimalFormat("0.0");
        String mz_text = mz_df.format(a.getPeakPoint().getX());
        Dimension mz_dim = Geometry.textBounds((String)mz_text, (String)this.theOptions.ANNOTATION_MZ_FONT, (int)this.theOptions.ANNOTATION_MZ_SIZE);
        double width = Math.max(bbox.getWidth(), mz_dim.getWidth());
        double height = bbox.getHeight() + (double)this.theOptions.ANNOTATION_MARGIN + (double)this.theOptions.ANNOTATION_MZ_SIZE;
        return new Rectangle2D.Double(0.0, 0.0, this.screenToDataX(width), this.screenToDataY(height));
    }

    protected Point2D computeAnchor(Rectangle rect, Point2D cp, Point2D peak) {
        Point2D.Double anchor = peak.getY() > (double)Geometry.bottom((Rectangle)rect) ? (cp.getY() > (double)Geometry.bottom((Rectangle)rect) ? new Point2D.Double(Geometry.midx((Rectangle)rect), Geometry.bottom((Rectangle)rect)) : (cp.getY() < (double)Geometry.top((Rectangle)rect) ? new Point2D.Double(Geometry.midx((Rectangle)rect), Geometry.top((Rectangle)rect)) : (cp.getX() < (double)Geometry.left((Rectangle)rect) ? new Point2D.Double(Geometry.left((Rectangle)rect), Geometry.midy((Rectangle)rect)) : new Point2D.Double(Geometry.right((Rectangle)rect), Geometry.midy((Rectangle)rect))))) : (peak.getY() < (double)Geometry.top((Rectangle)rect) ? new Point2D.Double(Geometry.midx((Rectangle)rect), Geometry.top((Rectangle)rect)) : (peak.getX() < (double)Geometry.left((Rectangle)rect) ? new Point2D.Double(Geometry.left((Rectangle)rect), Geometry.midy((Rectangle)rect)) : new Point2D.Double(Geometry.right((Rectangle)rect), Geometry.midy((Rectangle)rect))));
        return anchor;
    }

    protected void computeConnections() {
        this.connections = new HashMap();
        this.connections_cp = new HashMap();
        for (AnnotationObject a : this.theDocument.getAnnotations()) {
            boolean add_cp;
            Rectangle rect = this.rectangles_complete.get(a);
            Point2D cp = this.dataToScreenCoords(this.theDocument.getControlPoint(a));
            Point2D peak = this.dataToScreenCoords(a.getPeakPoint());
            Point2D anchor = this.computeAnchor(rect, cp, peak);
            boolean bl = add_cp = peak.getY() > (double)Geometry.bottom((Rectangle)rect);
            if (!(anchor.distance(peak) > 10.0)) continue;
            Polygon connection = new Polygon();
            connection.addPoint((int)anchor.getX(), (int)anchor.getY());
            if (add_cp) {
                connection.addPoint((int)cp.getX(), (int)cp.getY());
            }
            connection.addPoint((int)peak.getX(), (int)peak.getY());
            if (add_cp) {
                connection.addPoint((int)cp.getX(), (int)cp.getY());
            }
            this.connections.put(a, connection);
            if (!add_cp) continue;
            this.connections_cp.put(a, cp);
        }
    }

    protected void paintAnnotations(Graphics2D g2d) {
        DecimalFormat mz_df = new DecimalFormat("0.0");
        Font old_font = g2d.getFont();
        Font new_font = new Font(this.theOptions.ANNOTATION_MZ_FONT, 0, this.theOptions.ANNOTATION_MZ_SIZE);
        PositionManager pman = new PositionManager();
        BBoxManager bbman = new BBoxManager();
        this.computeRectangles(pman, bbman);
        this.computeConnections();
        for (AnnotationObject a : this.theDocument.getAnnotations()) {
            boolean selected = !this.is_printing && this.selections.contains(a);
            Polygon connection = this.connections.get(a);
            if (connection != null) {
                g2d.setColor(this.theOptions.CONNECTION_LINES_COLOR);
                g2d.setStroke(selected ? new BasicStroke((float)(1.0 + this.theOptions.ANNOTATION_LINE_WIDTH)) : new BasicStroke((float)this.theOptions.ANNOTATION_LINE_WIDTH));
                g2d.draw(connection);
                g2d.setStroke(new BasicStroke(1.0f));
            }
            if (!selected) continue;
            g2d.setColor(Color.black);
            Point2D cp = this.connections_cp.get(a);
            if (cp == null) continue;
            int s = (int)(2.0 + this.theOptions.ANNOTATION_LINE_WIDTH);
            g2d.fill(new Rectangle((int)cp.getX() - s, (int)cp.getY() - s, 2 * s, 2 * s));
        }
        for (AnnotationObject a : this.theDocument.getAnnotations()) {
            boolean highlighted = a.isHighlighted();
            boolean selected = !this.is_printing && this.selections.contains(a);
            this.theGlycanRenderer.getGraphicOptions().setScale(this.theOptions.SCALE_GLYCANS * this.theDocument.getScale(a));
            if (highlighted) {
                Rectangle c_bbox = this.rectangles_complete.get(a);
                g2d.setColor(this.theOptions.HIGHLIGHTED_COLOR);
                g2d.setXORMode(Color.white);
                g2d.fill(c_bbox);
                g2d.setPaintMode();
                g2d.setColor(Color.black);
                g2d.draw(c_bbox);
            }
            for (Glycan s : a.getStructures()) {
                this.theGlycanRenderer.paint((Paintable)new DefaultPaintable(g2d), s, null, null, false, false, pman, bbman);
            }
            g2d.setFont(new_font);
            g2d.setColor(this.theOptions.MASS_TEXT_COLOR);
            String mz_text = mz_df.format(a.getPeakPoint().getX());
            Rectangle mz_bbox = this.rectangles_text.get(a);
            g2d.drawString(mz_text, mz_bbox.x, mz_bbox.y + mz_bbox.height);
            if (!selected) continue;
            Rectangle c_bbox = this.rectangles_complete.get(a);
            g2d.setStroke(new BasicStroke(highlighted ? 2.0f : 1.0f));
            g2d.setColor(Color.black);
            g2d.draw(c_bbox);
            g2d.setStroke(new BasicStroke(1.0f));
            Polygon p1 = new Polygon();
            int cx1 = Geometry.right((Rectangle)c_bbox);
            int cy1 = Geometry.top((Rectangle)c_bbox);
            p1.addPoint(cx1, cy1);
            p1.addPoint(cx1 - 2 * this.theOptions.ANNOTATION_MARGIN / 3, cy1);
            p1.addPoint(cx1, cy1 + 2 * this.theOptions.ANNOTATION_MARGIN / 3);
            g2d.fill(p1);
            Polygon p2 = new Polygon();
            int cx2 = Geometry.left((Rectangle)c_bbox);
            int cy2 = Geometry.top((Rectangle)c_bbox);
            p2.addPoint(cx2, cy2);
            p2.addPoint(cx2 + 2 * this.theOptions.ANNOTATION_MARGIN / 3, cy2);
            p2.addPoint(cx2, cy2 + 2 * this.theOptions.ANNOTATION_MARGIN / 3);
            g2d.fill(p2);
        }
        g2d.setFont(old_font);
    }

    private void xorRectangle(Point start_point, Point end_point) {
        Graphics g = this.getGraphics();
        g.setXORMode(Color.white);
        g.setColor(Color.gray);
        Rectangle rect = Geometry.makeRectangle((Point)start_point, (Point)end_point);
        g.drawRect(rect.x, rect.y, rect.width, rect.height);
    }

    private void xorSelections(Point start_point, Point end_point) {
        Graphics g = this.getGraphics();
        g.setXORMode(Color.white);
        g.setColor(Color.gray);
        int dx = end_point.x - start_point.x;
        int dy = end_point.y - start_point.y;
        for (AnnotationObject a : this.selections) {
            Rectangle rect = this.rectangles_complete.get(a);
            g.drawRect(dx + rect.x, dy + rect.y, rect.width, rect.height);
        }
    }

    private double scaleFactor(AnnotationObject selection, Point start_point, Point end_point) {
        Rectangle rect = this.rectangles.get(selection);
        double scale = 1.0;
        scale = start_point.x > Geometry.midx((Rectangle)rect) ? Math.min(((double)(end_point.x - start_point.x) + (double)rect.width / 2.0) / ((double)rect.width / 2.0), (double)(start_point.y - end_point.y + rect.height) / (double)rect.height) : Math.min(((double)(start_point.x - end_point.x) + (double)rect.width / 2.0) / ((double)rect.width / 2.0), (double)(start_point.y - end_point.y + rect.height) / (double)rect.height);
        return Math.max(0.0, scale);
    }

    private void xorConnection(AnnotationObject selection, Point start_point, Point end_point) {
        Graphics g = this.getGraphics();
        g.setXORMode(Color.white);
        g.setColor(Color.gray);
        Rectangle rect = this.rectangles_complete.get(selection);
        Point2D peak = this.dataToScreenCoords(selection.getPeakPoint());
        Point2D anchor = this.computeAnchor(rect, end_point, peak);
        g.drawLine((int)anchor.getX(), (int)anchor.getY(), (int)end_point.getX(), (int)end_point.getY());
        g.drawLine((int)end_point.getX(), (int)end_point.getY(), (int)peak.getX(), (int)peak.getY());
    }

    private void xorResizing(AnnotationObject selection, Point start_point, Point end_point) {
        Graphics g = this.getGraphics();
        g.setXORMode(Color.white);
        g.setColor(Color.gray);
        Rectangle rect = this.rectangles.get(selection);
        double scale = 1.0;
        scale = start_point.x > Geometry.midx((Rectangle)rect) ? Math.min(((double)(end_point.x - start_point.x) + (double)rect.width / 2.0) / ((double)rect.width / 2.0), (double)(start_point.y - end_point.y + rect.height) / (double)rect.height) : Math.min(((double)(start_point.x - end_point.x) + (double)rect.width / 2.0) / ((double)rect.width / 2.0), (double)(start_point.y - end_point.y + rect.height) / (double)rect.height);
        scale = Math.max(0.0, scale);
        g.drawRect((int)((double)Geometry.midx((Rectangle)rect) - (double)rect.width * scale / 2.0), (int)((double)Geometry.bottom((Rectangle)rect) - (double)rect.height * scale), (int)((double)rect.width * scale), (int)((double)rect.height * scale));
    }

    @Override
    public Dimension getPreferredSize() {
        if (this.is_printing) {
            return this.draw_area.getSize();
        }
        return this.theOptions.getViewDimension(this.draw_area.getSize());
    }

    @Override
    public Dimension getMinimumSize() {
        return new Dimension(0, 0);
    }

    public double screenToDataX(double length) {
        return length / this.thePlot.getDomainAxis().lengthToJava2D(1.0, this.data_area, this.thePlot.getDomainAxisEdge());
    }

    public double screenToDataY(double length) {
        return length / this.thePlot.getRangeAxis().lengthToJava2D(1.0, this.data_area, this.thePlot.getRangeAxisEdge());
    }

    public Point2D screenToDataCoords(Point2D p) {
        double x = this.thePlot.getDomainAxis().java2DToValue(p.getX(), this.data_area, this.thePlot.getDomainAxisEdge());
        double y = this.thePlot.getRangeAxis().java2DToValue(p.getY(), this.data_area, this.thePlot.getRangeAxisEdge());
        return new Point2D.Double(x, y);
    }

    public Point2D dataToScreenCoords(Point2D p) {
        double x = this.thePlot.getDomainAxis().valueToJava2D(p.getX(), this.data_area, this.thePlot.getDomainAxisEdge());
        double y = this.thePlot.getRangeAxis().valueToJava2D(p.getY(), this.data_area, this.thePlot.getRangeAxisEdge());
        return new Point2D.Double(x, y);
    }

    public AnnotationObject getAnnotationAtPoint(Point2D p) {
        for (Map.Entry<AnnotationObject, Rectangle> e : this.rectangles_complete.entrySet()) {
            if (!e.getValue().contains(p)) continue;
            return e.getKey();
        }
        return null;
    }

    public AnnotationObject getConnectionAtPoint(Point2D p) {
        for (Map.Entry<AnnotationObject, Polygon> e : this.connections.entrySet()) {
            if (!e.getValue().intersects(p.getX() - 3.0, p.getY() - 3.0, 6.0, 6.0)) continue;
            return e.getKey();
        }
        return null;
    }

    public AnnotationObject getCPAtPoint(Point2D p) {
        for (Map.Entry<AnnotationObject, Point2D> e : this.connections_cp.entrySet()) {
            if (!(e.getValue().distance(p) <= 3.0)) continue;
            return e.getKey();
        }
        return null;
    }

    public Collection<AnnotationObject> getAnnotationsInside(Rectangle r) {
        Vector<AnnotationObject> ret = new Vector<AnnotationObject>();
        if (r != null) {
            for (Map.Entry<AnnotationObject, Rectangle> e : this.rectangles_complete.entrySet()) {
                if (!r.intersects(e.getValue())) continue;
                ret.add(e.getKey());
            }
        }
        return ret;
    }

    public void selectAll() {
        this.selections.addAll(this.theDocument.getAnnotations());
        this.fireUpdatedSelection();
    }

    public void enforceSelection(Point2D p) {
        AnnotationObject a = this.getAnnotationAtPoint(p);
        if (a == null) {
            a = this.getConnectionAtPoint(p);
        }
        if (!this.isSelected(a)) {
            this.setSelection(a);
        }
    }

    public void resetSelection() {
        this.selections = new HashSet();
        this.fireUpdatedSelection();
    }

    public boolean hasSelection() {
        return this.selections.size() > 0;
    }

    public boolean isSelected(AnnotationObject a) {
        return this.selections.contains(a);
    }

    public void setSelection(AnnotationObject a) {
        this.selections.clear();
        if (a != null) {
            this.selections.add(a);
        }
        this.fireUpdatedSelection();
    }

    public void addSelection(AnnotationObject a) {
        if (a != null) {
            this.selections.add(a);
            this.fireUpdatedSelection();
        }
    }

    public void setSelection(Collection<AnnotationObject> toselect) {
        this.selections.clear();
        this.selections.addAll(toselect);
        this.fireUpdatedSelection();
    }

    public void addSelection(Collection<AnnotationObject> toselect) {
        this.selections.addAll(toselect);
        this.fireUpdatedSelection();
    }

    public void print(PrinterJob job) throws PrinterException {
        this.is_printing = true;
        job.print();
        this.is_printing = false;
    }

    @Override
    public int print(Graphics g, PageFormat pageFormat, int pageIndex) throws PrinterException {
        if (pageIndex > 0) {
            return 1;
        }
        Graphics2D g2d = (Graphics2D)g;
        g2d.setBackground(Color.white);
        g2d.translate(pageFormat.getImageableX(), pageFormat.getImageableY());
        Dimension td = this.getPreferredSize();
        double sx = pageFormat.getImageableWidth() / (double)td.width;
        double sy = pageFormat.getImageableHeight() / (double)td.height;
        double s = Math.min(sx, sy);
        if (s < 1.0) {
            g2d.scale(s, s);
        }
        RepaintManager.currentManager(this).setDoubleBufferingEnabled(false);
        this.paint(g2d);
        RepaintManager.currentManager(this).setDoubleBufferingEnabled(true);
        return 0;
    }

    public void setScale(double scale) {
        this.theOptions.setScale(scale);
        double scaleg = this.theGraphicOptions.setScale(this.theOptions.SCALE_GLYCANS);
        this.theOptions.setScale(scale * scaleg / this.theOptions.SCALE_GLYCANS);
        this.updateView();
    }

    public double getScale() {
        return this.theOptions.SCALE;
    }

    public void moveSelections(int dx, int dy) {
        HashSet<AnnotationObject> old_selections = this.selections;
        double ddx = this.screenToDataX(dx);
        double ddy = this.screenToDataY(dy);
        this.theDocument.move(this.selections, ddx, ddy);
        this.selections = old_selections;
    }

    public void moveControlPointTo(AnnotationObject selection, Point2D p) {
        Point2D dp = this.screenToDataCoords(p);
        this.theDocument.moveControlPointTo(selection, dp.getX(), dp.getY());
    }

    public void rescaleSelections(double factor) {
        HashSet<AnnotationObject> old_selections = this.selections;
        this.theDocument.rescale(this.selections, factor);
        this.selections = old_selections;
    }

    public void resetSelectionsScale() {
        HashSet<AnnotationObject> old_selections = this.selections;
        this.theDocument.resetScale(this.selections);
        this.selections = old_selections;
    }

    public void highlightSelections() {
        HashSet<AnnotationObject> old_selections = this.selections;
        boolean all_highlighted = true;
        for (AnnotationObject a : this.selections) {
            all_highlighted = all_highlighted && a.isHighlighted();
        }
        this.theDocument.setHighlighted(this.selections, !all_highlighted);
        this.selections = old_selections;
    }

    public void updateAnnotations(Glycan parent, PeakAnnotationCollection pac, boolean merge) {
        Vector<AnnotationObject> added = new Vector<AnnotationObject>();
        boolean changed = this.theDocument.updateData(parent, pac, added, false, merge);
        if (added.size() > 0) {
            this.updateDrawArea(false);
            this.resetSelection();
            this.repaint();
            this.placeStructures(added, false);
        } else if (changed) {
            this.theDocument.fireDocumentChanged();
        }
    }

    public void cut() {
        this.copy();
        this.delete();
    }

    public void copy() {
        Vector<Glycan> sel_structures = new Vector<Glycan>();
        for (AnnotationObject a : this.selections) {
            sel_structures.addAll(a.getStructures());
        }
        ClipUtils.setContents((Transferable)new GlycanSelection((GlycanRenderer)this.theGlycanRenderer, sel_structures));
    }

    public void delete() {
        this.theDocument.remove(this.selections);
    }

    public void getScreenshot() {
        ClipUtils.setContents((BufferedImage)this.getImage());
    }

    public BufferedImage getImage() {
        Dimension d = this.getPreferredSize();
        BufferedImage img = GraphicUtils.createCompatibleImage((int)d.width, (int)d.height, (boolean)false);
        Graphics2D g2d = img.createGraphics();
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2d.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_OFF);
        g2d.setBackground(new Color(255, 255, 255, 0));
        this.is_printing = true;
        this.paint(g2d);
        this.is_printing = false;
        return img;
    }

    public void placeStructures() {
        this.placeStructures(this.theDocument.getAnnotations(), false);
    }

    private void placeStructures(boolean init) {
        this.placeStructures(this.theDocument.getAnnotations(), init);
    }

    private void placeStructures(Vector<AnnotationObject> annotations, boolean init) {
        double y = this.thePlot.getRangeAxis().getRange().getUpperBound();
        double cur_x = this.thePlot.getDomainAxis().getRange().getLowerBound();
        double all_width = 0.0;
        for (AnnotationObject a : annotations) {
            if (!a.hasAnnotations()) continue;
            all_width += this.screenToDataX(this.rectangles_complete.get((Object)a).width);
        }
        double min_pp_x = annotations.firstElement().getPeakPoint().getX();
        double max_pp_x = annotations.lastElement().getPeakPoint().getX();
        double center_pp_x = (max_pp_x + min_pp_x) / 2.0;
        cur_x = Math.max(cur_x, center_pp_x - all_width / 2.0);
        for (AnnotationObject a : annotations) {
            Point2D pp = a.getPeakPoint();
            if (a.hasAnnotations()) {
                double cur_width = this.screenToDataX(this.rectangles_complete.get((Object)a).width);
                double x = cur_x + cur_width / 2.0;
                this.theDocument.getAnchor(a).setLocation(x, y);
                this.theDocument.getControlPoints().put(a, this.theDocument.computeControlPoint(new Point2D.Double(x, y), pp));
                cur_x += cur_width;
                continue;
            }
            this.theDocument.getAnchor(a).setLocation(pp.getX(), pp.getY());
            this.theDocument.getControlPoints().put(a, this.theDocument.computeControlPoint(pp, pp));
        }
        block2: for (int i = 0; i < annotations.size(); ++i) {
            Point2D cpl;
            Point2D aal;
            AnnotationObject al;
            int l;
            AnnotationObject ai = annotations.get(i);
            Point2D aai = this.theDocument.getAnchor(ai);
            Point2D cpi = this.theDocument.getControlPoint(ai);
            if (aai.getX() < cpi.getX()) {
                for (l = i + 1; l < annotations.size(); ++l) {
                    al = annotations.get(l);
                    aal = this.theDocument.getAnchor(al);
                    cpl = this.theDocument.getControlPoint(al);
                    if (aal.getX() > cpi.getX() || !(cpl.getY() < cpi.getY())) continue block2;
                    cpl.setLocation(cpl.getX(), cpi.getY());
                    ai = al;
                    aai = aal;
                    cpi = cpl;
                }
                continue;
            }
            for (l = i - 1; l >= 0; --l) {
                al = annotations.get(l);
                aal = this.theDocument.getAnchor(al);
                cpl = this.theDocument.getControlPoint(al);
                if (aal.getX() < cpi.getX() || !(cpl.getY() < cpi.getY())) continue block2;
                cpl.setLocation(cpl.getX(), cpi.getY());
                ai = al;
                aai = aal;
                cpi = cpl;
            }
        }
        if (init) {
            this.theDocument.fireDocumentInit();
        } else {
            this.theDocument.fireDocumentChanged();
        }
    }

    public boolean canGroupSelections() {
        return this.theDocument.canGroup(this.selections);
    }

    public void groupSelections() {
        this.theDocument.group(this.selections);
    }

    public void ungroupSelections() {
        this.theDocument.ungroup(this.selections, this);
    }

    public void documentInit(BaseDocument.DocumentChangeEvent e) {
        this.updateChart();
        this.resetSelection();
        this.updateView();
        this.updateView();
    }

    public void documentChanged(BaseDocument.DocumentChangeEvent e) {
        this.updateDrawArea(false);
        this.resetSelection();
        this.thePlot.getRenderer().setPaint((Paint)this.theOptions.SPECTRUM_COLOR);
        this.repaint();
    }

    public void addSelectionChangeListener(SelectionChangeListener l) {
        if (l != null) {
            this.listeners.add(l);
        }
    }

    public void removeSelectionChangeListener(SelectionChangeListener l) {
        if (l != null) {
            this.listeners.remove(l);
        }
    }

    public void fireUpdatedSelection() {
        Iterator<SelectionChangeListener> i = this.listeners.iterator();
        while (i.hasNext()) {
            i.next().selectionChanged(new SelectionChangeEvent(this));
        }
        this.repaint();
    }

    public void updateView() {
        this.updateDrawArea(true);
        this.updateData();
        this.repaint();
    }

    private void updateChart() {
        String x_label = "m/z ratio";
        String y_label = this.theDocument.isShowRelativeIntensities() ? "Intensity %" : "Intensity";
        this.theDataset = new DefaultXYDataset();
        if (this.theDocument.getPeakData() != null) {
            if (this.theOptions.SHOW_COMPLETE_PEAK_LIST) {
                this.theChart = ChartFactory.createScatterPlot(null, (String)x_label, (String)y_label, (XYDataset)new XYBarDataset((XYDataset)this.theDataset, 0.001), (PlotOrientation)PlotOrientation.VERTICAL, (boolean)false, (boolean)false, (boolean)false);
                this.thePlot = (XYPlot)this.theChart.getPlot();
                this.thePlot.setRenderer((XYItemRenderer)new XYBarRenderer());
            } else {
                this.theChart = ChartFactory.createScatterPlot(null, (String)x_label, (String)y_label, (XYDataset)this.theDataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)false, (boolean)false, (boolean)false);
                this.thePlot = (XYPlot)this.theChart.getPlot();
                this.thePlot.setRenderer((XYItemRenderer)new StandardXYItemRenderer(2));
            }
        } else {
            this.theChart = ChartFactory.createScatterPlot(null, (String)x_label, (String)y_label, (XYDataset)new XYBarDataset((XYDataset)this.theDataset, 0.001), (PlotOrientation)PlotOrientation.VERTICAL, (boolean)false, (boolean)false, (boolean)false);
            this.thePlot = (XYPlot)this.theChart.getPlot();
            this.thePlot.setRenderer((XYItemRenderer)new XYBarRenderer());
        }
        if (this.theDocument.isShowRelativeIntensities() && this.theOptions.SHOW_MAX_INTENSITY) {
            NumberAxis second_axis = new NumberAxis("");
            this.thePlot.setRangeAxis(1, (ValueAxis)second_axis);
            this.maxIntensityDataset = new DefaultXYDataset();
            this.thePlot.setDataset(1, (XYDataset)this.maxIntensityDataset);
            this.thePlot.mapDatasetToRangeAxis(1, 1);
            StandardXYItemRenderer r = new StandardXYItemRenderer(1);
            r.setBaseShapesVisible(false);
            this.thePlot.setRenderer(1, (XYItemRenderer)r);
        }
        this.theChart.setBackgroundPaint((Paint)Color.white);
        this.theChart.setBorderVisible(false);
        this.thePlot.getRenderer().setPaint((Paint)this.theOptions.SPECTRUM_COLOR);
        this.thePlot.setOutlinePaint(null);
        this.thePlot.setDomainGridlinesVisible(false);
        this.thePlot.setRangeGridlinesVisible(false);
    }

    private void updateData() {
        double[][] data = this.theDocument.getData(this.data_area, false);
        if (this.theDocument.isShowRelativeIntensities() && data != null && data[0].length > 0) {
            int i;
            double min_int = data[1][0];
            double max_int = data[1][0];
            for (i = 1; i < data[1].length; ++i) {
                max_int = Math.max(max_int, data[1][i]);
                min_int = Math.min(min_int, data[1][i]);
            }
            for (i = 0; i < data[1].length; ++i) {
                data[1][i] = 100.0 * data[1][i] / max_int;
            }
            if (this.maxIntensityDataset != null) {
                double[][] s = new double[][]{{data[0][0], data[0][data[0].length - 1]}, {min_int, max_int}};
                this.maxIntensityDataset.removeSeries((Comparable)((Object)"max"));
                this.maxIntensityDataset.addSeries((Comparable)((Object)"max"), (double[][])s);
                ((NumberAxis)this.thePlot.getRangeAxis(1)).setTickUnit(new NumberTickUnit(max_int));
            }
        }
        this.theDataset.removeSeries((Comparable)((Object)"intensities"));
        this.theDataset.addSeries((Comparable)((Object)"intensities"), data);
    }

    protected void updateDrawArea(boolean update_chart) {
        if (update_chart) {
            this.draw_area = this.theOptions.getDefaultDrawArea();
            this.chart_area = this.theOptions.getDefaultChartArea();
            this.data_area = null;
            this.paintChart(GraphicUtils.createImage((Dimension)this.theOptions.getDefaultViewDimension(), (boolean)true).createGraphics());
        }
        Rectangle all_bbox = this.computeRectangles();
        int add_left = Math.max(0, this.chart_area.x - all_bbox.x);
        int add_top = Math.max(0, this.chart_area.y - all_bbox.y);
        int add_right = Math.max(0, all_bbox.x + all_bbox.width - this.chart_area.x - this.chart_area.width);
        int add_bottom = Math.max(0, all_bbox.y + all_bbox.height - this.chart_area.y - this.chart_area.height);
        this.draw_area.width = this.chart_area.width + add_left + add_right + 2 * this.theOptions.CHART_X_MARGIN;
        this.draw_area.height = this.chart_area.height + add_top + add_bottom + 2 * this.theOptions.CHART_Y_MARGIN;
        this.chart_area.x = this.draw_area.x + add_left + this.theOptions.CHART_X_MARGIN;
        this.chart_area.y = this.draw_area.y + add_top + this.theOptions.CHART_Y_MARGIN;
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    public boolean isInResizeCorner(AnnotationObject selection, Point p) {
        Rectangle rect = this.rectangles_complete.get(selection);
        int size = 2 * this.theOptions.ANNOTATION_MARGIN / 3;
        Rectangle corner1 = new Rectangle(Geometry.left((Rectangle)rect), Geometry.top((Rectangle)rect), size, size);
        if (corner1.contains(p)) {
            return true;
        }
        Rectangle corner2 = new Rectangle(Geometry.right((Rectangle)rect) - size, Geometry.top((Rectangle)rect), size, size);
        return corner2.contains(p);
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (MouseUtils.isPushTrigger((MouseEvent)e) || MouseUtils.isCtrlPushTrigger((MouseEvent)e)) {
            this.start_position = this.getAnnotationAtPoint(e.getPoint());
            this.mouse_start_point = e.getPoint();
            this.mouse_end_point = null;
            if (this.start_position != null) {
                if (this.isInResizeCorner(this.start_position, this.mouse_start_point)) {
                    this.setSelection(this.start_position);
                    this.is_resizing = true;
                } else {
                    if (!this.isSelected(this.start_position)) {
                        this.setSelection(this.start_position);
                    }
                    this.is_dragndrop = true;
                }
            } else {
                this.start_position = this.getCPAtPoint(e.getPoint());
                if (this.start_position != null) {
                    this.setSelection(this.start_position);
                    this.is_movingcp = true;
                } else {
                    this.is_dragndrop = false;
                }
            }
        }
        this.was_dragged = false;
    }

    @Override
    public void mouseMoved(MouseEvent e) {
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        this.was_dragged = true;
        if (this.is_dragndrop) {
            if (this.mouse_end_point != null) {
                this.xorSelections(this.mouse_start_point, this.mouse_end_point);
            }
            this.mouse_end_point = e.getPoint();
            this.xorSelections(this.mouse_start_point, this.mouse_end_point);
        } else if (this.is_resizing) {
            if (this.mouse_end_point != null) {
                this.xorResizing(this.start_position, this.mouse_start_point, this.mouse_end_point);
            }
            this.mouse_end_point = e.getPoint();
            this.xorResizing(this.start_position, this.mouse_start_point, this.mouse_end_point);
        } else if (this.is_movingcp) {
            if (this.mouse_end_point != null) {
                this.xorConnection(this.start_position, this.mouse_start_point, this.mouse_end_point);
            }
            this.mouse_end_point = e.getPoint();
            this.xorConnection(this.start_position, this.mouse_start_point, this.mouse_end_point);
        } else if (this.mouse_start_point != null) {
            if (this.mouse_end_point != null) {
                this.xorRectangle(this.mouse_start_point, this.mouse_end_point);
            }
            this.mouse_end_point = e.getPoint();
            this.xorRectangle(this.mouse_start_point, this.mouse_end_point);
        }
        this.dragAndScroll(e);
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (this.is_dragndrop && this.was_dragged) {
            if (this.mouse_end_point != null) {
                this.xorSelections(this.mouse_start_point, this.mouse_end_point);
            }
            this.moveSelections(e.getPoint().x - this.mouse_start_point.x, e.getPoint().y - this.mouse_start_point.y);
        } else if (this.is_resizing && this.was_dragged) {
            if (this.mouse_end_point != null) {
                this.xorResizing(this.start_position, this.mouse_start_point, this.mouse_end_point);
            }
            this.rescaleSelections(this.scaleFactor(this.start_position, this.mouse_start_point, e.getPoint()));
        } else if (this.is_movingcp && this.was_dragged) {
            if (this.mouse_end_point != null) {
                this.xorConnection(this.start_position, this.mouse_start_point, this.mouse_end_point);
            }
            this.moveControlPointTo(this.start_position, e.getPoint());
        } else if (this.mouse_start_point != null) {
            if (this.mouse_end_point != null) {
                this.xorRectangle(this.mouse_start_point, this.mouse_end_point);
            }
            Rectangle mouse_rect = Geometry.makeRectangle((Point)this.mouse_start_point, (Point)e.getPoint());
            if (MouseUtils.isNothingPressed((MouseEvent)e)) {
                this.setSelection(this.getAnnotationsInside(mouse_rect));
            } else if (MouseUtils.isCtrlPressed((MouseEvent)e)) {
                this.addSelection(this.getAnnotationsInside(mouse_rect));
            }
        }
        this.start_position = null;
        this.is_resizing = false;
        this.is_movingcp = false;
        this.is_dragndrop = false;
        this.was_dragged = false;
        this.mouse_start_point = null;
        this.mouse_end_point = null;
        this.repaint();
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        AnnotationObject a = this.getAnnotationAtPoint(e.getPoint());
        if (a == null) {
            a = this.getConnectionAtPoint(e.getPoint());
        }
        if (a != null) {
            if (MouseUtils.isAddSelectTrigger((MouseEvent)e) || MouseUtils.isSelectAllTrigger((MouseEvent)e)) {
                this.addSelection(a);
            } else if (MouseUtils.isSelectTrigger((MouseEvent)e)) {
                this.setSelection(a);
            }
        } else {
            this.resetSelection();
        }
    }

    private void dragAndScroll(MouseEvent e) {
        Point point = e.getPoint();
        JViewport view = this.theScrollPane.getViewport();
        Rectangle inner = view.getViewRect();
        inner.grow(-10, -10);
        if (!inner.contains(point)) {
            Point orig = view.getViewPosition();
            if (point.x < inner.x) {
                orig.x -= 10;
            } else if (point.x > inner.x + inner.width) {
                orig.x += 10;
            }
            if (point.y < inner.y) {
                orig.y -= 10;
            } else if (point.y > inner.y + inner.height) {
                orig.y += 10;
            }
            int maxx = this.getBounds().width - view.getViewRect().width;
            int maxy = this.getBounds().height - view.getViewRect().height;
            if (orig.x < 0) {
                orig.x = 0;
            }
            if (orig.x > maxx) {
                orig.x = maxx;
            }
            if (orig.y < 0) {
                orig.y = 0;
            }
            if (orig.y > maxy) {
                orig.y = maxy;
            }
            view.setViewPosition(orig);
        }
    }

    public static class SelectionChangeEvent {
        private AnnotationReportCanvas src;

        public SelectionChangeEvent(AnnotationReportCanvas _src) {
            this.src = _src;
        }

        public AnnotationReportCanvas getSource() {
            return this.src;
        }
    }

    public static interface SelectionChangeListener {
        public void selectionChanged(SelectionChangeEvent var1);
    }
}

