/*
 * Decompiled with CFR 0.152.
 */
package org.eurocarbdb.application.glycoworkbench.plugin.peakpicker;

import org.eurocarbdb.application.glycoworkbench.Peak;

public class ContinuousWaveletTransform {
    protected Peak[] signal_;
    protected double[] wavelet_;
    protected double scale_ = 0.0;
    protected double spacing_ = 0.0;
    protected int signal_length_ = 0;
    protected int end_left_padding_ = 0;
    protected int begin_right_padding_ = 0;

    public Peak[] getSignal() {
        return this.signal_;
    }

    public void setSignal(Peak[] signal) {
        this.signal_ = signal;
    }

    public double[] getWavelet() {
        return this.wavelet_;
    }

    public void setWavelet(double[] wavelet) {
        this.wavelet_ = wavelet;
    }

    public double getScale() {
        return this.scale_;
    }

    public void setScale(double scale) {
        this.scale_ = scale;
    }

    public double getSpacing() {
        return this.spacing_;
    }

    public void setSpacing(double spacing) {
        this.spacing_ = spacing;
    }

    public int getLeftPaddingIndex() {
        return this.end_left_padding_;
    }

    public void setLeftPaddingIndex(int end_left_padding) {
        this.end_left_padding_ = end_left_padding;
    }

    public int getRightPaddingIndex() {
        return this.begin_right_padding_;
    }

    public void setRightPaddingIndex(int begin_right_padding) {
        this.begin_right_padding_ = begin_right_padding;
    }

    public int getSignalLength() {
        return this.signal_length_;
    }

    public void setSignalLength(int signal_length) {
        this.signal_length_ = signal_length;
    }

    public int getSize() {
        return this.signal_.length;
    }

    public void init(double scale, double spacing) {
        this.scale_ = scale;
        this.spacing_ = spacing;
    }

    public double get(int i) {
        return this.signal_[i].getIntensity();
    }

    protected double getInterpolatedValue_(Peak[] data, double x, int it_left) {
        double left_position = data[it_left].getMZ();
        double right_position = data[it_left + 1].getMZ();
        double d = (x - left_position) / (right_position - left_position);
        return data[it_left + 1].getIntensity() * d + data[it_left].getIntensity() * (1.0 - d);
    }
}

