/*
 * Decompiled with CFR 0.152.
 */
package org.eurocarbdb.application.glycoworkbench.plugin;

import java.util.Vector;
import org.eurocarbdb.application.glycanbuilder.FragmentEntry;
import org.eurocarbdb.application.glycanbuilder.FragmentSource;
import org.eurocarbdb.application.glycanbuilder.GWSParser;
import org.eurocarbdb.application.glycanbuilder.Glycan;
import org.eurocarbdb.application.glycanbuilder.MassOptions;
import org.eurocarbdb.application.glycanbuilder.SAXUtils;
import org.eurocarbdb.application.glycanbuilder.TextUtils;
import org.eurocarbdb.application.glycanbuilder.XMLUtils;
import org.eurocarbdb.application.glycoworkbench.plugin.ProfilerOptions;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class StructureType
implements FragmentSource {
    String database = "";
    String type = "";
    String source = "";
    String structure = "";

    public StructureType() {
    }

    public StructureType(Glycan glycan) {
        this.structure = GWSParser.toString((Glycan)glycan);
    }

    public StructureType(String d, String t, String s, String g) {
        this.database = "" + d;
        this.type = "" + t;
        this.source = "" + s;
        this.structure = "" + g.split("\\$")[0];
    }

    public StructureType(String init) throws Exception {
        Vector tokens = TextUtils.tokenize((String)init, (String)"\t");
        if (tokens.size() != 4) {
            throw new Exception("Invalid string format: " + init);
        }
        this.database = (String)tokens.elementAt(0);
        this.type = (String)tokens.elementAt(1);
        this.source = (String)tokens.elementAt(2);
        this.structure = ((String)tokens.elementAt(3)).split("\\$")[0];
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof StructureType)) {
            return false;
        }
        StructureType other = (StructureType)o;
        return other.database.equals(this.database) && other.type.equals(this.type) && other.source.equals(this.source) && other.structure.equals(this.structure);
    }

    public int hashCode() {
        return this.database.hashCode() + this.type.hashCode() + this.source.hashCode() + this.structure.hashCode();
    }

    public StructureType clone(String dict_name) {
        if (this.database == null || this.database.length() == 0 || this.database.equals("unknown")) {
            return new StructureType(dict_name, this.type, this.source, this.structure);
        }
        return new StructureType(this.database, this.type, this.source, this.structure);
    }

    public String getDatabase() {
        return this.database;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String t) {
        this.type = t;
    }

    public String getSource() {
        return this.source;
    }

    public void setSource(String s) {
        this.source = s;
    }

    public String getStructure() {
        return this.structure;
    }

    public void setStructure(String s) {
        this.structure = s;
    }

    public boolean merge(StructureType other) {
        if (other == null) {
            return false;
        }
        if (!other.structure.equals(this.structure)) {
            return false;
        }
        boolean changed = false;
        if (!other.type.equals("unknown") && !TextUtils.tokenize((String)this.type, (String)",").contains(other.type)) {
            this.type = this.type.equals("unknown") ? other.type : this.type + ", " + other.type;
            changed = true;
        }
        if (!other.source.equals("unknown") && !TextUtils.tokenize((String)this.source, (String)",").contains(other.source)) {
            this.source = this.source.equals("unknown") ? other.source : this.source + ", " + other.source;
            changed = true;
        }
        return changed;
    }

    public FragmentEntry generateFragmentEntry(MassOptions mass_opt) throws Exception {
        Glycan g = this.generateStructure(mass_opt);
        FragmentEntry ret = new FragmentEntry();
        ret.fragment = g;
        ret.name = this.getDescription();
        ret.mass = g.computeMass();
        ret.mz_ratio = g.getChargesAndExchanges().computeMZ(ret.mass.doubleValue());
        ret.structure = this.structure;
        ret.source = this;
        return ret;
    }

    public Glycan generateStructure(ProfilerOptions opt) throws Exception {
        Glycan ret = Glycan.fromString((String)this.structure, (MassOptions)new MassOptions());
        ret.setMassOptions(opt.getMassOptions());
        return ret;
    }

    public Glycan generateStructure(MassOptions mass_opt) throws Exception {
        Glycan ret = Glycan.fromString((String)this.structure, (MassOptions)new MassOptions());
        if (ret == null) {
            return null;
        }
        ret.setMassOptions(mass_opt);
        return ret;
    }

    public Glycan generateStructure() throws Exception {
        return this.generateStructure(new MassOptions("Und"));
    }

    public String getDescription() {
        StringBuilder desc = new StringBuilder();
        if (!this.type.equals("unknown")) {
            desc.append(this.type);
        }
        if (!this.source.equals("unknown")) {
            if (desc.length() > 0) {
                desc.append(": ");
            }
            desc.append(this.source);
        }
        if (!this.source.equals("unknown")) {
            if (desc.length() > 0) {
                desc.append(' ');
            }
            desc.append('(');
            desc.append(this.database);
            desc.append(')');
        }
        return desc.toString();
    }

    public static StructureType fromString(String str) throws Exception {
        String[] tokens = str.split("\t");
        if (tokens.length != 4) {
            throw new Exception("Invalid format");
        }
        StructureType ret = new StructureType();
        ret.database = tokens[0];
        ret.type = tokens[1];
        ret.source = tokens[2];
        ret.structure = tokens[3];
        return ret;
    }

    public String toString() {
        return this.database + "\t" + this.type + "\t" + this.source + "\t" + this.structure;
    }

    public static StructureType fromXML(Node st_node) throws Exception {
        StructureType ret = new StructureType();
        ret.database = XMLUtils.getAttribute((Node)st_node, (String)"database");
        if (ret.database == null) {
            ret.database = "";
        }
        ret.type = XMLUtils.getAttribute((Node)st_node, (String)"type");
        if (ret.type == null) {
            ret.type = "";
        }
        ret.source = XMLUtils.getAttribute((Node)st_node, (String)"source");
        if (ret.source == null) {
            ret.source = "";
        }
        ret.structure = XMLUtils.getAttribute((Node)st_node, (String)"structure");
        if (ret.structure == null) {
            ret.structure = "";
        }
        return ret;
    }

    public Element toXML(Document document) {
        if (document == null) {
            return null;
        }
        Element st_node = document.createElement("StructureType");
        st_node.setAttribute("database", "" + this.database);
        st_node.setAttribute("type", "" + this.type);
        st_node.setAttribute("source", "" + this.source);
        st_node.setAttribute("structure", "" + this.structure);
        return st_node;
    }

    public static class SAXHandler
    extends SAXUtils.ObjectTreeHandler {
        public boolean isElement(String namespaceURI, String localName, String qName) {
            return qName.equals(SAXHandler.getNodeElementName());
        }

        public static String getNodeElementName() {
            return "StructureType";
        }

        protected void initContent(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
            super.initContent(namespaceURI, localName, qName, atts);
            StructureType ret = new StructureType();
            ret.database = this.stringAttribute(atts, "database", "");
            ret.type = this.stringAttribute(atts, "type", "");
            ret.source = this.stringAttribute(atts, "source", "");
            ret.structure = this.stringAttribute(atts, "structure", "");
            this.object = ret;
        }
    }
}

