/*
 * Decompiled with CFR 0.152.
 */
package org.eurocarbdb.application.glycoworkbench.plugin;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FocusTraversalPolicy;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.net.MalformedURLException;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import org.eurocarbdb.application.glycanbuilder.BuilderWorkspace;
import org.eurocarbdb.application.glycanbuilder.CustomFocusTraversalPolicy;
import org.eurocarbdb.application.glycanbuilder.Glycan;
import org.eurocarbdb.application.glycanbuilder.GlycanCanvas;
import org.eurocarbdb.application.glycanbuilder.GlycanRenderer;
import org.eurocarbdb.application.glycanbuilder.GlycanRendererAWT;
import org.eurocarbdb.application.glycanbuilder.GraphicOptions;
import org.eurocarbdb.application.glycanbuilder.MouseUtils;
import org.eurocarbdb.application.glycanbuilder.TextUtils;
import org.eurocarbdb.application.glycanbuilder.ThemeManager;
import org.eurocarbdb.application.glycoworkbench.plugin.ProfilerPlugin;
import org.eurocarbdb.application.glycoworkbench.plugin.StructureDictionary;
import org.jdesktop.layout.GroupLayout;
import org.pushingpixels.flamingo.api.ribbon.JRibbonFrame;

public class SearchDialog
extends JRibbonFrame
implements ActionListener,
MouseListener {
    private ProfilerPlugin theProfiler;
    private BuilderWorkspace theWorkspace = new BuilderWorkspace(null, false, (GlycanRenderer)new GlycanRendererAWT());
    private GlycanCanvas theCanvas;
    private StructureDictionary return_database = null;
    private Glycan return_structure = null;
    private String return_type = "";
    private String return_source = "";
    private boolean include_redend = false;
    private boolean include_all_leafs = false;
    private boolean fuzzy = true;
    protected String return_status;
    protected Runnable run;
    private JButton button_cancel;
    private JButton button_search;
    private JCheckBox button_search_core;
    private JCheckBox button_search_terminal;
    private JCheckBox button_search_fuzzy;
    private JComboBox field_database;
    private JTextField field_source;
    private JTextField field_type;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JSeparator jSeparator1;
    private JPanel panel_canvas;

    public void setRunnable(Runnable _run) {
        this.run = _run;
    }

    public String getReturnStatus() {
        return this.return_status;
    }

    public SearchDialog(Frame parent, ProfilerPlugin profiler, boolean search_again, GraphicOptions gopt) throws MalformedURLException {
        this.theWorkspace.getGraphicOptions().copy(gopt);
        this.theWorkspace.getGraphicOptions().SHOW_MASSES_CANVAS = false;
        this.theWorkspace.getGraphicOptions().SHOW_REDEND_CANVAS = false;
        this.theProfiler = profiler;
        this.initComponents();
        this.initCanvas();
        this.initData(search_again);
        this.setTraversal();
        this.setActions();
        this.setLocationRelativeTo(parent);
        this.setResizable(false);
    }

    public boolean getIncludeRedEnd() {
        return this.include_redend;
    }

    public boolean getIncludeAllLeafs() {
        return this.include_all_leafs;
    }

    public boolean getFuzzy() {
        return this.fuzzy;
    }

    public StructureDictionary getDatabase() {
        return this.return_database;
    }

    public void setDatabase(StructureDictionary database) {
        if (database != null && this.field_database.isEnabled()) {
            this.field_database.setSelectedItem(database.getDictionaryName());
        }
        this.return_database = database;
    }

    public Glycan getStructure() {
        return this.return_structure;
    }

    public void setStructure(Glycan s) {
        if (s != null && !s.isEmpty()) {
            this.theWorkspace.getStructures().clear();
            this.theWorkspace.getStructures().addStructure(s);
        }
        this.return_structure = s;
    }

    public String getStructureType() {
        return this.return_type;
    }

    public String getSource() {
        return this.return_source;
    }

    private void initCanvas() throws MalformedURLException {
        this.panel_canvas.setLayout(new BorderLayout());
        this.theCanvas = new GlycanCanvas(null, this.theWorkspace, new ThemeManager("/icons", this.getClass()));
        JPanel northTbPanel = new JPanel();
        northTbPanel.setLayout(new BorderLayout());
        for (Component component : this.theCanvas.getToolBarStructure().getComponents()) {
            component.setEnabled(true);
            component.setVisible(true);
        }
        this.theCanvas.getToolBarStructure().setEnabled(true);
        this.theCanvas.getToolBarStructure().setVisible(true);
        northTbPanel.add((Component)this.theCanvas.getToolBarStructure(), "North");
        northTbPanel.add((Component)this.theCanvas.getToolBarProperties(), "Center");
        this.panel_canvas.add((Component)northTbPanel, "North");
        JScrollPane sp = new JScrollPane((Component)this.theCanvas);
        this.theCanvas.setScrollPane(sp);
        this.panel_canvas.add((Component)sp, "Center");
        this.theCanvas.addMouseListener((MouseListener)this);
    }

    private void initData(boolean search_again) {
        this.field_database.setModel(new DefaultComboBoxModel<String>(this.theProfiler.getDictionaryNames().toArray(new String[0])));
        this.field_database.setEnabled(!search_again);
        this.field_type.setText("");
        this.field_source.setText("");
    }

    private void setTraversal() {
        CustomFocusTraversalPolicy tp = new CustomFocusTraversalPolicy();
        tp.addComponent((Component)this.field_database);
        tp.addComponent((Component)this.field_source);
        tp.addComponent((Component)this.field_type);
        tp.addComponent((Component)this.button_search);
        tp.addComponent((Component)this.button_search_core);
        tp.addComponent((Component)this.button_search_terminal);
        tp.addComponent((Component)this.button_search_fuzzy);
        tp.addComponent((Component)this.button_cancel);
        this.setFocusTraversalPolicy((FocusTraversalPolicy)tp);
        this.getRootPane().setDefaultButton(this.button_search);
    }

    private void setActions() {
        this.button_search.addActionListener(this);
        this.button_search_core.addActionListener(this);
        this.button_search_terminal.addActionListener(this);
        this.button_search_fuzzy.addActionListener(this);
        this.button_cancel.addActionListener(this);
        this.field_database.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                if (SearchDialog.this.theProfiler.getDictionary((String)SearchDialog.this.field_database.getSelectedItem()).isWggds()) {
                    SearchDialog.this.field_source.setEnabled(false);
                    SearchDialog.this.field_type.setEnabled(false);
                } else {
                    SearchDialog.this.field_source.setEnabled(true);
                    SearchDialog.this.field_type.setEnabled(true);
                }
            }
        });
    }

    private void retrieveData() {
        this.return_database = this.field_database.isEnabled() ? this.theProfiler.getDictionary((String)this.field_database.getSelectedItem()) : null;
        this.return_structure = this.theWorkspace.getStructures().getFirstStructure();
        if (this.return_structure == null) {
            this.return_structure = new Glycan();
        }
        this.return_type = TextUtils.trim((String)this.field_type.getText());
        this.return_source = TextUtils.trim((String)this.field_source.getText());
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String action = e.getActionCommand();
        if (action.equals("Search")) {
            this.retrieveData();
            this.return_status = "OK";
            this.run.run();
        } else if (action.equals("Search core")) {
            this.include_redend = this.button_search_core.isSelected();
        } else if (action.equals("Search terminal")) {
            this.include_all_leafs = this.button_search_terminal.isSelected();
        } else if (action.equals("Cancel")) {
            this.return_status = "Cancel";
            this.run.run();
        } else if (action.equals("Search fuzzy")) {
            this.fuzzy = this.button_search_fuzzy.isSelected();
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (MouseUtils.isPopupTrigger((MouseEvent)e)) {
            this.theCanvas.enforceSelection(e.getPoint());
            this.theCanvas.createPopupMenu(false).show((Component)this.theCanvas, e.getX(), e.getY());
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (MouseUtils.isPopupTrigger((MouseEvent)e)) {
            this.theCanvas.enforceSelection(e.getPoint());
            this.theCanvas.createPopupMenu(false).show((Component)this.theCanvas, e.getX(), e.getY());
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    private void initComponents() {
        this.panel_canvas = new JPanel();
        this.jLabel1 = new JLabel();
        this.field_source = new JTextField();
        this.jLabel2 = new JLabel();
        this.field_type = new JTextField();
        this.jSeparator1 = new JSeparator();
        this.button_search_core = new JCheckBox();
        this.button_search_terminal = new JCheckBox();
        this.button_search_fuzzy = new JCheckBox();
        this.button_search = new JButton();
        this.button_cancel = new JButton();
        this.jLabel3 = new JLabel();
        this.field_database = new JComboBox();
        this.setDefaultCloseOperation(2);
        this.panel_canvas.setBackground(Color.white);
        this.panel_canvas.setPreferredSize(new Dimension(600, 400));
        this.panel_canvas.setRequestFocusEnabled(false);
        GroupLayout panel_canvasLayout = new GroupLayout((Container)this.panel_canvas);
        this.panel_canvas.setLayout((LayoutManager)panel_canvasLayout);
        panel_canvasLayout.setHorizontalGroup((GroupLayout.Group)panel_canvasLayout.createParallelGroup(1).add(0, 693, Short.MAX_VALUE));
        panel_canvasLayout.setVerticalGroup((GroupLayout.Group)panel_canvasLayout.createParallelGroup(1).add(0, 400, Short.MAX_VALUE));
        this.jLabel1.setText("Source");
        this.field_source.setText("jTextField1");
        this.jLabel2.setText("Type");
        this.field_type.setText("jTextField1");
        this.button_search_core.setText("Search core");
        this.button_search_terminal.setText("Search terminal");
        this.button_search_fuzzy.setText("Search fuzzy");
        this.button_search_fuzzy.setSelected(true);
        this.button_search.setText("Search");
        this.button_cancel.setText("Cancel");
        this.jLabel3.setText("Database");
        this.field_database.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jLabel2).addPreferredGap(0).add((Component)this.field_type, -2, 233, -2).addPreferredGap(0).add((Component)this.jLabel1).addPreferredGap(0).add((Component)this.field_source, -1, 349, Short.MAX_VALUE)).add((Component)this.jSeparator1, -1, 693, Short.MAX_VALUE))).add((GroupLayout.Group)layout.createSequentialGroup().add(139, 139, 139).add((Component)this.button_search).addPreferredGap(0).add((Component)this.button_search_core).addPreferredGap(0).add((Component)this.button_search_terminal).addPreferredGap(0).add((Component)this.button_search_fuzzy).addPreferredGap(0).add((Component)this.button_cancel)).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((Component)this.jLabel3).addPreferredGap(0).add((Component)this.field_database, -2, 216, -2)).add(2, (GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((Component)this.panel_canvas, -1, 693, Short.MAX_VALUE))).addContainerGap()));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jLabel3).add((Component)this.field_database, -2, -1, -2)).addPreferredGap(1).add((Component)this.panel_canvas, -2, -1, -2).add(12, 12, 12).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jLabel2).add((Component)this.jLabel1).add((Component)this.field_type, -2, -1, -2).add((Component)this.field_source, -2, -1, -2)).addPreferredGap(1).add((Component)this.jSeparator1, -2, 10, -2).addPreferredGap(1).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.button_search_core).add((Component)this.button_search_terminal).add((Component)this.button_search_fuzzy).add((Component)this.button_search).add((Component)this.button_cancel)).addContainerGap(-1, Short.MAX_VALUE)));
        this.pack();
    }

    private void closeDialog() {
        this.setVisible(false);
        this.dispose();
    }
}

