/*
 * Decompiled with CFR 0.152.
 */
package org.eurocarbdb.application.glycoworkbench.plugin;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.FocusTraversalPolicy;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.text.DecimalFormat;
import java.text.ParsePosition;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import org.eurocarbdb.application.glycanbuilder.BaseDocument;
import org.eurocarbdb.application.glycanbuilder.CustomFocusTraversalPolicy;
import org.eurocarbdb.application.glycanbuilder.EscapeDialog;
import org.eurocarbdb.application.glycanbuilder.TextUtils;
import org.eurocarbdb.application.glycoworkbench.GlycanWorkspace;
import org.eurocarbdb.application.glycoworkbench.Scan;
import org.jdesktop.layout.GroupLayout;

public class ScanPropertiesDialog
extends EscapeDialog
implements ActionListener {
    private Scan current;
    private GlycanWorkspace theWorkspace;
    private JButton button_cancel;
    private JButton button_ok;
    private JTextField field_name;
    private JTextField field_precursor_mz;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JSeparator jSeparator1;

    public ScanPropertiesDialog(Frame parent, Scan _current, GlycanWorkspace _workspace) {
        super(parent, true);
        this.current = _current;
        this.theWorkspace = _workspace;
        this.initComponents();
        this.fillComponents();
        this.setSelections();
        this.setTraversal();
        this.setActions();
        this.enableItems();
        this.setLocationRelativeTo(parent);
    }

    private void fillComponents() {
        this.field_name.setText(this.current.getName());
        if (this.current.getPrecursorMZ() != null) {
            this.field_precursor_mz.setText(new DecimalFormat("0.0000").format(this.current.getPrecursorMZ()));
        } else {
            this.field_precursor_mz.setText("");
        }
    }

    private void setSelections() {
    }

    private void setTraversal() {
        CustomFocusTraversalPolicy tp = new CustomFocusTraversalPolicy();
        tp.addComponent((Component)this.field_name);
        tp.addComponent((Component)this.field_precursor_mz);
        tp.addComponent((Component)this.button_ok);
        tp.addComponent((Component)this.button_cancel);
        this.setFocusTraversalPolicy((FocusTraversalPolicy)tp);
        this.getRootPane().setDefaultButton(this.button_ok);
    }

    private void setActions() {
        this.button_ok.addActionListener(this);
        this.button_cancel.addActionListener(this);
    }

    private void enableItems() {
    }

    private void retrieveData() {
        this.current.setName(this.field_name.getText());
        if (TextUtils.trim((String)this.field_precursor_mz.getText()).length() > 0) {
            Number mz = new DecimalFormat("0.0000").parse(this.field_precursor_mz.getText(), new ParsePosition(0));
            if (mz == null) {
                this.current.setPrecursorMZ(null);
            } else {
                this.current.setPrecursorMZ(mz.doubleValue());
            }
        } else {
            this.current.setPrecursorMZ(null);
        }
        this.theWorkspace.fireDocumentChanged((BaseDocument)this.theWorkspace);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String action = e.getActionCommand();
        if (action == "OK") {
            this.retrieveData();
            this.closeDialog();
        } else if (action == "Cancel") {
            this.closeDialog();
        }
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.field_precursor_mz = new JTextField();
        this.field_name = new JTextField();
        this.jSeparator1 = new JSeparator();
        this.button_ok = new JButton();
        this.button_cancel = new JButton();
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                ScanPropertiesDialog.this.closeDialog();
            }
        });
        this.jLabel1.setText("Name");
        this.jLabel2.setText("Precursor m/z");
        this.field_precursor_mz.setText("jTextField1");
        this.field_precursor_mz.setMinimumSize(new Dimension(75, 19));
        this.field_name.setText("jTextField1");
        this.button_ok.setText("OK");
        this.button_cancel.setText("Cancel");
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.jSeparator1, -1, 305, Short.MAX_VALUE).add((GroupLayout.Group)layout.createSequentialGroup().add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.jLabel2).add((Component)this.jLabel1)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.field_precursor_mz, -1, 205, Short.MAX_VALUE).add((Component)this.field_name, -1, 205, Short.MAX_VALUE)))).addContainerGap()).add(2, (GroupLayout.Group)layout.createSequentialGroup().add((Component)this.button_ok).addPreferredGap(0).add((Component)this.button_cancel).add(92, 92, 92)))));
        layout.linkSize(new Component[]{this.button_cancel, this.button_ok}, 1);
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jLabel1).add((Component)this.field_name, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jLabel2).add((Component)this.field_precursor_mz, -2, -1, -2)).addPreferredGap(0).add((Component)this.jSeparator1, -2, 10, -2).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.button_cancel).add((Component)this.button_ok)).addContainerGap(17, Short.MAX_VALUE)));
        this.pack();
    }

    private void closeDialog() {
        this.setVisible(false);
        this.dispose();
    }
}

