/*
 * Decompiled with CFR 0.152.
 */
package org.eurocarbdb.application.glycoworkbench.plugin;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.InputStream;
import java.util.Vector;
import javax.swing.Action;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JToolBar;
import org.eurocarbdb.application.glycanbuilder.BaseDocument;
import org.eurocarbdb.application.glycanbuilder.ClipUtils;
import org.eurocarbdb.application.glycanbuilder.FileUtils;
import org.eurocarbdb.application.glycanbuilder.Glycan;
import org.eurocarbdb.application.glycanbuilder.GlycanCanvas;
import org.eurocarbdb.application.glycanbuilder.GlycanRendererAWT;
import org.eurocarbdb.application.glycanbuilder.IntPair;
import org.eurocarbdb.application.glycanbuilder.LogUtils;
import org.eurocarbdb.application.glycanbuilder.STOCK_ICON;
import org.eurocarbdb.application.glycanbuilder.TextUtils;
import org.eurocarbdb.application.glycoworkbench.AnnotatedPeakList;
import org.eurocarbdb.application.glycoworkbench.AnnotationSelection;
import org.eurocarbdb.application.glycoworkbench.GlycanWorkspace;
import org.eurocarbdb.application.glycoworkbench.GlycoWorkbench;
import org.eurocarbdb.application.glycoworkbench.plugin.AnnotationPlugin;
import org.eurocarbdb.application.glycoworkbench.plugin.Plugin;
import org.eurocarbdb.application.glycoworkbench.plugin.PluginManager;
import org.eurocarbdb.application.glycoworkbench.plugin.SortingTablePanel;

public class PeakAnnotationStatsPanel
extends SortingTablePanel<AnnotatedPeakList>
implements ActionListener {
    protected JToolBar theToolBarDocument;
    protected JToolBar theToolBarEdit;

    @Override
    protected void initComponents() {
        super.initComponents();
        JPanel theToolBarPanel = new JPanel(new BorderLayout());
        this.theToolBarDocument = this.createToolBarDocument();
        this.theToolBarEdit = this.createToolBarEdit();
        theToolBarPanel.add((Component)this.theToolBarDocument, "North");
        theToolBarPanel.add((Component)this.theToolBarEdit, "Center");
        this.add((Component)theToolBarPanel, "South");
        this.theTable.setShowVerticalLines(false);
    }

    @Override
    public AnnotatedPeakList getDocumentFromWorkspace(GlycanWorkspace workspace) {
        return workspace != null ? workspace.getAnnotatedPeakList() : null;
    }

    @Override
    public void setDocumentFromWorkspace(GlycanWorkspace workspace) {
        if (this.theDocument != null) {
            ((AnnotatedPeakList)((Object)this.theDocument)).removeDocumentChangeListener(this);
        }
        this.theDocument = this.getDocumentFromWorkspace(workspace);
        if (this.theDocument == null) {
            this.theDocument = new AnnotatedPeakList();
        }
        ((AnnotatedPeakList)((Object)this.theDocument)).addDocumentChangeListener(this);
        this.updateView();
        this.updateActions();
    }

    @Override
    protected void createActions() {
        this.theActionManager.add("new", GlycoWorkbench.getDefaultThemeManager().getResizableIcon(STOCK_ICON.REFRESH, Plugin.DEFAULT_ICON_SIZE), "Clear", 78, "", (ActionListener)this);
        this.theActionManager.add("print", GlycoWorkbench.getDefaultThemeManager().getResizableIcon(STOCK_ICON.DOCUMENT_PRINT, Plugin.DEFAULT_ICON_SIZE), "Print...", 80, "", (ActionListener)this);
        this.theActionManager.add("open", GlycoWorkbench.getDefaultThemeManager().getResizableIcon(STOCK_ICON.DOCUMENT_OPEN, Plugin.DEFAULT_ICON_SIZE), "Open", 79, "", (ActionListener)this);
        this.theActionManager.add("save", GlycoWorkbench.getDefaultThemeManager().getResizableIcon(STOCK_ICON.DOCUMENT_SAVE, Plugin.DEFAULT_ICON_SIZE), "Save", 83, "", (ActionListener)this);
        this.theActionManager.add("saveas", GlycoWorkbench.getDefaultThemeManager().getResizableIcon(STOCK_ICON.DOCUMENT_SAVE_AS, Plugin.DEFAULT_ICON_SIZE), "Save as...", 65, "", (ActionListener)this);
        this.theActionManager.add("cut", GlycoWorkbench.getDefaultThemeManager().getResizableIcon(STOCK_ICON.CUT, Plugin.DEFAULT_ICON_SIZE), "Cut", 84, "", (ActionListener)this);
        this.theActionManager.add("copy", GlycoWorkbench.getDefaultThemeManager().getResizableIcon(STOCK_ICON.COPY, Plugin.DEFAULT_ICON_SIZE), "Copy", 67, "", (ActionListener)this);
        this.theActionManager.add("paste", GlycoWorkbench.getDefaultThemeManager().getResizableIcon(STOCK_ICON.PASTE, Plugin.DEFAULT_ICON_SIZE), "Paste", 80, "", (ActionListener)this);
        this.theActionManager.add("delete", GlycoWorkbench.getDefaultThemeManager().getResizableIcon("deleteNew", Plugin.DEFAULT_ICON_SIZE), "Delete", 127, "", (ActionListener)this);
        this.theActionManager.add("transfer", FileUtils.defaultThemeManager.getImageIcon("transfer"), "Copy structures into canvas", 86, "", (ActionListener)this);
        this.theActionManager.add("showdetails", FileUtils.defaultThemeManager.getImageIcon("showdetails"), "Show annotation details", 68, "", (ActionListener)this);
    }

    @Override
    protected void updateActions() {
        this.theActionManager.get("save").setEnabled(((AnnotatedPeakList)((Object)this.theDocument)).hasChanged());
        boolean has_selection = this.theTable.getSelectedRows().length > 0;
        this.theActionManager.get("cut").setEnabled(has_selection);
        this.theActionManager.get("copy").setEnabled(has_selection);
        this.theActionManager.get("delete").setEnabled(has_selection);
        this.theActionManager.get("transfer").setEnabled(has_selection);
        this.theActionManager.get("showdetails").setEnabled(has_selection);
    }

    private JToolBar createToolBarDocument() {
        JToolBar toolbar = new JToolBar();
        toolbar.setFloatable(false);
        toolbar.add((Action)this.theActionManager.get("new"));
        toolbar.add((Action)this.theActionManager.get("open"));
        toolbar.add((Action)this.theActionManager.get("save"));
        toolbar.add((Action)this.theActionManager.get("saveas"));
        toolbar.addSeparator();
        toolbar.add((Action)this.theActionManager.get("print"));
        return toolbar;
    }

    private JToolBar createToolBarEdit() {
        JToolBar toolbar = new JToolBar();
        toolbar.setFloatable(false);
        toolbar.add((Action)this.theActionManager.get("showdetails"));
        toolbar.addSeparator();
        toolbar.add((Action)this.theActionManager.get("cut"));
        toolbar.add((Action)this.theActionManager.get("copy"));
        toolbar.add((Action)this.theActionManager.get("paste"));
        toolbar.add((Action)this.theActionManager.get("delete"));
        toolbar.add((Action)this.theActionManager.get("transfer"));
        return toolbar;
    }

    @Override
    protected JPopupMenu createPopupMenu() {
        JPopupMenu menu = new JPopupMenu();
        menu.add((Action)this.theActionManager.get("showdetails"));
        menu.addSeparator();
        menu.add((Action)this.theActionManager.get("cut"));
        menu.add((Action)this.theActionManager.get("copy"));
        menu.add((Action)this.theActionManager.get("paste"));
        menu.add((Action)this.theActionManager.get("delete"));
        menu.add((Action)this.theActionManager.get("transfer"));
        return menu;
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        if (columnIndex == 0) {
            return Glycan.class;
        }
        if (columnIndex == 1) {
            return Double.class;
        }
        if (columnIndex == 2) {
            return Double.class;
        }
        if (columnIndex == 3) {
            return Double.class;
        }
        if (columnIndex == 4) {
            return IntPair.class;
        }
        if (columnIndex == 5) {
            return IntPair.class;
        }
        if (columnIndex == 6) {
            return IntPair.class;
        }
        return Object.class;
    }

    @Override
    public String getColumnName(int columnIndex) {
        if (columnIndex == 0) {
            return "Structure";
        }
        if (columnIndex == 1) {
            return "Coverage";
        }
        if (columnIndex == 2) {
            return "RMSD";
        }
        if (columnIndex == 3) {
            return "RMSD PPM";
        }
        if (columnIndex == 4) {
            return "Assigned";
        }
        if (columnIndex == 5) {
            return ">10% assigned";
        }
        if (columnIndex == 6) {
            return ">5% assigned";
        }
        return null;
    }

    @Override
    public int getColumnCount() {
        return 7;
    }

    @Override
    public int getRowCount() {
        return ((AnnotatedPeakList)((Object)this.theDocument)).getNoStructures();
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        if (columnIndex == 0) {
            return ((AnnotatedPeakList)((Object)this.theDocument)).getStructure(rowIndex);
        }
        if (columnIndex == 1) {
            return ((AnnotatedPeakList)((Object)this.theDocument)).getCoverage(rowIndex);
        }
        if (columnIndex == 2) {
            return ((AnnotatedPeakList)((Object)this.theDocument)).getRMSD(rowIndex);
        }
        if (columnIndex == 3) {
            return ((AnnotatedPeakList)((Object)this.theDocument)).getRMSD_PPM(rowIndex);
        }
        if (columnIndex == 4) {
            return new IntPair(((AnnotatedPeakList)((Object)this.theDocument)).getNoAnnotatedPeaks(rowIndex), ((AnnotatedPeakList)((Object)this.theDocument)).getNoPeaks());
        }
        if (columnIndex == 5) {
            return new IntPair(((AnnotatedPeakList)((Object)this.theDocument)).getNoAnnotatedPeaks(rowIndex, 10.0), ((AnnotatedPeakList)((Object)this.theDocument)).getNoPeaks(10.0));
        }
        if (columnIndex == 6) {
            return new IntPair(((AnnotatedPeakList)((Object)this.theDocument)).getNoAnnotatedPeaks(rowIndex, 5.0), ((AnnotatedPeakList)((Object)this.theDocument)).getNoPeaks(5.0));
        }
        return null;
    }

    @Override
    public void updateData() {
    }

    public void clear() {
        ((AnnotatedPeakList)((Object)this.theDocument)).clear();
    }

    public void onNew() {
        this.clear();
    }

    public void onPrint() {
        this.theTable.print(this.theWorkspace.getPrinterJob());
    }

    public void onShowDetails() {
        try {
            int s_ind = this.theTable.getSelectedRow();
            if (s_ind != -1) {
                PluginManager pm = this.theApplication.getPluginManager();
                pm.show("Annotation", "Details");
                ((AnnotationPlugin)pm.get("Annotation")).getPeakAnnotationDetailsPanel().showStructure(this.theTableSorter.modelIndex(s_ind));
            }
        }
        catch (Exception e) {
            LogUtils.report((Exception)e);
        }
    }

    public void cut() {
        this.copy();
        this.delete();
    }

    public void copy() {
        Vector<Glycan> structures = new Vector<Glycan>();
        int[] sel_inds = this.theTable.getSelectedRows();
        if (sel_inds.length > 0) {
            int[] mod_inds = this.theTableSorter.modelIndexes(sel_inds);
            for (int i = 0; i < mod_inds.length; ++i) {
                Glycan fragment = ((AnnotatedPeakList)((Object)this.theDocument)).getStructure(mod_inds[i]);
                if (fragment == null) continue;
                structures.add(fragment);
            }
            ClipUtils.setContents((Transferable)((Object)new AnnotationSelection(this.theTable.getSelectedData(), ((AnnotatedPeakList)((Object)this.theDocument)).extractCollections(mod_inds), (GlycanRendererAWT)this.theWorkspace.getGlycanRenderer(), structures)));
        }
    }

    public void paste() {
        try {
            Transferable t = ClipUtils.getContents();
            if (t != null && t.isDataFlavorSupported(AnnotationSelection.annotationFlavor)) {
                String content = TextUtils.consume((InputStream)((InputStream)t.getTransferData(AnnotationSelection.annotationFlavor)));
                ((AnnotatedPeakList)((Object)this.theDocument)).fromString(content, true, true);
            }
        }
        catch (Exception e) {
            LogUtils.report((Exception)e);
        }
    }

    public void delete() {
        ((AnnotatedPeakList)((Object)this.theDocument)).removePeakAnnotationsAt(this.theTableSorter.modelIndexes(this.theTable.getSelectedRows()));
    }

    public void transfer() {
        GlycanCanvas theCanvas = this.theApplication.getCanvas();
        this.copy();
        theCanvas.resetSelection();
        theCanvas.paste();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String action = e.getActionCommand();
        if (action.equals("new")) {
            this.theApplication.onNew((BaseDocument)this.theDocument);
        } else if (action.equals("open")) {
            this.theApplication.onOpen(null, (BaseDocument)this.theDocument, false);
        } else if (action.equals("save")) {
            this.theApplication.onSave((BaseDocument)this.theDocument);
        } else if (action.equals("saveas")) {
            this.theApplication.onSaveAs((BaseDocument)this.theDocument);
        } else if (action.equals("print")) {
            this.onPrint();
        } else if (action.equals("showdetails")) {
            this.onShowDetails();
        } else if (action.equals("cut")) {
            this.cut();
        } else if (action.equals("copy")) {
            this.copy();
        } else if (action.equals("paste")) {
            this.paste();
        } else if (action.equals("delete")) {
            this.delete();
        } else if (action.equals("transfer")) {
            this.transfer();
        }
        this.updateActions();
    }
}

