/*
 * Decompiled with CFR 0.152.
 */
package org.eurocarbdb.application.glycoworkbench.plugin;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;
import java.util.HashSet;
import java.util.Random;
import java.util.Vector;
import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JToolBar;
import javax.swing.border.BevelBorder;
import org.eurocarbdb.application.glycanbuilder.BaseDocument;
import org.eurocarbdb.application.glycanbuilder.ClipUtils;
import org.eurocarbdb.application.glycanbuilder.FileUtils;
import org.eurocarbdb.application.glycanbuilder.FragmentCollection;
import org.eurocarbdb.application.glycanbuilder.FragmentDocument;
import org.eurocarbdb.application.glycanbuilder.FragmentEntry;
import org.eurocarbdb.application.glycanbuilder.FragmentOptions;
import org.eurocarbdb.application.glycanbuilder.Glycan;
import org.eurocarbdb.application.glycanbuilder.GlycanCanvas;
import org.eurocarbdb.application.glycanbuilder.GlycanRenderer;
import org.eurocarbdb.application.glycanbuilder.GlycanRendererAWT;
import org.eurocarbdb.application.glycanbuilder.GlycanSelection;
import org.eurocarbdb.application.glycanbuilder.IonCloud;
import org.eurocarbdb.application.glycanbuilder.STOCK_ICON;
import org.eurocarbdb.application.glycoworkbench.AnnotationOptions;
import org.eurocarbdb.application.glycoworkbench.AnnotationOptionsDialog;
import org.eurocarbdb.application.glycoworkbench.GlycanWorkspace;
import org.eurocarbdb.application.glycoworkbench.GlycoWorkbench;
import org.eurocarbdb.application.glycoworkbench.Peak;
import org.eurocarbdb.application.glycoworkbench.PeakList;
import org.eurocarbdb.application.glycoworkbench.plugin.AnnotationThread;
import org.eurocarbdb.application.glycoworkbench.plugin.Plugin;
import org.eurocarbdb.application.glycoworkbench.plugin.SortingTablePanel;

public class FragmentDetailsPanel
extends SortingTablePanel<FragmentDocument>
implements ActionListener {
    protected JLabel theStructure;
    protected JToolBar theToolBarDocument;
    protected JToolBar theToolBarEdit;
    protected int current_ind = 0;

    @Override
    protected void initComponents() {
        super.initComponents();
        this.theStructure = new JLabel();
        this.theStructure.setBorder(new BevelBorder(0));
        this.add((Component)this.theStructure, "North");
        JPanel theToolBarPanel = new JPanel(new BorderLayout());
        this.theToolBarDocument = this.createToolBarDocument();
        this.theToolBarEdit = this.createToolBarEdit();
        theToolBarPanel.add((Component)this.theToolBarDocument, "North");
        theToolBarPanel.add((Component)this.theToolBarEdit, "Center");
        this.add((Component)theToolBarPanel, "South");
    }

    @Override
    protected FragmentDocument getDocumentFromWorkspace(GlycanWorkspace workspace) {
        return workspace != null ? workspace.getFragments() : null;
    }

    @Override
    public void setDocumentFromWorkspace(GlycanWorkspace workspace) {
        if (this.theDocument != null) {
            ((FragmentDocument)this.theDocument).removeDocumentChangeListener((BaseDocument.DocumentChangeListener)this);
        }
        this.theDocument = this.getDocumentFromWorkspace(workspace);
        if (this.theDocument == null) {
            this.theDocument = new FragmentDocument();
        }
        ((FragmentDocument)this.theDocument).addDocumentChangeListener((BaseDocument.DocumentChangeListener)this);
        this.current_ind = 0;
        this.updateView();
        this.updateActions();
    }

    @Override
    protected void createActions() {
        this.theActionManager.add("new", GlycoWorkbench.getDefaultThemeManager().getResizableIcon(STOCK_ICON.REFRESH, Plugin.DEFAULT_ICON_SIZE), "Clear", 78, "", (ActionListener)this);
        this.theActionManager.add("open", GlycoWorkbench.getDefaultThemeManager().getResizableIcon(STOCK_ICON.DOCUMENT_OPEN, Plugin.DEFAULT_ICON_SIZE), "Open", 79, "", (ActionListener)this);
        this.theActionManager.add("save", GlycoWorkbench.getDefaultThemeManager().getResizableIcon(STOCK_ICON.DOCUMENT_SAVE, Plugin.DEFAULT_ICON_SIZE), "Save", 83, "", (ActionListener)this);
        this.theActionManager.add("saveas", GlycoWorkbench.getDefaultThemeManager().getResizableIcon(STOCK_ICON.DOCUMENT_SAVE_AS, Plugin.DEFAULT_ICON_SIZE), "Save as...", 65, "", (ActionListener)this);
        this.theActionManager.add("close", FileUtils.defaultThemeManager.getImageIcon("close"), "Close structure", 83, "", (ActionListener)this);
        this.theActionManager.add("previous", FileUtils.defaultThemeManager.getImageIcon("previous"), "Previous structure", 76, "", (ActionListener)this);
        this.theActionManager.add("next", FileUtils.defaultThemeManager.getImageIcon("next"), "Next structure", 78, "", (ActionListener)this);
        this.theActionManager.add("print", GlycoWorkbench.getDefaultThemeManager().getResizableIcon(STOCK_ICON.DOCUMENT_PRINT, Plugin.DEFAULT_ICON_SIZE), "Print...", 80, "", (ActionListener)this);
        this.theActionManager.add("cut", GlycoWorkbench.getDefaultThemeManager().getResizableIcon(STOCK_ICON.CUT, Plugin.DEFAULT_ICON_SIZE), "Cut", -1, "", (ActionListener)this);
        this.theActionManager.add("copy", GlycoWorkbench.getDefaultThemeManager().getResizableIcon(STOCK_ICON.COPY, Plugin.DEFAULT_ICON_SIZE), "Copy", 67, "", (ActionListener)this);
        this.theActionManager.add("delete", GlycoWorkbench.getDefaultThemeManager().getResizableIcon("deleteNew", Plugin.DEFAULT_ICON_SIZE), "Delete", -1, "", (ActionListener)this);
        this.theActionManager.add("transfer", FileUtils.defaultThemeManager.getImageIcon("transfer"), "Copy fragments into canvas", 86, "", (ActionListener)this);
        this.theActionManager.add("charges", FileUtils.defaultThemeManager.getImageIcon("charges"), "Compute multiple charges and exchanges", -1, "", (ActionListener)this);
        this.theActionManager.add("filterselection", FileUtils.defaultThemeManager.getImageIcon(""), "Show only selected fragments", -1, "", (ActionListener)this);
        this.theActionManager.add("showallrows", FileUtils.defaultThemeManager.getImageIcon(""), "Show all fragments", -1, "", (ActionListener)this);
        this.theActionManager.add("copy_to_peak_list", GlycoWorkbench.getDefaultThemeManager().getResizableIcon(STOCK_ICON.COPY, Plugin.DEFAULT_ICON_SIZE), "Copy m/z values to peak list", 77, "", (ActionListener)this);
    }

    @Override
    protected void updateActions() {
        this.theActionManager.get("previous").setEnabled(this.current_ind > 0);
        this.theActionManager.get("next").setEnabled(this.current_ind < ((FragmentDocument)this.theDocument).getNoStructures() - 1);
        this.theActionManager.get("close").setEnabled(!((FragmentDocument)this.theDocument).isEmpty());
        this.theActionManager.get("save").setEnabled(((FragmentDocument)this.theDocument).hasChanged());
        boolean has_selection = this.theTable.getSelectedRows().length > 0;
        this.theActionManager.get("cut").setEnabled(has_selection);
        this.theActionManager.get("copy").setEnabled(has_selection);
        this.theActionManager.get("delete").setEnabled(has_selection);
        this.theActionManager.get("transfer").setEnabled(has_selection);
        this.theActionManager.get("charges").setEnabled(has_selection);
        this.theActionManager.get("filterselection").setEnabled(has_selection);
        this.theActionManager.get("showallrows").setEnabled(!this.theTableSorter.isAllRowsVisible());
    }

    private JToolBar createToolBarDocument() {
        JToolBar toolbar = new JToolBar();
        toolbar.setFloatable(false);
        toolbar.add((Action)this.theActionManager.get("previous"));
        toolbar.add((Action)this.theActionManager.get("close"));
        toolbar.add((Action)this.theActionManager.get("next"));
        toolbar.addSeparator();
        toolbar.add((Action)this.theActionManager.get("new"));
        toolbar.add((Action)this.theActionManager.get("open"));
        toolbar.add((Action)this.theActionManager.get("save"));
        toolbar.add((Action)this.theActionManager.get("saveas"));
        toolbar.add((Action)this.theActionManager.get("copy_to_peak_list"));
        toolbar.addSeparator();
        toolbar.add((Action)this.theActionManager.get("print"));
        return toolbar;
    }

    private JToolBar createToolBarEdit() {
        JToolBar toolbar = new JToolBar();
        toolbar.setFloatable(false);
        toolbar.add((Action)this.theActionManager.get("cut"));
        toolbar.add((Action)this.theActionManager.get("copy"));
        toolbar.add((Action)this.theActionManager.get("delete"));
        toolbar.add((Action)this.theActionManager.get("transfer"));
        return toolbar;
    }

    @Override
    protected JPopupMenu createPopupMenu() {
        JPopupMenu menu = new JPopupMenu();
        menu.add((Action)this.theActionManager.get("cut"));
        menu.add((Action)this.theActionManager.get("copy"));
        menu.add((Action)this.theActionManager.get("delete"));
        menu.add((Action)this.theActionManager.get("transfer"));
        menu.addSeparator();
        menu.add((Action)this.theActionManager.get("charges"));
        menu.addSeparator();
        menu.add((Action)this.theActionManager.get("filterselection"));
        menu.add((Action)this.theActionManager.get("showallrows"));
        return menu;
    }

    public int getNoStructures() {
        return ((FragmentDocument)this.theDocument).getNoStructures();
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        if (columnIndex == 0) {
            return Glycan.class;
        }
        if (columnIndex == 1) {
            return String.class;
        }
        if (columnIndex == 2) {
            return Double.class;
        }
        if (columnIndex == 3) {
            return IonCloud.class;
        }
        if (columnIndex == 4) {
            return IonCloud.class;
        }
        if (columnIndex == 5) {
            return Double.class;
        }
        return Object.class;
    }

    @Override
    public String getColumnName(int columnIndex) {
        if (columnIndex == 0) {
            return "Fragment";
        }
        if (columnIndex == 1) {
            return "Type";
        }
        if (columnIndex == 2) {
            return "m/z";
        }
        if (columnIndex == 3) {
            return "Ions";
        }
        if (columnIndex == 4) {
            return "Neutral\nExchanges";
        }
        if (columnIndex == 5) {
            return "Fragment\nMass";
        }
        return null;
    }

    @Override
    public int getColumnCount() {
        return 6;
    }

    @Override
    public int getRowCount() {
        return ((FragmentDocument)this.theDocument).isEmpty() ? 0 : this.getCurrentFragments().size();
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        if (!((FragmentDocument)this.theDocument).isEmpty()) {
            FragmentEntry f = this.getFragmentEntry(rowIndex);
            if (columnIndex == 0) {
                return f.fragment;
            }
            if (columnIndex == 1) {
                return f.name;
            }
            if (columnIndex == 2) {
                return f.mz_ratio;
            }
            if (columnIndex == 3) {
                return f.getCharges();
            }
            if (columnIndex == 4) {
                return f.getNeutralExchanges();
            }
            if (columnIndex == 5) {
                return f.mass;
            }
        }
        return null;
    }

    public void clear() {
        ((FragmentDocument)this.theDocument).init();
    }

    public Glycan getCurrentStructure() {
        return ((FragmentDocument)this.theDocument).isEmpty() ? null : ((FragmentDocument)this.theDocument).getStructure(this.current_ind);
    }

    public FragmentCollection getCurrentFragments() {
        return ((FragmentDocument)this.theDocument).isEmpty() ? null : ((FragmentDocument)this.theDocument).getFragments(this.current_ind);
    }

    public FragmentEntry getFragmentEntry(int l) {
        return ((FragmentDocument)this.theDocument).isEmpty() ? null : ((FragmentDocument)this.theDocument).getFragments(this.current_ind).elementAt(l);
    }

    public Collection<FragmentEntry> getSelectedFragments() {
        Vector<FragmentEntry> fragments = new Vector<FragmentEntry>();
        int[] sel_ind = this.theTable.getSelectedRows();
        for (int i = 0; i < sel_ind.length; ++i) {
            int r = this.theTableSorter.modelIndex(sel_ind[i]);
            fragments.add(this.getFragmentEntry(r));
        }
        return fragments;
    }

    @Override
    public void updateView() {
        GlycanRenderer gr = this.theWorkspace.getGlycanRenderer();
        this.theStructure.setIcon(((FragmentDocument)this.theDocument).isEmpty() ? null : new ImageIcon(gr.getImage(this.getCurrentStructure(), false, true, true, 0.667)));
        this.fireTableChanged();
    }

    public void showPrevious() {
        if (!((FragmentDocument)this.theDocument).isEmpty() && this.current_ind > 0) {
            --this.current_ind;
            this.updateView();
        }
    }

    public void showNext() {
        if (!((FragmentDocument)this.theDocument).isEmpty() && this.current_ind < ((FragmentDocument)this.theDocument).getNoStructures() - 1) {
            ++this.current_ind;
            this.updateView();
        }
    }

    public void closeCurrent() {
        if (!((FragmentDocument)this.theDocument).isEmpty()) {
            ((FragmentDocument)this.theDocument).removeFragments(this.current_ind);
        }
    }

    public void onPrint() {
        this.theTable.print(this.theWorkspace.getPrinterJob(), this.getCurrentStructure());
    }

    public void cut() {
        this.copy();
        this.delete();
    }

    public void delete() {
        Vector<FragmentEntry> to_remove = new Vector<FragmentEntry>();
        int[] sel_ind = this.theTable.getSelectedRows();
        for (int i = 0; i < sel_ind.length; ++i) {
            to_remove.add(this.getFragmentEntry(this.theTableSorter.modelIndex(sel_ind[i])));
        }
        ((FragmentDocument)this.theDocument).removeFragments(this.current_ind, to_remove);
    }

    public void copy() {
        Vector<Glycan> structures = new Vector<Glycan>();
        int[] sel_ind = this.theTable.getSelectedRows();
        if (sel_ind.length > 0) {
            for (int i = 0; i < sel_ind.length; ++i) {
                int r = this.theTableSorter.modelIndex(sel_ind[i]);
                structures.add(this.getFragmentEntry((int)r).fragment);
            }
            ClipUtils.setContents((Transferable)new GlycanSelection(this.theTable.getSelectedData(), (GlycanRendererAWT)this.theWorkspace.getGlycanRenderer(), structures));
        }
    }

    public void transfer() {
        GlycanCanvas theCanvas = this.theApplication.getCanvas();
        this.copy();
        theCanvas.resetSelection();
        theCanvas.paste();
    }

    public void onComputeCharges() {
        FragmentOptions frag_opt = this.theWorkspace.getFragmentOptions();
        AnnotationOptions ann_opt = this.theWorkspace.getAnnotationOptions();
        AnnotationOptionsDialog dlg = new AnnotationOptionsDialog((Frame)((Object)this.theApplication), frag_opt, ann_opt, false, true);
        dlg.hideClearAnnotationOption();
        dlg.setVisible(true);
        if (!dlg.getReturnStatus().equals("OK")) {
            return;
        }
        Collection<FragmentEntry> fragments = this.getSelectedFragments();
        Collection<FragmentEntry> fragments_charges = AnnotationThread.computeChargesAndExchanges(this.getCurrentStructure(), fragments, ann_opt);
        ((FragmentDocument)this.theDocument).addFragments(this.current_ind, fragments_charges);
    }

    public void filterSelection() {
        int[] sel_inds = this.theTable.getSelectedRows();
        if (sel_inds != null & sel_inds.length > 0) {
            this.theTableSorter.setVisibleRows(this.theTableSorter.modelIndexes(sel_inds));
        }
    }

    public void showAllRows() {
        this.theTableSorter.resetVisibleRows();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String action = e.getActionCommand();
        if (action.equals("previous")) {
            this.showPrevious();
        } else if (action.equals("next")) {
            this.showNext();
        } else if (action.equals("close")) {
            this.closeCurrent();
        } else if (action.equals("print")) {
            this.onPrint();
        } else if (action.equals("new")) {
            this.theApplication.onNew((BaseDocument)this.theDocument);
        } else if (action.equals("open")) {
            this.theApplication.onOpen(null, (BaseDocument)this.theDocument, false);
        } else if (action.equals("save")) {
            this.theApplication.onSave((BaseDocument)this.theDocument);
        } else if (action.equals("saveas")) {
            this.theApplication.onSaveAs((BaseDocument)this.theDocument);
        } else if (action.equals("copy_to_peak_list")) {
            this.copyToPeakList();
        } else if (action.equals("cut")) {
            this.cut();
        } else if (action.equals("copy")) {
            this.copy();
        } else if (action.equals("delete")) {
            this.delete();
        } else if (action.equals("transfer")) {
            this.transfer();
        } else if (action.equals("charges")) {
            this.onComputeCharges();
        } else if (action.equals("filterselection")) {
            this.filterSelection();
        } else if (action.equals("showallrows")) {
            this.showAllRows();
        }
        this.updateActions();
    }

    @Override
    protected void updateData() {
        this.current_ind = Math.min(this.current_ind, ((FragmentDocument)this.theDocument).getNoStructures() - 1);
        this.current_ind = Math.max(this.current_ind, 0);
    }

    public void copyToPeakList() {
        PeakList peakList = this.theWorkspace.getPeakList();
        Collection fragmentList = this.getSelectedFragments();
        if (fragmentList.size() == 0) {
            FragmentCollection fragmentCollection = this.getCurrentFragments();
            fragmentList = fragmentCollection.getFragments();
        }
        Random rand = new Random();
        HashSet<Double> mzValues = new HashSet<Double>();
        for (FragmentEntry fragmentEntry : fragmentList) {
            mzValues.add(fragmentEntry.getMZ());
        }
        for (Double mzValue : mzValues) {
            int range = rand.nextInt(2);
            range = range == 0 ? 20 : 300;
            peakList.add(new Peak(mzValue, rand.nextInt(range)));
        }
    }
}

