/*
 * Decompiled with CFR 0.152.
 */
package org.eurocarbdb.application.glycoworkbench.plugin;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.util.Collection;
import java.util.Vector;
import org.eurocarbdb.application.glycanbuilder.Data;
import org.eurocarbdb.application.glycanbuilder.Glycan;
import org.eurocarbdb.application.glycanbuilder.GlycanRendererAWT;
import org.eurocarbdb.application.glycanbuilder.GlycanSelection;
import org.eurocarbdb.application.glycoworkbench.plugin.StructureType;

public class DictionarySelection
extends GlycanSelection {
    public static final DataFlavor dictionaryFlavor = new DataFlavor("application/x-glycoworkbench-dictionary", "application/x-glycoworkbench-dictionary");
    private Collection<StructureType> structure_types;

    public DictionarySelection(Data _data, Collection<StructureType> _structure_types, GlycanRendererAWT _glycanRenderer, Collection<Glycan> _structures) {
        super(_data, _glycanRenderer, _structures);
        this.structure_types = _structure_types;
    }

    public Vector<DataFlavor> getTransferDataFlavorsVector() {
        Vector supportedFlavors = super.getTransferDataFlavorsVector();
        supportedFlavors.add(dictionaryFlavor);
        return supportedFlavors;
    }

    public DataFlavor[] getTransferDataFlavors() {
        return this.getTransferDataFlavorsVector().toArray(new DataFlavor[0]);
    }

    public boolean isDataFlavorSupported(DataFlavor parFlavor) {
        return super.isDataFlavorSupported(parFlavor) || parFlavor.equals(dictionaryFlavor) && this.structure_types != null;
    }

    public synchronized Object getTransferData(DataFlavor parFlavor) throws UnsupportedFlavorException, IOException {
        if (parFlavor == null) {
            throw new NullPointerException();
        }
        if (parFlavor.equals(dictionaryFlavor) && this.structure_types != null) {
            return this.getStream(this.toString().getBytes());
        }
        return super.getTransferData(parFlavor);
    }

    public Collection<StructureType> getStructureTypes() {
        return this.structure_types;
    }

    public String toString() {
        if (this.structure_types == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (StructureType st : this.structure_types) {
            sb.append(st.toString());
            sb.append('\n');
        }
        return sb.toString();
    }

    public static Collection<StructureType> parseString(String str) throws Exception {
        Vector<StructureType> ret = new Vector<StructureType>();
        for (String token : str.split("\n")) {
            ret.add(StructureType.fromString(token));
        }
        return ret;
    }
}

