/*
 * Decompiled with CFR 0.152.
 */
package org.eurocarbdb.application.glycoworkbench;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.transform.sax.TransformerHandler;
import org.eurocarbdb.application.glycanbuilder.SAXUtils;
import org.eurocarbdb.application.glycanbuilder.XMLUtils;
import org.eurocarbdb.application.glycoworkbench.MassUnit;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class Peak
implements Comparable<Peak>,
SAXUtils.SAXWriter {
    protected static final Pattern pattern1;
    protected static final Pattern pattern2;
    protected static final Pattern pattern3;
    protected static final Pattern pattern4;
    protected Double mz_ratio;
    protected Double intensity;
    private Integer charge = Integer.MIN_VALUE;

    public Peak() {
        this.mz_ratio = 0.0;
        this.intensity = 0.0;
    }

    public Peak(double _mz, double _int) {
        this.mz_ratio = _mz;
        this.intensity = _int;
    }

    public Peak(double _mz, double _int, int _charge) {
        this.mz_ratio = _mz;
        this.intensity = _int;
        this.charge = _charge;
    }

    public Peak clone() {
        Peak clone = new Peak(this.mz_ratio, this.intensity);
        clone.setCharge(this.charge);
        return clone;
    }

    @Override
    public int compareTo(Peak p) {
        if (this.mz_ratio < p.mz_ratio) {
            return -1;
        }
        if (this.mz_ratio > p.mz_ratio) {
            return 1;
        }
        return 0;
    }

    public boolean equals(Object other) {
        if (!(other instanceof Peak)) {
            return false;
        }
        Peak p = (Peak)other;
        return Math.abs(this.mz_ratio - p.mz_ratio) < 1.0E-10 && Math.abs(this.intensity - p.intensity) < 1.0E-10;
    }

    public boolean mzEquals(Peak it) {
        return Math.abs(this.mz_ratio - it.mz_ratio) < 1.0E-10;
    }

    public boolean mzEquals(Peak it, MassUnit unit, double accuracy) {
        if (unit == MassUnit.PPM) {
            return Math.abs(1.0 - it.getMZ() / this.mz_ratio) < 1.0E-6 * accuracy;
        }
        return Math.abs(this.mz_ratio - it.getMZ()) < accuracy;
    }

    public int hashCode() {
        return this.mz_ratio.hashCode() + this.intensity.hashCode();
    }

    public double getMZ() {
        return this.mz_ratio;
    }

    public void setMZ(double _mz) {
        this.mz_ratio = _mz;
    }

    public double getIntensity() {
        return this.intensity;
    }

    public void setIntensity(double _int) {
        this.intensity = _int;
    }

    public String toString() {
        return this.mz_ratio + " " + this.intensity;
    }

    public static Peak parseString(String str) {
        try {
            Matcher m = pattern4.matcher(str);
            if (m.matches()) {
                return new Peak(Double.valueOf(m.group(1)), Double.valueOf(m.group(2)), Integer.valueOf(m.group(4)));
            }
            m = pattern3.matcher(str);
            if (m.matches()) {
                boolean col3IsCharge = false;
                try {
                    Integer.valueOf(m.group(3));
                    col3IsCharge = true;
                }
                catch (NumberFormatException e1) {
                    try {
                        Double.valueOf(m.group(3));
                    }
                    catch (NumberFormatException e2) {
                        return null;
                    }
                }
                if (col3IsCharge) {
                    return new Peak(Double.valueOf(m.group(1)), Double.valueOf(m.group(2)), Integer.valueOf(m.group(3)));
                }
                return new Peak(Double.valueOf(m.group(1)), Double.valueOf(m.group(2)));
            }
            m = pattern2.matcher(str);
            if (m.matches()) {
                return new Peak(Double.valueOf(m.group(1)), Double.valueOf(m.group(2)));
            }
            m = pattern1.matcher(str);
            if (m.matches()) {
                return new Peak(Double.valueOf(m.group(1)), 1.0);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return null;
    }

    public static Peak fromXML(Node peak_node) throws Exception {
        Peak ret = new Peak();
        ret.mz_ratio = Double.valueOf(XMLUtils.getAttribute((Node)peak_node, (String)"mz_ratio"));
        ret.intensity = Double.valueOf(XMLUtils.getAttribute((Node)peak_node, (String)"intensity"));
        if (XMLUtils.getAttribute((Node)peak_node, (String)"charge") != null) {
            ret.charge = Integer.valueOf(XMLUtils.getAttribute((Node)peak_node, (String)"charge"));
        }
        return ret;
    }

    public Element toXML(Document document) {
        if (document == null) {
            return null;
        }
        Element peak_node = document.createElement("Peak");
        if (peak_node == null) {
            return null;
        }
        peak_node.setAttribute("mz_ratio", "" + this.mz_ratio);
        peak_node.setAttribute("intensity", "" + this.intensity);
        if (this.getCharge() != Integer.MIN_VALUE) {
            peak_node.setAttribute("charge", "" + this.getCharge());
        }
        return peak_node;
    }

    public void write(TransformerHandler th) throws SAXException {
        AttributesImpl atts = new AttributesImpl();
        atts.addAttribute("", "", "mz_ratio", "CDATA", "" + this.mz_ratio);
        atts.addAttribute("", "", "intensity", "CDATA", "" + this.intensity);
        if (this.charge != Integer.MIN_VALUE) {
            atts.addAttribute("", "", "charge", "CDATA", "" + this.charge);
        }
        th.startElement("", "", "Peak", atts);
        th.endElement("", "", "Peak");
    }

    public void setCharge(int charge) {
        this.charge = charge;
    }

    public int getCharge() {
        return this.charge;
    }

    static {
        String number = "(\\S+)";
        String separator = "(?:\\s+|[,;])";
        pattern1 = Pattern.compile("^\\s*" + number + "\\s*$");
        pattern2 = Pattern.compile("^\\s*" + number + separator + number + "\\s*$");
        pattern3 = Pattern.compile("^\\s*" + number + separator + number + separator + number + "\\s*$");
        pattern4 = Pattern.compile("^\\s*" + number + separator + number + separator + number + separator + number + "\\s*$");
    }

    public static class SAXHandler
    extends SAXUtils.ObjectTreeHandler {
        public boolean isElement(String namespaceURI, String localName, String qName) {
            return qName.equals(SAXHandler.getNodeElementName());
        }

        public static String getNodeElementName() {
            return "Peak";
        }

        protected void initContent(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
            super.initContent(namespaceURI, localName, qName, atts);
            Peak ret = new Peak();
            ret.mz_ratio = this.doubleAttribute(atts, "mz_ratio", 0.0);
            ret.intensity = this.doubleAttribute(atts, "intensity", 0.0);
            ret.charge = this.integerAttribute(atts, "charge", Integer.MIN_VALUE);
            this.object = ret;
        }
    }
}

