/*
 * Decompiled with CFR 0.152.
 */
package org.eurocarbdb.application.glycoworkbench;

import java.awt.BorderLayout;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.KeyStroke;
import org.eurocarbdb.application.glycoworkbench.GlycoWorkbench;

public class DockableEvent {
    private Window defaultDockedWindow;
    private Container defaultDockedContainer;
    private Container currentDockedWindow;
    private Container currentDockedContainer;
    private Point lastDetachedPosition;
    private Dimension lastSize;
    private String title;
    private static Point lastPlacedWindowPosition;
    private Image theIcon;
    private static List<JFrame> detachedFrames;
    private static List<AbstractAction> globalActions;

    public static Point getLastPlacedWindowPosition() {
        return lastPlacedWindowPosition;
    }

    public static void setLastPlacedWindowPosition(Point lastPlacedWindowPosition) {
        DockableEvent.lastPlacedWindowPosition = lastPlacedWindowPosition;
    }

    public DockableEvent(Window _defaultDockedWindow, Container _defaultDockedContainer, String _title, Image icon) {
        this.defaultDockedWindow = _defaultDockedWindow;
        this.defaultDockedContainer = _defaultDockedContainer;
        this.title = _title;
        this.theIcon = icon;
    }

    public static List<JFrame> getDetachedFrames() {
        return detachedFrames;
    }

    public static List<AbstractAction> getGlobalActions() {
        return globalActions;
    }

    public static void setGlobalActions(List<AbstractAction> globalActions) {
        DockableEvent.globalActions = globalActions;
    }

    public static void addGlobalAction(AbstractAction globalAction) {
        globalActions.add(globalAction);
    }

    public Container getCurrentDockedWindow() {
        return this.currentDockedWindow;
    }

    protected void changeCanvasPaneContainer(GlycoWorkbench.CONTAINER container) {
        if (this.currentDockedWindow == null) {
            this.currentDockedWindow = this.defaultDockedWindow;
        } else if (container == GlycoWorkbench.CONTAINER.DOCKED && this.currentDockedWindow == this.defaultDockedWindow || container == GlycoWorkbench.CONTAINER.FRAME && this.currentDockedWindow != this.defaultDockedWindow && this.currentDockedWindow instanceof JFrame) {
            return;
        }
        if (container != GlycoWorkbench.CONTAINER.NODEC_DIALOG) {
            if (container == GlycoWorkbench.CONTAINER.FRAME) {
                JFrame.setDefaultLookAndFeelDecorated(true);
                final JFrame frame = new JFrame();
                frame.setDefaultCloseOperation(0);
                frame.addWindowListener(new WindowListener(){

                    @Override
                    public void windowActivated(WindowEvent arg0) {
                    }

                    @Override
                    public void windowClosed(WindowEvent arg0) {
                    }

                    @Override
                    public void windowClosing(WindowEvent arg0) {
                        DockableEvent.this.changeCanvasPaneContainer(GlycoWorkbench.CONTAINER.DOCKED);
                        detachedFrames.remove(frame);
                    }

                    @Override
                    public void windowDeactivated(WindowEvent arg0) {
                    }

                    @Override
                    public void windowDeiconified(WindowEvent arg0) {
                    }

                    @Override
                    public void windowIconified(WindowEvent arg0) {
                    }

                    @Override
                    public void windowOpened(WindowEvent arg0) {
                    }
                });
                frame.setLayout(new BorderLayout());
                frame.setIconImage(this.theIcon);
                this.initialise(frame, this.currentDockedContainer);
                this.currentDockedWindow = frame;
                this.currentDockedContainer = frame;
                frame.pack();
                if (this.lastDetachedPosition != null) {
                    this.currentDockedWindow.setLocation(this.lastDetachedPosition);
                    this.currentDockedWindow.setSize(this.lastSize);
                } else if (lastPlacedWindowPosition == null) {
                    lastPlacedWindowPosition = new Point(0, 0);
                    this.currentDockedWindow.setLocation(lastPlacedWindowPosition);
                } else {
                    lastPlacedWindowPosition = new Point((int)lastPlacedWindowPosition.getX() + 20, (int)lastPlacedWindowPosition.getY() + 30);
                    this.currentDockedWindow.setLocation(lastPlacedWindowPosition);
                }
                frame.setTitle(this.title);
                frame.setVisible(true);
                detachedFrames.add(frame);
                DockableEvent.initiliseGlobalKeyBindings(frame);
            } else if (container == GlycoWorkbench.CONTAINER.DOCKED) {
                this.initialise(this.defaultDockedContainer, this.currentDockedContainer);
                if (this.defaultDockedWindow != this.currentDockedWindow && this.currentDockedWindow instanceof JFrame) {
                    this.lastDetachedPosition = this.currentDockedWindow.getLocation();
                    this.lastSize = this.currentDockedWindow.getSize();
                    this.currentDockedWindow.setVisible(false);
                    ((JFrame)this.currentDockedWindow).dispose();
                }
                this.currentDockedContainer = this.defaultDockedContainer;
                this.currentDockedWindow = this.defaultDockedWindow;
                this.finaliseAttachment();
            }
        }
    }

    protected void initialise(Container moveToContainer, Container currentDockedContainer) {
    }

    protected void finaliseAttachment() {
    }

    public static void initiliseGlobalKeyBindings(JFrame frame) {
        JComponent component = (JComponent)frame.getContentPane();
        for (AbstractAction action : globalActions) {
            component.registerKeyboardAction(action, (String)action.getValue("ActionCommandKey"), (KeyStroke)action.getValue("AcceleratorKey"), 2);
        }
    }

    static {
        detachedFrames = new ArrayList<JFrame>();
        globalActions = new ArrayList<AbstractAction>();
    }
}

