/*
 * Decompiled with CFR 0.152.
 */
package edu.brandeis.glycodenovo.wizard;

import edu.brandeis.glycodenovo.core.CSpectrum;
import edu.brandeis.glycodenovo.datamodel.SettingForm;
import edu.brandeis.glycodenovo.datamodel.TableView;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.grits.toolbox.core.dataShare.PropertyHandler;
import org.grits.toolbox.core.datamodel.Entry;
import org.grits.toolbox.core.datamodel.dialog.ProjectExplorerDialog;
import org.grits.toolbox.core.datamodel.property.Property;
import org.grits.toolbox.core.utilShare.ListenerFactory;
import org.grits.toolbox.entry.ms.property.MassSpecProperty;
import org.grits.toolbox.entry.ms.property.datamodel.MSPropertyDataFile;

public class PageEntryChooser
extends WizardPage {
    private Composite mContainer;
    private SettingForm mForm;
    private Text mDescriptionText;
    private List<MSPropertyDataFile> mAnnotationFiles;

    protected PageEntryChooser(String pageName, SettingForm form) {
        super(pageName);
        this.setTitle("GlycoDeNovo: Reconstruct Topologies.");
        this.mForm = form;
    }

    public boolean canFlipToNextPage() {
        return this.mForm.isPathValid();
    }

    public void createControl(Composite parent) {
        this.mContainer = new Composite(parent, 0);
        this.mContainer.setLayout((Layout)new GridLayout(3, false));
        GridData gridData = new GridData(256);
        gridData.horizontalSpan = 2;
        Button btnSelectEntry = new Button(this.mContainer, 0);
        btnSelectEntry.setText("Select an Entry");
        Label empty = new Label(this.mContainer, 0);
        empty.setLayoutData((Object)gridData);
        Label entry_name_label = new Label(this.mContainer, 0);
        entry_name_label.setText("Entry Name");
        final Text entry_name = new Text(this.mContainer, 8);
        entry_name.setLayoutData((Object)gridData);
        Label res_label = new Label(this.mContainer, 0);
        res_label.setText("Result Name (defaut)");
        final Text res_name = new Text(this.mContainer, 8);
        res_name.setLayoutData((Object)gridData);
        Button button_OptionalResultFile = new Button(this.mContainer, 0);
        button_OptionalResultFile.setText("Set an Optional Result File");
        final Text optional_res_name = new Text(this.mContainer, 8);
        optional_res_name.setLayoutData((Object)gridData);
        button_OptionalResultFile.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                FileDialog fileDlg = new FileDialog(PageEntryChooser.this.mContainer.getShell(), 8192);
                fileDlg.setText("Select the location that you want to save result of GlycoDeNovo");
                String filename = fileDlg.open();
                System.out.println(filename);
                if (filename != null) {
                    PageEntryChooser.this.mForm.setOptionalResName(filename);
                    optional_res_name.setText(filename);
                }
                PageEntryChooser.this.getContainer().updateButtons();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        new Label(this.mContainer, 0).setText("Select the original data file:");
        final Combo combo = new Combo(this.mContainer, 12);
        combo.setLayoutData((Object)gridData);
        combo.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent a_e) {
                PageEntryChooser.this.selectMSProperty(combo);
                PageEntryChooser.this.getContainer().updateButtons();
            }

            public void widgetDefaultSelected(SelectionEvent a_e) {
            }
        });
        btnSelectEntry.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                Entry entry = PageEntryChooser.this.selectEntry();
                PageEntryChooser.this.mForm.setEntry(entry);
                PageEntryChooser.this.getContainer().updateButtons();
                PageEntryChooser.this.updateSelection(entry_name, res_name, combo);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.setPageComplete(false);
        this.createDescription(this.mContainer);
        this.createButtonReviewData();
        this.setControl((Control)this.mContainer);
    }

    private void createDescription(Composite parent) {
        GridData descriptionData = new GridData();
        Label descriptionLabel = new Label(parent, 0);
        descriptionData.grabExcessHorizontalSpace = true;
        descriptionData.horizontalSpan = 7;
        descriptionLabel.setText("Data file description");
        descriptionLabel.setLayoutData((Object)descriptionData);
        GridData descriptionTextData = new GridData(1808);
        descriptionTextData.minimumHeight = 70;
        descriptionTextData.grabExcessHorizontalSpace = true;
        descriptionTextData.horizontalSpan = 7;
        this.mDescriptionText = new Text(parent, 2570);
        this.mDescriptionText.setLayoutData((Object)descriptionTextData);
        this.mDescriptionText.addTraverseListener(ListenerFactory.getTabTraverseListener());
        this.mDescriptionText.addKeyListener(ListenerFactory.getCTRLAListener());
    }

    private void showDataInformation() {
        String description = this.mForm.getDescription();
        if (description != null) {
            this.mDescriptionText.setText(description);
        } else {
            this.mDescriptionText.setText("");
        }
    }

    private void updateSelection(Text entry_name, Text res_name, Combo combo) {
        if (this.mForm.getEntry() != null) {
            entry_name.setText(this.mForm.getEntry().getDisplayName());
            res_name.setText(String.valueOf(this.mForm.getEntry().getDisplayName()) + ".GlycoDeNovo");
            this.mForm.setResName(res_name.getText());
            this.updateMSProperty(combo);
        } else {
            entry_name.setText("");
            res_name.setText("");
            this.mForm.setResName(null);
        }
    }

    private Entry selectEntry() {
        Shell newShell = new Shell(this.mContainer.getShell(), 0x10008000);
        ProjectExplorerDialog dlg = new ProjectExplorerDialog(newShell);
        dlg.addFilter("org.grits.toolbox.property.ms.mycustom");
        dlg.setTitle("Select an MS entry");
        dlg.setMessage("Choose an MS experiment");
        dlg.open();
        return dlg.getEntry();
    }

    private void getAnnotationFilesForEntry() {
        Property prop;
        this.mAnnotationFiles = new ArrayList<MSPropertyDataFile>();
        if (this.mForm.getEntry() != null && (prop = this.mForm.getEntry().getProperty()) instanceof MassSpecProperty) {
            List files = ((MassSpecProperty)prop).getMassSpecMetaData().getAnnotationFiles();
            for (MSPropertyDataFile propertyDataFile : files) {
                this.mAnnotationFiles.add(propertyDataFile);
            }
        }
    }

    private void selectMSProperty(Combo combo) {
        MSPropertyDataFile selected = this.mAnnotationFiles.get(combo.getSelectionIndex());
        this.mForm.setDataFile(selected);
        String workspace = PropertyHandler.getVariable((String)"workspace_location");
        String path = String.valueOf(workspace) + this.findProjectName() + File.separator + "ms" + File.separator + selected.getName();
        int index = path.lastIndexOf(File.separator) + 1;
        String file = path.substring(index);
        path = path.substring(0, index - 1);
        this.mForm.setFilePath(path, file);
        System.out.println(this.mForm.getFilePath());
        CSpectrum spec = new CSpectrum(this.mForm.getFilePath());
        this.mForm.setSpectrum(spec);
        this.showDataInformation();
    }

    private String findProjectName() {
        String s = "";
        Entry entry = this.mForm.getEntry();
        while (entry != null && entry.getParent() != null && !entry.getParent().getDisplayName().equals("workspace")) {
            entry = entry.getParent();
            s = entry.getDisplayName();
        }
        return s;
    }

    private void updateMSProperty(Combo combo) {
        if (this.mForm.getEntry() == null) {
            MessageDialog.openError((Shell)this.getContainer().getShell(), (String)"Error", (String)"Please select entry first");
        } else {
            combo.removeAll();
            this.getAnnotationFilesForEntry();
            for (MSPropertyDataFile file : this.mAnnotationFiles) {
                String fileName = file.getName().substring(file.getName().lastIndexOf(File.separator) + 1);
                System.out.println(fileName);
                combo.add(fileName);
            }
            combo.select(0);
            this.selectMSProperty(combo);
            this.getContainer().updateButtons();
        }
    }

    private void createButtonReviewData() {
        Button review = new Button(this.mContainer, 2056);
        review.setText("review your data");
        review.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent a_e) {
                TableView table = new TableView(PageEntryChooser.this.mContainer, PageEntryChooser.this.mForm.getSpectrum());
                table.open();
            }

            public void widgetDefaultSelected(SelectionEvent a_e) {
            }
        });
    }
}

