/*
 * Decompiled with CFR 0.152.
 */
package edu.brandeis.glycodenovo.core;

import edu.brandeis.glycodenovo.core.CGlycoDeNovo;
import edu.brandeis.glycodenovo.core.CPeak;
import edu.brandeis.glycodenovo.core.CTopology;
import edu.brandeis.glycodenovo.core.CTopologySet;
import edu.brandeis.glycodenovo.core.HLightArrayList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;

public class CTopologySuperSet
implements Comparable<CTopologySuperSet> {
    boolean mLegal;
    String mType;
    double mMassPeak = 0.0;
    double mMassLow = Double.MAX_VALUE;
    double mMassHigh = 0.0;
    CGlycoDeNovo mReconstructor;
    Map<Integer, Integer> mTargetPeaks = new HashMap<Integer, Integer>();
    boolean mReconstructed = false;
    ArrayList<CTopologySet> mTopologySets = new ArrayList();
    HLightArrayList<CTopology> mTopologies;

    public CTopologySuperSet(String mType, double mMassPeak, CGlycoDeNovo mReconstructor, int peakIndex) {
        this.mType = mType;
        this.mMassPeak = mMassPeak;
        this.mReconstructor = mReconstructor;
        if (mType.equals("B")) {
            this.mTargetPeaks.put(peakIndex, 1);
        } else if (mType.equals("C")) {
            this.mTargetPeaks.put(peakIndex, 2);
        } else if (mType.equals("T")) {
            this.mTargetPeaks.put(peakIndex, 3);
        }
    }

    void addPeak(int peakIndex, int peakType) {
        if (!this.mTargetPeaks.containsKey(peakIndex)) {
            this.mTargetPeaks.put(peakIndex, peakType);
        }
    }

    void addATopologySet(CTopologySet newSet) {
        if (!newSet.mType.equals(this.mType)) {
            return;
        }
        this.mTopologySets.add(newSet);
        this.mMassLow = Math.min(newSet.mMassLow, this.mMassLow);
        this.mMassHigh = Math.max(newSet.mMassHigh, this.mMassHigh);
        newSet.mTargetPeaks = new HashMap<Integer, Integer>(this.mTargetPeaks);
    }

    boolean contains(CTopologySuperSet tss) {
        if (tss.mMassLow < this.mMassLow - 1.0E-7 || tss.mMassHigh > this.mMassHigh + 1.0E-7) {
            return false;
        }
        for (CTopologySet tssTS : tss.mTopologySets) {
            boolean notFound = true;
            for (CTopologySet mTS : this.mTopologySets) {
                if (!mTS.equals(tssTS)) continue;
                notFound = false;
                break;
            }
            if (!notFound) continue;
            return false;
        }
        return true;
    }

    public HLightArrayList<CTopology> getTopologies() {
        return this.mTopologies;
    }

    @Override
    public int compareTo(CTopologySuperSet o) {
        return Double.compare(this.mMassPeak, o.mMassPeak);
    }

    void reconstructFormulas() {
        if (this.mReconstructed) {
            return;
        }
        this.mTopologies = new HLightArrayList();
        Iterator<CTopologySet> iterTS = this.mTopologySets.iterator();
        while (iterTS.hasNext()) {
            CTopologySet mts = iterTS.next();
            mts.reconstructFormulas();
            if (mts.mTopologies.isEmpty()) {
                iterTS.remove();
                continue;
            }
            ((ArrayList)this.mTopologies).addAll(mts.mTopologies);
        }
        this.mReconstructed = true;
        this.mLegal = !this.mTopologies.isEmpty();
        HashMap<String, CTopology> formulatoTp = new HashMap<String, CTopology>();
        Iterator iterTp = this.mTopologies.iterator();
        while (iterTp.hasNext()) {
            CTopology mtp = (CTopology)iterTp.next();
            CTopology curr = formulatoTp.putIfAbsent(mtp.mFormula, mtp);
            if (curr == null) continue;
            curr.mSupportPeaks.addAll(mtp.mSupportPeaks);
            HashSet<CPeak> temp = new HashSet<CPeak>(curr.mSupportPeaks);
            ArrayList<CPeak> uniqueSupportPeaks = new ArrayList<CPeak>(temp);
            curr.mSupportPeaks = uniqueSupportPeaks;
            curr.mScore = curr.mSupportPeaks.size();
            iterTp.remove();
        }
    }
}

