/*
 * Decompiled with CFR 0.152.
 */
package edu.brandeis.glycodenovo.core;

import edu.brandeis.glycodenovo.core.CMonosaccharideSet;
import java.security.InvalidParameterException;

public class CMonosaccharide {
    int mID = -1;
    String mSymbol = "";
    String mName = "";
    String mClass = "";
    int mClassID = 0;
    String mFormula = "";
    String mInferredFormula = "";
    String mConciseFormula = "";
    boolean mPermethylated = false;
    int mReduced = 0;
    double mMass = -1.0;
    int[] mLegalLinkedInVs;
    int[] mCarbon2Vertex;
    CMonosacVertices mVertices;

    public CMonosaccharide(String symNameClass, boolean permethylated) {
        CMonosaccharideSet[] cMonosaccharideSetArray = CMonosaccharideSet.values();
        int n = cMonosaccharideSetArray.length;
        int n2 = 0;
        while (n2 < n) {
            CMonosaccharideSet mono = cMonosaccharideSetArray[n2];
            if (symNameClass.equals(mono.symbol) || symNameClass.equals(mono.name) || symNameClass.equals(mono.sacClass)) {
                this.mSymbol = mono.symbol;
                this.mName = mono.name;
                this.mClass = mono.sacClass;
                this.mClassID = mono.classID;
                this.mLegalLinkedInVs = (int[])mono.legalLinkedInVs.clone();
                this.mCarbon2Vertex = (int[])mono.carbon2vertex.clone();
                this.mPermethylated = permethylated;
                if (this.mPermethylated) {
                    this.mMass = mono.sacPermethylated.mass;
                    this.mFormula = mono.sacPermethylated.compostition;
                    this.mVertices = new CMonosacVertices(mono.sacPermethylated.vertexComposition, mono.sacPermethylated.vertexPermethylated, mono.sacPermethylated.vertexMass);
                } else {
                    this.mMass = mono.sacNative.mass;
                    this.mFormula = mono.sacNative.compostition;
                    this.mVertices = new CMonosacVertices(mono.sacNative.vertexComposition, mono.sacNative.vertexMass);
                }
                return;
            }
            ++n2;
        }
        throw new InvalidParameterException(String.valueOf(symNameClass) + " is not a valid monosac!");
    }

    class CMonosacVertices {
        String[] mComposition;
        String[] mModification;
        int[] mPermethylated;
        double[] mMass;

        public CMonosacVertices(String[] composition, double[] mass) {
            this.mComposition = (String[])composition.clone();
            this.mMass = (double[])mass.clone();
        }

        public CMonosacVertices(String[] composition, int[] permethylated, double[] mass) {
            this(composition, mass);
            this.mPermethylated = (int[])permethylated.clone();
            String[] cfr_ignored_0 = new String[this.mComposition.length];
        }
    }
}

