/*
 * Decompiled with CFR 0.152.
 */
package edu.brandeis.glycodenovo.core;

import java.security.InvalidParameterException;

public class CMass {
    static final double Electron = 5.489E-4;
    static final double H = 1.0078250321;
    static final double H2 = 2.0156500642;
    static final double H2O = 18.0105646863;
    static final double C = 12.0;
    static final double N = 14.0030740052;
    static final double O = 15.9949146221;
    static final double CH2 = 14.0156500642;
    static final double Proton = 1.007276432;
    static final double Lithium = 7.0154553836;
    static final double Sodium = 22.989769;
    static final double Cesium = 132.90545;
    static final double O18 = 2.00425;
    static final double DEUTERIUM = 17.03758;
    static final double AMINOPYRIDINE = 78.05803471;
    static final double PRAGS = 120.0687;
    public static final double PermethylationMassLoss = 28.0313001284;

    public static double getAtomMass(String atom) {
        switch (atom) {
            case "H": {
                return 1.0078250321;
            }
            case "Proton": {
                return 1.007276432;
            }
            case "Na": {
                return 22.989769;
            }
            case "Li": {
                return 7.0154553836;
            }
            case "Cs": 
            case "Cesium": {
                return 132.90545;
            }
            case "O": {
                return 15.9949146221;
            }
            case "N": {
                return 14.0030740052;
            }
            case "C": {
                return 12.0;
            }
        }
        throw new InvalidParameterException("atom not found!");
    }

    public static double reducingEndMassCompensation(String reducingEndMod, boolean permethylated) {
        switch (reducingEndMod) {
            case "O18": {
                return 2.00425;
            }
            case "Deuterium": {
                return 17.03758;
            }
            case "PRAGS": {
                return 120.0687;
            }
            case "Aminopyridine": {
                return 78.05803471;
            }
            case "Reduced": {
                if (permethylated) {
                    return 16.0313001284;
                }
                return 2.0156500642;
            }
        }
        throw new InvalidParameterException(reducingEndMod);
    }
}

