/*
 * Decompiled with CFR 0.152.
 */
package edu.brandeis.glycodenovo.clustering;

import edu.brandeis.glycodenovo.clustering.Cluster;
import edu.brandeis.glycodenovo.clustering.ClusterPair;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.PriorityQueue;

public class DistanceMap {
    private Map<String, Item> pairHash = new HashMap<String, Item>();
    private PriorityQueue<Item> data = new PriorityQueue();

    public List<ClusterPair> list() {
        ArrayList<ClusterPair> l = new ArrayList<ClusterPair>();
        for (Item clusterPair : this.data) {
            l.add(clusterPair.pair);
        }
        return l;
    }

    public ClusterPair findByCodePair(Cluster c1, Cluster c2) {
        String inCode = this.hashCodePair(c1, c2);
        return this.pairHash.get((Object)inCode).pair;
    }

    public ClusterPair removeFirst() {
        Item poll = this.data.poll();
        while (poll != null && poll.removed) {
            poll = this.data.poll();
        }
        if (poll == null) {
            return null;
        }
        ClusterPair link = poll.pair;
        this.pairHash.remove(poll.hash);
        return link;
    }

    public boolean remove(ClusterPair link) {
        Item remove = this.pairHash.remove(this.hashCodePair(link));
        if (remove == null) {
            return false;
        }
        remove.removed = true;
        this.data.remove(remove);
        return true;
    }

    public boolean add(ClusterPair link) {
        Item e = new Item(link);
        Item existingItem = this.pairHash.get(e.hash);
        if (existingItem != null) {
            System.err.println("hashCode = " + existingItem.hash + " adding redundant link:" + link + " (exist:" + existingItem + ")");
            return false;
        }
        this.pairHash.put(e.hash, e);
        this.data.add(e);
        return true;
    }

    public Double minDist() {
        Item peek = this.data.peek();
        return peek != null ? peek.pair.getLinkageDistance() : null;
    }

    String hashCodePair(ClusterPair link) {
        return this.hashCodePair(link.getlCluster(), link.getrCluster());
    }

    String hashCodePair(Cluster lCluster, Cluster rCluster) {
        return this.hashCodePairNames(lCluster.getName(), rCluster.getName());
    }

    String hashCodePairNames(String lName, String rName) {
        return lName.compareTo(rName) < 0 ? String.valueOf(lName) + "~~~" + rName : String.valueOf(rName) + "~~~" + lName;
    }

    public String toString() {
        return this.data.toString();
    }

    private class Item
    implements Comparable<Item> {
        final ClusterPair pair;
        final String hash;
        boolean removed = false;

        Item(ClusterPair p) {
            this.pair = p;
            this.hash = DistanceMap.this.hashCodePair(p);
        }

        @Override
        public int compareTo(Item o) {
            return this.pair.compareTo(o.pair);
        }

        public String toString() {
            return this.hash;
        }
    }
}

