/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.jrap.grits.stax;

import java.io.FileInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.Iterator;

public class ByteBufferIterator
implements Iterator {
    private int INITIAL_BUFFERSIZE;
    private int bufferSize;
    private FileInputStream fis;
    private FileChannel fc;
    private String fPath;
    private long fSize;
    private ByteBuffer bb;
    private long totBytesRead;

    public void setBufferSize(int b) {
        this.bufferSize = b;
    }

    public int getBufferSize() {
        return this.bufferSize;
    }

    public long getFileSize() {
        return this.fSize;
    }

    public String getPath() {
        return this.fPath;
    }

    public long getFilePos() {
        return this.totBytesRead;
    }

    public ByteBufferIterator(String fN) throws IOException {
        this.bufferSize = this.INITIAL_BUFFERSIZE = 10000;
        this.fis = null;
        this.fc = null;
        this.bb = null;
        this.totBytesRead = 0L;
        this.fPath = fN;
        this.fis = new FileInputStream(fN);
        this.fc = this.fis.getChannel();
        this.fSize = this.fc.size();
    }

    public ByteBufferIterator(String fN, int buflen) throws Exception {
        this.bufferSize = this.INITIAL_BUFFERSIZE = 10000;
        this.fis = null;
        this.fc = null;
        this.bb = null;
        this.totBytesRead = 0L;
        this.fPath = fN;
        this.fis = new FileInputStream(fN);
        this.fc = this.fis.getChannel();
        this.fSize = this.fc.size();
        this.bufferSize = buflen;
    }

    @Override
    public boolean hasNext() {
        return this.totBytesRead < this.fSize;
    }

    public ByteBuffer next() {
        try {
            long numBytesToRead = Math.min((long)this.bufferSize, this.fSize - this.totBytesRead);
            this.bb = this.fc.map(FileChannel.MapMode.READ_ONLY, this.totBytesRead, numBytesToRead);
            int bytesRead = this.bb.capacity();
            if (bytesRead > 0) {
                this.totBytesRead += (long)bytesRead;
            } else {
                this.fis.close();
            }
            this.bb.rewind();
        }
        catch (Exception e) {
            System.err.println("Problem in ByteBufferIterator.next(): " + e);
            e.printStackTrace();
            return null;
        }
        return this.bb;
    }

    @Override
    public void remove() {
    }

    protected void finalize() throws Throwable {
        try {
            this.fis.close();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        super.finalize();
    }
}

