/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.editor.samplemanager.pages;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.grits.toolbox.core.utilShare.ErrorUtils;
import org.grits.toolbox.editor.samplemanager.ManagementEditor;
import org.grits.toolbox.editor.samplemanager.input.ClassesWithFeatures;
import org.grits.toolbox.editor.samplemanager.pages.AbstractManagementPage;
import org.grits.toolbox.editor.samplemanager.pages.general.ListLabelProvider;
import org.grits.toolbox.editor.samplemanager.pages.leftside.SetupLeftSideSection;
import org.grits.toolbox.editor.samplemanager.pages.rightside.RightSideSelectionListener;
import org.grits.toolbox.editor.samplemanager.pages.rightside.category.CategorySelectionListener;
import org.grits.toolbox.editor.samplemanager.util.CategoryObjectComparator;
import org.grits.toolbox.entry.sample.model.Category;

public class CategoryManagementPage
extends AbstractManagementPage {
    private Logger logger = Logger.getLogger(CategoryManagementPage.class);
    public static final String ID = "3";
    public static final String PAGE_TITLE = "Categories";
    private List<Category> inputCategories = this.getAllCategories();
    public HashMap<String, String> uriLabelMap;

    public CategoryManagementPage(ManagementEditor managementEditor) {
        super(managementEditor, ID, PAGE_TITLE);
    }

    public List<Category> getAllCategories() {
        ArrayList<Category> categories = new ArrayList();
        this.logger.debug((Object)"- START : Retrieving all Categories for the Category Page.");
        try {
            categories = ((ManagementEditor)this.getEditor()).getOntologyManagerApi().getAllCategories();
        }
        catch (Exception ex) {
            ErrorUtils.createErrorMessageBox((Shell)Display.getCurrent().getActiveShell(), (String)"Error Reading Ontology", (Exception)ex);
            this.logger.error((Object)ex);
        }
        this.logger.debug((Object)"- END   : Retrieving all Categories for the Category Page.");
        return categories;
    }

    @Override
    public void createRestOftheContent() {
        this.logger.debug((Object)"- START : Creating remaining part for the Category page.");
        try {
            this.leftSectionOfPage.setText(this.getTitle());
            SetupLeftSideSection leftSectionSetup = new SetupLeftSideSection(this, this.getInput());
            this.leftSideTableViewer = leftSectionSetup.tableViewer;
            this.uriLabelMap = ((ManagementEditor)this.getEditor()).getAllCategoriesURILabelMap();
            ((ListLabelProvider)this.leftSideTableViewer.getLabelProvider()).setCategoryHashMap(this.uriLabelMap);
            Collections.sort(this.inputCategories, new CategoryObjectComparator());
            this.leftSideTableViewer.setInput(this.getInput());
            this.leftSideTableViewer.addSelectionChangedListener((ISelectionChangedListener)this.getSelectionListener());
        }
        catch (Exception ex) {
            this.logger.error((Object)ex);
        }
        this.logger.debug((Object)"- END   : Creating remaining part for the Category page.");
    }

    @Override
    protected Object getInput() {
        return this.inputCategories;
    }

    @Override
    protected void sortLeftSideInput() {
    }

    @Override
    protected RightSideSelectionListener getSelectionListener() {
        return new CategorySelectionListener(this, this.uriLabelMap);
    }

    @Override
    protected void addInputToList(List<ClassesWithFeatures> inputList, int selectionIndex, String label, String uri) {
    }

    @Override
    public void refreshPage() {
        this.leftSideSelection = Math.max(this.leftSideTableViewer.getTable().getSelectionIndex(), 0);
        this.inputCategories = this.getAllCategories();
        Collections.sort(this.inputCategories, new CategoryObjectComparator());
        this.leftSideTableViewer.setInput(this.inputCategories);
        if (this.leftSideTableViewer.getTable().getItemCount() > 0) {
            this.leftSideTableViewer.getTable().select(this.leftSideSelection);
            this.leftSideTableViewer.setSelection(this.leftSideTableViewer.getSelection());
        }
    }
}

