/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.editor.samplemanager.actions.pages.rightside.descriptortype.descriptorgroup;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.TableViewer;
import org.grits.toolbox.editor.samplemanager.actions.pages.rightside.AbstractAddAction;
import org.grits.toolbox.editor.samplemanager.dialogs.DescriptorSelectionDialog;
import org.grits.toolbox.editor.samplemanager.input.DescriptorWithFeatures;
import org.grits.toolbox.editor.samplemanager.pages.AbstractManagementPage;
import org.grits.toolbox.editor.samplemanager.pages.DesciptorManagementPage;
import org.grits.toolbox.entry.sample.model.Descriptor;
import org.grits.toolbox.entry.sample.model.DescriptorGroup;
import org.grits.toolbox.entry.sample.utilities.UtilityDescriptorDescriptorGroup;

public class AddDescriptorToGroupAction
extends AbstractAddAction {
    private CheckboxTableViewer tableViewer = null;
    private ArrayList<Descriptor> descriptors;
    private DescriptorSelectionDialog descriptorSelectionDialog;
    private HashMap<String, String> descriptorLabelToObjectMap;
    private List<DescriptorWithFeatures> descriptorsWithFeatures;

    public AddDescriptorToGroupAction(AbstractManagementPage page, CheckboxTableViewer tableViewer) {
        super(page, (TableViewer)tableViewer);
        this.tableViewer = tableViewer;
        this.descriptors = new ArrayList();
        this.descriptorSelectionDialog = new DescriptorSelectionDialog(page.getRightSectionOfPage().getShell());
        this.descriptorSelectionDialog.setInitialPattern("?");
    }

    @Override
    public void run() {
        DescriptorGroup descriptorGroup = (DescriptorGroup)this.tableViewer.getInput();
        this.descriptorSelectionDialog.setTitle("Add to the Descriptor Group : " + descriptorGroup.getLabel());
        List descriptorLabels = UtilityDescriptorDescriptorGroup.getDescriptorLabels((DescriptorGroup)descriptorGroup);
        this.descriptorSelectionDialog.setNotAllowedLabels(descriptorLabels);
        this.fillDialogChoices();
        this.descriptorSelectionDialog.open();
        if (this.descriptorSelectionDialog.getReturnCode() == 0) {
            String selectedDescriptorLabel = (String)this.descriptorSelectionDialog.getFirstResult();
            String descriptorUri = this.descriptorLabelToObjectMap.get(selectedDescriptorLabel);
            Descriptor descriptor = null;
            for (DescriptorWithFeatures d : this.descriptorsWithFeatures) {
                if (!d.getUri().equals(descriptorUri)) continue;
                descriptor = d.getDescriptor();
                break;
            }
            if (this.descriptorSelectionDialog.maxOccurrence != null) {
                descriptor.setMaxOccurrence(this.descriptorSelectionDialog.maxOccurrence);
            }
            if (this.descriptorSelectionDialog.mandatory) {
                descriptorGroup.addMandatoryDescriptor(descriptor);
            } else {
                descriptorGroup.addOptionalDescriptor(descriptor);
            }
            this.addDescriptorToGroupInOntology(descriptorGroup.getUri(), descriptor.getUri(), this.descriptorSelectionDialog.maxOccurrence, this.descriptorSelectionDialog.mandatory);
            this.refreshModifed();
        }
    }

    private void fillDialogChoices() {
        this.descriptorLabelToObjectMap = new HashMap();
        this.descriptorsWithFeatures = ((DesciptorManagementPage)this.editor.findPage("0")).getAllDescriptorWithFeatures();
        for (DescriptorWithFeatures descriptorWithFeatures : this.descriptorsWithFeatures) {
            this.descriptors.add(descriptorWithFeatures.getDescriptor());
            this.descriptorLabelToObjectMap.put(descriptorWithFeatures.getLabel(), descriptorWithFeatures.getDescriptor().getUri());
        }
        this.descriptorSelectionDialog.setAllDescriptors(this.descriptors);
    }

    private void addDescriptorToGroupInOntology(String groupURI, String descriptorURI, Integer maxOcurrence, boolean mandatory) {
        this.ontologyManagerApi.addDescriptorToGroup(groupURI, descriptorURI, maxOcurrence, mandatory);
    }
}

