/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.editor.samplemanager.actions.pages.rightside.category;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.jface.viewers.TableViewer;
import org.grits.toolbox.editor.samplemanager.actions.pages.rightside.AbstractAddAction;
import org.grits.toolbox.editor.samplemanager.dialogs.DescriptorGroupSelectionDialog;
import org.grits.toolbox.editor.samplemanager.input.DescriptorGroupWithFeatures;
import org.grits.toolbox.editor.samplemanager.pages.AbstractManagementPage;
import org.grits.toolbox.editor.samplemanager.pages.DescriptorGroupManagementPage;
import org.grits.toolbox.entry.sample.model.Category;
import org.grits.toolbox.entry.sample.model.DescriptorGroup;
import org.grits.toolbox.entry.sample.utilities.UtilityDescriptorDescriptorGroup;

public class AddDescriptorGroupToCategoryAction
extends AbstractAddAction {
    private ArrayList<DescriptorGroup> descriptorGroups = new ArrayList();
    private HashMap<String, String> descriptorLabelToObjectMap;
    private List<DescriptorGroupWithFeatures> descriptorGroupsWithFeatures;
    private DescriptorGroupSelectionDialog descriptorGroupSelectionDialog;

    public AddDescriptorGroupToCategoryAction(AbstractManagementPage page, TableViewer tableViewer) {
        super(page, tableViewer);
        this.descriptorGroupSelectionDialog = new DescriptorGroupSelectionDialog(page.getRightSectionOfPage().getShell(), false);
        this.descriptorGroupSelectionDialog.setInitialPattern("?");
    }

    @Override
    public void run() {
        Category selectedCategory = (Category)this.tableViewer.getInput();
        this.descriptorGroupSelectionDialog.setTitle("Add to the " + this.editor.getAllCategoriesURILabelMap().get(selectedCategory.getUri()));
        List descriptorGroupLabels = UtilityDescriptorDescriptorGroup.getDescriptorGroupLabels((Category)selectedCategory);
        this.descriptorGroupSelectionDialog.setNotAllowedLabels(descriptorGroupLabels);
        this.fillDialogChoices();
        this.descriptorGroupSelectionDialog.open();
        if (this.descriptorGroupSelectionDialog.getReturnCode() == 0) {
            String selectedDescriptorGroupLabel = (String)this.descriptorGroupSelectionDialog.getFirstResult();
            String descriptorGroupUri = this.descriptorLabelToObjectMap.get(selectedDescriptorGroupLabel);
            DescriptorGroup descriptorGroup = null;
            for (DescriptorGroupWithFeatures d : this.descriptorGroupsWithFeatures) {
                if (!d.getUri().equals(descriptorGroupUri)) continue;
                descriptorGroup = d.getDescriptorGroup();
                break;
            }
            if (this.descriptorGroupSelectionDialog.maxOccurrence != null) {
                descriptorGroup.setMaxOccurrence(this.descriptorGroupSelectionDialog.maxOccurrence);
            }
            selectedCategory.addDescriptorGroup(descriptorGroup);
            this.ontologyManagerApi.updateCategorySelection(selectedCategory.getUri(), descriptorGroup.getUri(), true);
            this.ontologyManagerApi.updateMaxOccurrence(descriptorGroup.getUri(), this.descriptorGroupSelectionDialog.maxOccurrence);
            this.refreshModifed();
        }
    }

    private void fillDialogChoices() {
        this.descriptorLabelToObjectMap = new HashMap();
        this.descriptorGroupsWithFeatures = ((DescriptorGroupManagementPage)this.editor.findPage("1")).getAllDescriptorGroupWithFeatures();
        for (DescriptorGroupWithFeatures descriptorWithFeatures : this.descriptorGroupsWithFeatures) {
            this.descriptorGroups.add(descriptorWithFeatures.getDescriptorGroup());
            this.descriptorLabelToObjectMap.put(descriptorWithFeatures.getLabel(), descriptorWithFeatures.getDescriptorGroup().getUri());
        }
        this.descriptorGroupSelectionDialog.setAllDescriptorGroups(this.descriptorGroups);
    }
}

