/*
 * Decompiled with CFR 0.152.
 */
package org.glycoinfo.WURCSFramework.wurcs.graph;

import org.glycoinfo.WURCSFramework.wurcs.graph.CarbonDescriptorInterface;

public enum CarbonDescriptor_TBD implements CarbonDescriptorInterface
{
    SZ3_METHYL_L('m', "sp3", 1, 0, 1, null, null, "-H", "-H", "-H", 4),
    SZ3_METHYL_U('M', "sp3", 1, 0, 1, null, null, "-X", "-X", "-X", 10),
    SZ3_HYDROXYL('h', "sp3", 1, 0, 2, null, null, "-H", "-H", "-X", 6),
    SZ3_ACETAL_L('c', "sp3", 1, 0, 2, null, null, "-X", "-X", "-H", 8),
    SZ3_ACETAL_U('C', "sp3", 1, 0, 2, null, null, "-X", "-X", "-X", 10),
    SZ3_STEREO_S_L('1', "sp3", 1, 0, 3, "S", null, "-X", "-X", "-H", 10),
    SZ3_STEREO_R_L('2', "sp3", 1, 0, 3, "R", null, "-X", "-X", "-H", 9),
    SZ3_STEREO_s_L('3', "sp3", 1, 0, 3, "s", null, "-X", "-X", "-H", 10),
    SZ3_STEREO_r_L('4', "sp3", 1, 0, 3, "r", null, "-X", "-X", "-H", 9),
    SZ3_STEREO_X_L('x', "sp3", 1, 0, 3, "X", null, "-X", "-X", "-H", 8),
    SZ3_STEREO_S_U('5', "sp3", 1, 0, 3, "S", null, "-X", "-X", "-X", 12),
    SZ3_STEREO_R_U('6', "sp3", 1, 0, 3, "R", null, "-X", "-X", "-X", 11),
    SZ3_STEREO_s_U('7', "sp3", 1, 0, 3, "s", null, "-X", "-X", "-X", 12),
    SZ3_STEREO_r_U('8', "sp3", 1, 0, 3, "r", null, "-X", "-X", "-X", 11),
    SZ3_STEREO_X_U('X', "sp3", 1, 0, 3, "X", null, "-X", "-X", "-X", 10),
    SZ2_ALDEHYDE('o', "sp2", 1, 0, 2, null, null, "=X", "-H", null, 17),
    SZ2_ACID_U('A', "sp2", 1, 0, 2, null, null, "=X", "-X", null, 14),
    DZ2_METHYLENE_L('n', "sp2", 2, 0, 1, null, null, "-H", "-H", null, 4),
    DZ2_METHYLENE_U('N', "sp2", 2, 0, 1, null, null, "-X", "-X", null, 8),
    DZ2_CISTRANS_EL('e', "sp2", 2, 0, 2, "E", null, "-X", "-H", null, 8),
    DZ2_CISTRANS_ZL('z', "sp2", 2, 0, 2, "Z", null, "-X", "-H", null, 7),
    DZ2_CISTRANS_XL('f', "sp2", 2, 0, 2, "X", null, "-X", "-H", null, 7),
    DZ2_CISTRANS_EU('E', "sp2", 2, 0, 2, "E", null, "-X", "-X", null, 10),
    DZ2_CISTRANS_ZU('Z', "sp2", 2, 0, 2, "Z", null, "-X", "-X", null, 9),
    DZ2_CISTRANS_XU('F', "sp2", 2, 0, 2, "X", null, "-X", "-X", null, 8),
    SZ1_XETHYNE('T', "sp", 1, 0, 1, null, null, "#X", null, null, 10),
    DZ1_KETENE_U('K', "sp", 2, 0, 1, null, null, "=X", null, null, 6),
    TZ1_ETHYNE_L('t', "sp", 3, 0, 1, null, null, "-H", null, null, 4),
    TZ1_ETHYNE_U('T', "sp", 3, 0, 1, null, null, "-X", null, null, 6),
    SZX_ANOMER('a', "sp3", 1, 0, -1, null, true, "-X", "-X", "-H", 17),
    SZX_UNDEF_L('u', "?", 1, 0, -1, null, null, "-X", "-H", null, 17),
    SZX_UNDEF_ALL('Q', "?", 1, 0, -1, null, null, null, null, null, 0),
    SS3_METHYNE('d', "sp3", 1, 1, 1, null, null, "-H", "-H", null, 4),
    SS3_ACETAL('C', "sp3", 1, 1, 1, null, null, "-X", "-X", null, 8),
    SS3_STEREO_S_L('1', "sp3", 1, 1, 2, "S", null, "-X", "-H", null, 8),
    SS3_STEREO_R_L('2', "sp3", 1, 1, 2, "R", null, "-X", "-H", null, 7),
    SS3_STEREO_s_L('3', "sp3", 1, 1, 2, "s", null, "-X", "-H", null, 8),
    SS3_STEREO_r_L('4', "sp3", 1, 1, 2, "r", null, "-X", "-H", null, 7),
    SS3_STEREO_X_L('x', "sp3", 1, 1, 2, "X", null, "-X", "-H", null, 6),
    SS3_CHIRAL_S_U('5', "sp3", 1, 1, 2, "S", null, "-X", "-X", null, 10),
    SS3_CHIRAL_R_U('6', "sp3", 1, 1, 2, "R", null, "-X", "-X", null, 9),
    SS3_CHIRAL_s_U('7', "sp3", 1, 1, 2, "s", null, "-X", "-X", null, 10),
    SS3_CHIRAL_r_U('8', "sp3", 1, 1, 2, "r", null, "-X", "-X", null, 9),
    SS3_CHIRAL_X_U('X', "sp3", 1, 1, 2, "X", null, "-X", "-X", null, 8),
    SS2_KETONE_U('O', "sp2", 1, 1, 1, null, null, "=X", null, null, 17),
    DS2_CISTRANS_EL('e', "sp2", 2, 1, 1, "E", null, "-H", null, null, 6),
    DS2_CISTRANS_ZL('z', "sp2", 2, 1, 1, "Z", null, "-H", null, null, 5),
    DS2_CISTRANS_NL('n', "sp2", 2, 1, 1, "N", null, "-H", null, null, 4),
    DS2_CISTRANS_XL('f', "sp2", 2, 1, 1, "X", null, "-H", null, null, 4),
    DS2_CISTRANS_EU('E', "sp2", 2, 1, 1, "E", null, "-X", null, null, 8),
    DS2_CISTRANS_ZU('Z', "sp2", 2, 1, 1, "Z", null, "-X", null, null, 7),
    DS2_CISTRANS_NU('N', "sp2", 2, 1, 1, "N", null, "-X", null, null, 6),
    DS2_CISTRANS_XU('F', "sp2", 2, 1, 1, "X", null, "-X", null, null, 6),
    DD1_KETENE('K', "sp", 2, 2, 0, null, null, null, null, null, 4),
    TS1_ETHYNE('T', "sp", 3, 1, 0, null, null, null, null, null, 4),
    SSX_ANOMER('a', "sp3", 1, 1, -1, null, true, "-X", "-X", null, 17),
    SSX_UNDEF_U('U', "?", 1, 1, -1, null, null, "-X", null, null, 17),
    SSX_UNDEF_ALL('Q', "?", 1, 1, -1, null, null, null, null, null, 0),
    XXX_UNKNOWN('?', "?", 0, 0, -1, null, null, null, null, null, 0);

    private char m_strChar;
    private String m_strHybridOrbital;
    private int m_iBondTypeCarbon1;
    private int m_iBondTypeCarbon2;
    private int m_nUniqueModification;
    private String m_strStereo;
    private Boolean m_bIsFootOfBridge;
    private String m_strModification1;
    private String m_strModification2;
    private String m_strModification3;
    private int m_iCarbonScore;

    private CarbonDescriptor_TBD(char a_strChar, String a_strOrbital, int a_iTypeC1, int a_iTypeC2, int a_nUniqMod, String a_strStereo, Boolean a_bIsFoot, String a_strMod1, String a_strMod2, String a_strMod3, int a_iScore) {
        this.m_strChar = a_strChar;
        this.m_strHybridOrbital = a_strOrbital;
        this.m_iBondTypeCarbon1 = a_iTypeC1;
        this.m_iBondTypeCarbon2 = a_iTypeC2;
        this.m_nUniqueModification = a_nUniqMod;
        this.m_strStereo = a_strStereo;
        this.m_bIsFootOfBridge = a_bIsFoot;
        this.m_strModification1 = a_strMod1;
        this.m_strModification2 = a_strMod2;
        this.m_strModification3 = a_strMod3;
        this.m_iCarbonScore = a_iScore;
    }

    @Override
    public char getChar() {
        return this.m_strChar;
    }

    @Override
    public String getHybridOrbital() {
        return this.m_strHybridOrbital;
    }

    @Override
    public Boolean isTerminal() {
        if (this.m_strChar == '?') {
            return null;
        }
        return this.m_iBondTypeCarbon2 == 0;
    }

    @Override
    public int getNumberOfUniqueModifications() {
        return this.m_nUniqueModification;
    }

    @Override
    public String getStereo() {
        return this.m_strStereo;
    }

    public boolean isFootOfBridge() {
        return this.m_bIsFootOfBridge == null ? false : this.m_bIsFootOfBridge;
    }

    @Override
    public String getModification(int num) {
        if (num == 1) {
            return this.m_strModification1;
        }
        if (num == 2) {
            return this.m_strModification2;
        }
        if (num == 3) {
            return this.m_strModification3;
        }
        return null;
    }

    @Override
    public int getCarbonScore() {
        return this.m_iCarbonScore;
    }

    public static CarbonDescriptor_TBD forCharacter(char cName, Boolean isTerminal) {
        for (CarbonDescriptor_TBD cd : CarbonDescriptor_TBD.values()) {
            if (cd.m_strChar != cName || cd.isTerminal() != isTerminal) continue;
            return cd;
        }
        return XXX_UNKNOWN;
    }

    public static CarbonDescriptor_TBD forCarbonSituation(String a_strOrbital, int a_iTypeC1, int a_iTypeC2, int a_nUniqMod, String a_strStereo, Boolean a_bIsFoot, String a_strMod1, String a_strMod2, String a_strMod3) {
        for (CarbonDescriptor_TBD cd : CarbonDescriptor_TBD.values()) {
            if (cd.m_strHybridOrbital != null && !cd.m_strHybridOrbital.equals(a_strOrbital) || cd.m_iBondTypeCarbon1 != a_iTypeC1 || cd.m_iBondTypeCarbon2 != a_iTypeC2 || cd.m_nUniqueModification != -1 && cd.m_nUniqueModification != a_nUniqMod || cd.m_strStereo != null && !cd.m_strStereo.equals(a_strStereo) || cd.m_bIsFootOfBridge != null && !cd.m_bIsFootOfBridge.equals(a_bIsFoot) || !cd.matchModifications(a_strMod1, a_strMod2, a_strMod3)) continue;
            return cd;
        }
        return XXX_UNKNOWN;
    }

    private boolean matchModifications(String Mod1, String Mod2, String Mod3) {
        String[] mMods = new String[]{this.m_strModification1, this.m_strModification2, this.m_strModification3};
        String[] aMods = new String[]{Mod1, Mod2, Mod3};
        for (int i = 0; i < 3; ++i) {
            if (mMods[i] == null) {
                return aMods[i] == null;
            }
            if (aMods[i] == null) {
                return false;
            }
            if (mMods[i].equals(aMods[i])) continue;
            if (mMods[i].charAt(0) != aMods[i].charAt(0)) {
                return false;
            }
            if (mMods[i].charAt(1) == 'X') continue;
            return false;
        }
        return true;
    }
}

