/*
 * Decompiled with CFR 0.152.
 */
package org.glycoinfo.WURCSFramework.util.graph.visitor;

import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import org.glycoinfo.WURCSFramework.util.WURCSException;
import org.glycoinfo.WURCSFramework.util.graph.ModificationAnalyzer;
import org.glycoinfo.WURCSFramework.util.graph.traverser.WURCSGraphTraverser;
import org.glycoinfo.WURCSFramework.util.graph.traverser.WURCSGraphTraverserTree;
import org.glycoinfo.WURCSFramework.util.graph.visitor.WURCSVisitor;
import org.glycoinfo.WURCSFramework.util.graph.visitor.WURCSVisitorCollectConnectingBackboneGroups;
import org.glycoinfo.WURCSFramework.util.graph.visitor.WURCSVisitorCollectSequence;
import org.glycoinfo.WURCSFramework.util.graph.visitor.WURCSVisitorException;
import org.glycoinfo.WURCSFramework.wurcs.graph.Backbone;
import org.glycoinfo.WURCSFramework.wurcs.graph.LinkagePosition;
import org.glycoinfo.WURCSFramework.wurcs.graph.Modification;
import org.glycoinfo.WURCSFramework.wurcs.graph.WURCSComponent;
import org.glycoinfo.WURCSFramework.wurcs.graph.WURCSEdge;
import org.glycoinfo.WURCSFramework.wurcs.graph.WURCSGraph;

public class WURCSVisitorSeparateWURCSGraphByAglycone
implements WURCSVisitor {
    private LinkedList<Modification> m_aAglycones;
    private HashMap<Modification, String> m_mapAglyconeToAbbrMAP;
    private LinkedList<String> m_aUniqueMAPAglycone;
    private HashMap<WURCSGraph, LinkedList<Modification>> m_mapGraphToAglycones;
    private LinkedList<WURCSGraph> m_aSeparatedGraphs;
    private LinkedList<WURCSGraph> m_aSeparatedGraphsWithOneAtom;

    public LinkedList<Modification> getAglycones() {
        return this.m_aAglycones;
    }

    public HashMap<Modification, String> getMapAglyconeToAbbr() {
        return this.m_mapAglyconeToAbbrMAP;
    }

    public LinkedList<WURCSGraph> getSeparatedGraphs() {
        return this.m_aSeparatedGraphs;
    }

    public LinkedList<WURCSGraph> getSeparatedGraphsWithOneAtom() {
        return this.m_aSeparatedGraphsWithOneAtom;
    }

    public HashMap<WURCSGraph, LinkedList<Modification>> getMapSeparatedGraphToAglycones() {
        return this.m_mapGraphToAglycones;
    }

    @Override
    public void clear() {
        this.m_aAglycones = new LinkedList();
        this.m_mapAglyconeToAbbrMAP = new HashMap();
        this.m_aUniqueMAPAglycone = new LinkedList();
        this.m_aSeparatedGraphs = new LinkedList();
        this.m_aSeparatedGraphsWithOneAtom = new LinkedList();
        this.m_mapGraphToAglycones = new HashMap();
    }

    @Override
    public void visit(Backbone a_objBackbone) throws WURCSVisitorException {
        for (WURCSEdge t_oEdge : a_objBackbone.getEdges()) {
            Modification t_oModif;
            if (!t_oEdge.getModification().isAglycone() || t_oEdge.getModification().isGlycosidic() || (t_oModif = t_oEdge.getModification()).getMAPCode().equals("") || t_oModif.getMAPCode().equals("*O")) continue;
            this.addAglyconeInformation(t_oModif);
        }
    }

    @Override
    public void visit(Modification a_objModification) throws WURCSVisitorException {
        if (!a_objModification.isAglycone()) {
            return;
        }
        if (a_objModification.getMAPCode().equals("")) {
            return;
        }
        if (a_objModification.getMAPCode().equals("*O*")) {
            return;
        }
        if (a_objModification.getMAPCode().length() < 4) {
            return;
        }
        this.addAglyconeInformation(a_objModification);
    }

    private void addAglyconeInformation(Modification a_oModif) {
        if (this.m_aAglycones.contains(a_oModif)) {
            return;
        }
        this.m_aAglycones.add(a_oModif);
        String t_strMAP = a_oModif.getMAPCode();
        if (!this.m_aUniqueMAPAglycone.contains(t_strMAP)) {
            this.m_aUniqueMAPAglycone.addLast(t_strMAP);
        }
        this.m_mapAglyconeToAbbrMAP.put(a_oModif, "@" + (this.m_aUniqueMAPAglycone.indexOf(t_strMAP) + 1));
    }

    @Override
    public void visit(WURCSEdge a_objWURCSEdge) throws WURCSVisitorException {
    }

    @Override
    public void start(WURCSGraph a_objGraph) throws WURCSVisitorException {
        this.clear();
        try {
            WURCSGraph t_oCopyGraph = a_objGraph.copy();
            WURCSVisitorCollectSequence t_oSeq = new WURCSVisitorCollectSequence();
            t_oSeq.start(t_oCopyGraph);
            for (WURCSComponent t_oNode : t_oSeq.getNodes()) {
                t_oNode.accept(this);
            }
            for (Modification t_oMod : t_oSeq.getLeafModifications()) {
                t_oMod.accept(this);
            }
            for (Modification t_oMod : t_oSeq.getRepeatModifications()) {
                t_oMod.accept(this);
            }
            if (this.m_aAglycones.isEmpty()) {
                return;
            }
            if (this.m_aUniqueMAPAglycone.size() == 1) {
                for (Modification t_oAglycone : this.m_mapAglyconeToAbbrMAP.keySet()) {
                    this.m_mapAglyconeToAbbrMAP.put(t_oAglycone, "@");
                }
            }
            HashMap<String, String> t_mapAbbrMAPToOneAtom = new HashMap<String, String>();
            HashMap<Modification, Modification> t_mapAbbrModifToAglycone = new HashMap<Modification, Modification>();
            for (Modification t_oAglycone : this.m_aAglycones) {
                ModificationAnalyzer t_oModAnal = new ModificationAnalyzer(t_oAglycone);
                for (WURCSEdge t_oEdge : t_oAglycone.getEdges()) {
                    Backbone t_oBackbone = t_oEdge.getBackbone();
                    WURCSEdge t_oNewEdge = t_oEdge.copy();
                    Modification t_oAbbrModif = new Modification(this.m_mapAglyconeToAbbrMAP.get(t_oAglycone));
                    t_oCopyGraph.addResidues(t_oEdge.getBackbone(), t_oNewEdge, t_oAbbrModif);
                    t_mapAbbrModifToAglycone.put(t_oAbbrModif, t_oAglycone);
                    t_oBackbone.removeEdge(t_oEdge);
                    int t_iMAPPos = t_oEdge.getLinkages().getFirst().getModificationPosition();
                    String t_strOneAtomMAP = "*" + t_oModAnal.getAtomConnectedBackboneCarbon(t_iMAPPos);
                    t_mapAbbrMAPToOneAtom.put(t_oAbbrModif.getMAPCode(), t_strOneAtomMAP);
                }
                t_oAglycone.removeAllEdges();
                t_oCopyGraph.removeModification(t_oAglycone);
            }
            WURCSVisitorCollectConnectingBackboneGroups t_oGroup = new WURCSVisitorCollectConnectingBackboneGroups();
            t_oGroup.start(t_oCopyGraph);
            LinkedList<HashSet<Backbone>> t_aBackboneList = t_oGroup.getBackboneGroups();
            if (t_aBackboneList.size() == 1) {
                this.m_aSeparatedGraphs.add(t_oCopyGraph);
                this.m_mapGraphToAglycones.put(t_oCopyGraph, this.m_aAglycones);
                this.m_aSeparatedGraphsWithOneAtom.add(this.makeOneAtomGraph(t_oCopyGraph, t_mapAbbrMAPToOneAtom));
                return;
            }
            for (HashSet hashSet : t_oGroup.getBackboneGroups()) {
                WURCSGraph t_oNewGraph = new WURCSGraph();
                this.m_mapGraphToAglycones.put(t_oNewGraph, new LinkedList());
                HashMap<Modification, Modification> t_mapOrigToCopyMod = new HashMap<Modification, Modification>();
                for (Backbone t_oBackbone : hashSet) {
                    Backbone t_oCopyBackbone = t_oBackbone.copy();
                    for (WURCSEdge t_oEdge : t_oBackbone.getEdges()) {
                        Modification t_oModification = t_oEdge.getModification();
                        if (!t_mapOrigToCopyMod.containsKey(t_oModification)) {
                            t_mapOrigToCopyMod.put(t_oModification, t_oModification.copy());
                        }
                        Modification t_oCopyModification = (Modification)t_mapOrigToCopyMod.get(t_oModification);
                        if (t_oModification.isAglycone() && t_oModification.getMAPCode().contains("@")) {
                            Modification t_oAglycone = (Modification)t_mapAbbrModifToAglycone.get(t_oModification);
                            this.m_mapGraphToAglycones.get(t_oNewGraph).addLast(t_oAglycone);
                        }
                        WURCSEdge t_oCopyEdge = t_oEdge.copy();
                        t_oCopyEdge.forward();
                        t_oNewGraph.addResidues(t_oCopyBackbone, t_oCopyEdge, t_oCopyModification);
                    }
                }
                this.m_aSeparatedGraphs.add(t_oNewGraph);
                this.m_aSeparatedGraphsWithOneAtom.add(this.makeOneAtomGraph(t_oNewGraph, t_mapAbbrMAPToOneAtom));
            }
        }
        catch (WURCSException e) {
            throw new WURCSVisitorException(e.getErrorMessage());
        }
    }

    private WURCSGraph makeOneAtomGraph(WURCSGraph a_oGraph, HashMap<String, String> a_mapAbbrToOneAtom) throws WURCSException {
        WURCSGraph t_oCopySepGraph = a_oGraph.copy();
        LinkedList<Modification> t_aAbbrModifs = new LinkedList<Modification>();
        for (Modification t_oModif : t_oCopySepGraph.getModifications()) {
            if (!a_mapAbbrToOneAtom.containsKey(t_oModif.getMAPCode())) continue;
            t_aAbbrModifs.add(t_oModif);
        }
        for (Modification t_oModif : t_aAbbrModifs) {
            Modification t_oOneAtomModif = new Modification(a_mapAbbrToOneAtom.get(t_oModif.getMAPCode()));
            for (WURCSEdge t_oEdge : t_oModif.getEdges()) {
                Backbone t_oBackbone = t_oEdge.getBackbone();
                WURCSEdge t_oNewEdge = new WURCSEdge();
                for (LinkagePosition t_oLinkPos : t_oEdge.getLinkages()) {
                    LinkagePosition t_oNewLink = new LinkagePosition(t_oLinkPos.getBackbonePosition(), t_oLinkPos.getDirection(), t_oLinkPos.canOmitDirection(), 0, true);
                    t_oNewEdge.addLinkage(t_oNewLink);
                }
                t_oCopySepGraph.addResidues(t_oBackbone, t_oNewEdge, t_oOneAtomModif);
                t_oBackbone.removeEdge(t_oEdge);
            }
            t_oCopySepGraph.removeModification(t_oModif);
        }
        return t_oCopySepGraph;
    }

    @Override
    public WURCSGraphTraverser getTraverser(WURCSVisitor a_objVisitor) throws WURCSVisitorException {
        return new WURCSGraphTraverserTree(a_objVisitor);
    }
}

