/*
 * Decompiled with CFR 0.152.
 */
package org.glycoinfo.WURCSFramework.util.graph.comparator;

import java.util.Comparator;
import java.util.LinkedList;
import org.glycoinfo.WURCSFramework.util.graph.comparator.BackboneComparator;
import org.glycoinfo.WURCSFramework.wurcs.graph.Backbone;
import org.glycoinfo.WURCSFramework.wurcs.graph.Modification;
import org.glycoinfo.WURCSFramework.wurcs.graph.Monosaccharide;
import org.glycoinfo.WURCSFramework.wurcs.graph.WURCSEdge;

public class MonosaccharideComparator
implements Comparator<Monosaccharide> {
    @Override
    public int compare(Monosaccharide MS1, Monosaccharide MS2) {
        Backbone b2;
        if (!MS1.checkAroundAlternative() && MS2.checkAroundAlternative()) {
            return -1;
        }
        if (MS1.checkAroundAlternative() && !MS2.checkAroundAlternative()) {
            return 1;
        }
        BackboneComparator t_oBComp = new BackboneComparator();
        Backbone b1 = MS1.getBackbone();
        int t_iComp = t_oBComp.compare(b1, b2 = MS2.getBackbone());
        if (t_iComp != 0) {
            return t_iComp;
        }
        LinkedList<Modification> t_aRingMod1 = MS1.getRingModifications();
        LinkedList<Modification> t_aRingMod2 = MS2.getRingModifications();
        t_iComp = t_aRingMod2.size() - t_aRingMod1.size();
        if (t_iComp != 0) {
            return t_iComp;
        }
        LinkedList<WURCSEdge> t_aSubstLinkages1 = MS1.getSubstituentEdges();
        LinkedList<WURCSEdge> t_aSubstLinkages2 = MS2.getSubstituentEdges();
        int t_nSubstCount1 = t_aSubstLinkages1.size();
        int t_nSubstCount2 = t_aSubstLinkages2.size();
        t_iComp = t_nSubstCount2 - t_nSubstCount1;
        if (t_iComp != 0) {
            return t_iComp;
        }
        int score1 = 0;
        int score2 = 0;
        for (WURCSEdge edge : t_aSubstLinkages1) {
            score1 += edge.getLinkages().getFirst().getBackbonePosition();
        }
        for (WURCSEdge edge : t_aSubstLinkages2) {
            score2 += edge.getLinkages().getFirst().getBackbonePosition();
        }
        t_iComp = score1 - score2;
        if (t_iComp != 0) {
            return t_iComp;
        }
        return 0;
    }
}

