/*
 * Decompiled with CFR 0.152.
 */
package org.glycoinfo.WURCSFramework.util.exchange;

import java.util.Collections;
import java.util.LinkedList;
import java.util.TreeMap;
import org.glycoinfo.WURCSFramework.util.WURCSDataConverter;
import org.glycoinfo.WURCSFramework.util.array.WURCSExporter;
import org.glycoinfo.WURCSFramework.util.array.comparator.GLIPComparator;
import org.glycoinfo.WURCSFramework.wurcs.array.GLIP;
import org.glycoinfo.WURCSFramework.wurcs.array.GLIPs;
import org.glycoinfo.WURCSFramework.wurcs.array.LIN;
import org.glycoinfo.WURCSFramework.wurcs.array.RES;
import org.glycoinfo.WURCSFramework.wurcs.array.UniqueRES;
import org.glycoinfo.WURCSFramework.wurcs.array.WURCSArray;
import org.glycoinfo.WURCSFramework.wurcs.sequence.GLIN;
import org.glycoinfo.WURCSFramework.wurcs.sequence.GRES;
import org.glycoinfo.WURCSFramework.wurcs.sequence.MS;
import org.glycoinfo.WURCSFramework.wurcs.sequence.WURCSSequence;

public class WURCSArrayToSequence {
    private WURCSSequence m_oSequence;
    private TreeMap<Integer, UniqueRES> m_mapRESIDtoURES = new TreeMap();

    public WURCSSequence getSequence() {
        return this.m_oSequence;
    }

    public void start(WURCSArray a_oWURCSArray) {
        WURCSExporter t_oExport = new WURCSExporter();
        WURCSSequence t_oSequence = new WURCSSequence(t_oExport.getWURCSString(a_oWURCSArray));
        TreeMap<Integer, MS> t_mapURESIDToMS = new TreeMap<Integer, MS>();
        for (UniqueRES t_oURES : a_oWURCSArray.getUniqueRESs()) {
            String t_strMS = new WURCSExporter().getUniqueRESString(t_oURES);
            t_mapURESIDToMS.put(t_oURES.getUniqueRESID(), new MS(t_strMS));
        }
        TreeMap<Integer, GRES> t_mapRESIDToGRES = new TreeMap<Integer, GRES>();
        for (RES t_oRES : a_oWURCSArray.getRESs()) {
            int t_oRESID = WURCSDataConverter.convertRESIndexToID(t_oRES.getRESIndex());
            this.m_mapRESIDtoURES.put(t_oRESID, a_oWURCSArray.getUniqueRESs().get(t_oRES.getUniqueRESID() - 1));
            MS t_oMS = (MS)t_mapURESIDToMS.get(t_oRES.getUniqueRESID());
            GRES t_oGRES = new GRES(t_oRESID, t_oMS);
            t_mapRESIDToGRES.put(t_oRESID, t_oGRES);
            t_oSequence.addGRES(t_oGRES);
        }
        for (LIN t_oLIN : a_oWURCSArray.getLINs()) {
            GRES t_oGRES;
            int t_oRESID;
            GLIPs t_oDonorGLIPs;
            if (t_oLIN.getListOfGLIPs().size() > 2) continue;
            GLIPs t_oAcceptorGLIPs = t_oLIN.getListOfGLIPs().getFirst();
            if (this.compareGLIPs(t_oAcceptorGLIPs, t_oDonorGLIPs = t_oLIN.getListOfGLIPs().getLast()) > 0) {
                GLIPs tmp = t_oDonorGLIPs;
                t_oDonorGLIPs = t_oAcceptorGLIPs;
                t_oAcceptorGLIPs = tmp;
            }
            if (t_oAcceptorGLIPs == t_oDonorGLIPs) {
                t_oDonorGLIPs = null;
            }
            GLIN t_oGLIN = new GLIN(t_oLIN.getMAPCode(), this.getGLINString(t_oAcceptorGLIPs, t_oDonorGLIPs, t_oLIN.getMAPCode(), t_mapRESIDToGRES));
            t_oSequence.addGLIN(t_oGLIN);
            if (t_oLIN.isRepeatingUnit()) {
                t_oGLIN.setRepeatCountMin(t_oLIN.getMinRepeatCount());
                t_oGLIN.setRepeatCountMax(t_oLIN.getMaxRepeatCount());
            }
            for (GLIP t_oGLIP : t_oAcceptorGLIPs.getGLIPs()) {
                if (!t_oGLIN.getAcceptorPositions().contains(t_oGLIP.getBackbonePosition())) {
                    t_oGLIN.addAcceptorPosition(t_oGLIP.getBackbonePosition());
                }
                t_oRESID = WURCSDataConverter.convertRESIndexToID(t_oGLIP.getRESIndex());
                t_oGRES = t_mapRESIDToGRES.get(t_oRESID);
                if (t_oGLIN.getAcceptorMSs().contains(t_oGRES)) continue;
                t_oGRES.addAcceptorGLIN(t_oGLIN);
                t_oGLIN.addAcceptorMS(t_oGRES.getMS());
            }
            if (t_oDonorGLIPs == null) continue;
            for (GLIP t_oGLIP : t_oDonorGLIPs.getGLIPs()) {
                if (!t_oGLIN.getDonorPositions().contains(t_oGLIP.getBackbonePosition())) {
                    t_oGLIN.addDonorPosition(t_oGLIP.getBackbonePosition());
                }
                t_oRESID = WURCSDataConverter.convertRESIndexToID(t_oGLIP.getRESIndex());
                t_oGRES = t_mapRESIDToGRES.get(t_oRESID);
                if (t_oGLIN.getDonorMSs().contains(t_oGRES)) continue;
                t_oGRES.addDonorGLIN(t_oGLIN);
                t_oGLIN.addDonorMS(t_oGRES.getMS());
            }
        }
        this.m_oSequence = t_oSequence;
    }

    private int compareGLIPs(GLIPs a_oGLIPs1, GLIPs a_oGLIPs2) {
        int t_iRESID1 = WURCSDataConverter.convertRESIndexToID(a_oGLIPs1.getGLIPs().getLast().getRESIndex());
        int t_iRESID2 = WURCSDataConverter.convertRESIndexToID(a_oGLIPs2.getGLIPs().getLast().getRESIndex());
        int t_iAnomPos1 = this.m_mapRESIDtoURES.get(t_iRESID1).getAnomericPosition();
        int t_iAnomPos2 = this.m_mapRESIDtoURES.get(t_iRESID2).getAnomericPosition();
        int t_iPos1 = a_oGLIPs1.getGLIPs().getLast().getBackbonePosition();
        int t_iPos2 = a_oGLIPs2.getGLIPs().getLast().getBackbonePosition();
        if (t_iPos1 != t_iAnomPos1 && t_iPos2 == t_iAnomPos2) {
            return -1;
        }
        if (t_iPos1 == t_iAnomPos1 && t_iPos2 != t_iAnomPos2) {
            return 1;
        }
        if (t_iAnomPos1 > 0 && t_iAnomPos2 <= 0) {
            if (t_iPos1 != t_iAnomPos1) {
                return -1;
            }
            if (t_iPos1 == t_iAnomPos1) {
                return 1;
            }
        }
        if (t_iAnomPos1 <= 0 && t_iAnomPos2 > 0) {
            if (t_iPos2 != t_iAnomPos2) {
                return 1;
            }
            if (t_iPos2 == t_iAnomPos2) {
                return -1;
            }
        }
        if (t_iPos1 != t_iPos2) {
            return t_iPos2 - t_iPos1;
        }
        if (t_iRESID1 != t_iRESID2) {
            return t_iRESID1 - t_iRESID2;
        }
        return 0;
    }

    private String getGLINString(GLIPs a_oAGLIPs, GLIPs a_oDGLIPs, String a_strMAP, TreeMap<Integer, GRES> a_mapRESIDToGRES) {
        WURCSExporter t_oExport = new WURCSExporter();
        String t_strGLIN = "";
        LinkedList<GLIPs> t_aGLIPs = new LinkedList<GLIPs>();
        if (a_oAGLIPs != null) {
            t_aGLIPs.add(a_oAGLIPs);
        }
        if (a_oDGLIPs != null) {
            t_aGLIPs.add(a_oDGLIPs);
        }
        for (GLIPs t_oGLIPs : t_aGLIPs) {
            String t_strExGLIPs = "";
            LinkedList<GLIP> t_aGLIP = t_oGLIPs.getGLIPs();
            Collections.sort(t_aGLIP, new GLIPComparator());
            for (GLIP t_oGLIP : t_aGLIP) {
                if (t_strExGLIPs != "") {
                    t_strExGLIPs = t_strExGLIPs + "|";
                }
                int t_oRESID = WURCSDataConverter.convertRESIndexToID(t_oGLIP.getRESIndex());
                String t_strMS = a_mapRESIDToGRES.get(t_oRESID).getMS().getString();
                t_strExGLIPs = t_strExGLIPs + "[" + t_strMS + "]";
                t_strExGLIPs = t_strExGLIPs + t_oExport.getLIPString(t_oGLIP);
            }
            if (t_oGLIPs.getAlternativeType() != null) {
                if (t_oGLIPs.getAlternativeType().equals("{")) {
                    t_strExGLIPs = "{" + t_strExGLIPs;
                }
                if (t_oGLIPs.getAlternativeType().equals("}")) {
                    t_strExGLIPs = t_strExGLIPs + "}";
                }
            }
            if (t_strGLIN != "") {
                t_strGLIN = t_strGLIN + "-";
            }
            t_strGLIN = t_strGLIN + t_strExGLIPs;
        }
        t_strGLIN = t_strGLIN + a_strMAP;
        return t_strGLIN;
    }
}

