/*
 * Decompiled with CFR 0.152.
 */
package org.glycoinfo.GlycanFormatconverter.util.exchange.WURCSGraphToGlyContainer;

import java.util.ArrayList;
import java.util.Collections;
import org.glycoinfo.GlycanFormatconverter.Glycan.BaseCrossLinkedTemplate;
import org.glycoinfo.GlycanFormatconverter.Glycan.BaseSubstituentTemplate;
import org.glycoinfo.GlycanFormatconverter.Glycan.LinkageType;
import org.glycoinfo.WURCSFramework.util.array.WURCSFormatException;

public class MAPAnalyzer {
    private BaseSubstituentTemplate baseTemp = null;
    private BaseCrossLinkedTemplate baseCrossTemp;
    private String headAtom = "";
    private String tailAtom = "";
    private String headPos = "";
    private String tailPos = "";

    public String getHeadAtom() {
        return this.headAtom;
    }

    public String getTailAtom() {
        return this.tailAtom;
    }

    public BaseSubstituentTemplate getSingleTemplate() {
        return this.baseTemp;
    }

    public BaseCrossLinkedTemplate getCrossTemplate() {
        return this.baseCrossTemp;
    }

    public void start(String _map) throws WURCSFormatException {
        if (_map.equals("")) {
            return;
        }
        String tempMAP = _map;
        this.baseCrossTemp = BaseCrossLinkedTemplate.forMAP(_map);
        if (this.baseCrossTemp != null && this.baseCrossTemp.equals(BaseCrossLinkedTemplate.ANHYDRO)) {
            return;
        }
        if (this.isMAPOfSingleLinkage(_map)) {
            tempMAP = tempMAP.replaceFirst("\\*", "");
        }
        if (tempMAP.indexOf("*") == -1 && _map.startsWith("*O")) {
            this.headAtom = tempMAP.substring(0, 1);
            tempMAP = this.removeOxygenFromHead(tempMAP);
        }
        this.baseTemp = BaseSubstituentTemplate.forMAP(tempMAP);
        if (this.baseTemp != null) {
            if (this.baseTemp.equals(BaseSubstituentTemplate.AMINE)) {
                this.headAtom = "N";
            }
            return;
        }
        if (_map.equals("*N*")) {
            tempMAP = tempMAP.replaceFirst("\\*", "");
            this.baseCrossTemp = BaseCrossLinkedTemplate.forMAP(tempMAP);
            return;
        }
        tempMAP = this.extractHeadPosition(tempMAP);
        tempMAP = this.extractTailPosition(tempMAP);
        this.headAtom = String.valueOf(tempMAP.charAt(tempMAP.indexOf("*") + 1));
        this.tailAtom = String.valueOf(tempMAP.charAt(tempMAP.lastIndexOf("*") - 1));
        tempMAP = tempMAP.replaceFirst("\\*", "");
        if ((tempMAP = this.makeDoubleLinkMAP(tempMAP)).startsWith("*")) {
            tempMAP = tempMAP.substring(1, tempMAP.length());
        }
        this.baseCrossTemp = BaseCrossLinkedTemplate.forMAP(tempMAP);
    }

    private String makeDoubleLinkMAP(String _map) {
        String ret = _map;
        Boolean isSwap = null;
        boolean hasOrder = false;
        if (isSwap == null && this.headAtom != this.tailAtom) {
            if (this.headAtom.equals("O")) {
                isSwap = false;
            } else if (this.tailAtom.equals("O")) {
                isSwap = true;
            }
        }
        if (isSwap != null) {
            hasOrder = true;
        } else {
            isSwap = false;
        }
        if (this.checkLinkageTypeWithAtom(this.headAtom).equals((Object)LinkageType.H_AT_OH)) {
            String string = ret = isSwap != false ? this.removeOxygenFromTail(ret) : this.removeOxygenFromHead(ret);
        }
        if (this.checkLinkageTypeWithAtom(this.tailAtom).equals((Object)LinkageType.H_AT_OH)) {
            ret = isSwap != false ? this.removeOxygenFromHead(ret) : this.removeOxygenFromTail(ret);
        }
        ret = ret.replace("P*", "P^X*");
        return ret;
    }

    private String removeOxygenFromHead(String _map) {
        if (_map.startsWith("NCCOP")) {
            return _map;
        }
        ArrayList<Integer> nums = new ArrayList<Integer>();
        String num = "";
        int i = 0;
        while (i < _map.length()) {
            char c = _map.charAt(i);
            if (Character.isDigit(c)) {
                num = String.valueOf(num) + c;
            } else if (!num.equals("") && !nums.contains(Integer.parseInt(num))) {
                nums.add(Integer.parseInt(num));
                num = "";
            }
            ++i;
        }
        Collections.sort(nums);
        String newMAP = _map;
        for (Integer num1 : nums) {
            Integer num2 = num1 - 1;
            newMAP = newMAP.replaceAll(num1.toString(), num2.toString());
        }
        if (this.headAtom.equals("O")) {
            newMAP = newMAP.replaceFirst(this.headAtom, "");
        }
        return newMAP;
    }

    private String removeOxygenFromTail(String _map) {
        StringBuilder sb = new StringBuilder(_map);
        int pos = _map.lastIndexOf("*");
        sb.replace(pos - 1, pos, "");
        _map = sb.toString();
        int posO = 1;
        int i = 0;
        while (i < pos) {
            char c = _map.charAt(i);
            if (c == '^' || c == '/') {
                ++i;
            } else if (c != '=' && c != '#') {
                if (c == '*') break;
                ++posO;
            }
            ++i;
        }
        ArrayList<Integer> nums = new ArrayList<Integer>();
        String num = "";
        int i2 = 0;
        while (i2 < _map.length()) {
            char c = _map.charAt(i2);
            if (Character.isDigit(c)) {
                num = String.valueOf(num) + c;
            } else if (!num.equals("") && !nums.contains(Integer.parseInt(num))) {
                nums.add(Integer.parseInt(num));
                num = "";
            }
            ++i2;
        }
        Collections.sort(nums);
        Collections.reverse(nums);
        String newMAP = _map;
        for (Integer num1 : nums) {
            if (num1 <= posO) continue;
            Integer num2 = num1 - 1;
            newMAP = newMAP.replaceAll(num1.toString(), num2.toString());
        }
        return newMAP;
    }

    private boolean isMAPOfSingleLinkage(String _map) {
        int ret = 0;
        int i = 0;
        while (i < _map.length()) {
            char item = _map.charAt(i);
            if (item == '*') {
                ++ret;
            }
            ++i;
        }
        return ret == 1;
    }

    private String extractHeadPosition(String _map) {
        int pos = _map.indexOf("*");
        if (pos != 0) {
            return "";
        }
        this.headPos = _map.substring(pos + 1, pos + 2);
        if (this.headPos.matches("[1-9]")) {
            _map = _map.replaceFirst(this.headPos, "");
        } else {
            this.headPos = "";
        }
        return _map;
    }

    private String extractTailPosition(String _map) {
        int pos = _map.lastIndexOf("*");
        StringBuilder ret = new StringBuilder(_map);
        if (pos == -1) {
            return "";
        }
        if (_map.length() == pos + 1) {
            return "";
        }
        this.tailPos = _map.substring(pos + 1, pos + 2);
        if (this.tailPos.matches("[1-9]")) {
            ret.replace(pos + 1, pos + 2, "");
        } else {
            this.tailPos = "";
        }
        return ret.toString();
    }

    private LinkageType checkLinkageTypeWithAtom(String _atom) {
        if (_atom.equals("O") || _atom.equals("N")) {
            return LinkageType.H_AT_OH;
        }
        return LinkageType.DEOXY;
    }
}

