/*
 * Decompiled with CFR 0.152.
 */
package org.glycoinfo.GlycanFormatconverter.util.exchange.GlyContainerToWURCSGraph;

import java.util.ArrayList;
import java.util.Collections;
import org.glycoinfo.GlycanFormatconverter.Glycan.Edge;
import org.glycoinfo.GlycanFormatconverter.Glycan.LinkageType;
import org.glycoinfo.GlycanFormatconverter.Glycan.Substituent;
import org.glycoinfo.GlycanFormatconverter.util.exchange.SugarToWURCSGraph.SubstituentTypeToMAP;
import org.glycoinfo.WURCSFramework.util.exchange.WURCSExchangeException;

public class SubstituentToModification {
    private Substituent substituent;
    private Edge parentEdge = null;
    private Edge childEdge = null;
    private LinkageType parentType;
    private LinkageType childType;
    private int parentSidePosition = 0;
    private int childSidePosition = 0;
    private String headAtom = "";
    private String tailAtom = "";
    private String mapCode = "";
    private SubstituentTypeToMAP subTypeToMap;

    public String getMAPCode() {
        return this.mapCode;
    }

    public int getParentSidePosition() {
        return this.parentSidePosition;
    }

    public int getChildSidePosition() {
        return this.childSidePosition;
    }

    public String getHeadAtom() {
        return this.headAtom;
    }

    public String getTailAtom() {
        return this.tailAtom;
    }

    public void setParentEdge(Edge _edge) {
        this.parentEdge = _edge;
    }

    public void setChildEdge(Edge _edge) {
        this.childEdge = _edge;
    }

    public void start(Substituent _sub) throws WURCSExchangeException {
        String mapDouble;
        this.substituent = _sub;
        if (_sub.getSubstituent() == null) {
            return;
        }
        this.subTypeToMap = SubstituentTypeToMAP.forName(_sub.getSubstituent().getglycoCTnotation());
        this.headAtom = this.subTypeToMap.getHeadAtom();
        this.tailAtom = this.subTypeToMap.getTailAtom();
        ArrayList<LinkageType> linkageTypes = new ArrayList<LinkageType>();
        if (this.substituent.getParentEdge() != null) {
            this.parentEdge = this.substituent.getParentEdge();
        }
        if (this.parentEdge == null) {
            throw new WURCSExchangeException("Substituent must have parent linkage.");
        }
        if (!this.substituent.getChildEdges().isEmpty()) {
            this.childEdge = this.substituent.getChildEdges().get(0);
        }
        if (this.substituent.getFirstPosition() != null) {
            linkageTypes.add(this.substituent.getFirstPosition().getParentLinkageType());
        }
        if (this.substituent.getSecondPosition() != null) {
            linkageTypes.add(this.substituent.getSecondPosition().getChildLinkageType());
        }
        if (linkageTypes.isEmpty()) {
            throw new WURCSExchangeException("Substituent having no linkage is NOT handled in this system.");
        }
        if (linkageTypes.size() > 2) {
            throw new WURCSExchangeException("Substituent having three or more linkage is NOT handled in this system.");
        }
        this.parentType = (LinkageType)((Object)linkageTypes.get(0));
        LinkageType linkageType = this.childType = linkageTypes.size() == 2 ? (LinkageType)((Object)linkageTypes.get(1)) : null;
        if (this.parentType == LinkageType.UNKNOWN) {
            this.parentType = LinkageType.H_AT_OH;
        }
        if ((mapDouble = this.subTypeToMap.getMAPDouble()) != null && mapDouble.equals("")) {
            return;
        }
        this.mapCode = this.childType == null ? this.getMAPCodeSingle() : this.getMAPCodeDouble();
    }

    public String getMAPCodeSingle() {
        String map = this.subTypeToMap.getMAPSingle();
        if (this.parentType == LinkageType.H_AT_OH) {
            this.headAtom = "O";
            map = this.addOxygenToHead(map);
        }
        return "*" + map;
    }

    public String getMAPCodeDouble() {
        String map = this.subTypeToMap.getMAPDouble();
        Boolean isSwap = this.subTypeToMap.isSwapCarbonPositions();
        boolean hasOrder = false;
        if (isSwap == null && this.parentType != this.childType) {
            if (this.parentType == LinkageType.H_AT_OH) {
                isSwap = false;
            } else if (this.childType == LinkageType.H_AT_OH) {
                isSwap = true;
            }
        }
        if (isSwap != null) {
            this.parentSidePosition = 1;
            this.childSidePosition = 2;
            if (isSwap.booleanValue()) {
                this.parentSidePosition = 2;
                this.childSidePosition = 1;
            }
            hasOrder = true;
        } else {
            isSwap = false;
        }
        if (this.parentType == LinkageType.H_AT_OH) {
            this.headAtom = "O";
            String string = map = isSwap != false ? this.addOxygenToTail(map) : this.addOxygenToHead(map);
        }
        if (this.childType == LinkageType.H_AT_OH) {
            this.tailAtom = "O";
            String string = map = isSwap != false ? this.addOxygenToHead(map) : this.addOxygenToTail(map);
        }
        if (hasOrder) {
            map = this.addMAPStarIndex(map);
        }
        map = "*" + map;
        map = map.replace("*OP^XO*", "*OPO*");
        map = map.replace("*P^X*", "*P*");
        return map;
    }

    private String addOxygenToTail(String _map) {
        StringBuilder sb = new StringBuilder(_map);
        int pos = _map.lastIndexOf("*");
        sb.insert(pos, 'O');
        _map = sb.toString();
        int posO = 1;
        int i = 0;
        while (i < pos) {
            char c = _map.charAt(i);
            if (c == '^' || c == '/') {
                ++i;
            } else if (c != '=' && c != '#') {
                if (c == '*') break;
                ++posO;
            }
            ++i;
        }
        ArrayList<Integer> nums = new ArrayList<Integer>();
        String num = "";
        int i2 = 0;
        while (i2 < _map.length()) {
            char c = _map.charAt(i2);
            if (Character.isDigit(c)) {
                num = String.valueOf(num) + c;
            } else if (!num.equals("") && !nums.contains(Integer.parseInt(num))) {
                nums.add(Integer.parseInt(num));
                num = "";
            }
            ++i2;
        }
        Collections.sort(nums);
        Collections.reverse(nums);
        String newMAP = _map;
        for (Integer num1 : nums) {
            if (num1 <= posO) continue;
            Integer num2 = num1 + 1;
            newMAP = newMAP.replaceAll(num1.toString(), num2.toString());
        }
        return newMAP;
    }

    private String addOxygenToHead(String _map) {
        if (_map.startsWith("NCCOP")) {
            return _map;
        }
        ArrayList<Integer> nums = new ArrayList<Integer>();
        String num = "";
        int i = 0;
        while (i < _map.length()) {
            char c = _map.charAt(i);
            if (Character.isDigit(c)) {
                num = String.valueOf(num) + c;
            } else if (!num.equals("") && !nums.contains(Integer.parseInt(num))) {
                nums.add(Integer.parseInt(num));
                num = "";
            }
            ++i;
        }
        Collections.sort(nums);
        Collections.reverse(nums);
        String newMAP = _map;
        for (Integer num1 : nums) {
            Integer num2 = num1 + 1;
            newMAP = newMAP.replaceAll(num1.toString(), num2.toString());
        }
        return "O" + newMAP;
    }

    private String addMAPStarIndex(String _map) {
        StringBuilder sb = new StringBuilder(_map);
        int pos2 = _map.indexOf("*");
        sb.insert(pos2 + 1, '2');
        sb.insert(0, '1');
        return sb.toString();
    }
}

