/*
 * Decompiled with CFR 0.152.
 */
package org.glycoinfo.GlycanFormatconverter.io.LinearCode;

public enum LinearCodeSubstituentDictionary {
    DN_ACETYL("Q", "NAc"),
    N_ACETYL("N", "NAc"),
    O_ACETYL("T", "Ac"),
    PHOSPHOETHANOL_AMINE("PE", "PEth"),
    INOSITOL("IN", ""),
    METHYL("ME", "Me"),
    PHOSPHATE("P", "P"),
    PHOSPHOCHOLINE("PC", "PCho"),
    PYRUVATE("PYR", "Py"),
    SULFATE("S", "S"),
    N_SULFATE("NS", "NS"),
    SULFIDE("SH", "SH"),
    CILIATIN("EP", ""),
    FLUORO("FL", "F"),
    CHLORO("CH", "Cl"),
    ANHYDRO("AH", "Anhydro");

    private String linearCodeNotation;
    private String iupacNotation;

    public String getIUPACNotation() {
        return this.iupacNotation;
    }

    public String getLinearCodeNotation() {
        return this.linearCodeNotation;
    }

    private LinearCodeSubstituentDictionary(String _linearCode, String _iupac) {
        this.linearCodeNotation = _linearCode;
        this.iupacNotation = _iupac;
    }

    public static LinearCodeSubstituentDictionary forLinearCode(String _linearCode) {
        LinearCodeSubstituentDictionary[] linearCodeSubstituentDictionaryArray = LinearCodeSubstituentDictionary.values();
        int n = linearCodeSubstituentDictionaryArray.length;
        int n2 = 0;
        while (n2 < n) {
            LinearCodeSubstituentDictionary ind = linearCodeSubstituentDictionaryArray[n2];
            if (ind.linearCodeNotation.equals(_linearCode)) {
                return ind;
            }
            ++n2;
        }
        return null;
    }

    public static LinearCodeSubstituentDictionary forIUPACNotation(String _iupac) {
        LinearCodeSubstituentDictionary[] linearCodeSubstituentDictionaryArray = LinearCodeSubstituentDictionary.values();
        int n = linearCodeSubstituentDictionaryArray.length;
        int n2 = 0;
        while (n2 < n) {
            LinearCodeSubstituentDictionary ind = linearCodeSubstituentDictionaryArray[n2];
            if (ind.iupacNotation.equals(_iupac)) {
                return ind;
            }
            ++n2;
        }
        return null;
    }
}

